/*
 * Decompiled with CFR 0.152.
 */
package com.android.base.image.glide;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.android.base.image.ProgressInfo;
import com.android.base.image.ProgressListener;
import com.android.base.image.glide.ProgressResponseBody;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class ProgressManager {
    private static volatile ProgressManager mProgressManager;
    private static final int DEFAULT_REFRESH_TIME = 200;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Map<String, List<WeakReference<ProgressListener>>> mMultiResponseListeners = new HashMap<String, List<WeakReference<ProgressListener>>>();
    private final Map<String, WeakReference<ProgressListener>> mExclusiveResponseListeners = new HashMap<String, WeakReference<ProgressListener>>();
    private final ResponseProgressInterceptor mInterceptor = new ResponseProgressInterceptor();
    private int mRefreshTime = 200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ProgressManager getInstance() {
        if (mProgressManager != null) return mProgressManager;
        Class<ProgressManager> clazz = ProgressManager.class;
        synchronized (ProgressManager.class) {
            if (mProgressManager != null) return mProgressManager;
            mProgressManager = new ProgressManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mProgressManager;
        }
    }

    private ProgressManager() {
    }

    OkHttpClient.Builder withProgress(OkHttpClient.Builder builder) {
        return builder.addNetworkInterceptor((Interceptor)this.mInterceptor);
    }

    @UiThread
    private void notifyResponseProgress(String url, ProgressInfo progressInfo) {
        ProgressListener progressListener;
        WeakReference<ProgressListener> listenerWeakReference;
        List<WeakReference<ProgressListener>> weakReferences = this.mMultiResponseListeners.get(url);
        if (this.isNotEmpty(weakReferences)) {
            for (WeakReference<ProgressListener> weakReference : weakReferences) {
                ProgressListener progressListener2 = (ProgressListener)weakReference.get();
                if (progressListener2 == null) continue;
                progressListener2.onProgress(url, progressInfo);
            }
        }
        if ((listenerWeakReference = this.mExclusiveResponseListeners.get(url)) != null && (progressListener = (ProgressListener)listenerWeakReference.get()) != null) {
            progressListener.onProgress(url, progressInfo);
        }
    }

    @UiThread
    private void notifyResponseError(String url, long id, Exception e) {
        ProgressListener progressListener;
        WeakReference<ProgressListener> listenerWeakReference;
        List<WeakReference<ProgressListener>> weakReferences = this.mMultiResponseListeners.get(url);
        if (this.isNotEmpty(weakReferences)) {
            for (WeakReference<ProgressListener> weakReference : weakReferences) {
                ProgressListener progressListener2 = (ProgressListener)weakReference.get();
                if (progressListener2 == null) continue;
                progressListener2.onError(id, url, e);
            }
        }
        if ((listenerWeakReference = this.mExclusiveResponseListeners.get(url)) != null && (progressListener = (ProgressListener)listenerWeakReference.get()) != null) {
            progressListener.onError(id, url, e);
        }
    }

    void setRefreshTime(int refreshTime) {
        if (refreshTime < 0) {
            throw new IllegalArgumentException("the refreshTime must be >= 0");
        }
        this.mRefreshTime = refreshTime;
    }

    @UiThread
    void addLoadListener(String url, ProgressListener listener) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("url cannot be null");
        }
        if (listener == null) {
            throw new NullPointerException("ProgressListener cannot be null");
        }
        List<WeakReference<ProgressListener>> progressListeners = this.mMultiResponseListeners.get(url);
        if (progressListeners == null) {
            progressListeners = new ArrayList<WeakReference<ProgressListener>>();
            this.mMultiResponseListeners.put(url, progressListeners);
        }
        if (progressListeners.isEmpty()) {
            progressListeners.add(new WeakReference<ProgressListener>(listener));
        } else {
            boolean containers = false;
            for (WeakReference<ProgressListener> progressListener : progressListeners) {
                ProgressListener reference = (ProgressListener)progressListener.get();
                if (reference != listener) continue;
                containers = true;
                break;
            }
            if (!containers) {
                progressListeners.add(new WeakReference<ProgressListener>(listener));
            }
        }
    }

    @UiThread
    public void setListener(String url, ProgressListener progressListener) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("url cannot be null");
        }
        if (progressListener == null) {
            this.mExclusiveResponseListeners.remove(url);
        } else {
            this.mExclusiveResponseListeners.put(url, new WeakReference<ProgressListener>(progressListener));
        }
    }

    @UiThread
    void removeListener(String url) {
        this.mMultiResponseListeners.remove(url);
    }

    private boolean isNotEmpty(List<WeakReference<ProgressListener>> weakReferences) {
        return weakReferences != null && !weakReferences.isEmpty();
    }

    private void runOnUIThread(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    private class ResponseProgressInterceptor
    implements Interceptor {
        private ResponseProgressInterceptor() {
        }

        @NonNull
        public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
            return this.wrapResponseBody(chain.proceed(chain.request()));
        }

        private Response wrapResponseBody(Response response) {
            if (response == null || response.body() == null) {
                return response;
            }
            final String key = response.request().url().toString();
            ProgressResponseBody progressResponseBody = new ProgressResponseBody(response.body(), ProgressManager.this.mRefreshTime){

                @Override
                void onProgress(ProgressInfo progressInfo) {
                    ProgressManager.this.runOnUIThread(() -> ProgressManager.this.notifyResponseProgress(key, progressInfo));
                }

                @Override
                protected void onError(long id, Exception e) {
                    ProgressManager.this.runOnUIThread(() -> ProgressManager.this.notifyResponseError(key, id, e));
                }
            };
            return response.newBuilder().body((ResponseBody)progressResponseBody).build();
        }
    }
}

