/*
 * Decompiled with CFR 0.152.
 */
package com.android.base.image;

import android.graphics.drawable.Drawable;

public class DisplayConfig {
    private boolean mCacheMemory = true;
    private boolean mCacheDisk = true;
    private int mTransform;
    private int mScaleType;
    private int mErrorPlaceholder = -1;
    private int mLoadingPlaceholder = -1;
    private int mRoundedCornersRadius;
    private float thumbnail;
    private int height;
    private int width;
    public static final int NO_PLACE_HOLDER = -1;
    private Drawable mErrorDrawable = null;
    private Drawable mLoadingDrawable = null;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_CENTER_CROP = 1;
    public static final int SCALE_FIT_CENTER = 2;
    public static final int TRANSFORM_NONE = 1;
    public static final int TRANSFORM_CIRCLE = 2;
    public static final int TRANSFORM_ROUNDED_CORNERS = 3;
    public static final int ANIM_NONE = 1;

    private DisplayConfig() {
    }

    public static DisplayConfig create() {
        return new DisplayConfig();
    }

    public DisplayConfig setErrorPlaceholder(int errorPlaceholder) {
        this.mErrorPlaceholder = errorPlaceholder;
        this.mErrorDrawable = null;
        return this;
    }

    public DisplayConfig setLoadingPlaceholder(int loadingPlaceholder) {
        this.mLoadingPlaceholder = loadingPlaceholder;
        this.mErrorDrawable = null;
        return this;
    }

    public Drawable getErrorDrawable() {
        return this.mErrorDrawable;
    }

    public Drawable getLoadingDrawable() {
        return this.mLoadingDrawable;
    }

    public DisplayConfig scaleType(int scaleType) {
        this.mScaleType = scaleType;
        return this;
    }

    public DisplayConfig cacheMemory(boolean cacheMemory) {
        this.mCacheMemory = cacheMemory;
        return this;
    }

    public DisplayConfig setCacheDisk(boolean cacheDisk) {
        this.mCacheDisk = cacheDisk;
        return this;
    }

    public DisplayConfig setThumbnail(float thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public DisplayConfig setErrorDrawable(Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        this.mErrorPlaceholder = -1;
        return this;
    }

    public DisplayConfig setLoadingDrawable(Drawable loadingDrawable) {
        this.mLoadingPlaceholder = -1;
        this.mLoadingDrawable = loadingDrawable;
        return this;
    }

    public DisplayConfig setTransform(int transform) {
        this.mTransform = transform;
        return this;
    }

    public DisplayConfig setRoundedCornersRadius(int roundedCornersRadius) {
        this.mRoundedCornersRadius = roundedCornersRadius;
        return this;
    }

    public DisplayConfig setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public boolean isCacheMemory() {
        return this.mCacheMemory;
    }

    public boolean isCacheDisk() {
        return this.mCacheDisk;
    }

    public int getTransform() {
        return this.mTransform;
    }

    public int getErrorPlaceholder() {
        return this.mErrorPlaceholder;
    }

    public int getLoadingPlaceholder() {
        return this.mLoadingPlaceholder;
    }

    public int getRoundedCornersRadius() {
        return this.mRoundedCornersRadius;
    }

    public float getThumbnail() {
        return this.thumbnail;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

