/*
 * Decompiled with CFR 0.152.
 */
package com.implozia.shloader;

import android.content.Context;
import android.content.res.Resources;
import android.opengl.GLES20;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/implozia/shloader/Shloader;", "", "()V", "loadShader", "", "shaderType", "source", "context", "Landroid/content/Context;", "readTextFromRaw", "", "resourceId", "shloader_release"})
public final class Shloader {
    public static final Shloader INSTANCE;

    public final int loadShader(int shaderType, int source, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int shader = GLES20.glCreateShader((int)shaderType);
        GLES20.glShaderSource((int)shader, (String)this.readTextFromRaw(context, source));
        GLES20.glCompileShader((int)shader);
        return shader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String readTextFromRaw(Context context, int resourceId) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = null;
            try {
                InputStream inputStream = context.getResources().openRawResource(resourceId);
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.resources.openRawResource(resourceId)");
                InputStream inputStream2 = inputStream;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
                Ref.ObjectRef line = new Ref.ObjectRef();
                while (true) {
                    String string = bufferedReader.readLine();
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    line.element = it;
                    if (string != null) {
                        stringBuilder.append((String)line.element);
                        stringBuilder.append("\r\n");
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                BufferedReader bufferedReader2 = bufferedReader;
                if (bufferedReader2 == null) throw throwable;
                bufferedReader2.close();
                throw throwable;
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return stringBuilder.toString();
        }
        catch (Resources.NotFoundException notFoundException) {
            notFoundException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private Shloader() {
    }

    static {
        Shloader shloader;
        INSTANCE = shloader = new Shloader();
    }
}

