/*
 * Decompiled with CFR 0.152.
 */
package com.lib;

import android.app.Activity;
import android.app.Application;
import android.content.res.AssetManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.basic.G;
import com.lib.FunSDKAnnotation;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.XMSGHandler;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.lib.sdk.struct.SDK_FishEyeFrameCM;
import com.lib.sdk.struct.SDK_FishEyeFrameHW;
import com.lib.sdk.struct.SDK_FishEyeFrameSW;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FunSDK {
    public static final int N_DEF_TIMEOUT = 10000;
    public static ActiveLifeListener s_actListener = null;
    private static int s_nWndId;
    private static Map<Integer, XMSGHandler> s_wnd_handler;
    private static Map<Integer, ArrayList<Integer>> s_wnd_msg;
    public static boolean s_bInitNetSDK;

    static {
        try {
            System.loadLibrary("vrsoft");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.loadLibrary("fisheye");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.loadLibrary("FunSDK");
        s_nWndId = 1;
        s_wnd_handler = new HashMap<Integer, XMSGHandler>();
        s_wnd_msg = new HashMap<Integer, ArrayList<Integer>>();
        s_bInitNetSDK = true;
    }

    private FunSDK() {
    }

    public static void SetApplication(Application ap) {
        if (ap == null) {
            return;
        }
        if (s_actListener == null) {
            s_actListener = new ActiveLifeListener();
            ap.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity act, Bundle arg1) {
                    System.out.println("FunSDK-->onActivityCreated" + act.toString());
                }

                public void onActivityDestroyed(Activity act) {
                    System.out.println("FunSDK-->onActivityDestroyed" + act.toString());
                }

                public void onActivityPaused(Activity act) {
                    System.out.println("FunSDK-->onActivityPaused" + act.toString());
                }

                public void onActivityResumed(Activity act) {
                    System.out.println("FunSDK-->onActivityResumed" + act.toString());
                }

                public void onActivitySaveInstanceState(Activity act, Bundle arg1) {
                    System.out.println("FunSDK-->onActivitySaveInstanceState" + act.toString());
                }

                public void onActivityStarted(Activity act) {
                    s_actListener.OnActive(true);
                    System.out.println("FunSDK-->onActivityStarted" + act.toString());
                }

                public void onActivityStopped(Activity act) {
                    s_actListener.OnActive(false);
                    System.out.println("FunSDK-->onActivityStopped" + act.toString());
                }
            });
        }
    }

    public static boolean IsActive() {
        return s_actListener != null && s_actListener.IsActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int RegUser(IFunSDKResult resultListener) {
        int nRet = 0;
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            nRet = s_nWndId++;
            XMSGHandler handler = new XMSGHandler(resultListener);
            s_wnd_handler.put(nRet, handler);
        }
        System.err.println("OnMessage RegUser-->User:[" + nRet + "]");
        return nRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UnRegUser(int nUserId) {
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            if (s_wnd_handler.containsKey(nUserId)) {
                s_wnd_handler.remove(nUserId);
                Collection<ArrayList<Integer>> c = s_wnd_msg.values();
                for (ArrayList<Integer> v : c) {
                    Iterator<Integer> itrValue = v.iterator();
                    while (itrValue.hasNext()) {
                        Integer i = itrValue.next();
                        if (i != nUserId) continue;
                        itrValue.remove();
                        System.err.println("OnMessage UnRegUser-->User:[" + nUserId + "]");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int GetId(int nUserChekId, IFunSDKResult resultListener) {
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            XMSGHandler handler;
            if (s_wnd_handler.containsKey(nUserChekId) && (handler = s_wnd_handler.get(nUserChekId)).GetUserInterface().equals(resultListener)) {
                try {
                    Thread handlerThread = handler.getLooper().getThread();
                    if (handlerThread != null && handlerThread.isAlive()) {
                        return nUserChekId;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.err.println("OnMessage Thread dead-->User:[" + nUserChekId + "]");
                s_wnd_handler.remove(nUserChekId);
            }
        }
        return FunSDK.RegUser(resultListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int RegMsgId(int nMsgId, int nUserId) {
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            ArrayList<Object> wndList = null;
            if (s_wnd_msg.containsKey(nMsgId)) {
                wndList = s_wnd_msg.get(nMsgId);
            } else {
                wndList = new ArrayList();
                s_wnd_msg.put(nMsgId, wndList);
            }
            if (!wndList.contains(nUserId)) {
                wndList.add(nUserId);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int UnRegMsgId(int nMsgId, int nUserId) {
        block5: {
            Map<Integer, XMSGHandler> map = s_wnd_handler;
            synchronized (map) {
                List wndList;
                block4: {
                    if (!s_wnd_msg.containsKey(nMsgId)) break block5;
                    wndList = s_wnd_msg.get(nUserId);
                    if (wndList != null) break block4;
                    return 0;
                }
                wndList.remove(nUserId);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int OnMessage(int sender, int user, int id, int param1, int param2, int param3, String str, byte[] pData, int seq) {
        Handler hUser = null;
        MsgContent xmsg = new MsgContent();
        xmsg.arg3 = param3;
        xmsg.str = str;
        xmsg.pData = pData;
        xmsg.seq = seq;
        xmsg.sender = sender;
        Message message = Message.obtain();
        message.arg1 = param1;
        message.arg2 = param2;
        message.obj = xmsg;
        message.what = id;
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            if (s_wnd_handler.containsKey(user)) {
                hUser = s_wnd_handler.get(user);
                if (hUser != null) {
                    hUser.sendMessage(message);
                }
            } else {
                System.err.println("OnMessage ERROR-->\u6ca1\u6709\u63a5\u6536\u5bf9\u8c61 " + id);
            }
            ArrayList<Integer> wndList = null;
            if (s_wnd_msg.containsKey(id)) {
                wndList = s_wnd_msg.get(id);
                for (Integer i : wndList) {
                    if (!s_wnd_handler.containsKey(i)) continue;
                    MsgContent xmsg2 = new MsgContent();
                    xmsg2.arg3 = param3;
                    xmsg2.str = str;
                    xmsg2.pData = pData;
                    xmsg2.seq = seq;
                    xmsg2.sender = sender;
                    Message message2 = Message.obtain();
                    message2.arg1 = param1;
                    message2.arg2 = param2;
                    message2.obj = xmsg2;
                    message2.what = id;
                    hUser = s_wnd_handler.get(i);
                    if (hUser == null) continue;
                    hUser.sendMessage(message2);
                }
            }
        }
        return 0;
    }

    @FunSDKAnnotation(method="@deprecated \u63a5\u53e3\u5e9f\u5f03", param="")
    public static native void SetNotSupXMSDKAttr();

    @FunSDKAnnotation(method="\u7279\u6b8aFunSDK\u7248\u672c-->xmnat_nabto\u7248\u672c\u4f7f\u7528\uff0c\u9700\u8981\u5728Init\u63a5\u53e3\u4e4b\u524d\u8c03\u7528\u63a5\u53e3", param="String sPath")
    public static native int SetXMNatNabtoPath(String var0);

    @FunSDKAnnotation(method="\u8bbe\u7f6exmnat_nabto\u65e5\u5fd7\u7b49\u7ea7, error, warn, info, debug, trace *\u9ed8\u8ba4:debug", param="String sLogLevel")
    public static native int SetXMNatNabtoLogLevel(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6Nabto Device ID \uff0c\u5982\u679c\u83b7\u53d6\u5230\u4e3a\u7a7a\u7684\u4e0d\u663e\u793a\uff08\u8868\u660e\u4e0d\u662fNabto\u7684\u8bbe\u5907\uff0c\u65b9\u4fbf\u6392\u67e5\u662f\u5426\u5df2\u7ecf\u7ed1\u5b9aNabto ID\u6216\u8005\u5df2\u5347\u7ea7\u65b0\u56fa\u4ef6\uff09", param="String szDevSn)")
    public static native String GetXMNabtoDevID(String var0);

    @FunSDKAnnotation(method="\u7981\u6b62\u9700\u8981\u8fde\u63a5\u5916\u7f51\u76f8\u5173\u670d\u52a1\uff0c\u4e3a\u4e86\u5c40\u57df\u7f51\u73af\u5883\u7684\u8bbe\u5907\uff0c\u51cf\u5c11\u6d41\u91cf\u6d88\u8017", param="")
    public static native void DisableConnectExtranet();

    @FunSDKAnnotation(method="\u521d\u59cb\u5316\u5e93\uff0c\u6574\u4e2a\u7a0b\u5e8f\u53ea\u9700\u8981\u8c03\u7528\u4e00\u6b21", param="int nParam, byte[] pParam")
    public static native int Init(int var0, byte[] var1);

    public static native int InitExV2(int var0, byte[] var1, int var2, String var3, String var4, int var5);

    public static native void UnInit(int var0);

    public static native int InitEx(int var0, byte[] var1, String var2, String var3, int var4);

    public static void MyInitNetSDK(OnFunSDKInitListener ls) {
        if (ls != null) {
            ls.onInit();
        }
        if (!s_bInitNetSDK) {
            System.out.println("InitNetSDK");
            FunSDK.InitNetSDK();
            s_bInitNetSDK = true;
        }
    }

    public static void MyInitNetSDK() {
        FunSDK.MyInitNetSDK(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void MyUnInitNetSDK() {
        if (s_bInitNetSDK) {
            System.out.println("UnInitNetSDK");
            FunSDK.UnInitNetSDK();
            Map<Integer, XMSGHandler> map = s_wnd_handler;
            synchronized (map) {
                s_wnd_handler.clear();
            }
            s_wnd_msg.clear();
            s_bInitNetSDK = false;
        }
    }

    @FunSDKAnnotation(method="UnInitNetSDK & \u5220\u9664\u4e0e\u7c7b\u4e0d\u5339\u914d\u7684\u6d88\u606f\u5bf9\u8c61\u952e\u503c", param="\u7c7b\u540d\u79f0")
    public static void MyUnInitNetSDKAndDeleteNonMatch(String className) {
        if (s_bInitNetSDK) {
            System.out.println("MyUnInitNetSDKAndDeleteNonMatch");
            FunSDK.UnInitNetSDK();
            FunSDK.clearGeneralReference(className, false);
            s_wnd_msg.clear();
            s_bInitNetSDK = false;
        }
    }

    @FunSDKAnnotation(method="UnInitNetSDK & \u5220\u9664\u4e0e\u7c7b\u5339\u914d\u7684\u6d88\u606f\u5bf9\u8c61\u952e\u503c", param="\u7c7b\u540d\u79f0")
    public static void MyUnInitNetSDKAndDeleteMatch(String className) {
        if (s_bInitNetSDK) {
            System.out.println("MyUnInitNetSDKAndDeleteMatch");
            FunSDK.UnInitNetSDK();
            FunSDK.clearGeneralReference(className, true);
            s_wnd_msg.clear();
            s_bInitNetSDK = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FunSDKAnnotation(method="", param="\u7c7b\u540d\u79f0")
    private static void clearGeneralReference(String className, boolean deleteMatching) {
        if (className != null && !className.equals("")) {
            Map<Integer, XMSGHandler> map = s_wnd_handler;
            synchronized (map) {
                Iterator<Map.Entry<Integer, XMSGHandler>> var2 = s_wnd_handler.entrySet().iterator();
                while (var2.hasNext()) {
                    Map.Entry<Integer, XMSGHandler> entry = var2.next();
                    String currentClassName = entry.getValue().GetUserInterface().getClass().getSimpleName();
                    if (deleteMatching && className.equals(currentClassName)) {
                        var2.remove();
                        continue;
                    }
                    if (deleteMatching || className.equals(currentClassName)) continue;
                    var2.remove();
                }
            }
        }
        Map<Integer, XMSGHandler> map = s_wnd_handler;
        synchronized (map) {
            s_wnd_handler.clear();
        }
    }

    private static native void SetActive(int var0);

    private static native int InitNetSDK();

    private static native void UnInitNetSDK();

    public static native void Log(String var0);

    public static native void LogInit(int var0, String var1, int var2, String var3, int var4);

    public static native void SendLogFile(String var0);

    public static native void Crash(String var0);

    public static native String GetVersionInfo();

    @FunSDKAnnotation(method="\u8bbe\u7f6ep2p\u6570\u636e\u4ea4\u4e92\u52a0\u5bc6\u5f00\u5173 *\u9ed8\u8ba4:\u52a0\u5bc6", param="int nEnable")
    public static native int SetP2PDataEncryptEnable(int var0);

    public static native int GetIntAttr(int var0, int var1);

    public static native String GetStrAttr(int var0, int var1);

    public static native int SetIntAttr(int var0, int var1, int var2);

    public static native int SetStrAttr(int var0, int var1, String var2);

    public static native int GetAttr(int var0, int var1, byte[] var2);

    public static native int SetAttr(int var0, int var1, byte[] var2);

    public static native int DestoryObj(int var0, int var1);

    public static native int GetObjHandle(int var0);

    public static native int GetDevHandle(String var0);

    public static native int SendMsg(int var0, int var1, int var2, int var3, int var4, int var5, String var6, byte[] var7, int var8);

    public static int SendMsg(int hObj, int hUser, int nMsgId) {
        return FunSDK.SendMsg(hObj, hUser, nMsgId, 0, 0, 0, "", null, 0);
    }

    public static int SendMsg(int hObj, int hUser, int nMsgId, int nSeq) {
        return FunSDK.SendMsg(hObj, hUser, nMsgId, 0, 0, 0, "", null, nSeq);
    }

    public static int SendMsg(int hObj, int hUser, int nMsgId, int nParam1, String sParam, int nSeq) {
        return FunSDK.SendMsg(hObj, hUser, nMsgId, nParam1, 0, 0, sParam, null, nSeq);
    }

    public static native int GetFunIntAttr(int var0);

    public static native String GetFunStrAttr(int var0);

    public static native int SetFunIntAttr(int var0, int var1);

    public static native int SetFunStrAttr(int var0, String var1);

    @FunSDKAnnotation(method="\u670d\u52a1\u5668\u76f8\u5173\u7684\u64cd\u4f5c", param="String szIP, int nPort")
    public static native int SysInitNet(String var0, int var1);

    public static native int SysInitLocal(String var0);

    public static native int SysInitAsAPModle(String var0);

    @FunSDKAnnotation(method="\u5bc6\u7801\u6570\u636e\u8fc1\u79fb", param="String sPwdFile, String sPwdAesKeyFile")
    public static native int ThePwdDataMigration(String var0, String var1);

    @FunSDKAnnotation(method="\u540cThePwdDataMigration\uff0c \u589e\u52a0\u53c2\u6570boolean bIsCover\uff1a\u662f\u5426\u8986\u76d6\u5f53\u524d\u672c\u5730\u5bc6\u7801", param="String sPwdFile, String sPwdAesKeyFile, boolean bIsCover")
    public static native int ThePwdDataMigrationV2(String var0, String var1, boolean var2);

    @FunSDKAnnotation(method="\u521d\u59cb\u5316\u4e00\u4e9b\u8d26\u6237\u7cfb\u7edf\u9700\u8981\u4f7f\u7528\u7684\u57fa\u7840\u4fe1\u606f", param="String szInfoJson")
    public static native void SysInitBasicInfo(String var0);

    public static native int SysSetServerIPPort(String var0, String var1, int var2);

    public static native int SysAddDevByFile(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_CLOUD_ACCOUNT_LOGTIN = 5207 / \u4e91\u8d26\u6237\u767b\u5f55", param="int hUser, String szUserName, String szPassword, int nSeq")
    public static native int SysCloudAccountLogin(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_THIRD_PARTY_ACCOUNT_LOGTIN = 5208 / \u7b2c\u4e09\u65b9\u8d26\u6237\u767b\u5f55", param="int hUser, String szUnionId, String szType, int nSeq")
    public static native int SysThirdPartyAccountLogin(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_PHONE_SMS_LOGTIN = 5209 / \u624b\u673a\u77ed\u4fe1\u767b\u5f55", param="int hUser, String szPhone, String szCheckCode, int nSeq")
    public static native int SysPhoneSMSLogin(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_GET_CURRENT_USER_DEV_LIST = 5093 / \u83b7\u53d6\u5f53\u524d\u8d26\u6237\u4e0b\u8bbe\u5907\u5217\u8868", param="int hUser,int nSeq")
    public static native int SysGetCurrentUserDevList(int var0, int var1);

    public static native int SysGetDevList(int var0, String var1, String var2, int var3);

    public static native int SysSmsGetDevList(int var0, String var1, String var2, int var3, int var4);

    public static native int SysGetDevListEx(int var0, String var1, String var2, int var3, int var4);

    public static native int SysGetAPDevList(int var0, String var1, String var2, int var3);

    public static native int SysUserRegister(int var0, String var1, String var2, String var3, int var4);

    public static native int SysPswChange(int var0, String var1, String var2, String var3, int var4);

    public static native int SysAddDevice(int var0, byte[] var1, String var2, String var3, int var4);

    public static native int SysDevIsMasterAccount(String var0);

    public static native String SysGetDevComment(String var0);

    @FunSDKAnnotation(method="\u6309\u5b57\u6bb5\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f", param="String szDevId, String szField")
    public static native String SysGetDevInfoByField(String var0, String var1);

    @FunSDKAnnotation(method="\u4fee\u6539\u7f13\u5b58\u8bbe\u5907\u4fe1\u606f", param="String szDevId, long nSystemTime, int nNumberOfSharedAccounts, int nOptionType, String szExJson")
    public static native int SysModifyCacheDevInfo(String var0, long var1, int var3, int var4, String var5);

    public static native int SysChangeDevInfo(int var0, byte[] var1, String var2, String var3, int var4);

    public static native int SysDeleteDev(int var0, String var1, String var2, String var3, int var4);

    @FunSDKAnnotation(method="\u5220\u9664\u8bbe\u5907 \u66ff\u4ee3SysDeleteDev", param="int hUser, String szDelDevID, int nSeq")
    public static native int SysDeleteDevice(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u6279\u91cf\u5220\u9664\u8bbe\u5907", param="int hUser, String szDelDevID, int nSeq")
    public static native int SysBatchDeleteDevices(int var0, String var1, int var2);

    public static native int SysPswRestore(int var0, String var1, String var2, int var3);

    public static native int SysGetDevState(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_GET_DEV_STATE = 5009 / \u6309\u7c7b\u578b\u83b7\u53d6\u6279\u91cf\u8bbe\u5907\u72b6\u6001(\u53ea\u80fd\u83b7\u53d6\u5355\u4e2a\u7c7b\u578b\u72b6\u6001)", param="int hUser, String sDevIds, int nQueryType, int nSeq")
    public static native int SysGetDevStateByType(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="SYS_GET_DEV_STATE = 5009 / \u83b7\u53d6\u6279\u91cf\u8bbe\u5907\u72b6\u6001(\u53ef\u4ee5\u540c\u65f6\u83b7\u53d6\u591a\u4e2a\u7c7b\u578b\u72b6\u6001)", param="int hUser, String szDevIDs, int nQueryTypeMask, int nSeq")
    public static native int SysBatchGetDevsStatus(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="SYS_QUERY_DEVS_STATUS = 5210 / \u6279\u91cf\u67e5\u8be2\u591a\u4e2a\u8bbe\u5907\u591a\u4e2a\u670d\u52a1\u72b6\u6001(\u7ed3\u679c\u4e00\u6b21\u6027\u5168\u90e8\u8fd4\u56de)", param="int hUser, String szDevSNs, int nQueryTypeMask, int nTimeout, int nSeq")
    public static native int SysQueryDevsStatusV2(int var0, String var1, int var2, int var3, int var4);

    @FunSDKAnnotation(method="SYS_ON_DEV_STATE", param="int hUser")
    public static native int SysAddDevStateListener(int var0);

    public static native int SysRemoveDevStateListener(int var0);

    public static native int SysSendPhoneMsg(int var0, String var1, String var2, int var3);

    public static native int SysGetLoginAccountCode(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_REGISER_USER_XM", param="int hUser, String UserName, String pwd, String checkCode, String phoneNO, int nSeq")
    public static native int SysRegUserToXM(int var0, String var1, String var2, String var3, String var4, int var5);

    @FunSDKAnnotation(method="\u9a8c\u8bc1\u5bc6\u7801\u662f\u5426\u7b26\u5408\u89c4\u5b9a", param="int hUser, String pwd, int nSeq")
    public static native int SysCheckPwdStrength(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_GET_DEV_INFO_BY_USER_XM / Strings\u7ed3\u6784\u4f53", param="int hUser, String userName, String password, int nSeq")
    public static native int SysLoginToXM(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_EDIT_PWD_XM / \u4fee\u6539\u7528\u6237\u5bc6\u7801", param="int hUser, String UserName, String oldPwd, String newPwd, int nSeq")
    public static native int SysEditPwdXM(int var0, String var1, String var2, String var3, int var4);

    @FunSDKAnnotation(method="SYS_FORGET_PWD_XM / \u5fd8\u8bb0\u767b\u5f55\u5bc6\u7801", param="int hUser, String phoneOrEmail, int nSeq")
    public static native int SysForgetPwdXM(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_DULIST", param="int hUser, String devId, int nSeq")
    public static native int SysGetDevUserInfo(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_MDSETMA", param="int hUser, String devId, String sUserId, int nSeq")
    public static native int SysSetDevMasterAccount(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_IS_MASTERMA", param="int hUser, String devId, int nSeq")
    public static native int SysIsDevMasterAccountFromServer(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_GET_ABILITY_SET / \u4ece\u670d\u52a1\u5668\u7aef\u83b7\u53d6\u8bbe\u5907\u7684\u80fd\u529b\u96c6", param="int hUser,String devSysInfo, int nSeq")
    public static native int SysGetDevAbilitySetFromServer(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_GET_DEV_CAPABILITY_SET / \u4ece\u670d\u52a1\u5668\u83b7\u53d6\u8bbe\u5907\u7684\u80fd\u529b\u96c6,\u8fd4\u56de\u670d\u52a1\u5668\u4e0b\u53d1\u7684\u6574\u4e2ajson\u5bf9\u8c61\u7ed9\u8bf7\u6c42\u7aef", param="int hUser,String devSysInfo, int nSeq")
    public static native int SysGetDevCapabilitySet(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_BATCH_GET_DEV_CAPABILITY_SET / \u6279\u91cf\u83b7\u53d6\u8bbe\u5907\u80fd\u529b\u7ea7 \u53c2\u8003\uff1ahttp://10.2.11.100/pages/viewpage.action?pageId=25902177", param="int hUser, String szDevsSysInfo, int nSeq")
    public static native int SysBatchGetDevCapabilitySet(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_CHECK_DEV_VALIDITY / \u9a8c\u8bc1\u8bbe\u5907\u5408\u6cd5\u6027", param="int hUser,String devId,String devCode, int nSeq")
    public static native int SysCheckDevValidityFromServer(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_USER_WX_UNBIND = 5078 / \u7528\u6237\u89e3\u9664\u5fae\u4fe1\u7ed1\u5b9a", param="int hUser, int nSeq")
    public static native int SysUserWXUnbind(int var0, int var1);

    @FunSDKAnnotation(method="SYS_SEND_EMAIL_LINK_TO_REGISTER_USER = 5097 / \u53d1\u9001\u94fe\u63a5\u90ae\u4ef6\u7528\u4e8e\u6ce8\u518c\u7528\u6237", param="int hUser, String szEmail, String szPassword, int nSeq")
    public static native int SysSendEmailLinkToRegisterUser(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_CHECK_USER_IS_ACTIVATED = 5099 / \u68c0\u6d4b\u7528\u6237\u662f\u5426\u5df2\u6fc0\u6d3b", param="int hUser, String szUserID, int nSeq")
    public static native int SysCheckUserIsActivated(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_SEND_EMAIL_LINK_TO_RESET_PASSWORD = 5201 / \u53d1\u9001\u94fe\u63a5\u90ae\u4ef6\u7528\u4e8e\u91cd\u7f6e\u5bc6\u7801", param="int hUser, String szEmail, int nSeq")
    public static native int SysSendEmailLinkToResetPassword(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_CHECK_RESET_PASSWORD_IS_ACTIVATED = 5202 / \u68c0\u6d4b\u90ae\u7bb1\u91cd\u7f6e\u5bc6\u7801\u94fe\u63a5\u662f\u5426\u6fc0\u6d3b", param="int hUser, String szUserID, int nSeq")
    public static native int SysCheckResetPasswordIsActivated(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_MODIFY_ACCOUNT_NICKNAME = 5205 / \u4fee\u6539\u4e91\u8d26\u6237\u6635\u79f0", param="int hUser, String szNickname, int nSeq")
    public static native int SysModifyAccountNickname(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_GET_DEV_ENC_TOKEN_FORM_RS = 5094 / \u83b7\u53d6\u8bbe\u5907\u767b\u5f55\u4ee4\u724c\u4fe1\u606f", param="int hUser, const char *szDevIDs, int nSeq")
    public static native int SysGetDevEncToken(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u901a\u8fc7\u5f71\u5b50\u670d\u52a1\u5668\u6279\u91cf\u83b7\u53d6\u914d\u7f6e", param="int hUser, String sDeviceSN, String sRequestJsons, int nTimeout, int nSeq")
    public static native int SysGetCfgsFormShadowServer(int var0, String var1, String var2, int var3, int var4);

    @FunSDKAnnotation(method="\u589e\u52a0\u5f71\u5b50\u670d\u52a1\u8bbe\u5907\u914d\u7f6e\u72b6\u6001\u76d1\u542c", param="int hUser, String sDeviceSN, String sCfgNames")
    public static native int SysAddShadowServerListener(int var0, String var1, String var2);

    @FunSDKAnnotation(method="\u79fb\u9664\u5f71\u5b50\u670d\u52a1\u8bbe\u5907\u914d\u7f6e\u76d1\u542c", param="String sDeviceSN")
    public static native int SysRemoveShadowServerListener(String var0);

    @FunSDKAnnotation(method="SHADOW_SERVICE_GET_DEV_CONFIGS = 8800 / \u5f71\u5b50\u670d\u52a1\u5668\u83b7\u53d6\u8bbe\u5907\u914d\u7f6e", param="int hUser, String szDeviceSN, String szCfgsJson, int nTimeout, int nSeq")
    public static native int GetDevCfgsFromShadowService(int var0, String var1, String var2, int var3, int var4);

    @FunSDKAnnotation(method="SHADOW_SERVICE_SET_DEV_OFFLINE_CFGS = 8801 / \u8bbe\u7f6e\u8bbe\u5907\u79bb\u7ebf\u914d\u7f6e\u5230\u5f71\u5b50\u670d\u52a1", param="int hUser, String szDeviceSN, String szCfgsJson, int nTimeout, int nSeq")
    public static native int SetDevOffLineCfgsToShadowService(int var0, String var1, String var2, int var3, int var4);

    @FunSDKAnnotation(method="SHADOW_SERVICE_START_DEV_LISTENING / SHADOW_SERVICE_DEV_CONFIGS_CHANGE_NOTIFY / \u5f71\u5b50\u670d\u52a1\u8bbe\u5907\u914d\u7f6e\u72b6\u6001\u76d1\u542c", param="int hUser, String szDeviceSNs, int nTimeout, int nSeq")
    public static native int AddShadowServiceListener(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="SHADOW_SERVICE_STOP_DEV_LISTENING / \u79fb\u9664\u5f71\u5b50\u670d\u52a1\u8bbe\u5907\u914d\u7f6e\u76d1\u542c", param="int hUser, String szDeviceSNs, int nTimeout, int nSeq")
    public static native int RemoveShadowServiceListener(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="SYS_NET_SPEED_TEST / \u5ba2\u6237\u7aef\u5230JF\u670d\u52a1\u5668\u7f51\u7edc\u901f\u5ea6\u6d4b\u8bd5", param="int hUser, int nSpeedFileSize, int nSeq")
    public static native int SysNetSpeedTest(int var0, int var1, int var2);

    @FunSDKAnnotation(method=" SYS_REST_PWD_CHECK_XM / \u9a8c\u8bc1\u91cd\u7f6e\u5bc6\u7801\u7684\u9a8c\u8bc1\u7801\u662f\u5426\u6b63\u786e", param="int hUser, String phoneOrEmail, String checkNum, int nSeq")
    public static native int CheckResetCodeXM(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_RESET_PWD_XM / \u91cd\u7f6e\u767b\u5f55\u5bc6\u7801", param="int hUser, String phone, String newPwd, int nSeq")
    public static native int ResetPwdXM(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u68c0\u67e5\u7528\u6237\u540d\u662f\u5426\u5df2\u7ecf\u88ab\u6ce8\u518c", param="int hUser, String userName, int nSeq")
    public static native int SysCheckUserRegiste(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_DEV_GET_PUBLIC / \u83b7\u53d6\u7528\u6237\u516c\u5f00\u8bbe\u5907\u5217\u8868", param="int hUser, int nSeq")
    public static native int GetPublicDevList(int var0, int var1);

    @FunSDKAnnotation(method="SYS_DEV_GET_SHARE / \u83b7\u53d6\u7528\u6237\u5171\u4eab\u8bbe\u5907\u5217\u8868", param="int hUser, int nSeq")
    public static native int GetShareDevList(int var0, int var1);

    @FunSDKAnnotation(method="SYS_DEV_PUBLIC / \u516c\u5f00\u8bbe\u5907", param="int hUser, String szDevId, String param, int nSeq")
    public static native int SetDevPublic(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="SYS_DEV_SHARE / \u5206\u4eab\u8bbe\u5907(\u5206\u4eab\u89c6\u9891)", param="int hUser, String szDevId, String param, int nSeq")
    public static native int ShareDevVideo(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u89c6\u9891\u5e7f\u573a\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f", param="int hUser, String videoId, int nSeq")
    public static native int GetVideoInfo(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u89c6\u9891\u5e7f\u573a\u4e0a\u4f20", param="int hUser, String title, String location, String description, String catagroyId, String videoFileName, String pictureFileName, int nSeq")
    public static native int UpLoadLocalVideo(int var0, String var1, String var2, String var3, String var4, String var5, String var6, int var7);

    @FunSDKAnnotation(method="SYS_DEV_CANCLE_PUBLIC / \u53d6\u6d88\u516c\u5f00\u8bbe\u5907", param="int hUser, String szDevId, int nSeq")
    public static native int CancelDevPublic(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_DEV_CANCLE_SHARE / \u53d6\u6d88\u5206\u4eab\u8bbe\u5907", param="int hUser, String szDevId, int nSeq")
    public static native int CancelShareDevVideo(int var0, String var1, int var2);

    public static native int SendComment(int var0, String var1, String var2, int var3);

    public static native int GetCommentList(int var0, String var1, int var2, int var3);

    public static native int SysLogout(int var0, int var1);

    public static native int SysNoValidatedRegister(int var0, String var1, String var2, int var3);

    public static native int SysGetUerInfo(int var0, String var1, String var2, int var3);

    public static native int SysSendBindingPhoneCode(int var0, String var1, String var2, String var3, int var4);

    @FunSDKAnnotation(method="\u83b7\u53d6\u9a8c\u8bc1\u7801(\u7528\u4e8e\u5f53\u524d\u8d26\u6237\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u66ff\u6362SysSendBindingPhoneCode)", param="int hUser, String szPhone, int nSeq")
    public static native int SysGetVerCodeForBindPhone(int var0, String var1, int var2);

    public static native int SysBindingPhone(int var0, String var1, String var2, String var3, String var4, int var5);

    @FunSDKAnnotation(method="\u5f53\u524d\u8d26\u6237\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u66ff\u6362SysBindingPhone", param="int hUser, String szPhone, String szVerCode, int nSeq")
    public static native int SysAccountBindPhone(int var0, String var1, String var2, int var3);

    public static native int SysCloudUpGradeCheck(int var0, String var1, int var2);

    public static native int SysCloudUpGradeDownLoad(int var0, String var1, int var2);

    public static native int SysStopCloudUpGradeDownLoad(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u4ece\u670d\u52a1\u5668\u68c0\u6d4b\u5347\u7ea7\u4fe1\u606f SYS_CHECK_UPGRADE_FOR_SERVER", param="int hUser, String szRequestJson, String szCmd, int nTimeout, int nSeq")
    public static native int SysCheckUpgradeForServer(int var0, String var1, String var2, int var3, int var4);

    @FunSDKAnnotation(method="\u5f00\u59cb\u4ece\u670d\u52a1\u5668\u4e0b\u8f7d\u5347\u7ea7\u56fa\u4ef6 SYS_START_DOWNLOAD_UPGRADE_FILEE_FOR_SERVER/SYS_DOWNLOAD_UPGRADE_FILE_PROGRESSE_FOR_SERVER", param="int hUser, String szFilePath, String szUpgradeInfo, int nSeq")
    public static native int SysStartDownloadUpgradeFileForServer(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u505c\u6b62\u4ece\u670d\u52a1\u5668\u4e0b\u8f7d\u5347\u7ea7\u56fa\u4ef6 SYS_STOP_DOWNLOAD_UPGRADE_FILEE_FOR_SERVER", param="int hHandle, int hUser, int nSeq")
    public static native int SysStopDownloadUpgradeFileForServer(int var0, int var1, int var2);

    public static native int TestUpdate(int var0, byte[] var1, byte[] var2, int var3, String var4, int var5, int var6);

    @FunSDKAnnotation(method="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801 EMSG_SYS_SEND_EMAIL_CODE = 5041", param="int hUser, String email, int nSeq")
    public static native int SysSendEmailCode(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801 EMSG_SYS_SEND_EMAIL_CODE = 5041", param="int hUser, String email, String username, int nSeq")
    public static native int SysSendEmailCodeEx(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u90ae\u7bb1\u6ce8\u518c EMSG_SYS_REGISTE_BY_EMAIL = 5042", param="int hUser, String userName, String pwd, String email, String code, int nSeq")
    public static native int SysRegisteByEmail(int var0, String var1, String var2, String var3, String var4, int var5);

    @FunSDKAnnotation(method="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\uff08\u4fee\u6539\u5bc6\u7801\u3001\u91cd\u7f6e\u5bc6\u7801\uff09 EMSG_SYS_SEND_EMAIL_FOR_CODE = 5043", param="int hUser, String email, int nSeq")
    public static native int SysSendCodeForEmail(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u53d1\u9001\u90ae\u7bb1\u9a8c\u8bc1\u7801\uff08\u4fee\u6539\u5bc6\u7801\u3001\u91cd\u7f6e\u5bc6\u7801\uff09 EMSG_SYS_SEND_EMAIL_FOR_CODE = 5043", param="int hUser, String email, String username, int nSeq")
    public static native int SysSendCodeForEmailEx(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u9a8c\u8bc1\u90ae\u7bb1\u9a8c\u8bc1\u7801\uff08\u4fee\u6539\u5bc6\u7801\u3001\u91cd\u7f6e\u5bc6\u7801\uff09 EMSG_SYS_CHECK_CODE_FOR_EMAIL = 5044", param="int hUser, String email, String code, int nSeq")
    public static native int SysCheckCodeForEmail(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u901a\u8fc7\u90ae\u7bb1\u4fee\u6539\u5bc6\u7801\uff08\u91cd\u7f6e\u5bc6\u7801\uff09 EMSG_SYS_PSW_CHANGE_BY_EMAIL = 5045", param="int hUser, String email, String newPwd, int nSeq")
    public static native int SysChangePwdByEmail(int var0, String var1, String var2, int var3);

    public static native int SysSendBindingEmailCode(int var0, String var1, String var2, String var3, int var4);

    @FunSDKAnnotation(method="\u83b7\u53d6\u9a8c\u8bc1\u7801(\u7528\u4e8e\u5f53\u524d\u8d26\u6237\u7ed1\u5b9a\u90ae\u7bb1\uff0c\u66ff\u6362SysSendBindingEmailCode)", param="int hUser, String szEmail, String szUserName, int nSeq")
    public static native int SysGetVerCodeForBindEmail(int var0, String var1, String var2, int var3);

    public static native int SysBindingEmail(int var0, String var1, String var2, String var3, String var4, int var5);

    @FunSDKAnnotation(method="\u5f53\u524d\u8d26\u6237\u7ed1\u5b9a\u90ae\u7bb1 \u66ff\u6362FUN_SysBindingEmail", param="int hUser, String szEmail, String szVerCode, int nSeq")
    public static native int SysAccountBindEmail(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u6ce8\u9500\u7528\u6237\u8d26\u53f7 EMSG_SYS_CANCELLATION_USER_XM = 5075", param="int hUser,String code,int nSeq")
    public static native int SysCancellationAccount(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5f53\u524d\u8d26\u6237\u7ed1\u5b9a\u5fae\u4fe1", param="int hUser, String szwxLoginCode, int nSeq")
    public static native int SysBindWXAccount(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5f53\u524d\u8d26\u6237\u89e3\u7ed1\u5fae\u4fe1", param="int hUser, int nSeq")
    public static native int SysUnBindWXAccount(int var0, int var1);

    public static native int DevPTZControl(int var0, String var1, int var2, int var3, int var4, int var5, int var6);

    public static native int DevGetChnName(int var0, String var1, String var2, String var3, int var4);

    public static native int DevGetConnectType(int var0, String var1, int var2);

    public static native int DevGetConfigJson(int var0, String var1, String var2, int var3, int var4, String var5, int var6, int var7, int var8);

    @FunSDKAnnotation(method="\u8bbe\u5907\u914d\u7f6e\u83b7\u53d6(\u4e0d\u901a\u8fc7\u7f13\u5b58) / DEV_GET_JSON = 5128", param="int hUser, String szDevId, String szCmdName, int nChannelIndex, int nCmdReqId, String pConfig, int nCmdRes, int nTimeout, int nSeq")
    public static native int DevGetConfigJsonWithoutCache(int var0, String var1, String var2, int var3, int var4, String var5, int var6, int var7, int var8);

    public static native int DevSetConfigJson(int var0, String var1, String var2, String var3, int var4, int var5, int var6, int var7, int var8);

    public static native int DevGetConfigByJson(int var0, String var1, String var2, int var3, int var4, int var5, int var6);

    public static native int DevSetConfigByJson(int var0, String var1, String var2, String var3, int var4, int var5, int var6);

    public static native int DevCmdGeneral(int var0, String var1, int var2, String var3, int var4, int var5, byte[] var6, int var7, int var8);

    public static native int DevConfigJsonNotLogin(int var0, String var1, String var2, String var3, int var4, int var5, int var6, int var7, int var8);

    @FunSDKAnnotation(method="DEV_CONFIG_JSON_NOT_LOGIN / \u8bbe\u5907\u914d\u7f6e\u83b7\u53d6\u3001\u8bbe\u7f6e(not login)", param="int hUser, String szDevId, String szCmd, String pInParam, int nCmdReq, int nChannelNO, int nCmdRes, int nTimeout, int nSeq, int nActiveClose")
    public static native int DevConfigJsonNotLoginPtl(int var0, String var1, String var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public static native int DevSearchPicture(int var0, String var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, String var8, int var9);

    public static native int DevGetAttr(int var0, String var1, int var2, int var3, int var4, int var5, int var6);

    public static native int DevSetAttr(int var0, String var1, int var2, byte[] var3, int var4, int var5, int var6);

    public static native int DevFindFile(int var0, String var1, byte[] var2, int var3, int var4, int var5);

    public static native int DevFindFileByTime(int var0, String var1, byte[] var2, int var3, int var4);

    public static native int DevDowonLoadByFile(int var0, String var1, byte[] var2, String var3, int var4);

    public static native int DevDowonLoadByTime(int var0, String var1, byte[] var2, String var3, int var4);

    public static native int DevStopDownLoad(int var0);

    public static native int DownloadRecordBImage(int var0, String var1, int var2, int var3, String var4, int var5, int var6);

    public static native int DownloadRecordBImages(int var0, String var1, int var2, int var3, int var4, String var5, int var6, int var7, int var8);

    public static native int CancelDownloadRecordImage(String var0, int var1);

    public static native int SetDownRBImageQueueSize(String var0, int var1);

    @FunSDKAnnotation(method="\u5f00\u542f\u5bf9\u8bb2\u529f\u80fd\uff0c@deprecated\u63a5\u53e3\u5e9f\u5f03\uff0c\u4f7f\u7528DevStartTalk\u4ee3\u66ff", param="int hUser, String szDevId, byte[] pDevTalkParams, int nSeq")
    public static native int DevStarTalk(int var0, String var1, int var2, int var3, int var4);

    @FunSDKAnnotation(method="\u5f00\u542f\u5bf9\u8bb2\u529f\u80fd\uff0c\u5f02\u6b65\u6d88\u606fid=5501", param="int hUser, String szDevId, byte[] pDevTalkParams, int nSeq")
    public static native int DevStartTalk(int var0, String var1, byte[] var2, int var3);

    public static native int DevSendTalkData(String var0, byte[] var1, int var2);

    public static native void DevStopTalk(int var0);

    @FunSDKAnnotation(method="\u5f00\u542f\u97f3\u89c6\u9891\u5bf9\u8bb2(Client-->Dev) / DEV_START_AV_TALK = 5556", param="int hUser, String szDevID, String szReqJson, int nTimeout, int nSeq")
    public static native int DevStartAVTalk(int var0, String var1, String var2, int var3, int var4);

    @FunSDKAnnotation(method="\u53d1\u9001\u97f3\u89c6\u9891\u5bf9\u8bb2\u6570\u636e(Client-->Dev) / DEV_AV_TALK_SEND_DATA = 5557", param="int hUser, String szFrameInfo, byte[] pAVData, int nSeq")
    public static native int DevSendAVTalkData(int var0, String var1, byte[] var2, int var3);

    @FunSDKAnnotation(method="\u5173\u95ed\u97f3\u89c6\u9891\u5bf9\u8bb2(Client-->Dev) / DEV_STOP_AV_TALK = 5558", param="int hPlayer")
    public static native void DevStopAVTalkData(int var0);

    @FunSDKAnnotation(method="\u63a7\u5236\u97f3\u89c6\u9891\u5bf9\u8bb2(Client-->Dev) / DEV_CONTROL_AV_TALK = 5559", param="int hPlayer, String szCtrlJson, int nSeq")
    public static native int DevControlAVTalk(int var0, String var1, int var2);

    public static native int DevSearchDevice(int var0, int var1, int var2);

    public static native int DevStartAPConfig(int var0, int var1, String var2, String var3, String var4, String var5, int var6, int var7, String var8, int var9);

    public static native void DevStopAPConfig();

    public static native int DevStartWifiConfig(int var0, String var1, String var2, String var3, int var4);

    public static native int DevStartWifiConfigByAPLogin(int var0, String var1, String var2, String var3, int var4);

    public static native int DevStopWifiConfig();

    public static native int DevLogout(int var0, String var1, int var2);

    public static native int DevOption(int var0, String var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, String var8, int var9);

    public static native int DevSetUserData(int var0, byte[] var1);

    @FunSDKAnnotation(method="\u8bbe\u5907\u5347\u7ea7\u68c0\u6d4b", param="int hUser, String szDevId, int nSeq")
    public static native int DevCheckUpgrade(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u8bbe\u5907\u5347\u7ea7\u68c0\u6d4b(\u8bbe\u5907\u7aef\u68c0\u6d4b\u5347\u7ea7\u5931\u8d25\u540e\uff0cp2p\u6a21\u5f0f\u4e5f\u5141\u8bb8\u53bb\u670d\u52a1\u5668\u68c0\u6d4b\u5347\u7ea7\u4fe1\u606f\uff0capp\u9700\u8981\u63a7\u5236\u5347\u7ea7\uff0c\u5982\u679c\u662fp2p/\u8f6c\u53d1\u63d0\u793a\u65e0\u6cd5\u8fdb\u884c\u5347\u7ea7)", param="int hUser, String szDevId, int nSeq")
    public static native int DevCheckUpgradeAllNet(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5f00\u59cb\u5347\u7ea7", param="int hUser, String szDevId, int nType, int nSeq")
    public static native int DevStartUpgrade(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="\u901a\u8fc7\u672c\u5730\u6587\u4ef6\u5f00\u59cb\u5347\u7ea7", param="int hUser, String szDevId, String sFileName, int nSeq")
    public static native int DevStartUpgradeByFile(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u505c\u6b62\u5347\u7ea7", param="int hUser, String szDevId, int nSeq")
    public static native int DevStopUpgrade(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5347\u7ea7\u68c0\u6d4b(\u62d3\u5c55\u6a21\u5757)", param="int hUser, String szReqJson, int nSeq")
    public static native int DevExModulesCheckUpgrade(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5f00\u59cb\u5347\u7ea7(\u62d3\u5c55\u6a21\u5757)", param="int hUser, String szReqJson, int nSeq")
    public static native int DevExModulesStartUpgrade(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u901a\u8fc7\u672c\u5730\u6587\u4ef6\u5f00\u59cb\u5347\u7ea7(\u62d3\u5c55\u6a21\u5757)", param="int hUser, String szReqJson, int nSeq")
    public static native int DevExModulesStartUpgradeByFile(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u505c\u6b62\u5347\u7ea7(\u62d3\u5c55\u6a21\u5757)", param="int hUser, String szDevId, int nSe")
    public static native int DevExModulesStopUpgrade(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u5f00\u59cb\u5347\u7ea7\u524d\u7aefIPC", param="int hUser, String szDevID, int nChannel, int nUpgType, int nTimeout, int nSeq")
    public static native int DevStartUpgradeIPC(int var0, String var1, int var2, int var3, int var4, int var5);

    @FunSDKAnnotation(method="\u505c\u6b62\u524d\u7aefIPC\u5347\u7ea7", param="int hUser, String szDevID, int nSeq")
    public static native int DevStopUpgradeIPC(int var0, String var1, int var2);

    public static native int GetDevAbility(String var0, String var1);

    public static native int MediaRealPlay(int var0, String var1, int var2, int var3, Object var4, int var5);

    @FunSDKAnnotation(method="\u5b9e\u65f6\u9884\u89c8,\u517c\u5bb9MediaRealPlay", param="int hUser, String szDevId, int nChnIndex, int nStreamType, boolean bEnableSharedMediaLink, Object hWnd, int nSeq")
    public static native int MediaRealPlayEx(int var0, String var1, int var2, int var3, boolean var4, Object var5, int var6);

    public static native int MediaNetRecordPlay(int var0, String var1, byte[] var2, Object var3, int var4);

    public static native int MediaByVideoId(int var0, String var1, Object var2, int var3);

    public static native int MediaNetRecordPlayByTime(int var0, String var1, byte[] var2, Object var3, int var4);

    public static native int MediaLocRecordPlay(int var0, String var1, Object var2, int var3);

    public static native int MediaCloudRecordPlay(int var0, String var1, int var2, String var3, int var4, int var5, Object var6, int var7);

    public static native int MediaCloudRecordPlayV2(int var0, String var1, int var2, String var3, int var4, int var5, String var6, int var7, Object var8, int var9);

    public static native int MediaCloudRecordDownload(int var0, String var1, int var2, String var3, int var4, int var5, String var6, int var7);

    public static native int MediaCloudRecordDownloadV2(int var0, String var1, int var2, String var3, int var4, int var5, String var6, String var7, int var8, int var9);

    @FunSDKAnnotation(method="\u4e91\u5b58\u50a8\u89c6\u9891\u64ad\u653e(\u7b80\u5316\u534f\u8bae)", param="int hUser, String szReqJson, Object hWnd, int nSeq")
    public static native int MediaCloudStorageRecordPlay(int var0, String var1, Object var2, int var3);

    @FunSDKAnnotation(method="\u4e91\u5b58\u50a8\u89c6\u9891\u4e0b\u8f7d(\u7b80\u5316\u534f\u8bae)", param="int hUser, String szReqJson, int nSeq")
    public static native int MediaCloudStorageRecordDownload(int var0, String var1, int var2);

    @FunSDKAnnotation(method="\u591a\u8def\u4e91\u5b58\u50a8\u89c6\u9891\u64ad\u653e", param="String szReqJson, Object[] pObjects")
    public static native int MultiMediaCloudStorageRecordPlay(String var0, Object[] var1);

    @FunSDKAnnotation(method="\u591a\u8def\u4e91\u5b58\u50a8\u89c6\u9891\u4e0b\u8f7d", param="String szReqJson")
    public static native int MultiMediaCloudStorageRecordDownload(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6\u5a92\u4f53\u901a\u9053\u64ad\u653e\u53e5\u67c4", param="int hMultiPlayer, int nChannelIndex")
    public static native int GetMediaPlayerHandle(int var0, int var1);

    public static native int MediaRtspPlay(int var0, String var1, int var2, String var3, Object var4, int var5);

    public static native int GetDSSAbility(String var0, int var1);

    public static native int GetDSSChannelState(String var0, int var1, int var2);

    public static native int GetDSSMixedChannel(String var0, int var1);

    public static native int GetDevState(String var0, int var1);

    public static native int GetDevAllNetState(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6\u8bbe\u5907\u4e3b\u63a7\u4f4e\u529f\u8017\u72b6\u6001 / \u51fd\u6570\u8fd4\u56de\u503c:com.lib.SDKCONST.EFunDevState", param="String szDevSN")
    public static native int GetDevMasterControlState(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6\u8bbe\u5907\u5916\u7f51IP\u5730\u5740", param="String szDevSN")
    public static native String GetDevWanIP(String var0);

    @FunSDKAnnotation(method="\u6dfb\u52a0\u8bbe\u5907\u4fe1\u606f\u5230\u6570\u636e\u4e2d\u5fc3(SDK\u672c\u5730\u6570\u636e\u4e2d\u5fc3)", param="byte[] pDevInfo, int nWxpms, int nMa, String szComments")
    public static native void AddDevInfoToDataCenter(byte[] var0, int var1, int var2, String var3);

    @FunSDKAnnotation(method="\u4ece(SDK\u672c\u5730\u6570\u636e\u4e2d\u5fc3)\u5220\u9664\u8bbe\u5907\u4fe1\u606f(\u591a\u4e2a\u8bbe\u5907\u4ee5';'\u5206\u9694)", param="szDevsId")
    public static native void DeleteDevsInfoFromDataCenter(String var0);

    public static native int AddSharedDevMaUserId(String var0, String var1);

    public static native int MediaPlayXMp4(int var0, int var1, Object var2, int var3);

    public static native int MediaPlay(int var0, int var1);

    public static native int MediaPause(int var0, int var1, int var2);

    public static native int MediaStop(int var0);

    public static native int MediaSetPlaySpeed(int var0, int var1, int var2);

    public static native int MediaSetPlaySpeedStrategy(int var0, boolean var1);

    public static native int MediaStartRecord(int var0, String var1, int var2);

    public static native int MediaStopRecord(int var0, int var1);

    public static native int MediaSeekToTime(int var0, int var1, int var2, int var3);

    public static native int MediaSeekToMSTime(int var0, long var1, int var3);

    public static native int MediaSetSound(int var0, int var1, int var2);

    public static native int MediaSetBufferByTime(int var0, int var1, int var2);

    public static native int MediaPlayByURL(int var0, String var1, Object var2, int var3);

    public static native int MediaRecordPlay(int var0, String var1, Object var2, int var3);

    public static native int MediaPlayByURLEx(int var0, String var1, int var2, Object var3, int var4);

    @FunSDKAnnotation(method="\u901a\u8fc7M3u8 url\u64ad\u653e\u89c6\u9891", param="int hUser, String szUrl, Object hWnd, int nSeq")
    public static native int MediaPlayM3u8ByUrl(int var0, String var1, Object var2, int var3);

    @FunSDKAnnotation(method="\u901a\u8fc7M3u8 url\u4e0b\u8f7d\u89c6\u9891", param="int hUser, String szUrl, String szStorageFileName, int nSeq")
    public static native int MediaDownloadM3u8ByUrl(int var0, String var1, String var2, int var3);

    public static native int MediaRefresh(int var0, int var1);

    public static native int MediaSetPlayView(int var0, Object var1, int var2);

    public static native int MediaSetRealPlayModel(String var0, int var1);

    public static native int MediaGetRealPlayModel(String var0);

    @FunSDKAnnotation(method="\u5f00\u59cb\u5b58\u50a8\u5f53\u524d\u6b63\u5728\u64ad\u653e\u7684\u5a92\u4f53\u6570\u636e / START_STORE_PLAYING_MEDIA_DATA_INFO = 5560", param="int hPlayer, String szStorageInfoJson")
    public static native int StartStorePlayingMediaData(int var0, String var1);

    @FunSDKAnnotation(method="\u505c\u6b62\u5b58\u50a8\u5f53\u524d\u6b63\u5728\u64ad\u653e\u7684\u5a92\u4f53\u6570\u636e / STOP_STORE_PLAYING_MEDIA_DATA_INFO = 5561", param="int hPlayer")
    public static native int StopStorePlayingMediaData(int var0);

    public static native int MediaSetFluency(int var0, int var1, int var2);

    public static native int MediaSetIntellPlay(int var0, int var1, int var2, int var3);

    public static native int DevStartPushFacePicture(int var0, String var1, int var2, int var3, int var4, int var5);

    public static native int DevStartFileTransfer(int var0, String var1, String var2, int var3, int var4);

    public static native int DevFileDataTransfer(int var0, String var1, byte[] var2, int var3, int var4, int var5);

    public static native int DevFileDataTransfersV2(int var0, String var1, byte[] var2, int var3, int var4, int var5, int var6);

    public static native void DevStopFileTransfer(int var0);

    public static native int DevStartFileDataRecv(int var0, String var1, String var2, int var3, int var4);

    public static native long MediaGetCurTime(int var0);

    public static native int MediaSetDisplayBCSG(int var0, int var1, int var2, int var3, int var4);

    public static native byte[] MediaGetDecParam(String var0);

    public static native byte[] MediaGetFishParam(String var0);

    public static native int MediaGetCodecType(String var0);

    public static native String MediaGetRealTime(String var0);

    public static native int ToTimeType(int[] var0);

    public static native int ToTime(int var0, int[] var1);

    @FunSDKAnnotation(method="SYS_NET_PING / Ping\u6307\u5b9a\u57df\u540d", param="int hUser, String pServerAddr, boolean ifUseIPv6, int nPingTimes, int nSeq")
    public static native void Ping(int var0, String var1, boolean var2, int var3, int var4);

    @FunSDKAnnotation(method="SYS_MQTT_CLIENT / MQTT \u521d\u59cb\u5316", param="int hUser, String pPacketName,int nInterval, int nSeq")
    public static native int MQTTInit(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="SYS_MQTT_UNINIT / MQTT \u53cd\u521d\u59cb\u5316", param="int hUser, int nSeq")
    public static native int MQTTUnInit(int var0, int var1);

    @FunSDKAnnotation(method="SYS_MQTT_SUBSCRIBE_INFO / MQTT \u8ba2\u9605", param="int hUser, String sSubscribeJson, int nSeq")
    public static native int SubscribeInfoFromServer(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_MQTT_UNSUBSCRIBE_INFO / MQTT \u53d6\u6d88\u8ba2\u9605", param="int hUser, String sUnSubscribeJson, int nSeq")
    public static native int UnSubscribeInfoFromServer(int var0, String var1, int var2);

    @FunSDKAnnotation(method="SYS_LOCAL_PHONE_LOGIN = 5212 / \u672c\u673a\u53f7\u7801\u4e00\u952e\u767b\u5f55\u5e76\u83b7\u53d6\u8bbe\u5907\u5217\u8868", param="int hUser, String szAppToken, String szAppID, int nSeq")
    public static native int LoginByLocalPhoneNumber(int var0, String var1, String var2, int var3);

    public static native int MediaSnapImage(int var0, String var1, int var2);

    public static native int MediaGetThumbnail(int var0, String var1, int var2);

    public static native int MediaSeekToPos(int var0, int var1, int var2);

    public static native String DevMD5Encrypt(String var0);

    public static native int GNDeleteFiles(String var0, long var1, String var3);

    public static native String XMEncodePassword(String var0);

    public static native String XMDecodePassword(String var0);

    public static native int GetUserPhotosList(int var0, int var1, int var2);

    public static native int GetPhotoList(int var0, String var1, int var2, int var3);

    public static native int CreateUserPhotos(int var0, String var1, String var2, String var3, String var4, int var5);

    public static native int EditUserPhotos(int var0, String var1, String var2, String var3, String var4, String var5, int var6);

    public static native int UpLoadPhoto(int var0, String var1, String var2, String var3, String var4, String var5, int var6, int var7);

    public static native int EditPhotoInfo(int var0, String var1, String var2, String var3, String var4, String var5, int var6);

    public static native int GetShortVideoList(int var0, int var1);

    public static native int EditShortVideoInfo(int var0, String var1, String var2, String var3, String var4, int var5);

    public static native int DeleteShortVideo(int var0, String var1, int var2);

    public static native int DeletePhotos(int var0, String var1, int var2);

    public static native int DeletePhoto(int var0, String var1, int var2);

    public static native int CSSAPICommandCFS(int var0, String var1, String var2, String var3, String var4, int var5);

    public static native int KSSAPIUpLoadVideo(int var0, String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, int var10);

    public static native int StopDevSearchPic(int var0, String var1, int var2);

    public static native int DevStartUploadData(int var0, String var1, int var2, int var3);

    public static native int DevGeneralStartUploadData(int var0, String var1, String var2, int var3, int var4, int var5);

    public static native int DevStopUploadData(int var0, String var1, int var2, int var3);

    public static native int DevGeneralStopUploadData(int var0, String var1, String var2, int var3, int var4, int var5);

    public static native int Jpeg2Mp4Create(int var0, String var1, int var2, int var3, int var4, int var5);

    public static native int Jpeg2Mp4Add(int var0, String var1);

    public static native int Jpeg2Mp4Close(int var0);

    public static native int Jpeg2Mp4Cancel(int var0);

    public static native int InitLanguage(AssetManager var0, String var1);

    public static native String TS(String var0);

    public static native int GetDevChannelCount(String var0);

    public static native int DevErrorCodeAddToMonitor(int var0, int var1);

    public static native int DevErrorCodeRemoveFromTheMonitor(int var0, int var1);

    @FunSDKAnnotation(method="[sync]\u5224\u65ad\u8bbe\u5907\u662f\u5426\u5728\u5c40\u57df\u7f51\u5185\uff08\u4e0d\u8fdb\u884c\u5c40\u57df\u7f51\u641c\u7d22", param="String szDevId, byte[] devInfo")
    public static native int DevIsSearched(String var0, byte[] var1);

    @FunSDKAnnotation(method="[sync]\u5c40\u57df\u7f51\u641c\u7d22\u8bbe\u5907", param="String szDevId, int nTimeout, byte[] pDevInfo")
    public static native int DevLANSearch(String var0, int var1, byte[] var2);

    @FunSDKAnnotation(method="[sync]\u68c0\u6d4b\u5c40\u57df\u7f51\u8bbe\u5907TCP\u670d\u52a1", param="byte[] pDevsInfo, int nTimeout")
    public static native int DevIsDetectTCPService(byte[] var0, int var1);

    @FunSDKAnnotation(method="\u6dfb\u52a0\u5c40\u57df\u7f51\u5185\u8bbe\u5907\u5230SDK\u7f13\u5b58", param="byte[] pDevsInfo, int nDevCount")
    public static native int AddLANDevsToCache(byte[] var0, int var1);

    public static native void SwtichWriteH264File(boolean var0, String var1);

    public static native String EncDevInfo(String var0, String var1, String var2, int var3);

    public static native String DecDevInfo(String var0);

    public static native String EncGeneralDevInfo(String var0);

    public static native String DecGeneralDevInfo(String var0);

    public static native String DecQRCodeDevInfo(String var0);

    @FunSDKAnnotation(method="AES_ECB_128_PKCS5Padding\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679cbase64\u52a0\u5bc6\u8fd4\u56de", param="String sRawData, String sKey")
    public static native String EncAesEcb128(String var0, String var1);

    @FunSDKAnnotation(method="AES_ECB_128_PKCS5Padding\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679c\u4e8c\u8fdb\u5236\u6570\u636e\u8fd4\u56de", param="String szRawData, String szKey, boolean bSecureRandomKey")
    public static native byte[] AesEcb128PKCS5RetBinary(String var0, String var1, boolean var2);

    @FunSDKAnnotation(method="base64\u6570\u636eAES_ECB_128_PKCS5Padding_Key\u89e3\u5bc6\uff0c\u89e3\u5bc6\u7ed3\u679c\u4e3a\u5b57\u7b26\u4e32", param="String sBase64EncData, String sKey")
    public static native String DecAesEcb128(String var0, String var1);

    @FunSDKAnnotation(method="\u4e8c\u8fdb\u5236\u6570\u636eAES_ECB_128_PKCS5Padding_Key\u89e3\u5bc6\uff0c\u89e3\u5bc6\u7ed3\u679c\u4e3a\u5b57\u7b26\u4e32", param="byte[] pRawBinaryData, String szKey, boolean bSecureRandomKey")
    public static native String BinaryDataDecAesEcb128PKCS5(byte[] var0, String var1, boolean var2);

    @FunSDKAnnotation(method="AesCbc128PKCS7\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679c\u4e8c\u8fdb\u5236\u6570\u636e\u8fd4\u56de", param="byte[] pData, String szKey")
    public static native byte[] EncAesCbc128PKCS7RetBinary(byte[] var0, String var1);

    @FunSDKAnnotation(method="AesCbc128PKCS7\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679cBase64\u5b57\u7b26\u4e32\u6570\u636e\u8fd4\u56de", param="byte[] pData, String szKey")
    public static native String EncAesCbc128PKCS7RetBase64(byte[] var0, String var1);

    @FunSDKAnnotation(method="\u4e8c\u8fdb\u5236\u6570\u636e\u901a\u8fc7AesCbc128PKCS7\u89e3\u5bc6", param="byte[] pData, String szKey")
    public static native byte[] BinaryDataDecAesCbc128PKCS7(byte[] var0, String var1);

    @FunSDKAnnotation(method="Base64\u52a0\u5bc6\u7684\u6570\u636e\u901a\u8fc7AesCbc128PKCS7\u89e3\u5bc6", param="String szData, String szKey")
    public static native byte[] DecBase64DataAesCbc128PKCS7(String var0, String var1);

    @FunSDKAnnotation(method="\u901a\u7528AesCbc128PKCS7\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679c\u4e8c\u8fdb\u5236\u6570\u636e\u8fd4\u56de", param="byte[] pData, String szKey, byte[] pIV")
    public static native byte[] GenEncAesCbc128PKCS7RetBinary(byte[] var0, String var1, byte[] var2);

    @FunSDKAnnotation(method="\u901a\u7528AesCbc128PKCS7\u52a0\u5bc6\uff0c\u52a0\u5bc6\u7ed3\u679cBase64\u5b57\u7b26\u4e32\u6570\u636e\u8fd4\u56de", param="byte[] pData, String szKey, byte[] pIV")
    public static native String GenEncAesCbc128PKCS7RetBase64(byte[] var0, String var1, byte[] var2);

    @FunSDKAnnotation(method="\u901a\u7528\u4e8c\u8fdb\u5236\u6570\u636e\u901a\u8fc7AesCbc128PKCS7\u89e3\u5bc6", param="byte[] pData, String szKey, byte[] pIV")
    public static native byte[] GenBinaryDataDecAesCbc128PKCS7(byte[] var0, String var1, byte[] var2);

    @FunSDKAnnotation(method="\u901a\u7528Base64\u52a0\u5bc6\u7684\u6570\u636e\u901a\u8fc7AesCbc128PKCS7\u89e3\u5bc6", param="String szData, String szKey, byte[] pIV")
    public static native byte[] GenDecBase64DataAesCbc128PKCS7(String var0, String var1, byte[] var2);

    public static native String DecDevRandomUserInfo(String var0, String var1);

    public static native int DevSetAttrAlarm(int var0, String var1, int var2, byte[] var3, int var4, int var5, int var6, int var7);

    public static native int DevGetAlarmState(int var0, int var1);

    public static native int DevSetLocalPwd(String var0, String var1, String var2);

    @FunSDKAnnotation(method="\u8bbe\u7f6e\u8bbe\u5907\u767b\u5f55\u4ee4\u724c\u4fe1\u606f(\u52a0\u5bc6\u540e\u7684\u6570\u636e)\u5230\u672c\u5730\u7f13\u5b58", param="String szDevId, String szEncToken")
    public static native int DevSetLocalEncToken(String var0, String var1);

    @FunSDKAnnotation(method="\u8bbe\u7f6e\u8bbe\u5907\u4fe1\u606f\u5230\u672c\u5730\u7f13\u5b58", param="String szDevId, String szUser, String szPwd, String szEncToken")
    public static native int DevSetDevInfoToLocal(String var0, String var1, String var2, String var3);

    public static native String DevGetLocalPwd(String var0);

    public static native String DevGetLocalUserName(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6\u8bbe\u5907\u767b\u5f55\u4ee4\u724c\u4fe1\u606f(\u52a0\u5bc6\u540e\u7684\u6570\u636e)", param="String szDevId")
    public static native String DevGetLocalEncToken(String var0);

    @FunSDKAnnotation(method="\u8bbe\u7f6e\u8bbe\u5907Pid\u5230SDK\u7f13\u5b58", param="String szDevId, String szPid")
    public static native int DevSetPid(String var0, String var1);

    @FunSDKAnnotation(method="\u83b7\u53d6\u8bbe\u5907PID(SDK\u672c\u5730\u7f13\u5b58)", param="String szDevId")
    public static native String GetDevPid(String var0);

    @FunSDKAnnotation(method="\u901a\u8fc7\u952e\u503cID\u83b7\u53d6\u968f\u673a\u79d8\u94a5(\u76f4\u5230APP\u5378\u8f7d\u4fdd\u6301\u6709\u6548)", param="String szKeyID, int nRandKeyLen")
    public static native String GetLocalCacheRandKey(String var0, int var1);

    @FunSDKAnnotation(method="\u901a\u8fc7\u952e\u503cID\u5220\u9664\u968f\u673a\u79d8\u94a5", param="String szKeyID")
    public static native void DelLocalCacheRandKey(String var0);

    @FunSDKAnnotation(method="\u52a0\u5bc6\u751f\u6210\u84dd\u7259TOKEN", param="String szDevID, String szInfoJson")
    public static native String EncBleToken(String var0, String var1);

    @FunSDKAnnotation(method="\u89e3\u5bc6\u84dd\u7259TOKEN", param="String szDevID, String szToken")
    public static native String DecBleToken(String var0, String var1);

    public static native int GetMediaThumbnail(String var0, String var1);

    public static native int CheckUserPhone(int var0, String var1, int var2);

    public static native int CheckUserMail(int var0, String var1, int var2);

    public static native int JPGHeadWriteExif(String var0, String var1, byte[] var2);

    public static native int JPGHeadReadExif(String var0, byte[] var1);

    public static boolean JPGHead_Write_Exif(String srcPath, String dstPath, SDK_FishEyeFrame fishEyeFrame) {
        byte[] bytes;
        byte[] tmpBuf = new byte[128];
        if (fishEyeFrame instanceof SDK_FishEyeFrameHW) {
            int offset = 0;
            SDK_FishEyeFrameHW fishHW = (SDK_FishEyeFrameHW)fishEyeFrame;
            bytes = G.IntToBytes(3);
            tmpBuf[offset++] = bytes[0];
            tmpBuf[offset++] = bytes[1];
            tmpBuf[offset++] = bytes[2];
            tmpBuf[offset++] = bytes[3];
            bytes = G.IntToBytes(0);
            tmpBuf[offset++] = bytes[0];
            tmpBuf[offset++] = bytes[1];
            tmpBuf[offset++] = bytes[2];
            tmpBuf[offset++] = bytes[3];
            bytes = G.IntToBytes(fishHW.st_0_secene);
            tmpBuf[offset++] = bytes[0];
            tmpBuf[offset++] = bytes[1];
            tmpBuf[offset++] = bytes[2];
            tmpBuf[offset++] = bytes[3];
        } else if (fishEyeFrame instanceof SDK_FishEyeFrameSW) {
            int offset = 0;
            SDK_FishEyeFrameSW fishSW = (SDK_FishEyeFrameSW)fishEyeFrame;
            bytes = G.IntToBytes(4);
            tmpBuf[offset++] = bytes[0];
            tmpBuf[offset++] = bytes[1];
            tmpBuf[offset++] = bytes[2];
            tmpBuf[offset++] = bytes[3];
            bytes = G.IntToBytes(fishSW.st_0_version);
            System.arraycopy(bytes, 0, tmpBuf, offset, 4);
            bytes = G.IntToBytes(fishSW.st_1_lensType);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_2_centerOffsetX);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_3_centerOffsetY);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_4_radius);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_5_imageWidth);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_6_imageHeight);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_7_viewAngle);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            bytes = G.IntToBytes(fishSW.st_8_viewMode);
            System.arraycopy(bytes, 0, tmpBuf, offset += 4, 4);
            offset += 4;
        }
        int result = FunSDK.JPGHeadWriteExif(srcPath, dstPath, tmpBuf);
        return result == 0;
    }

    public static SDK_FishEyeFrame JPGHead_Read_Exif(String srcPath) {
        byte[] tmpBuf = new byte[128];
        int offset = 0;
        tmpBuf[0] = 0;
        int result = FunSDK.JPGHeadReadExif(srcPath, tmpBuf);
        if (result != 0) {
            return null;
        }
        byte type = (byte)G.ToInt(tmpBuf, 0);
        offset = 4;
        if (type == 3) {
            SDK_FishEyeFrameHW fishHW = new SDK_FishEyeFrameHW();
            fishHW.st_0_secene = (byte)G.ToInt(tmpBuf, offset += 4);
            offset += 4;
            return fishHW;
        }
        if (type == 4) {
            SDK_FishEyeFrameSW fishSW = new SDK_FishEyeFrameSW();
            fishSW.st_0_version = (byte)G.ToInt(tmpBuf, offset);
            fishSW.st_1_lensType = (byte)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_2_centerOffsetX = (short)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_3_centerOffsetY = (short)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_4_radius = (short)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_5_imageWidth = (short)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_6_imageHeight = (short)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_7_viewAngle = (byte)G.ToInt(tmpBuf, offset += 4);
            fishSW.st_8_viewMode = (byte)G.ToInt(tmpBuf, offset += 4);
            offset += 4;
            return fishSW;
        }
        if (type == 5) {
            SDK_FishEyeFrameCM fishCM = new SDK_FishEyeFrameCM();
            fishCM.st_0_camera = (byte)G.ToInt(tmpBuf, offset += 4);
            offset += 4;
            return fishCM;
        }
        return null;
    }

    public static native int GNWriteFile(String var0, byte[] var1);

    public static native int GNDeleteFile(String var0);

    public static native String SMGetObjRunState(String var0, String var1);

    public static native void SMEnable(int var0, String var1, String var2, boolean var3);

    @FunSDKAnnotation(method="\u521d\u59cb\u5316\u670d\u52a1\u5668\u7528\u6237\u4ee3\u7406\u4fe1\u606f", param="String sInfo")
    public static native void SysInitUserAgentInfo(String var0);

    public static native int XMCloundPlatformInit(String var0, String var1, String var2, int var3);

    public static native void SysInitVerificationCodeSize(String var0);

    @FunSDKAnnotation(method="\u521d\u59cb\u5316\u8d26\u6237\u8bbf\u95ee\u4ee4\u724c\u4fe1\u606f", param="String szLoginType, String szAccessToken")
    public static native void SysInitAccountAccessToken(String var0, String var1);

    public static native String SysGetCurLoginParams();

    @FunSDKAnnotation(method="\u540c\u6b65\u8bbe\u5907\u4fe1\u606f\u5230\u6570\u636e\u4e2d\u5fc3(SDK\u5185\u5b58\u7f13\u5b58)", param="String szDevInfos")
    public static native int SysSyncDevInfoToDataCenter(String var0);

    @FunSDKAnnotation(method="\u83b7\u53d6\u89c6\u9891\u8bf7\u6c42\u7edf\u8ba1\u4fe1\u606f", param="")
    public static native String GetVideoPlayStatistics();

    @FunSDKAnnotation(method="\u5220\u9664\u89c6\u9891\u8bf7\u6c42\u7edf\u8ba1\u4fe1\u606f\uff0c\u5ba2\u6237\u7aef\u5728\u4e0a\u62a5\u6210\u529f\u4e4b\u540e\u8c03\u7528\u6b64\u63a5\u53e3\u8fdb\u884c\u672c\u5730\u6570\u636e\u6e05\u7a7a", param="")
    public static native void DelVideoPlayStatistics();

    public static native int DevGetConfig(int var0, String var1, int var2, int var3, int var4, int var5, int var6);

    public static native int DevSetConfig(int var0, String var1, int var2, byte[] var3, int var4, int var5, int var6);

    public static native int DevLogin(int var0, String var1, String var2, String var3, int var4);

    public static native int DevSetAlarmListener(int var0, int var1);

    public static int DevSetAttrAlarmByInt(int hUser, String szDevId, int nCommand, int nValue, int nSeq) {
        byte[] pValue = G.ToBytes(nValue);
        return FunSDK.DevSetAttr(hUser, szDevId, nCommand, pValue, 0, 5000, nSeq);
    }

    public static native int DevSaveRealTimeStream(int var0, String var1, int var2, int var3, String var4, int var5);

    public static native int DevCloseRealTimeStream(int var0);

    public static native int DevReturnRealStream(int var0, String var1, int var2, int var3, int var4);

    public static native int DevCloseReturnRealStream(int var0);

    public static native int DevSleep(int var0, String var1, int var2);

    public static native int DevWakeUp(int var0, String var1, int var2);

    public static native int DevWakeUpCtlLogin(int var0, String var1, boolean var2, int var3);

    @FunSDKAnnotation(method="\u8bbe\u5907\u91cd\u8fde\u4f7f\u80fd", param="String szDevId, boolean nEnable")
    public static native int DevIsReconnectEnable(String var0, boolean var1);

    @FunSDKAnnotation(method="\u8bbe\u5907\u5524\u9192\u63a5\u53e3 / DEV_WAKE_UP = 5142", param="int hUser, String szDevId, String szReqExJson, boolean bDevLogin, int nSeq")
    public static native int DevWakeUpExt(int var0, String var1, String var2, boolean var3, int var4);

    public static native int DevStartLocalDevWakeUp(int var0, String var1, int var2);

    public static native void DevStopLocalDevWakeUp();

    public static native int DevPredatorFileOperation(int var0, byte[] var1, String var2, String var3, int var4);

    public static native int DevPredatorFileSave(int var0, String var1, String var2, int var3);

    public static native int DevSetNetCfgOverUDP(int var0, int var1, byte[] var2, String var3, String var4, String var5, String var6, int var7, int var8);

    public static native int XMVideoLogin(int var0, String var1, String var2, int var3);

    public static native int XMVideoLogout(int var0, int var1);

    public static void setWebViewCookie(String url, String value) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String[] values = value.split(";");
        if (values == null || values.length == 0) {
            return;
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        int i = 0;
        while (i < values.length) {
            cookieManager.setCookie(url, values[i]);
            ++i;
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }
    }

    public static void deleteWebViewCookie(String url, String value) {
        if (TextUtils.isEmpty((CharSequence)url) || TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        String[] values = value.split(";");
        if (values == null || values.length == 0) {
            return;
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        int i = 0;
        while (i < values.length) {
            String[] cookieParts = values[i].split("=");
            if (cookieParts != null && cookieParts.length > 0) {
                cookieManager.setCookie(url, String.valueOf(cookieParts[0]) + "=; Expires=Wed, 31 Dec 2015 23:59:59 GMT");
            }
            ++i;
        }
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.getInstance().sync();
        } else {
            CookieManager.getInstance().flush();
        }
    }

    public static native int SysSetLoginType(String var0);

    public static native int SysGetUnionId2U(int var0, String var1, int var2);

    public static native int SysBindingAccount(int var0, String var1, String var2, int var3);

    public static native int SysThirdPartyBindAccount(int var0, String var1, String var2, String var3, String var4, int var5, int var6);

    public static native int SysGetPhoneSupportAreaCode(int var0, int var1);

    @FunSDKAnnotation(method="SYS_GET_PHONE_SUPPORT_AREA_CODE_AND_URL = 5206 / \u83b7\u53d6\u652f\u6301\u624b\u673a\u9a8c\u8bc1\u7684\u5168\u7403\u533a\u53f7\u548c\u533a\u57dfURL", param="int hUser, int nSeq")
    public static native int SysGetPhoneSupportAreaCodeAndUrl(int var0, int var1);

    public static native int SysSendGlobalPhoneCode(int var0, String var1, String var2, int var3);

    public static native byte[] GetMediaFileInfo(String var0);

    public static native int StartDecTest(int var0, String var1, Object var2, int var3);

    public static native void StopDecTest();

    public static native void testMP4();

    public static native int DevImgListDowonLoadM(int var0, String var1, byte[] var2, String var3, int var4, String var5, int var6);

    public static native void TestTest(int var0, int var1, int var2, String var3);

    @FunSDKAnnotation(method="\u667a\u8054\u4e2d\u5fc3\u5b50\u8bbe\u5907\u5347\u7ea7\u68c0\u6d4b", param="int hUser, String szDevId, byte[] pSDK_SubDevInfo, int nSeq")
    public static native int DevCheckUpgradeEx(int var0, String var1, byte[] var2, int var3);

    @FunSDKAnnotation(method="\u667a\u8054\u4e2d\u5fc3\u5b50\u8bbe\u5907\u5347\u7ea7\u68c0\u6d4b(\u8bbe\u5907\u7aef\u68c0\u6d4b\u5347\u7ea7\u5931\u8d25\u540e\uff0cp2p\u6a21\u5f0f\u4e5f\u5141\u8bb8\u53bb\u670d\u52a1\u5668\u68c0\u6d4b\u5347\u7ea7\u4fe1\u606f, app\u9700\u8981\u63a7\u5236\u5347\u7ea7\uff0c\u5982\u679c\u662fp2p/\u8f6c\u53d1\u63d0\u793a\u65e0\u6cd5\u8fdb\u884c\u5347\u7ea7)", param="int hUser, String szDevId, byte[] pSDK_SubDevInfo, int nSeq")
    public static native int DevCheckUpgradeExAllNet(int var0, String var1, byte[] var2, int var3);

    @FunSDKAnnotation(method="\u667a\u8054\u4e2d\u5fc3\u5b50\u8bbe\u5907\u672c\u5730\u6587\u4ef6\u5347\u7ea7\u63a5\u53e3", param="int hUser, String szDevId, String szSubDevId, String sFileName, int nSeq")
    public static native int DevStartUpgradeByFileEx(int var0, String var1, String var2, String var3, int var4);

    @FunSDKAnnotation(method="\u667a\u8054\u4e2d\u5fc3\u5b50\u8bbe\u5907\u5347\u7ea7\u63a5\u53e3", param="int hUser, String szDevId, byte[] pSDK_SubDevInfo, int nType, int nSeq")
    public static native int DevStartUpgradeEx(int var0, String var1, byte[] var2, int var3, int var4);

    public static native int SysOpenWXAlarmListen(int var0, String var1, int var2);

    public static native int SysCloseWXAlarmListen(int var0, String var1, int var2);

    public static native int SysWXAlarmStateCheck(int var0, String var1, int var2);

    public static native int SysThirdPartyOpenAlarmListen(int var0, String var1, String var2, int var3);

    public static native int SysThirdPartyCloseAlarmListen(int var0, String var1, String var2, int var3);

    public static native int SysThirdPartyAlarmStateCheck(int var0, String var1, String var2, int var3);

    @FunSDKAnnotation(method="\u4fdd\u5b58APP\u4fe1\u606f / SYS_APP_INFO_SAVE", param="int hUser, String szAppInfo, int nExpireTime, int nSeq")
    public static native int SysAppInfoSave(int var0, String var1, int var2, int var3);

    @FunSDKAnnotation(method="\u83b7\u53d6APP\u4fe1\u606f / SYS_APP_INFO_QUERY", param="int hUser, String szFindKey, int nSeq")
    public static native int SysAppInfoQuery(int var0, String var1, int var2);

    public static native int SysModifyUserName(int var0, String var1, int var2);

    public static native int CheckDevType(String var0);

    public static native int IsDevSN(String var0);

    public static native int SysGetDevsCSStatus(int var0, String var1, int var2);

    public static native int GroupSearchDevInfo(int var0, String var1, int var2, int var3);

    public static native int GroupDevSetInfo(int var0, String var1, int var2, int var3);

    public static native int SendDataRadioOperation(byte[] var0, int var1, int var2, int var3);

    public static native byte[] PcmEncodeToG711(byte[] var0, int var1);

    public static native int Mp3Decoder2PCM(String var0, String var1, int var2, int var3, int var4);

    @FunSDKAnnotation(method="\u8c03\u8282PCM\u97f3\u9891\u97f3\u91cf\u5927\u5c0f", param="byte[] pPcmData, int nLength, int nRepeat, double nVol")
    public static native byte[] RaisePCMVolume(byte[] var0, int var1, int var2, double var3);

    public static native void InfraRedTest();

    public static native void InfraRedIRemoteClientSetPath(String var0);

    public static native byte[] InfraRedIRemoteClientLoadBrands();

    public static native byte[] InfraRedIRemoteClientLoadBrandsEx(int var0);

    public static native byte[] InfraRedIRemoteClientExactMatchRemotes(byte[] var0, byte[] var1);

    public static native byte[] InfraRedIRemoteClientExactMatchAirRemotes(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] InfraRedIRemoteManagerGetAllRooms();

    public static native byte[] InfraRedIRemoteManagerGetRemoteFromRoom(byte[] var0);

    public static native byte[] InfraRedIRemoteManagerGetRemoteByID(String var0, String var1);

    public static native void InfraRedIRemoteManagerAddRemoteToRoom(byte[] var0, byte[] var1);

    public static native void InfraRedIRemoteManagerDeleteRemoteFromRoom(byte[] var0, byte[] var1);

    public static native void InfraRedIRemoteManagerAddRemote(byte[] var0);

    public static native void InfraRedIRemoteManagerAddRoom(byte[] var0);

    public static native void InfraRedIRemoteManagerDeleteRoom(byte[] var0);

    public static native void InfraRedIRemoteManagerChangeRoomName(byte[] var0, String var1);

    public static native byte[] InfraRedIInfraredFetcherFetchInfrareds(byte[] var0, byte[] var1);

    public static native byte[] InfraRedIInfraredFetcherGetAirRemoteStatus(byte[] var0);

    public static native byte[] InfraRedIInfraredFetcherFetchAirTimerInfrared(byte[] var0, byte[] var1, byte[] var2);

    public static native byte[] InfraRedIInfraredFetcherTranslateInfrared(byte[] var0, int var1);

    public static native int InfraRedIRemoteClientGetBrandNum(int var0);

    public static native int InfraRedIRemoteClientGetRemoteNum();

    public static native byte[] InfraRedIRemoteClientLoadRemotes();

    public static native int InfraRedIInfraredFetcherSetAirRemoteStatus(String var0, byte[] var1);

    public static native int InitSuperResolution(AssetManager var0);

    public static native int UnInitSuperResolution();

    public static native String GetVersionSuperResolution();

    public static native int StartRealplaySuperResolution(int var0, int var1, int var2, int var3, int var4);

    public static native int StopRealplaySuperResolution(int var0);

    public static native int SnapImageSuperResolution(int var0, String var1, int var2, int var3, int var4, int var5);

    public static native byte[] OnYUV420PSuperResolution(int var0, int var1, byte[] var2, int var3, int var4, int var5);

    public static native int ClearCacheSuperResolution();

    static class ActiveLifeListener
    extends Handler {
        public int _nActive = 0;
        public int _nSDKActive = 1;

        ActiveLifeListener() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                int nActive;
                int n = nActive = this._nActive > 0 ? 1 : 0;
                if (nActive != this._nSDKActive) {
                    this._nSDKActive = nActive;
                    FunSDK.SetActive(this._nSDKActive);
                    System.out.println("FunSDK--SetActive" + this._nSDKActive);
                }
            } else {
                System.out.println("FunSDK--SetActive--> NULL");
            }
        }

        public void OnActive(boolean bActive) {
            this._nActive = bActive ? ++this._nActive : --this._nActive;
            this.removeMessages(1);
            if (this._nActive <= 0) {
                this._nActive = 0;
                this.sendEmptyMessageDelayed(1, 2000L);
            } else {
                this.sendEmptyMessageDelayed(1, 10L);
            }
        }

        public boolean IsActive() {
            return this._nActive == 0;
        }
    }

    public static interface OnFunSDKInitListener {
        public void onInit();
    }
}

