/*
 * Decompiled with CFR 0.152.
 */
package com.xmgl.vrsoft;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.core.view.GestureDetectorCompat;
import com.xmgl.vrsoft.GrandAnimation;
import com.xmgl.vrsoft.GrandAnimationDecelerate;
import com.xmgl.vrsoft.VRSoftEvent;
import com.xmgl.vrsoft.VRSoftGLView;
import com.xmgl.vrsoft.VRSoftJNI;

public class VRSoftEvent360
extends VRSoftEvent {
    private static final String TAG = "XMVREvent";
    private final int MESSAGE_ADJUST = 257;
    private final int MESSAGE_SWITCH_SHAPE = 258;
    private int touchEventFingerCount = 0;
    private DewarperGestureListener mDewarperGestureListener = null;
    private GestureDetectorCompat mDetector = null;
    private GrandAnimation mGrandAnimation = null;
    private double pan = 0.0;
    private boolean ready = false;
    private double roll = 0.0;
    private double textureScale = 1.0;
    private double tilt = 0.0;
    private double wallAngle = 0.0;
    private double zoom = 180.0;
    private int mMount = 0;
    private int mShape = 0;
    private int mLastAction = 1;
    private boolean mEnterForceZoomOut = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 257: {
                    VRSoftEvent360.this.adjestGraphic();
                    break;
                }
                case 258: {
                    if (null == VRSoftEvent360.this.mGLSurfaceView) break;
                    if (VRSoftEvent360.this.mMount == 0) {
                        if (VRSoftEvent360.this.mShape == 0) {
                            VRSoftEvent360.this.mGLSurfaceView.setShape(5);
                            break;
                        }
                        if (VRSoftEvent360.this.mShape == 3) {
                            VRSoftEvent360.this.mGLSurfaceView.setShape(0);
                            break;
                        }
                        if (VRSoftEvent360.this.mShape == 5) {
                            VRSoftEvent360.this.mGLSurfaceView.setShape(1);
                            break;
                        }
                        if (VRSoftEvent360.this.mShape == 1) {
                            VRSoftEvent360.this.mGLSurfaceView.setShape(2);
                            break;
                        }
                        if (VRSoftEvent360.this.mShape != 2) break;
                        VRSoftEvent360.this.mGLSurfaceView.setShape(3);
                        break;
                    }
                    if (VRSoftEvent360.this.mMount != 1) break;
                    if (VRSoftEvent360.this.mShape == 0) {
                        VRSoftEvent360.this.mGLSurfaceView.setShape(5);
                        break;
                    }
                    VRSoftEvent360.this.mGLSurfaceView.setShape(0);
                }
            }
        }
    };

    public VRSoftEvent360(Context context, VRSoftGLView glView, int vrHandle) {
        super(context, glView, vrHandle);
        this.mDewarperGestureListener = new DewarperGestureListener();
        this.mDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this.mDewarperGestureListener);
    }

    public void setCameraMount(int mount) {
        this.mMount = mount;
    }

    public int getCameraMount() {
        return this.mMount;
    }

    public void setShape(int shape) {
        this.mShape = shape;
    }

    public int getShape() {
        return this.mShape;
    }

    private double pinToRange(double src, double min, double max) {
        if (src < min) {
            return min;
        }
        if (src > max) {
            return max;
        }
        return src;
    }

    private void checkRange() {
        if (this.mMount == 2 || this.mMount == 3) {
            this.pan = this.pinToRange(this.pan, 0.0, 180.0);
            this.tilt = this.pinToRange(this.tilt, 0.0, 180.0);
            this.zoom = this.pinToRange(this.zoom, 5.0, 90.0);
        } else if (this.mShape == 0) {
            this.tilt = this.pinToRange(this.tilt, 0.0, 85.0);
            this.zoom = this.pinToRange(this.zoom, 5.0, 90.0);
        } else if (this.mShape == 1) {
            this.tilt = this.pinToRange(this.tilt, 60.0, 100.0);
            this.zoom = 90.0;
        } else if (this.mShape == 2) {
            this.tilt = this.pinToRange(this.tilt, -100.0, -60.0);
            this.zoom = 90.0;
        } else if (this.mShape == 3) {
            this.tilt = this.pinToRange(this.tilt, -45.0, 45.0);
            this.zoom = 90.0;
        } else if (this.mShape == 4) {
            this.tilt = this.pinToRange(this.tilt, -10.0, 10.0);
            this.zoom = 90.0;
        } else {
            this.tilt = this.pinToRange(this.tilt, 0.0, 85.0);
            this.zoom = this.pinToRange(this.zoom, 5.0, 90.0);
        }
    }

    @Override
    public void drawView() {
        this.checkRange();
        super.drawView();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.mLastAction != 1) {
            return true;
        }
        this.mLastAction = event.getAction();
        int pointerCount = event.getPointerCount();
        if (null != this.mHandler) {
            this.mHandler.removeMessages(257);
        }
        if (this.mEnterForceZoomOut) {
            return true;
        }
        if (null != this.mGrandAnimation) {
            this.mGrandAnimation.cancel();
            this.mGrandAnimation = null;
        }
        Log.d((String)TAG, (String)(" onTouch : action = " + event.getAction()));
        Log.d((String)TAG, (String)(" onTouch : touchEventFingerCount = " + this.touchEventFingerCount + " pointerCount = " + pointerCount));
        if (this.touchEventFingerCount == 1 && pointerCount == 2) {
            this.mDewarperGestureListener.initialTwoFingerDistance = -1.0;
            this.mDewarperGestureListener.zoomBaseValue = this.zoom;
        }
        if (this.touchEventFingerCount == 2 && pointerCount == 1) {
            this.mDewarperGestureListener.startX = event.getX();
            this.mDewarperGestureListener.startY = event.getY();
            this.mDewarperGestureListener.panBaseValue = this.pan;
            this.mDewarperGestureListener.tiltBaseValue = this.tilt;
        }
        this.touchEventFingerCount = pointerCount;
        this.mDetector.onTouchEvent(event);
        if (event.getAction() == 1 && this.mMount == 0 && null != this.mHandler) {
            this.mHandler.sendEmptyMessageDelayed(257, 120L);
        }
        return true;
    }

    private void adjestGraphic() {
        if (this.mShape == 0) {
            if (this.zoom == 90.0 && this.tilt > 0.0) {
                this.mGrandAnimation = new GrandAnimationDecelerate(new GrandAnimation.GrandAnimationListener(){

                    @Override
                    public void onGrandAnimationUpdate(double value) {
                        VRSoftEvent360.this.zoom = value;
                        VRSoftEvent360.this.drawView();
                    }

                    @Override
                    public void onGrandAnimationFinished() {
                        VRSoftEvent360.this.adjestEdge();
                    }
                });
                this.mGrandAnimation.start(90.0, 20.0, 200);
            } else {
                this.adjestEdge();
            }
        }
    }

    public double getTiltEdge() {
        return 90.0 - this.zoom - 5.0;
    }

    private void adjestEdge() {
        double edgeTile = this.getTiltEdge();
        if (this.tilt > edgeTile) {
            this.mGrandAnimation = new GrandAnimationDecelerate(new GrandAnimation.GrandAnimationListener(){

                @Override
                public void onGrandAnimationUpdate(double value) {
                    VRSoftEvent360.this.tilt = value;
                    VRSoftEvent360.this.drawView();
                }

                @Override
                public void onGrandAnimationFinished() {
                }
            });
            this.mGrandAnimation.start(this.tilt, edgeTile, 500);
        }
    }

    private void enterForceZoomOut() {
        this.mEnterForceZoomOut = true;
        this.mGrandAnimation = new GrandAnimationDecelerate(new GrandAnimation.GrandAnimationListener(){

            @Override
            public void onGrandAnimationUpdate(double value) {
                VRSoftEvent360.this.zoom = value;
                VRSoftEvent360.this.drawView();
            }

            @Override
            public void onGrandAnimationFinished() {
                VRSoftEvent360.this.mEnterForceZoomOut = false;
                VRSoftEvent360.this.adjestEdge();
            }
        });
        this.mGrandAnimation.start(this.zoom, 90.0, 200);
    }

    @Override
    public void setPTZs() {
        VRSoftJNI.setPTZ(this.mVRSoftHande, this.pan, this.tilt, this.zoom, this.roll, this.wallAngle);
    }

    @Override
    public boolean needContinue() {
        return false;
    }

    @Override
    public void goToDefaultPosition() {
        this.pan = 90.0;
        this.zoom = 90.0;
        if (this.mMount == 0) {
            this.tilt = this.mShape == 1 ? 75.0 : (this.mShape == 2 ? -75.0 : 0.0);
        } else if (this.mMount == 1) {
            this.tilt = 90.0;
        } else if (this.mMount == 2) {
            this.tilt = 90.0;
        } else if (this.mMount == 3) {
            this.tilt = -90.0;
        }
        this.drawView();
    }

    class DewarperGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public double initialTwoFingerDistance = -1.0;
        public double panBaseValue;
        public double rollBaseValue;
        public boolean rotating;
        public float rotationAngle;
        public boolean rotationFirstMeasurement;
        public float rotationStartAngle;
        public double startX = 0.0;
        public double startY = 0.0;
        public double tiltBaseValue;
        private double zoomBaseValue;
        public boolean zooming;

        DewarperGestureListener() {
        }

        private float angleBetweenPoints(float x0, float y0, float x1, float y1) {
            double d = x1 - x0;
            return (float)(180.0 * Math.atan2(y1 - y0, d) / Math.PI);
        }

        public boolean onDoubleTapEvent(MotionEvent event) {
            Log.v((String)VRSoftEvent360.TAG, (String)"DewarperGestureListener.onDoubleTapEvent");
            if (null != VRSoftEvent360.this.mHandler) {
                VRSoftEvent360.this.mHandler.removeMessages(258);
                VRSoftEvent360.this.mHandler.sendEmptyMessageDelayed(258, 120L);
            }
            return false;
        }

        public boolean onDown(MotionEvent event) {
            Log.v((String)VRSoftEvent360.TAG, (String)"DewarperGestureListener.onDown");
            this.startX = event.getX();
            this.startY = event.getY();
            this.panBaseValue = VRSoftEvent360.this.pan;
            this.tiltBaseValue = VRSoftEvent360.this.tilt;
            this.zoomBaseValue = VRSoftEvent360.this.zoom;
            this.initialTwoFingerDistance = -1.0;
            this.zooming = false;
            this.rotating = false;
            this.rotationFirstMeasurement = true;
            this.rotationStartAngle = 0.0f;
            this.rollBaseValue = VRSoftEvent360.this.roll;
            return true;
        }

        public boolean onFling(MotionEvent event1, MotionEvent event2, final float velocityX, final float velocityY) {
            Log.v((String)VRSoftEvent360.TAG, (String)("DewarperGestureListener.onFling; velocity(" + velocityX + ", " + velocityY));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Log.v((String)"DewarperGestureListener", (String)"flingThread");
                    if (VRSoftEvent360.this.getCameraMount() == 0) {
                        double d1 = -1.0;
                        double d4 = VRSoftEvent360.this.zoom / 360.0 * (1024.0 / (double)VRSoftEvent360.this.mGLSurfaceView.getWidth());
                        double d5 = (double)velocityX / 100.0;
                        double d3 = (double)velocityY / 100.0;
                        double d2 = 0.94;
                        for (int i = 0; i < 25; ++i) {
                            VRSoftEvent360.this.pan += d4 * (d1 * d5);
                            VRSoftEvent360.this.tilt -= d4 * (d1 * d3);
                            d5 *= d2;
                            d3 *= d2;
                            d2 -= 0.01;
                            VRSoftEvent360.this.drawView();
                            try {
                                Thread.sleep(20L);
                                continue;
                            }
                            catch (InterruptedException localInterruptedException) {
                                break;
                            }
                        }
                    }
                }
            }).start();
            return true;
        }

        public boolean onScroll(MotionEvent event1, MotionEvent event2, float paramFloat1, float paramFloat2) {
            boolean bool;
            Log.v((String)VRSoftEvent360.TAG, (String)"DewarperGestureListener.onScroll");
            if (event2 != null) {
                switch (event2.getPointerCount()) {
                    case 1: {
                        double d2 = VRSoftEvent360.this.getCameraMount() != 0 ? 1.0 : -1.0;
                        double d4 = VRSoftEvent360.this.zoom / 360.0 * (1024.0 / (double)VRSoftEvent360.this.mGLSurfaceView.getWidth());
                        double d1 = (double)event2.getX() - this.startX;
                        double d3 = (double)event2.getY() - this.startY;
                        VRSoftEvent360.this.pan = this.panBaseValue + d4 * (d2 * d1);
                        VRSoftEvent360.this.tilt = this.tiltBaseValue - d4 * (d2 * d3);
                        VRSoftEvent360.this.drawView();
                        break;
                    }
                    case 2: {
                        MotionEvent.PointerCoords localPointerCoords2 = new MotionEvent.PointerCoords();
                        MotionEvent.PointerCoords localPointerCoords1 = new MotionEvent.PointerCoords();
                        event2.getPointerCoords(0, localPointerCoords2);
                        event2.getPointerCoords(1, localPointerCoords1);
                        double d2 = localPointerCoords1.x - localPointerCoords2.x;
                        double d3 = localPointerCoords1.y - localPointerCoords2.y;
                        d2 = Math.sqrt(d2 * d2 + d3 * d3);
                        if (this.initialTwoFingerDistance < 0.0) {
                            this.initialTwoFingerDistance = d2;
                            if (this.initialTwoFingerDistance < 250.0) {
                                this.zooming = true;
                            }
                        }
                        VRSoftEvent360.this.zoom = this.zoomBaseValue / (d2 /= this.initialTwoFingerDistance);
                        if (!this.rotating && d2 > 1.2) {
                            this.zooming = true;
                        }
                        if (!this.zooming) {
                            if (!this.rotationFirstMeasurement) {
                                this.rotationAngle = this.angleBetweenPoints(localPointerCoords2.x, localPointerCoords2.y, localPointerCoords1.x, localPointerCoords1.y);
                                if (d2 < 1.1 && d2 > 0.9 && Math.abs(this.rotationAngle - this.rotationStartAngle) > 10.0f) {
                                    this.rotating = true;
                                }
                            } else {
                                this.rotationFirstMeasurement = false;
                                this.rotationStartAngle = this.angleBetweenPoints(localPointerCoords2.x, localPointerCoords2.y, localPointerCoords1.x, localPointerCoords1.y);
                            }
                        }
                        if (this.zooming) {
                            this.rotationAngle = 0.0f;
                        }
                        if (this.rotating) {
                            VRSoftEvent360.this.zoom = this.zoomBaseValue;
                            float f = this.rotationAngle - this.rotationStartAngle;
                            VRSoftEvent360.this.roll = this.rollBaseValue + (double)f;
                        }
                        VRSoftEvent360.this.drawView();
                        if (VRSoftEvent360.this.getCameraMount() != 0 || !(VRSoftEvent360.this.zoom > this.zoomBaseValue) || !(VRSoftEvent360.this.zoom > 70.0)) break;
                        VRSoftEvent360.this.enterForceZoomOut();
                    }
                }
                bool = true;
            } else {
                Log.e((String)VRSoftEvent360.TAG, (String)"DewarperGestureListener.onScroll - e2 is null");
                bool = false;
            }
            return bool;
        }

        public boolean onSingleTapConfirmed(MotionEvent event) {
            Log.v((String)VRSoftEvent360.TAG, (String)"DewarperGestureListener.onSingleTapConfirmed");
            return true;
        }
    }
}

