/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.dialog;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.xm.ui.widget.dialog.AnimatedView;
import com.xm.ui.widget.dialog.AnimatorPlayer;
import com.xm.ui.widget.dialog.HesitateInterpolator;
import com.xm.ui.widget.dialog.ProgressLayout;
import demo.xm.com.libxmfunsdk.R;

public class SpotsDialog
extends AlertDialog {
    private static final int DELAY = 150;
    private static final int DURATION = 1500;
    private TextView title;
    private int size;
    private AnimatedView[] spots;
    private AnimatorPlayer animator;

    public SpotsDialog(Context context) {
        this(context, R.style.SpotsDialogDefault);
    }

    public SpotsDialog(Context context, int theme) {
        super(context, theme);
    }

    public SpotsDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.funsdk_spots_dialog);
        this.title = (TextView)this.findViewById(R.id.title);
        this.title.setText(R.string.libfunsdk_dlg_title_text);
        this.setCanceledOnTouchOutside(false);
        this.initProgress();
    }

    protected void onStart() {
        super.onStart();
        this.animator = new AnimatorPlayer(this.createAnimations());
        this.animator.play();
    }

    protected void onStop() {
        super.onStop();
        this.animator.stop();
    }

    public void show(String str) {
        Log.e((String)"wwww", (String)("title-->" + (null == this.title)));
        if (null != str && str.length() > 0 && !str.trim().equals("") && null != this.title) {
            this.title.setText((CharSequence)str);
        }
        this.show();
    }

    private void initProgress() {
        ProgressLayout progress = (ProgressLayout)this.findViewById(R.id.progress);
        this.size = progress.getSpotsCount();
        this.spots = new AnimatedView[this.size];
        int size = this.getContext().getResources().getDimensionPixelSize(R.dimen.spot_size);
        int progressWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.progress_width);
        for (int i = 0; i < this.spots.length; ++i) {
            AnimatedView v = new AnimatedView(this.getContext());
            v.setBackgroundResource(R.drawable.spot);
            v.setTarget(progressWidth);
            v.setXFactor(-1.0f);
            progress.addView((View)v, size, size);
            this.spots[i] = v;
        }
    }

    @SuppressLint(value={"NewApi"})
    private Animator[] createAnimations() {
        Animator[] animators = new Animator[this.size];
        for (int i = 0; i < this.spots.length; ++i) {
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)this.spots[i], (String)"xFactor", (float[])new float[]{0.0f, 1.0f});
            move.setDuration(1500L);
            move.setInterpolator((TimeInterpolator)new HesitateInterpolator());
            move.setStartDelay((long)(150 * i));
            animators[i] = move;
        }
        return animators;
    }
}

