/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import demo.xm.com.libxmfunsdk.R;

public class VolumeView
extends View {
    private Paint paint;
    private int colorId;
    private int levelCount;
    private int level;

    public VolumeView(Context context) {
        this(context, null);
    }

    public VolumeView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VolumeView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.VolumeView);
        if (params != null) {
            this.colorId = params.getResourceId(R.styleable.VolumeView_LevelColor, -1);
            this.levelCount = params.getInteger(R.styleable.VolumeView_LevelCount, 4);
            params.recycle();
        }
        this.paint = new Paint();
        this.paint.setColor(-1);
        this.paint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(this.getResources().getColor(R.color.transparent));
        int minWidth = (this.getWidth() - 50) / this.levelCount;
        int height = this.getHeight() / (this.levelCount * 2 + 1);
        for (int i = 0; i < this.levelCount; ++i) {
            if (i <= this.level) {
                this.paint.setStyle(Paint.Style.FILL);
            } else {
                this.paint.setStyle(Paint.Style.STROKE);
            }
            float left = (float)(this.getWidth() - minWidth * (i + 1)) / 2.0f;
            float right = (float)(this.getWidth() + minWidth * (i + 1)) / 2.0f;
            float top = ((this.levelCount - i) * 2 - 1) * height;
            float bottom = (this.levelCount - i) * 2 * height;
            canvas.drawRect(new RectF(left, top, right, bottom), this.paint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void setLevel(int level) {
        this.level = level;
        this.postInvalidate();
    }

    public int getLevelCount() {
        return this.levelCount;
    }
}

