/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import demo.xm.com.libxmfunsdk.R;

public class ImageTextView
extends RelativeLayout {
    public static final int DIRECTION_LEFT_UP = 1;
    public static final int DIRECTION_RIGHT_UP = 2;
    public static final int DIRECTION_LEFT_DOWN = 3;
    public static final int DIRECTION_RIGHT_DOWN = 4;
    public static final int DIRECTION_CENTER = 0;
    private ImageView mImageView;
    private TextView mTextView;
    private int mImgWidth;
    private int mImgHeight;
    private int mImageSrcId;
    private String mText;
    private int mTextSize;
    private int mTextColorId;
    private int mTextDirection;

    public ImageTextView(Context context) {
        super(context);
        this.initAttributes(null, 0);
        this.initView();
        this.initData();
    }

    public ImageTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttributes(attrs, 0);
        this.initView();
        this.initData();
    }

    public ImageTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttributes(attrs, defStyleAttr);
        this.initView();
        this.initData();
    }

    private void initView() {
        this.mImageView = new ImageView(this.getContext());
        this.mTextView = new TextView(this.getContext());
        RelativeLayout.LayoutParams imageViewLP = this.mImgWidth == 0 || this.mImgHeight == 0 ? new RelativeLayout.LayoutParams(-2, -2) : new RelativeLayout.LayoutParams(this.mImgWidth, this.mImgHeight);
        imageViewLP.addRule(13);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)imageViewLP);
        RelativeLayout.LayoutParams textViewLP = new RelativeLayout.LayoutParams(-2, -2);
        textViewLP.addRule(13);
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)textViewLP);
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ImageTextView, defStyle, 0);
        this.mImgWidth = (int)typedArray.getDimension(R.styleable.ImageTextView_it_img_width, 0.0f);
        this.mImgHeight = (int)typedArray.getDimension(R.styleable.ImageTextView_it_img_height, 0.0f);
        this.mImageSrcId = typedArray.getResourceId(R.styleable.ImageTextView_it_src, R.color.thumbnail_bg_color);
        this.mText = typedArray.getString(R.styleable.ImageTextView_it_text);
        this.mTextColorId = typedArray.getColor(R.styleable.ImageTextView_it_text_color, -1);
        this.mTextSize = typedArray.getDimensionPixelSize(R.styleable.ImageTextView_it_text_size, 20);
        this.mTextDirection = typedArray.getInteger(R.styleable.ImageTextView_it_text_direction, 0);
        typedArray.recycle();
    }

    private void initData() {
        if (null != this.mText) {
            this.mTextView.setText((CharSequence)this.mText);
        }
        this.mTextView.setTextColor(this.mTextColorId);
        this.mTextView.setTextSize((float)this.mTextSize);
        if (this.mImageSrcId != 0) {
            this.mImageView.setImageResource(this.mImageSrcId);
        }
    }

    public void setText(CharSequence text) {
        this.mText = text.toString();
        this.mTextView.setText(text);
    }

    public void setTextSize(int size) {
        this.mTextSize = size;
        this.mTextView.setTextSize(0, (float)size);
    }

    public void setTextColor(int colorId) {
        this.mTextColorId = colorId;
        this.mTextView.setTextColor(colorId);
    }

    public void setImageResource(int imageId) {
        this.mImageView.setImageResource(imageId);
    }

    public void setTextDirection(int direction) {
        this.mTextDirection = direction;
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            this.mImageView.setImageBitmap(bitmap);
        }
    }

    public void setImgHeight(int imgHeight) {
        this.mImgHeight = imgHeight;
    }

    public void setImgWidth(int imgWidth) {
        this.mImgWidth = imgWidth;
    }

    public ImageView getImageView() {
        return this.mImageView;
    }

    public TextView getTextView() {
        return this.mTextView;
    }
}

