/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import com.xm.linke.face.FaceFeature;
import io.reactivex.annotations.Nullable;

public class FaceFrameView
extends View {
    private FaceFeature[] faceFeatures;
    private Paint paint;
    private float ratioW;
    private float ratioH;

    public FaceFrameView(Context context) {
        this(context, null);
    }

    public FaceFrameView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FaceFrameView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.paint = new Paint();
        this.paint.setColor(-65536);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        canvas.drawPaint(this.paint);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        if (this.faceFeatures != null) {
            for (FaceFeature faceFeature : this.faceFeatures) {
                if (faceFeature == null || faceFeature.faceRect == null) continue;
                canvas.drawRect(faceFeature.faceRect.left * this.ratioW, faceFeature.faceRect.top * this.ratioH, faceFeature.faceRect.right * this.ratioW, faceFeature.faceRect.bottom * this.ratioH, this.paint);
            }
        }
    }

    public void setFaceFeature(FaceFeature[] faceFeatures, int width, int height) {
        if (faceFeatures == null || width == 0 || height == 0) {
            this.faceFeatures = null;
        } else {
            this.ratioW = (float)this.getWidth() * 1.0f / ((float)width * 1.0f);
            this.ratioH = (float)this.getHeight() * 1.0f / ((float)height * 1.0f);
            this.faceFeatures = faceFeatures;
        }
        this.postInvalidate();
    }
}

