/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.utils.XUtils;
import com.xm.ui.media.MultiWinView;
import demo.xm.com.libxmfunsdk.R;

public class MultiWinLayout
extends LinearLayout
implements MultiWinView.OnViewSimpleGestureListener,
View.OnKeyListener,
MultiWinView.OnChildFocusListener {
    public static final int MAX_WND_COUNT = 4;
    public static final int DEFAULT_WND_COUNT = 1;
    public static final int FRAME_BG_NORMAL = 0;
    public static final int FRAME_BG_SEL = 1;
    private RelativeLayout[][] layouts;
    private TextView[][] playMsgs;
    private MultiWinView[] playViews;
    private int wndCount;
    private int rowCount;
    private int columnCount;
    private boolean isSingleWnd = false;
    private int selectedId;
    private int[] frameBgs = new int[2];
    private OnMultiWndListener multiWndLs;

    public MultiWinLayout(Context context) {
        super(context);
    }

    public MultiWinLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray params = context.obtainStyledAttributes(attrs, R.styleable.MultiWinLayout);
        this.frameBgs[0] = params.getResourceId(R.styleable.MultiWinLayout_NormalFrameBg, R.drawable.wnd_margin_normal);
        this.frameBgs[1] = params.getResourceId(R.styleable.MultiWinLayout_SelectedFrameBg, R.drawable.wnd_margin_selected);
    }

    public MultiWinLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @SuppressLint(value={"NewApi"})
    public MultiWinLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public ViewGroup[] setViewCount(int wndCount) {
        this.unBindingPlayViews();
        this.selectedId = 0;
        this.wndCount = wndCount;
        boolean bl = this.isSingleWnd = wndCount == 1;
        if (wndCount == 2) {
            this.rowCount = 1;
            this.columnCount = 2;
        } else {
            this.rowCount = this.columnCount = (int)Math.sqrt(wndCount);
        }
        this.layouts = new RelativeLayout[this.rowCount][this.columnCount];
        this.playMsgs = new TextView[this.rowCount][this.columnCount];
        this.setOrientation(1);
        this.setWeightSum(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            LinearLayout.LayoutParams lpi = new LinearLayout.LayoutParams(-1, -1);
            LinearLayout ll = new LinearLayout(this.getContext());
            ll.setOrientation(0);
            ll.setWeightSum((float)this.columnCount);
            lpi.weight = 1.0f;
            for (int j = 0; j < this.columnCount; ++j) {
                LinearLayout.LayoutParams lpj = new LinearLayout.LayoutParams(-1, -1);
                lpj.weight = 1.0f;
                this.layouts[i][j] = new RelativeLayout(this.getContext());
                this.layouts[i][j].setId(i * this.rowCount + j);
                this.layouts[i][j].setBackgroundColor(-16777216);
                this.layouts[i][j].setFocusable(true);
                this.layouts[i][j].requestFocus();
                if (!this.isSingleWnd) {
                    if (i == 0 && j == 0) {
                        this.layouts[i][j].setBackgroundResource(this.frameBgs[1]);
                    } else {
                        this.layouts[i][j].setBackgroundResource(this.frameBgs[0]);
                    }
                }
                this.playMsgs[i][j] = new TextView(this.getContext());
                this.playMsgs[i][j].setBackgroundColor(this.getContext().getResources().getColor(R.color.wnd_cover_gray));
                this.playMsgs[i][j].setTextSize(0, (float)XUtils.sp2px(this.getContext(), R.dimen.small_text_size));
                this.playMsgs[i][j].setTextColor(this.getContext().getResources().getColor(R.color.white));
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                this.layouts[i][j].addView((View)this.playMsgs[i][j]);
                ll.addView((View)this.layouts[i][j], (ViewGroup.LayoutParams)lpj);
            }
            this.addView((View)ll, (ViewGroup.LayoutParams)lpi);
        }
        return this.bindingPlayViews();
    }

    public void release() {
        this.unBindingPlayViews();
    }

    private void unBindingPlayViews() {
        try {
            int i;
            if (this.layouts != null) {
                for (i = 0; i < this.rowCount; ++i) {
                    for (int j = 0; j < this.columnCount; ++j) {
                        RelativeLayout layout2 = this.layouts[i][j];
                        if (layout2 == null) continue;
                        layout2.removeAllViews();
                    }
                }
            }
            for (i = 0; i < this.getChildCount(); ++i) {
                ViewGroup layout3 = (ViewGroup)this.getChildAt(i);
                if (null == layout3) continue;
                layout3.removeAllViews();
            }
            this.removeAllViews();
            this.playViews = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ViewGroup[] bindingPlayViews() {
        if (null == this.playViews) {
            this.playViews = new MultiWinView[this.wndCount];
        }
        for (int i = 0; i < this.wndCount; ++i) {
            RelativeLayout fatherLayout = this.layouts[i / this.rowCount][i % this.columnCount];
            this.playViews[i] = new MultiWinView(this.getContext());
            this.playViews[i].setId(fatherLayout.getId());
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            fatherLayout.addView((View)this.playViews[i], (ViewGroup.LayoutParams)layoutParams);
            this.playViews[i].setOnViewSimpleGestureListener(this);
            this.playViews[i].setOnDispatchKeyListener(this);
            this.playViews[i].setOnChildFocusListener(this);
            this.playViews[i].setPadding(2, 2, 2, 2);
            this.playViews[i].setFocusable(true);
        }
        return this.playViews;
    }

    public ViewGroup getWnd(int id2) {
        if (null == this.playViews || id2 >= this.wndCount) {
            return null;
        }
        return this.playViews[id2];
    }

    public int getSelectedId() {
        return this.selectedId < 0 ? 0 : this.selectedId;
    }

    public boolean isSingleWnd() {
        return this.isSingleWnd;
    }

    public boolean isSupportMoreWnd() {
        return this.wndCount > 1;
    }

    public void changeChannel(int chnId) {
        if (this.wndCount > 1 && this.isSingleWnd) {
            this.selectedId = chnId;
            this.setViewVisibility(this.selectedId, 8);
        }
    }

    private void setViewVisibility(int chnId, int visibility) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            int columnNo = chnId / this.rowCount;
            ViewGroup layout2 = (ViewGroup)this.getChildAt(i);
            if (null == layout2) continue;
            for (int j = 0; j < layout2.getChildCount(); ++j) {
                View view = layout2.getChildAt(j);
                if (view.getId() != chnId) {
                    view.setVisibility(visibility);
                    if (visibility == 0) {
                        this.setChildViewVisibility((ViewGroup)this.playViews[i * this.rowCount + j], 0);
                        this.playViews[i * this.rowCount + j].setVisibility(0);
                        continue;
                    }
                    this.setChildViewVisibility((ViewGroup)this.playViews[i * this.rowCount + j], 8);
                    this.playViews[i * this.rowCount + j].setVisibility(8);
                    continue;
                }
                view.setVisibility(0);
                this.setChildViewVisibility((ViewGroup)this.playViews[i * this.rowCount + j], 0);
                this.playViews[i * this.rowCount + j].setVisibility(0);
            }
            if (i != columnNo) {
                layout2.setVisibility(visibility);
                continue;
            }
            layout2.setVisibility(0);
        }
    }

    private void setChildViewVisibility(ViewGroup viewGroup, int visibility) {
        for (int k = 0; k < viewGroup.getChildCount(); ++k) {
            View childView = viewGroup.getChildAt(k);
            if (childView == null) continue;
            childView.setVisibility(visibility);
        }
    }

    @Override
    public boolean isNeedInterceptTouchEvent(View view) {
        return this.selectedId != view.getId();
    }

    @Override
    public boolean onTouchEvent(View view, MotionEvent event) {
        if (this.multiWndLs != null) {
            this.multiWndLs.onTouchEvent(view.getId(), event);
        }
        return false;
    }

    @Override
    public boolean onSingleTapUp(View view, MotionEvent e) {
        if (null != this.multiWndLs) {
            this.multiWndLs.onSingleTapUp(view.getId(), e, this.isSingleWnd);
        }
        if (this.selectedId != view.getId() && !this.isSingleWnd) {
            view.setBackgroundResource(this.frameBgs[1]);
            if (null != this.multiWndLs) {
                this.multiWndLs.onSelectedWnd(view.getId(), e, true);
            }
            if (this.selectedId >= 0) {
                this.layouts[this.selectedId / this.rowCount][this.selectedId % this.columnCount].setBackgroundResource(this.frameBgs[0]);
                if (null != this.multiWndLs) {
                    this.multiWndLs.onSelectedWnd(this.selectedId, e, false);
                }
            }
            this.selectedId = view.getId();
            System.out.println("selectedId:" + this.selectedId);
        }
        return false;
    }

    @Override
    public void onLongPress(View view, MotionEvent e) {
        if (this.multiWndLs != null) {
            this.multiWndLs.onLongPress(view, e);
        }
    }

    @Override
    public boolean onDown(View view, MotionEvent e) {
        return false;
    }

    @Override
    public boolean onDoubleTap(View view, MotionEvent e) {
        if (this.multiWndLs != null && this.multiWndLs.isDisableToChangeWndSize(view.getId())) {
            return false;
        }
        if (this.wndCount > 1) {
            if (this.isSingleWnd) {
                this.layouts[view.getId() / this.rowCount][view.getId() % this.columnCount].setBackgroundResource(R.drawable.wnd_margin_selected);
                this.setViewVisibility(view.getId(), 0);
                this.isSingleWnd = false;
                if (null != this.multiWndLs) {
                    this.multiWndLs.onSingleWnd(view.getId(), e, false);
                }
            } else {
                this.layouts[view.getId() / this.rowCount][view.getId() % this.columnCount].setBackgroundResource(0);
                this.setViewVisibility(view.getId(), 8);
                this.isSingleWnd = true;
                if (null != this.multiWndLs) {
                    this.multiWndLs.onSingleWnd(view.getId(), e, true);
                }
            }
        }
        if (null != this.multiWndLs) {
            this.multiWndLs.onDoubleTap((View)this, e);
        }
        return false;
    }

    @Override
    public boolean onDoubleTapEvent(View view, MotionEvent e) {
        return false;
    }

    @Override
    public boolean onSingleTapConfirmed(View view, MotionEvent e) {
        if (null != this.multiWndLs) {
            this.multiWndLs.onSingleTapConfirmed(view.getId(), e, this.isSingleWnd);
        }
        return false;
    }

    @Override
    public boolean onFling(View view, MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (null != this.multiWndLs) {
            this.multiWndLs.onFling(view, e1, e2, velocityX, velocityY);
        }
        return false;
    }

    @Override
    public boolean onScroll(View view, MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void setOnMultiWndListener(OnMultiWndListener ls) {
        this.multiWndLs = ls;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() != 1) {
            return false;
        }
        System.out.println("isSameWnd:" + ((View)v.getParent()).getId() + "action:" + event.getAction());
        boolean isSameWnd = this.selectedId == ((View)v.getParent()).getId();
        switch (keyCode) {
            case 23: {
                if (!v.isFocused() || this.isSingleWnd) break;
                this.onDoubleTap((View)v.getParent(), null);
                break;
            }
            case 19: 
            case 20: {
                if (isSameWnd && this.multiWndLs instanceof OnMultiWndKeyListener) {
                    ((OnMultiWndKeyListener)this.multiWndLs).onKey(keyCode, event, true);
                }
                this.onSingleTapUp((View)v.getParent(), null);
                break;
            }
            case 21: {
                if (isSameWnd) {
                    if (this.selectedId > 0 && this.selectedId % this.rowCount == 0) {
                        this.getWnd(this.selectedId - 1).requestFocus();
                        this.onSingleTapUp((View)this.getWnd(this.selectedId - 1).getParent(), null);
                        break;
                    }
                    if (!(this.multiWndLs instanceof OnMultiWndKeyListener)) break;
                    ((OnMultiWndKeyListener)this.multiWndLs).onKey(keyCode, event, true);
                    break;
                }
                this.onSingleTapUp((View)v.getParent(), null);
                break;
            }
            case 22: {
                if (isSameWnd) {
                    if (this.selectedId + 1 < this.wndCount && (this.selectedId + 1) % this.rowCount == 0) {
                        this.getWnd(this.selectedId + 1).requestFocus();
                        this.onSingleTapUp((View)this.getWnd(this.selectedId + 1).getParent(), null);
                        break;
                    }
                    if (!(this.multiWndLs instanceof OnMultiWndKeyListener)) break;
                    ((OnMultiWndKeyListener)this.multiWndLs).onKey(keyCode, event, true);
                    break;
                }
                this.onSingleTapUp((View)v.getParent(), null);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        System.out.println("onRequestFocusInDescendants:" + direction);
        return false;
    }

    @Override
    public void onRequestChildFocus(View child, View focused) {
        System.out.println("onRequestChildFocus:" + child.getId() + " " + focused.getId());
    }

    public void addTitleBar(int wndPos, ViewGroup titleBar) {
        MultiWinView playView;
        if (wndPos < this.wndCount && (playView = this.playViews[wndPos]) != null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            playView.addView((View)titleBar, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public View addTitleBar(int wndPos, int layoutId) {
        if (wndPos < this.wndCount && layoutId != 0) {
            View titleBar = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, null);
            MultiWinView playView = this.playViews[wndPos];
            if (playView != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                playView.addView(titleBar, (ViewGroup.LayoutParams)layoutParams);
            }
            return titleBar;
        }
        return null;
    }

    public void setPlayMsgView(int wndId, View view) {
        try {
            if (null == this.layouts || wndId >= this.wndCount) {
                return;
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(12, -1);
            layoutParams.setMargins(10, 0, 0, 10);
            this.layouts[wndId / this.rowCount][wndId % this.columnCount].addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDevName(int wndId, View view) {
        try {
            if (null == this.layouts || wndId >= this.wndCount) {
                return;
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(10, -1);
            layoutParams.setMargins(10, 10, 0, 0);
            this.layouts[wndId / this.rowCount][wndId % this.columnCount].addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPlayView(int wndId, ViewGroup view) {
        try {
            if (null == this.layouts || wndId >= this.wndCount) {
                return;
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13, -1);
            this.layouts[wndId / this.rowCount][wndId % this.columnCount].addView((View)view, (ViewGroup.LayoutParams)layoutParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    public static interface OnMultiWndListener {
        public boolean isDisableToChangeWndSize(int var1);

        public boolean onTouchEvent(int var1, MotionEvent var2);

        public boolean onSingleWnd(int var1, MotionEvent var2, boolean var3);

        public boolean onSelectedWnd(int var1, MotionEvent var2, boolean var3);

        public boolean onSingleTapUp(int var1, MotionEvent var2, boolean var3);

        public boolean onSingleTapConfirmed(int var1, MotionEvent var2, boolean var3);

        public boolean onDoubleTap(View var1, MotionEvent var2);

        public void onLongPress(View var1, MotionEvent var2);

        public void onFling(View var1, MotionEvent var2, MotionEvent var3, float var4, float var5);
    }

    public static interface OnMultiWndKeyListener
    extends OnMultiWndListener {
        public boolean onKey(int var1, KeyEvent var2, boolean var3);
    }
}

