/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.dialog;

import android.app.DialogFragment;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.annotation.IntRange;
import com.xm.ui.widget.NumberPicker;
import demo.xm.com.libxmfunsdk.R;
import io.reactivex.annotations.Nullable;
import java.util.Calendar;
import java.util.Date;

public class TimePickBottomDialog
extends DialogFragment
implements View.OnClickListener {
    private View root;
    private String[] hours;
    private String[] minutes;
    private int hour;
    private int minute;
    private NumberPicker npHour;
    private NumberPicker npMinute;
    private TextView btnOk;
    private TextView btnCancel;
    private OnDatePickerListener onDatePickerListener;
    private int seq = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(1, R.style.SimpleDialog);
        if (this.hours == null) {
            this.initData();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.initData();
        }
        this.root = inflater.inflate(R.layout.funsdk_time_number_pick, container, false);
        this.btnOk = (TextView)this.root.findViewById(R.id.tv_sure);
        this.btnCancel = (TextView)this.root.findViewById(R.id.tv_cancel);
        this.npHour = (NumberPicker)this.root.findViewById(R.id.numpicker_h);
        this.npMinute = (NumberPicker)this.root.findViewById(R.id.numpicker_m);
        this.npHour.setDescendantFocusability(393216);
        this.npHour.setMaxValue(this.hours.length - 1);
        this.npHour.setMinValue(0);
        this.npHour.setDisplayedValues(this.hours);
        this.npHour.setValue(this.hour);
        this.npMinute.setDescendantFocusability(393216);
        this.npMinute.setMaxValue(this.minutes.length - 1);
        this.npMinute.setMinValue(0);
        this.npMinute.setDisplayedValues(this.minutes);
        this.npMinute.setValue(this.minute);
        this.btnOk.setOnClickListener((View.OnClickListener)this);
        this.btnCancel.setOnClickListener((View.OnClickListener)this);
        return this.root;
    }

    public void onStart() {
        super.onStart();
        this.initParams();
    }

    private void initParams() {
        Window window = this.getDialog().getWindow();
        if (window != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.gravity = 80;
            params.width = -1;
            params.height = -2;
            window.setAttributes(params);
            window.setWindowAnimations(R.style.CornerPopwindowAnimStyle);
        }
        this.setCancelable(true);
        this.getDialog().setCanceledOnTouchOutside(false);
    }

    private void initData() {
        int i;
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.hours = new String[24];
        for (i = 0; i < this.hours.length; ++i) {
            this.hours[i] = (i < 10 ? "0" : "") + i;
        }
        this.minutes = new String[60];
        for (i = 0; i < this.minutes.length; ++i) {
            this.minutes[i] = (i < 10 ? "0" : "") + i;
        }
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.tv_sure) {
            if (this.onDatePickerListener != null) {
                this.onDatePickerListener.onTimePicked(null, null, null, this.hours[this.npHour.getValue()], this.minutes[this.npMinute.getValue()], this.seq);
            }
            this.dismiss();
        } else if (i == R.id.tv_cancel) {
            this.dismiss();
        }
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void setTimes(@IntRange(from=0L, to=23L) int hour, @IntRange(from=0L, to=59L) int minute) {
        if (this.hours == null) {
            this.initData();
        }
        this.hour = hour;
        this.minute = minute;
    }

    public void setOnDatePickerListener(OnDatePickerListener listener) {
        this.onDatePickerListener = listener;
    }

    public static interface OnDatePickerListener {
        public void onTimePicked(String var1, String var2, String var3, String var4, String var5, int var6);
    }
}

