/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.lib.FunSDK;
import com.lib.sdk.bean.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class FileUtils {
    public static byte[] readSDFile(String fileName) throws IOException {
        File file = new File(fileName);
        FileInputStream fis = new FileInputStream(file);
        int length = fis.available();
        byte[] buffer = new byte[length];
        fis.read(buffer);
        fis.close();
        return buffer;
    }

    public static void writeSDFile(String fileName, String write_str) throws IOException {
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        byte[] bytes = write_str.getBytes();
        fos.write(bytes);
        fos.close();
    }

    public static void writeSDFile(String fileName, byte[] data, boolean append) throws IOException {
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file, append);
        fos.write(data);
        fos.close();
    }

    public static String FormetFileSize(long fileS, int unit) {
        DecimalFormat df = new DecimalFormat("#.0");
        String fileSizeString = "";
        if (unit == 0) {
            fileSizeString = fileS == 0L ? "0.00B" : (fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "K" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "M" : df.format((double)fileS / 1.073741824E9) + "G")));
        } else if (unit == 1) {
            fileSizeString = fileS == 0L ? "0.00K" : (fileS < 1024L ? df.format((double)fileS) + "K" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "M" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "G" : df.format((double)fileS / 1.073741824E9) + "T")));
        } else if (unit == 2) {
            if (fileS == 0L) {
                fileSizeString = "0.0M";
            } else if (fileS < 1024L) {
                fileSizeString = df.format((double)fileS) + "M";
            } else if (fileS < 0x100000L) {
                fileSizeString = df.format((double)fileS / 1024.0) + "G";
            } else if (fileS < 0x40000000L) {
                fileSizeString = df.format((double)fileS / 1048576.0) + "T";
            }
        }
        return fileSizeString;
    }

    public static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    public static int[] fileNameToTime(String filename) {
        if (!filename.endsWith(".h264")) {
            return null;
        }
        int[] times = new int[2];
        int pos = filename.indexOf(".h264");
        if (!(pos > 17 && filename.substring(pos - 15, pos - 14).equals(":") && filename.substring(pos - 12, pos - 11).equals(":") && filename.substring(pos - 9, pos - 8).equals("-") && filename.substring(pos - 6, pos - 5).equals(":") && filename.substring(pos - 3, pos - 2).equals(":"))) {
            return null;
        }
        String str1 = filename.substring(pos - 17, pos - 15);
        String str2 = filename.substring(pos - 14, pos - 12);
        String str3 = filename.substring(pos - 11, pos - 9);
        String str4 = filename.substring(pos - 8, pos - 6);
        String str5 = filename.substring(pos - 5, pos - 3);
        String str6 = filename.substring(pos - 2, pos);
        try {
            times[0] = Integer.parseInt(str1) * 3600 + Integer.parseInt(str2) * 60 + Integer.parseInt(str3);
            times[1] = Integer.parseInt(str4) * 3600 + Integer.parseInt(str5) * 60 + Integer.parseInt(str6);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return times;
    }

    public static boolean readSDSurplusSpace() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            File sdcardDir = Environment.getExternalStorageDirectory();
            StatFs sf = new StatFs(sdcardDir.getPath());
            long size = sf.getBlockSize() * sf.getAvailableBlocks();
            return size >= 0x3200000L;
        }
        return false;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static void fileScan(Context context, String filePath) {
        Uri data = Uri.parse((String)("file://" + filePath));
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", data));
    }

    public static boolean copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                fs.close();
                ((InputStream)inStream).close();
            }
            return true;
        }
        catch (Exception e) {
            System.out.println(FunSDK.TS((String)"Error copying a single file operation"));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean deleteFile(File file) {
        if (null == file) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
            return false;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                file.delete();
                return true;
            }
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtils.deleteFile(childFiles[i]);
            }
            file.delete();
        }
        return true;
    }

    public static boolean deleteFile(String fileStr) {
        if (!TextUtils.isEmpty((CharSequence)fileStr)) {
            File file = new File(fileStr);
            if (null != file && file.exists()) {
                file.delete();
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean deleteFiles(File file) {
        if (null == file) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles == null || childFiles.length == 0) {
                return true;
            }
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtils.deleteFile(childFiles[i]);
            }
        }
        return true;
    }

    public static long isFileExists(String file) {
        File f = new File(file);
        if (f.exists() && f.isFile()) {
            return f.length();
        }
        return 0L;
    }

    public static boolean isFileAvailable(String filePath) {
        File f;
        if (null != filePath && (f = new File(filePath)).exists()) {
            if (f.isFile()) {
                return f.length() > 0L;
            }
            if (f.isDirectory()) {
                return true;
            }
        }
        return false;
    }

    public static void copyAssetsResToSD(Context context, String resName, String outFileName) throws IOException {
        File file = new File(outFileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream myOutput = new FileOutputStream(outFileName);
        InputStream myInput = context.getAssets().open(resName);
        byte[] buffer = new byte[1024];
        int length = myInput.read(buffer);
        while (length > 0) {
            ((OutputStream)myOutput).write(buffer, 0, length);
            length = myInput.read(buffer);
        }
        myOutput.flush();
        myInput.close();
        ((OutputStream)myOutput).close();
    }

    public static long getFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : file.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return blockSize;
    }

    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : file.length();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileUtils.FormetFileSize(blockSize);
    }

    private static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtils.getFileSizes(flist[i]);
                continue;
            }
            size += flist[i].length();
        }
        return size;
    }

    public static boolean rename(File org, File tag) {
        if (null == org || null == tag) {
            return false;
        }
        return org.renameTo(tag);
    }

    public static boolean isFishEyePicture(String filePath) {
        return !TextUtils.isEmpty((CharSequence)filePath) && FunSDK.JPGHead_Read_Exif((String)filePath) != null && filePath.endsWith(".jpg");
    }

    public static boolean isFishEyeVideo(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && (path.toLowerCase().endsWith(".fvideo") || path.toLowerCase().endsWith(".fyuv") || FunSDK.MediaGetDecParam((String)path) != null);
    }

    public static boolean savePicToSysGallery(Activity activity, String fileName, Bitmap bitmap) {
        if (activity == null || fileName == null || bitmap == null) {
            return false;
        }
        try {
            String galleryPath = Environment.getExternalStorageDirectory() + File.separator + Environment.DIRECTORY_DCIM + File.separator + "Camera" + File.separator;
            if (!FileUtils.isFileAvailable(galleryPath)) {
                galleryPath = Environment.getExternalStorageDirectory() + File.separator + Environment.DIRECTORY_DCIM + File.separator;
            }
            if (!FileUtils.isFileAvailable(galleryPath)) {
                galleryPath = Environment.getExternalStorageDirectory() + File.separator;
            }
            galleryPath = galleryPath + fileName;
            FileOutputStream fileOutputStream = new FileOutputStream(galleryPath);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            Uri uri = Uri.fromFile((File)new File(galleryPath));
            intent.setData(uri);
            activity.sendBroadcast(intent);
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    public static String filePathFormat(String filePath) {
        if (!StringUtils.isStringNULL(filePath)) {
            filePath = filePath.replace(" ", "").replace(":", "");
        }
        return filePath;
    }

    public static boolean makeRootDirectory(String filePath) {
        File file = null;
        String newPath = null;
        String[] path = filePath.split("/");
        for (int i = 0; i < path.length; ++i) {
            if (StringUtils.isStringNULL(newPath = newPath == null ? path[i] : newPath + "/" + path[i]) || (file = new File(newPath)).exists()) continue;
            return file.mkdir();
        }
        return true;
    }

    public static boolean isFileExist(String file) {
        File f = new File(file);
        return f.exists() && f.isFile();
    }

    public static boolean isFileOrDirExists(String file) {
        try {
            File f = new File(file);
            return f.exists();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

