/*
 * Decompiled with CFR 0.152.
 */
package com.manager.image;

import android.graphics.Bitmap;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.utils.FileUtils;
import com.utils.XUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public abstract class BaseImageManager
implements IFunSDKResult {
    protected String mDevId;
    protected String mSaveImageDir;
    protected int mUserId;
    protected boolean mIsDownloading;
    protected int maxQueueSize = 10;
    protected Queue<DownItemData> mDownloadQueue;
    protected HashMap<Integer, DownItemData> mDownloadResultMap;
    protected HashMap<String, Bitmap> mBitmapMaps;
    protected OnImageManagerListener mListener;

    public BaseImageManager() {
        this.mUserId = FunSDK.GetId((int)this.mUserId, (IFunSDKResult)this);
    }

    public BaseImageManager(String saveImageDir) {
        this.mSaveImageDir = saveImageDir;
        this.mUserId = FunSDK.GetId((int)this.mUserId, (IFunSDKResult)this);
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void setDevId(String devId) {
        this.mDevId = devId;
    }

    public void cancel() {
        if (this.mDownloadQueue != null) {
            this.mDownloadQueue.clear();
        }
    }

    public void release() {
        if (this.mBitmapMaps != null) {
            for (Map.Entry<String, Bitmap> entry : this.mBitmapMaps.entrySet()) {
                Bitmap bitmap;
                if (entry == null || (bitmap = entry.getValue()) == null) continue;
                bitmap.recycle();
            }
            this.mBitmapMaps.clear();
        }
        this.cancel();
    }

    public Bitmap getPicBitmap(String imagePath) {
        if (this.mBitmapMaps != null) {
            if (this.mBitmapMaps.containsKey(imagePath)) {
                return this.mBitmapMaps.get(imagePath);
            }
            if (FileUtils.isFileExist(imagePath)) {
                Bitmap bitmap = XUtils.createImageThumbnail(imagePath);
                this.mBitmapMaps.put(imagePath, bitmap);
                return bitmap;
            }
        }
        return null;
    }

    public void setOnImageManagerListener(OnImageManagerListener listener) {
        this.mListener = listener;
    }

    public static interface OnImageManagerListener {
        public void onDownloadResult(boolean var1, String var2, Bitmap var3, int var4, int var5);

        public void onDeleteResult(boolean var1, int var2);
    }

    public class DownItemData
    implements Serializable {
        public static final int ORIGINAL_IMG = 0;
        public static final int THUMB_IMG = 1;
        int mType;
        int mSeq;
        int mWidth = 0;
        int mHeight = 0;
        int mTimes;
        int mChnId;
        String mPath;
        String mDownloadJsonData;
        OnImageManagerListener mListener;
    }
}

