/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Message;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import com.basic.G;
import com.lib.AP.AudioProcess;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.WebRtcAudio.AudioProcessParams;
import com.lib.WebRtcAudio.WebRtcAudio;
import com.manager.db.DevDataCenter;
import com.manager.device.media.audio.IXMAudioManager;
import com.manager.device.media.audio.OnAudioDecibelListener;
import com.utils.LogUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Deque;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class XMAudioManager
implements IXMAudioManager,
IFunSDKResult {
    private static final String TAG = "XMAudioManager";
    private static final int AUDIO_SIZE = 640;
    public static final int HALF_DUPLEX = 1;
    public static final int FULL_DUPLEX = 2;
    public static final int SPEAKER_TYPE_NORMAL = 0;
    public static final int SPEAKER_TYPE_MAN = 1;
    public static final int SPEAKER_TYPE_WOMAN = 2;
    private int speakerType;
    protected int mTalkBackMode = 1;
    protected boolean canSendTalkDataToDevice = false;
    private AudioRecordThread mRecordThread;
    private byte[] mLock = new byte[1];
    private Object mAudioLock = new Object();
    protected Context mContext;
    protected OnAudioDecibelListener mAudioDecibelLs;
    private int userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
    private boolean isSoundTouchInit;
    private Deque<ByteBuffer> audioDataList;
    private byte[] oldAudioData;
    protected String mDevId;
    protected int chnId = -1;
    private boolean isVideoTalk;
    protected int sampleRate = 8000;
    private int audioFormat = 2;
    private int channelConfig = 2;

    public XMAudioManager(boolean isVideoTalk) {
        this.isVideoTalk = isVideoTalk;
    }

    public void initAudio(int sampleRate, int audioFormat, int channelConfig) {
        if (sampleRate > 0) {
            this.sampleRate = sampleRate;
        }
        this.audioFormat = audioFormat;
        this.channelConfig = channelConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createThreadAndStart() {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            int iret;
            if (this.mRecordThread == null) {
                this.mRecordThread = new AudioRecordThread();
                this.mRecordThread.startThread();
            }
            if ((iret = AudioProcess.STInit((int)this.userId, (int)1, (int)this.sampleRate, (float)1.0f, (float)1.0f, (float)1.0f)) >= 0) {
                this.isSoundTouchInit = true;
            }
            LogUtils.debugInfo("[APP_TALK]->", "Initialize voice changer");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createThreadAndStart(boolean uploadTalk) {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            int iret;
            this.canSendTalkDataToDevice = uploadTalk;
            if (this.mRecordThread == null) {
                this.mRecordThread = new AudioRecordThread();
                this.mRecordThread.startThread();
            }
            if ((iret = AudioProcess.STInit((int)this.userId, (int)1, (int)this.sampleRate, (float)1.0f, (float)1.0f, (float)1.0f)) >= 0) {
                this.isSoundTouchInit = true;
            }
            LogUtils.debugInfo("[APP_TALK]->", "Initialize voice changer");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUploadTalk(boolean uploadTalk) {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            this.canSendTalkDataToDevice = uploadTalk;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTalkThread() {
        byte[] byArray = this.mLock;
        synchronized (this.mLock) {
            if (this.mRecordThread != null) {
                this.mRecordThread.stopThread();
                this.mRecordThread = null;
            }
            this.releaseSoundTouch();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void dealWithVolume(byte[] audioData, int readSize) {
        short[] buffers = this.bytesToShort(audioData);
        double sum = 0.0;
        for (short buffer : buffers) {
            sum += (double)Math.abs(buffer);
        }
        sum = sum / (double)readSize / 2.0;
        double volume = 0.0;
        if (sum > 0.0) {
            volume = 20.0 * Math.log10(sum);
        }
        if (this.mAudioDecibelLs != null) {
            this.mAudioDecibelLs.onVolume(volume);
        }
    }

    private boolean isNeedLossData(byte[] audioData, int readSize) {
        if (this.mDevId == null || !DevDataCenter.getInstance().isLowPowerDev(this.mDevId)) {
            return false;
        }
        short[] buffers = this.bytesToShort(audioData);
        double sum = 0.0;
        for (short buffer : buffers) {
            sum += (double)Math.abs(buffer);
        }
        sum = sum / (double)readSize / 2.0;
        double volume = 0.0;
        if (sum > 0.0) {
            volume = 20.0 * Math.log10(sum);
        }
        if (volume < 15.0) {
            this.oldAudioData = (byte[])audioData.clone();
            LogUtils.debugInfo("[APP_TALK]->", "If the score is lower than 15, the audio data is discarded.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithSendAudioData(byte[] audioData, int readSize) {
        if (readSize > 0) {
            if (this.mTalkBackMode == 2 || this.isVideoTalk) {
                audioData = WebRtcAudio.Process((byte[])audioData, (int)readSize);
                LogUtils.debugInfo("[APP_TALK]->", "echo cancellation processing");
            }
            if (!this.isNeedLossData(audioData, readSize)) {
                if (this.oldAudioData != null) {
                    this.sendAudioToDev(this.oldAudioData, readSize);
                    this.oldAudioData = null;
                }
                this.sendAudioToDev(audioData, readSize);
            }
        } else {
            Object object = this.mAudioLock;
            synchronized (object) {
                try {
                    this.mAudioLock.wait(5L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private short[] bytesToShort(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        short[] shorts = new short[bytes.length / 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
        return shorts;
    }

    public void setPitchSemiTones(float tones) {
        if (this.isSoundTouchInit) {
            AudioProcess.STSetPitchSemiTones((float)tones);
        }
    }

    public void setTempo(float tempo) {
        if (this.isSoundTouchInit) {
            AudioProcess.STSetTempo((float)tempo);
        }
    }

    public void setSpeakerType(int speakerType) {
        this.speakerType = speakerType;
        if (!this.isSoundTouchInit) {
            return;
        }
        if (speakerType == 1) {
            this.setPitchSemiTones(-4.0f);
        } else if (speakerType == 2) {
            this.setPitchSemiTones(4.0f);
        } else {
            this.setPitchSemiTones(1.0f);
        }
        LogUtils.debugInfo("[APP_TALK]->", "Switch voice change:" + speakerType);
    }

    public void releaseSoundTouch() {
        if (this.isSoundTouchInit) {
            AudioProcess.STUnInit();
            this.isSoundTouchInit = false;
            this.audioDataList.clear();
            LogUtils.debugInfo("[APP_TALK]->", "Destroy voice changer");
        }
    }

    public int OnFunSDKResult(Message message, MsgContent msgContent) {
        if (message.what == 8700) {
            byte[] audioData = msgContent.pData;
            this.writeAudioDataToBuffer(audioData, message.arg1);
            this.readAudioDataFromBuffer();
        }
        return 0;
    }

    private synchronized void writeAudioDataToBuffer(byte[] audioData, int audioSize) {
        int len;
        for (int offset = 0; offset < audioSize; offset += len) {
            ByteBuffer byteBuffer = this.getLastNotWholeDataFromList();
            if (byteBuffer == null) {
                byteBuffer = ByteBuffer.allocate(640);
            }
            len = Math.min(640, audioSize - offset);
            len = Math.min(len, 640 - byteBuffer.position());
            byteBuffer.put(audioData, offset, len);
            this.audioDataList.add(byteBuffer);
        }
    }

    private synchronized void readAudioDataFromBuffer() {
        ByteBuffer byteBuffer;
        int readAudioSize = 0;
        while (!this.audioDataList.isEmpty() && (byteBuffer = this.audioDataList.peek()) != null && byteBuffer.position() == 640) {
            byte[] readAudioData = new byte[640];
            byteBuffer.flip();
            byteBuffer.get(readAudioData);
            readAudioSize = readAudioData.length;
            this.dealWithSendAudioData(readAudioData, readAudioSize);
            this.dealWithVolume(readAudioData, readAudioData.length);
            this.audioDataList.poll();
        }
    }

    private ByteBuffer getLastNotWholeDataFromList() {
        ByteBuffer byteBuffer;
        if (!this.audioDataList.isEmpty() && (byteBuffer = this.audioDataList.getLast()).position() < 640) {
            this.audioDataList.removeLast();
            return byteBuffer;
        }
        return null;
    }

    class AudioRecordThread
    extends Thread {
        private boolean mThreadExitFlag = false;
        private AudioRecord mAudioRecord = null;
        private AudioManager mAudioManager;

        AudioRecordThread() {
        }

        public boolean startThread() {
            this.mThreadExitFlag = false;
            boolean isInit = this.initAudioRecord();
            if (isInit) {
                this.start();
            }
            return isInit;
        }

        public void stopThread() {
            this.mThreadExitFlag = true;
            if (this.mAudioManager != null) {
                this.mAudioManager.setMode(0);
                this.mAudioManager.setSpeakerphoneOn(false);
                this.mAudioManager = null;
            }
            WebRtcAudio.UnInit();
        }

        private boolean initAudioRecord() {
            AudioProcessParams audioProcessParams;
            LogUtils.debugInfo("[APP_TALK]->", "Initialize intercom");
            if (XMAudioManager.this.isVideoTalk) {
                audioProcessParams = new AudioProcessParams();
                audioProcessParams.st_0_nFuncBit = 7;
                audioProcessParams.st_4_webRtcAecParams.st_3_nRemoteType = 1;
                audioProcessParams.st_1_nSampleRate = XMAudioManager.this.sampleRate;
                audioProcessParams.st_6_webRtcAgcParams.st_4_nTargetLevelDbfs = 5;
                audioProcessParams.st_6_webRtcAgcParams.st_3_nCompressionGaindB = 10;
                WebRtcAudio.Init((byte[])G.ObjToBytes((Object)audioProcessParams));
                LogUtils.debugInfo("[APP_TALK]->", "Initialize WebRtc--video intercom");
            } else if (XMAudioManager.this.mTalkBackMode == 2) {
                audioProcessParams = new AudioProcessParams();
                audioProcessParams.st_0_nFuncBit = 7;
                audioProcessParams.st_1_nSampleRate = XMAudioManager.this.sampleRate;
                audioProcessParams.st_6_webRtcAgcParams.st_4_nTargetLevelDbfs = 5;
                audioProcessParams.st_6_webRtcAgcParams.st_3_nCompressionGaindB = 10;
                WebRtcAudio.Init((byte[])G.ObjToBytes((Object)audioProcessParams));
                LogUtils.debugInfo("[APP_TALK]->", "Initialize WebRtc--two-way intercom");
            } else {
                audioProcessParams = new AudioProcessParams();
                audioProcessParams.st_0_nFuncBit = 6;
                audioProcessParams.st_1_nSampleRate = XMAudioManager.this.sampleRate;
                WebRtcAudio.Init((byte[])G.ObjToBytes((Object)audioProcessParams));
                LogUtils.debugInfo("[APP_TALK]->", "Initialize WebRtc--one-way intercom");
            }
            int minBufSize = AudioRecord.getMinBufferSize((int)XMAudioManager.this.sampleRate, (int)XMAudioManager.this.channelConfig, (int)XMAudioManager.this.audioFormat);
            if (ActivityCompat.checkSelfPermission((Context)XMAudioManager.this.mContext, (String)"android.permission.RECORD_AUDIO") == 0) {
                this.mAudioRecord = new AudioRecord(1, XMAudioManager.this.sampleRate, XMAudioManager.this.channelConfig, XMAudioManager.this.audioFormat, minBufSize);
                this.mAudioManager = (AudioManager)XMAudioManager.this.mContext.getSystemService("audio");
                this.mAudioManager.setMode(2);
                this.mAudioManager.setSpeakerphoneOn(false);
                XMAudioManager.this.audioDataList = new LinkedBlockingDeque();
                return this.mAudioRecord.getState() != 0;
            }
            LogUtils.debugInfo("[APP_TALK]->", "Record Permission Not Open");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (null == this.mAudioRecord) {
                return;
            }
            this.mAudioRecord.startRecording();
            while (!this.mThreadExitFlag && this.mAudioRecord != null) {
                if (!XMAudioManager.this.canSendTalkDataToDevice) {
                    Object object = XMAudioManager.this.mAudioLock;
                    synchronized (object) {
                        try {
                            XMAudioManager.this.mAudioLock.wait(5L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                }
                int bufferSizeInBytes = XMAudioManager.this.speakerType != 0 ? 640 : 640;
                byte[] audioData = new byte[bufferSizeInBytes];
                int audioSize = this.mAudioRecord.read(audioData, 0, bufferSizeInBytes);
                if (audioSize <= 0) continue;
                if (XMAudioManager.this.speakerType != 0) {
                    AudioProcess.STChangeVoice((byte[])audioData);
                    continue;
                }
                XMAudioManager.this.dealWithSendAudioData(audioData, audioSize);
                XMAudioManager.this.dealWithVolume(audioData, audioSize);
            }
            if (this.mAudioRecord != null) {
                if (this.mAudioRecord.getState() == 3) {
                    this.mAudioRecord.stop();
                    Log.d((String)XMAudioManager.TAG, (String)"\u505c\u6b62\u5f55\u97f3");
                }
                this.mAudioRecord.release();
                this.mAudioRecord = null;
            }
        }
    }
}

