/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.GestureDetectorCompat;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.decoder.DecoderManaer;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.ATTR_WITH_HEITH;
import com.lib.sdk.struct.MultiLensParam;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.lib.sdk.struct.SDK_FishEyeFrameSW;
import com.lib.sdk.struct.SDK_TwoLensesInOne;
import com.manager.db.DevDataCenter;
import com.manager.device.fisheye.FishEyeCorrectManager;
import com.manager.device.fisheye.FishEyeParams;
import com.manager.device.fisheye.FishEyeParamsCache;
import com.manager.device.fisheye.FishEyeVidType;
import com.manager.device.media.MediaManagerInterface;
import com.manager.device.media.attribute.PlayerAttribute;
import com.manager.device.media.monitor.MonitorManager;
import com.utils.FileUtils;
import com.utils.LogUtils;
import com.utils.MediaUtils;
import com.vatics.dewarp.FecCenter;
import com.vatics.dewarp.GL2JNIView;
import com.video.opengl.GLSurfaceView20;
import com.video.opengl.OnPlayViewTouchListener;
import com.xm.UIUtils;
import com.xm.ui.media.MultiWinView;
import com.xm.ui.widget.SwitchFishEyeView;
import com.xmgl.vrsoft.VRSoftGLView;
import demo.xm.com.libxmfunsdk.R;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class MediaManager<T extends PlayerAttribute, I extends OnMediaManagerListener>
implements MediaManagerInterface,
IFunSDKResult,
FishEyeCorrectManager.OnFishEyeCorrectListener {
    public static final int PLAY_MONITOR = 0;
    public static final int PLAY_DEV_PLAYBACK = 1;
    public static final int PLAY_CLOUD_PLAYBACK = 2;
    public static final int HORIZONTAL_FLIP_TYPE_NORMAL = 0;
    public static final int HORIZONTAL_FLIP_TYPE_90 = 1;
    public static final int HORIZONTAL_FLIP_TYPE_180 = 2;
    public static final int HORIZONTAL_FLIP_TYPE_270 = 3;
    public static final int VERTICAL_FLIP_TYPE_NORMAL = 0;
    public static final int VERTICAL_FLIP_TYPE_FLIP = 1;
    protected ViewGroup playView;
    protected RelativeLayout rlPlayFunLayout;
    protected ImageView ivPlayState;
    protected boolean isPlayStateShow = true;
    protected TextView tvPlayStateTips;
    protected ProgressBar pbWaiting;
    protected SurfaceView surfaceView;
    protected int userId;
    protected T playerAttribute;
    protected I mediaManagerLs;
    private boolean isSaveImageToSysAlbum;
    private boolean isNeedCorrectFishEye = true;
    protected FishEyeParams fishEyeParams;
    private byte[] mRecordLock = new byte[1];
    private CutCountdown cutCountdown;
    private ScheduledExecutorService cutService;
    private OnRecordClipTimingListener recordClipTimingListener;
    private int bufferWaitingProgress;
    private BufferWaitingCountdown bufferWaitingCountdown;
    private ScheduledExecutorService bufferWaitingService;
    private String bufferWaitingTips;
    private OnPlayViewTouchListener onPlayViewTouchListener;
    private GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
    private int recordClipTimeCount;
    private ViewGroup extendView;
    private OnFrameInfoListener onFrameInfoListener;
    private GestureDetectorCompat gestureDetectorCompat;
    protected int playMode = 0;
    private boolean isPlayStateTipsEnable;
    protected SwitchFishEyeView switchFishEyeView;
    private int flipType;
    private boolean addBigIvState = false;
    private int bigBtnSize = 72;
    private ATTR_WITH_HEITH attrWithHeight;
    private boolean mIsPlayViewDestroy;
    private boolean mIsTouchable = true;
    private boolean mIsZOrderOnTop = false;
    private boolean mIsZOrderMediaOverlay = false;
    private Object mOnZoomLs;

    public MediaManager(@NotNull ViewGroup playView, T playerAttribute) {
        this.playView = playView;
        this.playerAttribute = playerAttribute;
        this.userId = FunSDK.RegUser((IFunSDKResult)this);
        this.fishEyeParams = new FishEyeParams(FishEyeVidType.GENERAL_VIDEO);
        this.createFunInPlayView();
        if (playView instanceof MultiWinView) {
            ((MultiWinView)playView).setOnLayoutChangeListener(new MultiWinView.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(int width, int height) {
                    if (MediaManager.this.fishEyeParams.getSpliceDirection() == 1) {
                        MediaManager.this.changeVideoSize(width, height);
                    } else {
                        MediaManager.this.changeVideoRatio();
                    }
                }
            });
            this.simpleOnGestureListener = ((MultiWinView)playView).getWndGestureDetector();
        }
    }

    public MediaManager(@NotNull ViewGroup playView, FishEyeVidType vidType, T playerAttribute) {
        this.playView = playView;
        this.playerAttribute = playerAttribute;
        this.userId = FunSDK.RegUser((IFunSDKResult)this);
        this.fishEyeParams = new FishEyeParams(vidType);
        this.createFunInPlayView();
        if (playView instanceof MultiWinView) {
            ((MultiWinView)playView).setOnLayoutChangeListener(new MultiWinView.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(int width, int height) {
                    MediaManager.this.changeVideoRatio();
                }
            });
            this.simpleOnGestureListener = ((MultiWinView)playView).getWndGestureDetector();
        }
    }

    public void setBigBtnCfg(boolean bigBtn) {
        this.setBigBtnCfg(bigBtn, 0);
    }

    public void setBigBtnCfg(boolean bigBtn, int size) {
        this.addBigIvState = bigBtn;
        this.bigBtnSize = Math.max(60, size);
        this.bigBtnSize = Math.min(this.bigBtnSize, 82);
    }

    @Override
    public void initFishCtrlLayout() {
        if (this.playView == null) {
            LogUtils.debugInfo("[APP_UI_ERROR]->", "initFishCtrlLayout error,playView is Null");
            return;
        }
        if (this.rlPlayFunLayout == null) {
            return;
        }
        if (!(this.surfaceView instanceof VRSoftGLView)) {
            return;
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(9);
        params.addRule(12);
        this.switchFishEyeView = new SwitchFishEyeView(this.playView.getContext(), (VRSoftGLView)this.surfaceView);
        this.rlPlayFunLayout.addView((View)this.switchFishEyeView, (ViewGroup.LayoutParams)params);
        if (this.playerAttribute != null) {
            if (((PlayerAttribute)this.playerAttribute).getVideoMode() == 1) {
                this.switchFishEyeView.init180VR(false);
            } else if (((PlayerAttribute)this.playerAttribute).getVideoMode() == 2) {
                this.switchFishEyeView.init360VR();
            }
        }
        ((VRSoftGLView)this.surfaceView).setmDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return false;
            }

            public boolean onDoubleTap(MotionEvent e) {
                return false;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                MediaManager.this.closeFishCtrl();
                if (e.getAction() == 1 && ((PlayerAttribute)MediaManager.this.playerAttribute).getVideoMode() == 5) {
                    if (((VRSoftGLView)MediaManager.this.surfaceView).getTwoLensesScreen() == 0) {
                        if (e.getX() <= (float)MediaManager.this.surfaceView.getWidth() / 2.0f) {
                            ((VRSoftGLView)MediaManager.this.surfaceView).setTwoLensesScreen(1);
                        } else {
                            ((VRSoftGLView)MediaManager.this.surfaceView).setTwoLensesScreen(2);
                        }
                    } else {
                        ((VRSoftGLView)MediaManager.this.surfaceView).setTwoLensesScreen(0);
                    }
                }
                return false;
            }
        });
    }

    public void offsetSwitchFishEyeView(int x, int y) {
        this.offsetSwitchFishEyeView(x, y, 150);
    }

    public void offsetSwitchFishEyeView(int x, int y, int duration) {
        if (this.switchFishEyeView == null) {
            return;
        }
        duration = Math.abs(duration);
        duration = Math.min(duration, 3000);
        this.switchFishEyeView.animate().translationX((float)x).translationY((float)(-y)).setDuration((long)duration).start();
    }

    @Override
    public void showFishCtrlLayout() {
        if (this.switchFishEyeView != null) {
            int videoMode = this.getVideoMode();
            if (videoMode == 1) {
                this.switchFishEyeView.show180VR();
            } else if (videoMode == 2) {
                this.switchFishEyeView.show360VR();
            }
        }
    }

    @Override
    public void hideFishCtrlLayout() {
        if (this.switchFishEyeView != null) {
            int videoMode = this.getVideoMode();
            if (videoMode == 1) {
                this.switchFishEyeView.hidden180VR();
            } else if (videoMode == 2) {
                this.switchFishEyeView.hidden360VR();
            }
        }
    }

    @Override
    public boolean isFishCtrlLayoutShow() {
        return this.switchFishEyeView != null && this.switchFishEyeView.getVisibility() == 0;
    }

    @Override
    public void closeFishCtrl() {
        if (this.switchFishEyeView != null) {
            this.switchFishEyeView.touchOutSideHidden();
        }
    }

    public void setOnMediaManagerListener(I ls) {
        this.mediaManagerLs = ls;
    }

    public MediaManager setChnId(int chnId) {
        if (this.playerAttribute != null) {
            ((PlayerAttribute)this.playerAttribute).setChnnel(chnId);
        }
        return this;
    }

    @Override
    public int getChnId() {
        if (this.playerAttribute != null) {
            return ((PlayerAttribute)this.playerAttribute).getChnnel();
        }
        return 0;
    }

    public MediaManager setStreamType(int streamType) {
        if (this.playerAttribute != null) {
            ((PlayerAttribute)this.playerAttribute).setStreamType(streamType);
        }
        return this;
    }

    @Override
    public int getStreamType() {
        if (this.playerAttribute != null) {
            return ((PlayerAttribute)this.playerAttribute).getStreamType();
        }
        return 0;
    }

    @Override
    public void setDevId(String devId) {
        if (this.playerAttribute != null) {
            ((PlayerAttribute)this.playerAttribute).setDevId(devId);
        }
    }

    @Override
    public String getDevId() {
        return this.playerAttribute != null ? ((PlayerAttribute)this.playerAttribute).getDevId() : null;
    }

    @Override
    public int getDevType() {
        if (this.playerAttribute != null) {
            int devType = DevDataCenter.getInstance().getDevType(((PlayerAttribute)this.playerAttribute).getDevId());
            return devType;
        }
        return 0;
    }

    @Override
    public int getPlayState() {
        return this.playerAttribute != null ? ((PlayerAttribute)this.playerAttribute).getPlayState() : -1;
    }

    @Override
    public int getPlayHandle() {
        return this.playerAttribute != null ? ((PlayerAttribute)this.playerAttribute).getPlayHandle() : 0;
    }

    @Override
    public int getVideoMode() {
        return this.playerAttribute != null ? ((PlayerAttribute)this.playerAttribute).getVideoMode() : 0;
    }

    @Override
    public void setShape(int fishMode) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setShape(fishMode);
        }
    }

    @Override
    public int getShape() {
        if (this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).getShape();
        }
        return 0;
    }

    @Override
    public void setMount(int mount) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setCameraMount(mount);
        }
    }

    @Override
    public int getMount() {
        if (this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).getCameraMount();
        }
        return 0;
    }

    @Override
    public void setDoorBellWallMode(boolean isDoorBellWallMode) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setDoorBellWallMode(isDoorBellWallMode);
        }
    }

    @Override
    public boolean isDoorBellWallMode() {
        if (this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).isDoorBellWallMode();
        }
        return false;
    }

    @Override
    public void pausePlay() {
        if (this.playerAttribute != null && ((PlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
            FunSDK.MediaPause((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)1, (int)0);
            this.setPlayState(1);
        }
    }

    @Override
    public void rePlay() {
        if (this.playerAttribute != null && ((PlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
            FunSDK.MediaPause((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0, (int)0);
            this.setPlayState(0);
        }
    }

    protected void start() {
        if (this.surfaceView == null) {
            this.createSurfaceView();
        }
    }

    @Override
    public void stopPlay() {
        this.stopRecord();
        if (this.playerAttribute != null && ((PlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
            FunSDK.MediaStop((int)((PlayerAttribute)this.playerAttribute).getPlayHandle());
            ((PlayerAttribute)this.playerAttribute).setPlayHandle(0);
            ((PlayerAttribute)this.playerAttribute).setRecord(false);
        }
        this.setPlayState(4);
    }

    @Override
    public void stopPlayFakeSleepWake() {
        this.stopRecord();
        if (this.playerAttribute != null && ((PlayerAttribute)this.playerAttribute).getPlayHandle() != 0) {
            FunSDK.MediaStop((int)((PlayerAttribute)this.playerAttribute).getPlayHandle());
            ((PlayerAttribute)this.playerAttribute).setPlayHandle(0);
            ((PlayerAttribute)this.playerAttribute).setRecord(false);
        }
    }

    @Override
    public void destroyPlay() {
        this.stopPlay();
        this.destroySurfaceView();
        if (this.playView != null) {
            this.playView.removeAllViews();
        }
        this.surfaceView = null;
        this.fishEyeParams = new FishEyeParams(FishEyeVidType.GENERAL_VIDEO);
        this.extendView = null;
    }

    protected void destroySurfaceView() {
        this.mIsPlayViewDestroy = true;
        this.cleanUpSurfaceView();
    }

    protected void cleanUpSurfaceView() {
        if (null != this.surfaceView) {
            if (this.surfaceView instanceof GL2JNIView) {
                ((GL2JNIView)this.surfaceView).cleanUp();
            } else if (this.surfaceView instanceof VRSoftGLView) {
                ((VRSoftGLView)this.surfaceView).cleanUp();
            } else if (this.surfaceView instanceof GLSurfaceView20) {
                ((GLSurfaceView20)this.surfaceView).cleanUp();
            }
        }
    }

    @Override
    public void release() {
        if (this.playerAttribute != null) {
            FunSDK.UnRegUser((int)this.userId);
        }
        this.destroyPlay();
        this.mediaManagerLs = null;
    }

    @Override
    public void reDraw() {
        if (this.surfaceView instanceof GLSurfaceView20) {
            ((GLSurfaceView20)this.surfaceView).ReDraw();
        }
    }

    @Override
    public int setPlayHandleAndPlay(int playHandle) {
        if (playHandle != 0) {
            ((PlayerAttribute)this.playerAttribute).setPlayHandle(playHandle);
            int result = FunSDK.MediaSetPlayView((int)playHandle, (Object)this.surfaceView, (int)0);
            if (result < 0) {
                FunSDK.MediaStop((int)playHandle);
                this.start();
            } else {
                FunSDK.SetIntAttr((int)playHandle, (int)10020, (int)this.userId);
                FunSDK.SetIntAttr((int)playHandle, (int)10015, (int)1);
                FunSDK.SetIntAttr((int)playHandle, (int)10012, (int)100);
                FunSDK.GetIntAttr((int)playHandle, (int)10021);
                this.setPlayState(0);
            }
        }
        return 0;
    }

    @Override
    public String capture(String dir) {
        FishEyeParams params;
        if (null == this.playerAttribute || ((PlayerAttribute)this.playerAttribute).getPlayHandle() == 0) {
            return null;
        }
        if (((PlayerAttribute)this.playerAttribute).getPlayState() == 2) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String strDate = sdf.format(new Date());
        strDate = strDate + System.currentTimeMillis();
        String imgPath = null;
        SDK_FishEyeFrame fishLensParam = FishEyeParamsCache.getInstance().getFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel());
        imgPath = null != fishLensParam ? ((params = new FishEyeParams(fishLensParam)).getVidType() == FishEyeVidType.FISHEYE_180VR || params.getVidType() == FishEyeVidType.FISHEYE_360VR ? dir + File.separator + strDate + ".fyuv" : dir + File.separator + strDate + ".jpg") : dir + File.separator + strDate + ".jpg";
        imgPath = FileUtils.filePathFormat(imgPath);
        ((PlayerAttribute)this.playerAttribute).setTempSaveImagePath(imgPath);
        FunSDK.MediaSnapImage((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (String)imgPath, (int)0);
        return imgPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startRecord(String dir) {
        if (null == this.playerAttribute) {
            return false;
        }
        if (((PlayerAttribute)this.playerAttribute).getPlayState() != 0 || ((PlayerAttribute)this.playerAttribute).isRecord()) {
            return false;
        }
        byte[] byArray = this.mRecordLock;
        synchronized (this.mRecordLock) {
            ((PlayerAttribute)this.playerAttribute).setRecord(true);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strDate = sdf.format(new Date());
            ((PlayerAttribute)this.playerAttribute).setTempSaveVideoPath(dir + File.separator + strDate + ".mp4");
            FunSDK.MediaStartRecord((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (String)((PlayerAttribute)this.playerAttribute).getTempSaveVideoPath(), (int)0);
            if (this.recordClipTimingListener != null) {
                this.startRecordClipTiming();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stopRecord() {
        this.stopRecordClipTiming();
        if (this.playerAttribute != null && ((PlayerAttribute)this.playerAttribute).isRecord()) {
            byte[] byArray = this.mRecordLock;
            synchronized (this.mRecordLock) {
                FunSDK.MediaStopRecord((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0);
                ((PlayerAttribute)this.playerAttribute).setRecord(false);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return ((PlayerAttribute)this.playerAttribute).getTempSaveVideoPath();
            }
        }
        return null;
    }

    @Override
    public boolean isRecord() {
        return ((PlayerAttribute)this.playerAttribute).isRecord();
    }

    @Override
    public void openVoiceBySound() {
        if (this.playerAttribute != null) {
            ((PlayerAttribute)this.playerAttribute).setSound(true);
        }
        FunSDK.MediaSetSound((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)100, (int)0);
    }

    @Override
    public void closeVoiceBySound() {
        if (this.playerAttribute != null) {
            ((PlayerAttribute)this.playerAttribute).setSound(false);
        }
        FunSDK.MediaSetSound((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0, (int)0);
    }

    @Override
    public void addExtendView(ViewGroup extendView) {
        if (this.playView != null && this.extendView != extendView) {
            this.extendView = extendView;
            this.playView.addView((View)extendView, new ViewGroup.LayoutParams(-1, -1));
        }
    }

    @Override
    public void removeExtendView(ViewGroup extendView) {
        if (this.playView != null && this.extendView != null) {
            this.playView.removeView((View)extendView);
            this.extendView = null;
        }
    }

    @Override
    public void setPlayMode(int playMode) {
        this.playMode = playMode;
    }

    @Override
    public void setTouchable(boolean isTouchable) {
        this.mIsTouchable = isTouchable;
        if (this.surfaceView != null) {
            if (this.surfaceView instanceof VRSoftGLView) {
                ((VRSoftGLView)this.surfaceView).setTouchable(isTouchable);
            } else if (this.surfaceView instanceof GLSurfaceView20) {
                ((GLSurfaceView20)this.surfaceView).setTouchable(isTouchable);
            }
        }
    }

    @Override
    public void saveImageToSysAlbum(boolean isEnable) {
        this.isSaveImageToSysAlbum = isEnable;
    }

    @Override
    public boolean isVideoFullScreen() {
        return ((PlayerAttribute)this.playerAttribute).isVideoFullScreen();
    }

    @Override
    public void setVideoFullScreen(boolean fullScreen) {
        ((PlayerAttribute)this.playerAttribute).setVideoFullScreen(fullScreen);
        this.changeVideoRatio();
    }

    @Override
    public void setHardDecode(boolean enable) {
        DecoderManaer.SetEnableHDec((boolean)enable);
    }

    @Override
    public void setScale(float scale) {
        if (this.surfaceView instanceof GLSurfaceView20) {
            ((GLSurfaceView20)this.surfaceView).setScale(scale);
        }
    }

    @Override
    public void setScaleLevel(int scaleLevel) {
        if (this.surfaceView instanceof GLSurfaceView20) {
            ((GLSurfaceView20)this.surfaceView).setScaleLevel(scaleLevel);
        }
    }

    @Override
    public void setZOrderOnTop(boolean isEnable) {
        this.mIsZOrderOnTop = isEnable;
        if (this.surfaceView != null) {
            this.surfaceView.setZOrderOnTop(isEnable);
        }
    }

    @Override
    public void setZOrderMediaOverlay(boolean isEnable) {
        this.mIsZOrderMediaOverlay = isEnable;
        if (this.surfaceView != null) {
            this.surfaceView.setZOrderMediaOverlay(isEnable);
        }
    }

    @Override
    public void setOnFrameInfoListener(OnFrameInfoListener listener) {
        this.onFrameInfoListener = listener;
    }

    @Override
    public void swapPlayHandle(final @NotNull MediaManager mediaManager, int delayChange) {
        if (mediaManager == null) {
            return;
        }
        try {
            final int playHandleOne = mediaManager.getPlayHandle();
            final int playHandleTwo = this.getPlayHandle();
            GLSurfaceView20 transitionLayout = new GLSurfaceView20(this.surfaceView.getContext());
            ViewGroup viewGroup = (ViewGroup)mediaManager.getSurfaceView().getRootView();
            viewGroup.addView((View)transitionLayout);
            transitionLayout.setVisibility(8);
            FunSDK.MediaSetPlayView((int)playHandleOne, (Object)transitionLayout, (int)0);
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    mediaManager.setPlayHandleAndPlay(playHandleTwo);
                    MediaManager.this.setPlayHandleAndPlay(playHandleOne);
                }
            }, (long)delayChange);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (this.mediaManagerLs != null) {
            if (this.mediaManagerLs instanceof OnMediaManagerExListener) {
                ((OnMediaManagerExListener)this.mediaManagerLs).OnFunSDKResult((PlayerAttribute)this.playerAttribute, msg, ex);
            }
            if (msg.arg1 < 0) {
                this.mediaManagerLs.onFailed((PlayerAttribute)this.playerAttribute, msg.what, msg.arg1);
            }
        }
        switch (msg.what) {
            case 5501: {
                if (msg.arg2 == -210009 && this.mediaManagerLs != null) {
                    this.mediaManagerLs.onFailed((PlayerAttribute)this.playerAttribute, msg.what, msg.arg2);
                }
                if (msg.arg1 < 0) {
                    this.stopPlay();
                    if (this.mediaManagerLs != null) {
                        this.mediaManagerLs.onFailed((PlayerAttribute)this.playerAttribute, msg.what, msg.arg1);
                    }
                }
                return 0;
            }
            case 5516: {
                this.setPlayState(2);
                break;
            }
            case 5517: {
                this.setPlayState(0);
                byte[] wh = new byte[8];
                ATTR_WITH_HEITH _WH = new ATTR_WITH_HEITH();
                FunSDK.GetAttr((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)10008, (byte[])wh);
                G.BytesToObj((Object)_WH, (byte[])wh);
                if (_WH.st_0_width == 0 || _WH.st_1_height == 0) break;
                ((PlayerAttribute)this.playerAttribute).setVideoWidth(_WH.st_0_width);
                ((PlayerAttribute)this.playerAttribute).setVideoHeight(_WH.st_1_height);
                ((PlayerAttribute)this.playerAttribute).setVideoScale((float)_WH.st_0_width / (float)_WH.st_1_height);
                SDK_FishEyeFrame sdkFishEyeFrame = FishEyeParamsCache.getInstance().getFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel());
                if (sdkFishEyeFrame instanceof SDK_TwoLensesInOne) {
                    if (((PlayerAttribute)this.playerAttribute).getVideoScale() <= 1.0f && ((SDK_TwoLensesInOne)sdkFishEyeFrame).st_0_spliceDirection == 0 || ((PlayerAttribute)this.playerAttribute).getVideoScale() >= 1.0f && ((SDK_TwoLensesInOne)sdkFishEyeFrame).st_0_spliceDirection == 1) {
                        SDK_TwoLensesInOne sdkTwoLensesInOne = new SDK_TwoLensesInOne();
                        sdkTwoLensesInOne.setWidth((int)((PlayerAttribute)this.playerAttribute).getVideoWidth());
                        sdkTwoLensesInOne.setHeight((int)((PlayerAttribute)this.playerAttribute).getVideoHeight());
                        sdkTwoLensesInOne.st_0_spliceDirection = ((SDK_TwoLensesInOne)sdkFishEyeFrame).st_0_spliceDirection;
                        this.onFishFrame(sdkTwoLensesInOne, 5);
                    } else {
                        SDK_FishEyeFrameSW fp = new SDK_FishEyeFrameSW();
                        fp.st_1_lensType = 0;
                        FishEyeParamsCache.getInstance().setFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel(), null);
                        this.detectPrivateFrameData((SDK_FishEyeFrame)fp);
                    }
                }
                this.changeVideoRatio();
                if (this.mediaManagerLs == null) break;
                this.mediaManagerLs.onVideoBufferEnd((PlayerAttribute)this.playerAttribute, ex);
                break;
            }
            case 5508: {
                if (msg.arg1 == -11301) {
                    this.stopPlay();
                    if (this.mediaManagerLs == null) break;
                    this.mediaManagerLs.onFailed((PlayerAttribute)this.playerAttribute, msg.what, msg.arg1);
                    break;
                }
                String[] str = ex.str.split(";");
                if (str.length < 2) break;
                String time = str[0];
                boolean isShowTime = false;
                SDK_FishEyeFrame fishLensParam = FishEyeParamsCache.getInstance().getFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel());
                if (fishLensParam != null) {
                    isShowTime = true;
                }
                String rateValue = str[1].substring(str[1].indexOf("=") + 1);
                if (this.mediaManagerLs == null) break;
                this.mediaManagerLs.onShowRateAndTime((PlayerAttribute)this.playerAttribute, isShowTime, time, Long.parseLong(rateValue));
                break;
            }
            case 5503: {
                if (msg.arg2 != 2) break;
                this.setPlayState(1);
                break;
            }
            case 5514: {
                this.setPlayState(7);
                break;
            }
            case 5502: {
                break;
            }
            case 5509: {
                this.stopPlay();
                break;
            }
            case 5526: 
            case 5548: {
                FishEyeCorrectManager.getInstance(this).fishEyeCorrect(((PlayerAttribute)this.playerAttribute).getDevId(), ex.pData, msg.arg2);
                break;
            }
            case 5513: {
                this.setPlayState(8);
                break;
            }
            case 5507: {
                if (ex.seq == -1) break;
                if (this.isSaveImageToSysAlbum && ex.str != null && ex.str.endsWith(".jpg") && this.surfaceView != null) {
                    MediaUtils.getInstance(this.surfaceView.getContext()).saveImage(ex.str);
                }
                if (this.mediaManagerLs == null) break;
                this.mediaManagerLs.onMediaPlayState((PlayerAttribute)this.playerAttribute, 19);
                break;
            }
            case 5505: {
                break;
            }
            case 5506: {
                if (this.surfaceView != null && this.surfaceView.getContext() != null) {
                    this.surfaceView.getContext().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + msg.arg1))));
                }
                if (this.mediaManagerLs == null) break;
                this.mediaManagerLs.onMediaPlayState((PlayerAttribute)this.playerAttribute, 18);
                break;
            }
            case 5524: {
                if (!(this.mediaManagerLs instanceof OnMediaManagerYUVListener)) break;
                ((OnMediaManagerYUVListener)this.mediaManagerLs).onResultYUVData((PlayerAttribute)this.playerAttribute, msg.arg2, ex.arg3, ex.pData);
                break;
            }
            case 5533: {
                if (this.mediaManagerLs instanceof OnMediaOriginalDataListener) {
                    ((OnMediaOriginalDataListener)this.mediaManagerLs).onOrignalData((PlayerAttribute)this.playerAttribute, msg.arg2, ex.arg3, ex.pData, msg.arg1, ex.str);
                    break;
                }
                if (!(this.mediaManagerLs instanceof OnRecordOriginalDataListener)) break;
                ((OnRecordOriginalDataListener)this.mediaManagerLs).onOrignalData((PlayerAttribute)this.playerAttribute, msg.arg2, ex.arg3, ex.pData, msg.arg1, ex.str);
                break;
            }
            case 5525: {
                if (this.mediaManagerLs == null) break;
                this.mediaManagerLs.onMediaPlayState((PlayerAttribute)this.playerAttribute, 15);
                break;
            }
        }
        return 0;
    }

    private void changeVideoRatio() {
        if (this.surfaceView == null) {
            return;
        }
        if (((PlayerAttribute)this.playerAttribute).isVideoFullScreen()) {
            ViewGroup.LayoutParams layoutParams = this.surfaceView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = -1;
                layoutParams.height = -1;
                this.surfaceView.setLayoutParams(layoutParams);
                this.surfaceView.requestLayout();
            }
        } else {
            this.changeVideoRatio(((PlayerAttribute)this.playerAttribute).getVideoScale());
        }
    }

    public boolean isUHD() {
        return ((PlayerAttribute)this.playerAttribute).getVideoWidth() * ((PlayerAttribute)this.playerAttribute).getVideoHeight() > 2073600.0f;
    }

    public void changeVideoSize(int width, int height) {
        if (this.surfaceView != null) {
            ViewGroup.LayoutParams params = this.surfaceView.getLayoutParams();
            params.width = width;
            params.height = height;
            this.surfaceView.setLayoutParams(params);
            this.surfaceView.requestLayout();
        }
    }

    public void changeVideoRatio(float ratio, int width) {
        if (ratio > 0.0f) {
            int height = (int)((float)width / ratio);
            this.changeVideoSize(width, height);
        }
    }

    public void changeVideoRatio(float ratio) {
        if (this.playView == null || ratio <= 0.0f) {
            return;
        }
        int width = this.playView.getWidth();
        int height = this.playView.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        float _ratio = (float)width * 1.0f / ((float)height * 1.0f);
        if (_ratio > ratio) {
            width = (int)((float)height * ratio);
        } else {
            height = (int)((float)width / ratio);
        }
        this.changeVideoSize(width, height);
    }

    public float getVideoScale() {
        return ((PlayerAttribute)this.playerAttribute).getVideoScale();
    }

    @Override
    public void onFishFrame(SDK_FishEyeFrame fishEyeFrame, int videoMode) {
        if (videoMode != 0) {
            ((PlayerAttribute)this.playerAttribute).setVideoMode(videoMode);
        }
        if (fishEyeFrame != null) {
            if (!(fishEyeFrame instanceof MultiLensParam)) {
                SDK_FishEyeFrame oldFishFrame = FishEyeParamsCache.getInstance().getFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel());
                if (fishEyeFrame instanceof SDK_TwoLensesInOne) {
                    if (((PlayerAttribute)this.playerAttribute).getVideoWidth() > 0.0f && ((SDK_TwoLensesInOne)fishEyeFrame).getWidth() > 0 && ((SDK_TwoLensesInOne)fishEyeFrame).getWidth() != (int)((PlayerAttribute)this.playerAttribute).getVideoWidth()) {
                        ((PlayerAttribute)this.playerAttribute).setVideoWidth(((SDK_TwoLensesInOne)fishEyeFrame).getWidth());
                    }
                    if (((PlayerAttribute)this.playerAttribute).getVideoHeight() > 0.0f && ((SDK_TwoLensesInOne)fishEyeFrame).getHeight() > 0 && ((SDK_TwoLensesInOne)fishEyeFrame).getHeight() != (int)((PlayerAttribute)this.playerAttribute).getVideoHeight()) {
                        ((PlayerAttribute)this.playerAttribute).setVideoHeight(((SDK_TwoLensesInOne)fishEyeFrame).getHeight());
                    }
                    ((PlayerAttribute)this.playerAttribute).setVideoScale(((PlayerAttribute)this.playerAttribute).getVideoWidth() / ((PlayerAttribute)this.playerAttribute).getVideoHeight());
                    if (((SDK_TwoLensesInOne)fishEyeFrame).st_0_spliceDirection == -1) {
                        FishEyeParamsCache.getInstance().setFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel(), null);
                        if (this.isNeedCorrectFishEye()) {
                            this.detectPrivateFrameData(fishEyeFrame);
                        }
                        if (this.onFrameInfoListener != null) {
                            this.onFrameInfoListener.onFrameInfo((PlayerAttribute)this.playerAttribute, fishEyeFrame);
                        }
                        return;
                    }
                    if (null == oldFishFrame || !oldFishFrame.equals((Object)fishEyeFrame) || !(this instanceof MonitorManager)) {
                        if (((SDK_TwoLensesInOne)fishEyeFrame).getWidth() == 0) {
                            ((SDK_TwoLensesInOne)fishEyeFrame).setWidth((int)((PlayerAttribute)this.playerAttribute).getVideoWidth());
                        }
                        if (((SDK_TwoLensesInOne)fishEyeFrame).getHeight() == 0) {
                            ((SDK_TwoLensesInOne)fishEyeFrame).setHeight((int)((PlayerAttribute)this.playerAttribute).getVideoHeight());
                        }
                        if (this.isNeedCorrectFishEye()) {
                            this.detectPrivateFrameData(fishEyeFrame);
                        }
                        FishEyeParams currentFishEyeParams = new FishEyeParams(fishEyeFrame);
                        if (this.surfaceView != null && (this.fishEyeParams.getVidType() != currentFishEyeParams.getVidType() || this.fishEyeParams.getSpliceDirection() != currentFishEyeParams.getSpliceDirection())) {
                            ((PlayerAttribute)this.playerAttribute).setVideoMode(5);
                            int videoWidth = ((SDK_TwoLensesInOne)fishEyeFrame).getWidth();
                            int videoHeight = ((SDK_TwoLensesInOne)fishEyeFrame).getHeight();
                            if (((SDK_TwoLensesInOne)fishEyeFrame).st_0_spliceDirection == 0) {
                                ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(1);
                                ((VRSoftGLView)this.surfaceView).setParams(videoWidth / 2, videoHeight / 2, videoHeight / 2, videoWidth, videoHeight / 2);
                            } else if (((SDK_TwoLensesInOne)fishEyeFrame).st_0_spliceDirection == 1) {
                                ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(4);
                                ((VRSoftGLView)this.surfaceView).setParams(videoWidth / 2, videoHeight / 2, videoHeight / 2, videoWidth / 2, videoHeight);
                            }
                            LogUtils.debugInfo("[APP_FISH_EYE->]", "\u53cc\u76ee\u77eb\u6b63:[videoWidth:" + videoWidth + "][videoHeight:" + videoHeight + "][direction:" + ((SDK_TwoLensesInOne)fishEyeFrame).st_0_spliceDirection);
                        }
                        FishEyeParamsCache.getInstance().setFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel(), fishEyeFrame);
                    }
                } else {
                    if (null == oldFishFrame || !oldFishFrame.equals((Object)fishEyeFrame)) {
                        FishEyeParamsCache.getInstance().setFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel(), fishEyeFrame);
                    }
                    if (this.isNeedCorrectFishEye()) {
                        this.detectPrivateFrameData(fishEyeFrame);
                    }
                }
            }
            if (this.onFrameInfoListener != null) {
                this.onFrameInfoListener.onFrameInfo((PlayerAttribute)this.playerAttribute, fishEyeFrame);
            }
        }
    }

    public boolean isNeedCorrectFishEye() {
        return this.isNeedCorrectFishEye;
    }

    public void setNeedCorrectFishEye(boolean needCorrectFishEye) {
        this.isNeedCorrectFishEye = needCorrectFishEye;
    }

    protected void detectPrivateFrameData(SDK_FishEyeFrame fishLensParam) {
        try {
            this.updateFishEyeParams(new FishEyeParams(fishLensParam));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean updateFishEyeParams(FishEyeParams params) {
        if (this.fishEyeParams != null && this.fishEyeParams.equals(params)) {
            return false;
        }
        if (null != this.playerAttribute && this.surfaceView != null) {
            boolean needSwitchView;
            boolean bl = needSwitchView = !params.isSurfaceViewMatched(this.surfaceView);
            if (needSwitchView) {
                FunSDK.SetIntAttr((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)10015, (int)0);
                this.destroySurfaceView();
                this.setFishEyeParams(params);
                FunSDK.MediaSetPlayView((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (Object)this.surfaceView, (int)0);
                FunSDK.SetIntAttr((int)((PlayerAttribute)this.playerAttribute).getPlayHandle(), (int)10015, (int)1);
            } else {
                this.setFishEyeParams(params);
            }
            return true;
        }
        return false;
    }

    private void setFishEyeParams(FishEyeParams param) {
        if (this.playView == null) {
            return;
        }
        if (!this.fishEyeParams.equals(param)) {
            this.fishEyeParams = param;
            if (null == this.surfaceView || this.mIsPlayViewDestroy) {
                this.createSurfaceView();
            } else {
                this.updateFEParamsSurfaceView(param);
            }
        }
    }

    private boolean updateFEParamsSurfaceView(FishEyeParams params) {
        if (this.surfaceView instanceof GL2JNIView) {
            FecCenter fecCenter = null;
            if (params.hasOffset()) {
                fecCenter = new FecCenter(params.imageWidth, params.imageHeight, params.xCenter, params.yCenter, params.radius);
            }
            if (params.getVidType() == FishEyeVidType.GENERAL_180VR) {
                ((GL2JNIView)this.surfaceView).setFecParams(GL2JNIView.FecType.GENERAL_180VR, fecCenter);
            } else if (params.getVidType() == FishEyeVidType.GENERAL_360VR) {
                ((GL2JNIView)this.surfaceView).setFecParams(GL2JNIView.FecType.GENERAL_360VR, fecCenter);
            } else if (params.getVidType() == FishEyeVidType.FISHEYE_360VR || params.getVidType() == FishEyeVidType.FISHEYE_180VR) {
                ((GL2JNIView)this.surfaceView).setFecParams(GL2JNIView.FecType.FISHEYE_360VR, fecCenter);
            } else {
                ((GL2JNIView)this.surfaceView).setFecParams(GL2JNIView.FecType.NO_DEWARP, fecCenter);
            }
            return true;
        }
        if (this.surfaceView instanceof VRSoftGLView) {
            FecCenter fecCenter = null;
            if (params.hasOffset()) {
                fecCenter = new FecCenter(params.imageWidth, params.imageHeight, params.xCenter, params.yCenter, params.radius);
            }
            if (params.getVidType() == FishEyeVidType.GENERAL_180VR) {
                ((VRSoftGLView)this.surfaceView).setType(1);
                ((VRSoftGLView)this.surfaceView).setFecParams(GL2JNIView.FecType.GENERAL_180VR, fecCenter);
            } else if (params.getVidType() == FishEyeVidType.GENERAL_360VR) {
                ((VRSoftGLView)this.surfaceView).setType(0);
                ((VRSoftGLView)this.surfaceView).setFecParams(GL2JNIView.FecType.GENERAL_360VR, fecCenter);
            } else if (params.getVidType() == FishEyeVidType.GENERAL_DISTORTION) {
                ((VRSoftGLView)this.surfaceView).setType(3);
            } else if (params.getVidType() == FishEyeVidType.TWO_LENSES_IN_ONE) {
                int videoWidth = params.getImageWidth();
                int videoHeight = params.getImageHeight();
                if (params.getSpliceDirection() == 0) {
                    ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(1);
                    ((VRSoftGLView)this.surfaceView).setParams(videoWidth / 2, videoHeight / 2, videoHeight / 2, videoWidth, videoHeight / 2);
                } else if (params.getSpliceDirection() == 1) {
                    ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(4);
                    ((VRSoftGLView)this.surfaceView).setParams(videoWidth / 2, videoHeight / 2, videoHeight / 2, videoWidth / 2, videoHeight);
                }
                LogUtils.debugInfo("[APP_FISH_EYE->]", "\u53cc\u76ee\u5e03\u5c40\u66f4\u6b63:[videoWidth:" + videoWidth + "][videoHeight:" + videoHeight + "][direction:" + params.getSpliceDirection());
            }
            return true;
        }
        return false;
    }

    public void setVRSoftShapeType(int type) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setType(type);
        }
    }

    public int getVRSoftShapeType() {
        if (this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).getType();
        }
        return -1;
    }

    @Override
    public void setTwoLensesScreen(int screen) {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setTwoLensesScreen(screen);
        }
    }

    @Override
    public int getTwoLensesScreen() {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).getTwoLensesScreen();
        }
        return -1;
    }

    public void setOnZoomListener(Object ls) {
        this.mOnZoomLs = ls;
        if (null != this.surfaceView) {
            if (this.surfaceView instanceof GLSurfaceView20) {
                ((GLSurfaceView20)this.surfaceView).setOnPlayViewTouchListener((OnPlayViewTouchListener)ls);
            } else if (this.surfaceView instanceof VRSoftGLView) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)ls);
            }
        }
    }

    @Override
    public SurfaceView getSurfaceView() {
        if (this.surfaceView == null || this.mIsPlayViewDestroy) {
            this.createSurfaceView();
        }
        return this.surfaceView;
    }

    private void createSurfaceView() {
        SDK_FishEyeFrame sdk_fishEyeFrame;
        if (this instanceof MonitorManager && (sdk_fishEyeFrame = FishEyeParamsCache.getInstance().getFishFrame(((PlayerAttribute)this.playerAttribute).getDevId() + ((PlayerAttribute)this.playerAttribute).getChnnel())) instanceof SDK_TwoLensesInOne) {
            ((PlayerAttribute)this.playerAttribute).setVideoMode(5);
            this.fishEyeParams = new FishEyeParams(sdk_fishEyeFrame);
            if (((PlayerAttribute)this.playerAttribute).getVideoWidth() == 0.0f) {
                ((PlayerAttribute)this.playerAttribute).setVideoWidth(((SDK_TwoLensesInOne)sdk_fishEyeFrame).getWidth());
            }
            if (((PlayerAttribute)this.playerAttribute).getVideoHeight() == 0.0f) {
                ((PlayerAttribute)this.playerAttribute).setVideoHeight(((SDK_TwoLensesInOne)sdk_fishEyeFrame).getHeight());
            }
        }
        if (null == this.fishEyeParams || this.fishEyeParams.getVidType() == FishEyeVidType.UNSTEED || this.fishEyeParams.getSpliceDirection() == -1) {
            this.createSurfaceView(FishEyeVidType.GENERAL_VIDEO);
        } else {
            this.createSurfaceView(this.fishEyeParams.getVidType());
            this.initFishCtrlLayout();
        }
    }

    private void createSurfaceView(FishEyeVidType type) {
        if (this.playView == null) {
            return;
        }
        if (this.surfaceView != null || this.mIsPlayViewDestroy) {
            this.cleanUpSurfaceView();
            this.playView.removeView((View)this.surfaceView);
            this.surfaceView = null;
        }
        this.mIsPlayViewDestroy = false;
        if (type == FishEyeVidType.GENERAL_VIDEO) {
            this.surfaceView = new GLSurfaceView20(this.playView.getContext());
            if (this.simpleOnGestureListener != null) {
                this.gestureDetectorCompat = new GestureDetectorCompat(this.playView.getContext(), (GestureDetector.OnGestureListener)this.simpleOnGestureListener);
            }
            ((GLSurfaceView20)this.surfaceView).setOnPlayViewTouchListener(this.onPlayViewTouchListener);
            ((GLSurfaceView20)this.surfaceView).setGestureListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (MediaManager.this.gestureDetectorCompat != null) {
                        MediaManager.this.gestureDetectorCompat.onTouchEvent(event);
                    }
                    return false;
                }
            });
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof OnPlayViewTouchListener) {
                ((GLSurfaceView20)this.surfaceView).setOnPlayViewTouchListener((OnPlayViewTouchListener)this.mOnZoomLs);
            }
            this.setVideoFlip(this.flipType);
        } else if (type == FishEyeVidType.GENERAL_180VR || type == FishEyeVidType.GENERAL_360VR) {
            this.surfaceView = new VRSoftGLView(this.playView.getContext());
            ((VRSoftGLView)this.surfaceView).setmGestureListener((GestureDetector.OnGestureListener)this.simpleOnGestureListener);
            this.updateFEParamsSurfaceView(this.fishEyeParams);
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof VRSoftGLView.OnVRSoftZoomListener) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)this.mOnZoomLs);
            }
        } else if (type == FishEyeVidType.GENERAL_DISTORTION) {
            this.surfaceView = new VRSoftGLView(this.playView.getContext());
            ((VRSoftGLView)this.surfaceView).setType(3);
            ((VRSoftGLView)this.surfaceView).setmGestureListener((GestureDetector.OnGestureListener)this.simpleOnGestureListener);
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof VRSoftGLView.OnVRSoftZoomListener) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)this.mOnZoomLs);
            }
        } else if (type == FishEyeVidType.SINGLE_PIP) {
            this.surfaceView = new VRSoftGLView(this.playView.getContext());
            ((VRSoftGLView)this.surfaceView).setmGestureListener((GestureDetector.OnGestureListener)this.simpleOnGestureListener);
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof VRSoftGLView.OnVRSoftZoomListener) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)this.mOnZoomLs);
            }
        } else if (type == FishEyeVidType.TWO_LENSES_IN_ONE) {
            this.surfaceView = new VRSoftGLView(this.playView.getContext());
            if (((PlayerAttribute)this.playerAttribute).getVideoWidth() == 0.0f) {
                ((PlayerAttribute)this.playerAttribute).setVideoWidth(this.fishEyeParams.getImageWidth());
            }
            if (((PlayerAttribute)this.playerAttribute).getVideoHeight() == 0.0f) {
                ((PlayerAttribute)this.playerAttribute).setVideoHeight(this.fishEyeParams.getImageHeight());
            }
            ((PlayerAttribute)this.playerAttribute).setVideoScale(((PlayerAttribute)this.playerAttribute).getVideoWidth() / ((PlayerAttribute)this.playerAttribute).getVideoHeight());
            ((VRSoftGLView)this.surfaceView).setType(24);
            if (this.fishEyeParams.getSpliceDirection() == 0) {
                ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(1);
                ((VRSoftGLView)this.surfaceView).setParams((int)((PlayerAttribute)this.playerAttribute).getVideoWidth() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoHeight() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoHeight() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoWidth(), (int)((PlayerAttribute)this.playerAttribute).getVideoHeight() / 2);
            } else if (this.fishEyeParams.getSpliceDirection() == 1) {
                ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(4);
                ((VRSoftGLView)this.surfaceView).setParams((int)((PlayerAttribute)this.playerAttribute).getVideoWidth() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoHeight() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoHeight() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoWidth() / 2, (int)((PlayerAttribute)this.playerAttribute).getVideoHeight());
            }
            LogUtils.debugInfo("[APP_FISH_EYE->]", "\u53cc\u76ee\u521d\u59cb\u5316:[videoWidth:" + ((PlayerAttribute)this.playerAttribute).getVideoWidth() + "][videoHeight:" + ((PlayerAttribute)this.playerAttribute).getVideoHeight() + "][direction:" + this.fishEyeParams.getSpliceDirection());
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof VRSoftGLView.OnVRSoftZoomListener) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)this.mOnZoomLs);
            }
        } else if (type == FishEyeVidType.PIP_TWO_IN_ONE) {
            this.surfaceView = new VRSoftGLView(this.playView.getContext());
            ((VRSoftGLView)this.surfaceView).setType(24);
            ((VRSoftGLView)this.surfaceView).setmGestureListener((GestureDetector.OnGestureListener)this.simpleOnGestureListener);
            if (null != this.mOnZoomLs && this.mOnZoomLs instanceof VRSoftGLView.OnVRSoftZoomListener) {
                ((VRSoftGLView)this.surfaceView).setOnZoomListener((VRSoftGLView.OnVRSoftZoomListener)this.mOnZoomLs);
            }
        } else {
            this.surfaceView = new GL2JNIView(this.playView.getContext());
            this.updateFEParamsSurfaceView(this.fishEyeParams);
        }
        int count = this.playView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.playView.getChildAt(i);
            if (!(view instanceof SurfaceView)) continue;
            this.playView.removeView(view);
            break;
        }
        if (this.playView instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.addRule(13);
            this.playView.addView((View)this.surfaceView, 0, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.playView instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
            layoutParams.gravity = 17;
            this.playView.addView((View)this.surfaceView, 0, (ViewGroup.LayoutParams)layoutParams);
        } else if (this.playView instanceof LinearLayout) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
            layoutParams.gravity = 17;
            this.playView.addView((View)this.surfaceView, 0, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.playView.addView((View)this.surfaceView, 0);
        }
        this.createFunInPlayView();
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setTouchable(this.mIsTouchable);
        } else if (this.surfaceView instanceof GLSurfaceView20) {
            ((GLSurfaceView20)this.surfaceView).setTouchable(this.mIsTouchable);
            ((GLSurfaceView20)this.surfaceView).setZOrderOnTop(this.mIsZOrderOnTop);
            ((GLSurfaceView20)this.surfaceView).setZOrderMediaOverlay(this.mIsZOrderMediaOverlay);
        }
    }

    public void createFunInPlayView() {
        if (this.playView == null) {
            LogUtils.debugInfo("[APP_UI_ERROR]->", "createFunInPlayView error,playView is Null");
            return;
        }
        if (this.rlPlayFunLayout != null) {
            this.playView.removeView((View)this.rlPlayFunLayout);
        }
        this.rlPlayFunLayout = new RelativeLayout(this.playView.getContext());
        this.tvPlayStateTips = new TextView(this.playView.getContext());
        this.tvPlayStateTips.setBackgroundResource(R.color.wnd_cover_gray);
        this.tvPlayStateTips.setTextColor(-1);
        this.tvPlayStateTips.setVisibility(8);
        this.ivPlayState = new ImageView(this.playView.getContext());
        this.ivPlayState.setImageResource(R.drawable.icon_play);
        this.ivPlayState.setVisibility(8);
        this.ivPlayState.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MediaManager.this.mediaManagerLs != null) {
                    MediaManager.this.mediaManagerLs.onPlayStateClick(v);
                }
            }
        });
        this.pbWaiting = new ProgressBar(this.playView.getContext());
        this.pbWaiting.setIndeterminateDrawable(this.playView.getContext().getResources().getDrawable(R.drawable.progressbar_circle));
        this.pbWaiting.setVisibility(8);
        RelativeLayout.LayoutParams playStateLp = new RelativeLayout.LayoutParams(-2, -2);
        playStateLp.addRule(13);
        RelativeLayout.LayoutParams playStateBig = new RelativeLayout.LayoutParams(UIUtils.dp2px((Context)this.playView.getContext(), (float)this.bigBtnSize), UIUtils.dp2px((Context)this.playView.getContext(), (float)this.bigBtnSize));
        playStateBig.addRule(13);
        this.rlPlayFunLayout.addView((View)this.tvPlayStateTips, (ViewGroup.LayoutParams)playStateLp);
        this.rlPlayFunLayout.addView((View)this.ivPlayState, (ViewGroup.LayoutParams)(this.addBigIvState ? playStateBig : playStateLp));
        this.rlPlayFunLayout.addView((View)this.pbWaiting, (ViewGroup.LayoutParams)playStateLp);
        this.playView.addView((View)this.rlPlayFunLayout, new ViewGroup.LayoutParams(-1, -1));
    }

    public void setIvPlayStateButtonSize(int size) {
        if (this.playView != null && this.ivPlayState != null) {
            RelativeLayout.LayoutParams playStateBig = new RelativeLayout.LayoutParams(UIUtils.dp2px((Context)this.playView.getContext(), (float)size), UIUtils.dp2px((Context)this.playView.getContext(), (float)size));
            this.setBigBtnCfg(true, size);
            playStateBig.addRule(13);
            if (this.rlPlayFunLayout != null && this.ivPlayState != null) {
                this.rlPlayFunLayout.removeView((View)this.ivPlayState);
                this.rlPlayFunLayout.addView((View)this.ivPlayState, (ViewGroup.LayoutParams)playStateBig);
            }
        }
    }

    public void setPlayState(int playState) {
        System.out.println("playState:" + playState);
        if (((PlayerAttribute)this.playerAttribute).getPlayState() == playState) {
            return;
        }
        switch (playState) {
            case 24: {
                this.setPlayStateTipsShow(true);
                this.setPlayWaitingShow(true);
                this.setPlayStateViewShow(false);
                this.startBufferWaiting(this.getString(R.string.libfunsdk_device_wake_up));
                break;
            }
            case 28: {
                this.setPlayStateTipsShow(true);
                this.setPlayStateViewShow(false);
                this.startBufferWaiting(this.getString(R.string.libfunsdk_device_connect_media_waiting));
                break;
            }
            case 2: 
            case 7: {
                this.setPlayStateTipsShow(true);
                this.setPlayWaitingShow(true);
                this.setPlayStateViewShow(false);
                this.startBufferWaiting(this.getString(R.string.libfunsdk_device_video_buffer_waiting));
                break;
            }
            case 0: {
                this.stopBufferWaiting();
                this.setPlayStateTipsShow(false);
                this.setPlayWaitingShow(false);
                this.setPlayStateViewShow(false);
                break;
            }
            case 6: {
                this.stopBufferWaiting();
                this.setPlayStateViewShow(false);
                if (this.tvPlayStateTips == null) break;
                this.tvPlayStateTips.setText(R.string.libfunsdk_state_can_not_play);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: {
                this.stopBufferWaiting();
                this.setPlayStateTipsShow(false);
                this.setPlayWaitingShow(false);
                this.setPlayStateViewShow(true);
                break;
            }
            case 8: {
                if (this.mediaManagerLs != null) {
                    this.mediaManagerLs.onMediaPlayState((PlayerAttribute)this.playerAttribute, playState);
                }
                return;
            }
        }
        ((PlayerAttribute)this.playerAttribute).setPlayState(playState);
        if (this.mediaManagerLs != null) {
            this.mediaManagerLs.onMediaPlayState((PlayerAttribute)this.playerAttribute, playState);
        }
    }

    private String getString(int resId) {
        if (this.playView != null) {
            return this.playView.getContext().getString(resId);
        }
        return "";
    }

    private void setPlayStateViewShow(boolean isShow) {
        if (this.ivPlayState != null) {
            this.ivPlayState.setVisibility(this.isPlayStateShow && isShow ? 0 : 8);
        }
    }

    public void setBtnPlayVisible(boolean isVisible) {
        this.isPlayStateShow = false;
        this.setPlayStateViewShow(false);
    }

    private void setPlayStateTipsShow(boolean isShow) {
        if (!this.isPlayStateTipsEnable) {
            return;
        }
        if (this.tvPlayStateTips != null) {
            boolean isVisible;
            boolean bl = isVisible = this.tvPlayStateTips.getVisibility() == 0;
            if (isShow != isVisible) {
                this.tvPlayStateTips.setVisibility(isShow ? 0 : 8);
                this.tvPlayStateTips.requestLayout();
            }
        }
    }

    private void setPlayWaitingShow(boolean isShow) {
        if (this.isPlayStateTipsEnable) {
            return;
        }
        if (this.pbWaiting != null) {
            boolean isVisible;
            boolean bl = isVisible = this.pbWaiting.getVisibility() == 0;
            if (isShow != isVisible) {
                this.pbWaiting.setVisibility(isShow ? 0 : 8);
            }
        }
    }

    private void changePlayStateTips() {
        if (this.tvPlayStateTips != null) {
            this.tvPlayStateTips.setText((CharSequence)(this.bufferWaitingTips + this.bufferWaitingProgress + "%"));
        }
    }

    private void startRecordClipTiming() {
        this.stopRecordClipTiming();
        this.cutCountdown = new CutCountdown();
        this.cutService = Executors.newScheduledThreadPool(10);
        this.cutService.scheduleAtFixedRate(this.cutCountdown, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.recordClipTimeCount = 0;
    }

    private void stopRecordClipTiming() {
        if (this.cutCountdown != null && this.cutService != null) {
            this.cutService.shutdown();
            this.cutService = null;
            this.cutService = null;
            this.recordClipTimeCount = 0;
        }
    }

    public void setOnRecordClipTimingListener(OnRecordClipTimingListener listener) {
        this.recordClipTimingListener = listener;
    }

    public void setOnPlayViewTouchListener(OnPlayViewTouchListener onPlayViewTouchListener) {
        this.onPlayViewTouchListener = onPlayViewTouchListener;
    }

    public void setVRSoftGLViewTouchEvent(MotionEvent event) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).onTouchEvent(event);
        }
    }

    @Override
    public void setVideoFlip(int flipType) {
        this.flipType = flipType;
        if (this.surfaceView instanceof GLSurfaceView20) {
            GLSurfaceView20 glSurfaceView20 = (GLSurfaceView20)this.surfaceView;
            if (this.flipType == 0) {
                glSurfaceView20.set90DegreeFlip(false);
                glSurfaceView20.setVerticalFlip(false);
            } else if (this.flipType == 1) {
                glSurfaceView20.set90DegreeFlip(true);
                glSurfaceView20.setVerticalFlip(false);
            } else if (this.flipType == 2) {
                glSurfaceView20.set90DegreeFlip(true);
                glSurfaceView20.setVerticalFlip(true);
            } else if (this.flipType == 3) {
                glSurfaceView20.set90DegreeFlip(true);
                glSurfaceView20.setVerticalFlip(true);
            }
        }
    }

    private void startBufferWaiting(String tips) {
        if (StringUtils.contrast(this.bufferWaitingTips, tips)) {
            return;
        }
        this.stopBufferWaiting();
        this.bufferWaitingTips = tips;
        this.bufferWaitingCountdown = new BufferWaitingCountdown();
        this.bufferWaitingService = Executors.newScheduledThreadPool(10);
        this.bufferWaitingService.scheduleAtFixedRate(this.bufferWaitingCountdown, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private void stopBufferWaiting() {
        if (this.bufferWaitingCountdown != null && this.bufferWaitingService != null) {
            this.bufferWaitingService.shutdown();
            this.bufferWaitingService = null;
            this.bufferWaitingCountdown = null;
        }
        this.bufferWaitingTips = "";
        this.bufferWaitingProgress = 0;
    }

    @Override
    public void setPlayStateTipsEnable(boolean isEnable) {
        this.isPlayStateTipsEnable = isEnable;
    }

    @Override
    public void setTwoLensesDrawMode(int drawMode) {
        if (this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setTwoLensesDrawMode(drawMode);
        }
    }

    public void setLogicZoom(double zoomMin, double zoomMax, double zoomDiv, double zoomValue) {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setLogicZoom(zoomMin, zoomMax, zoomDiv, zoomValue);
        }
    }

    public float getLogicZoom(double zoomMin, double zoomMax) {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            return ((VRSoftGLView)this.surfaceView).getLogicZoom(zoomMin, zoomMax);
        }
        return 1.0f;
    }

    public void setFecParam(int xCenter, int yCenter, int radius, int imageWidth, int imageHeight) {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            ((VRSoftGLView)this.surfaceView).setParams(xCenter, yCenter, radius, imageWidth, imageHeight);
        }
    }

    public void setVRSoftTouchListener(View.OnTouchListener onTouchListener) {
        if (this.surfaceView != null && this.surfaceView instanceof VRSoftGLView) {
            this.surfaceView.setOnTouchListener(onTouchListener);
        }
    }

    public static interface OnRecordOriginalDataListener
    extends OnRecordManagerListener {
        public void onOrignalData(PlayerAttribute var1, int var2, int var3, byte[] var4, int var5, String var6);
    }

    public static interface OnRecordManagerListener
    extends OnMediaManagerListener {
        public void searchResult(PlayerAttribute var1, Object var2);
    }

    public static interface OnFrameInfoListener {
        public void onFrameInfo(PlayerAttribute var1, SDK_FishEyeFrame var2);
    }

    public static interface OnMediaManagerYUVListener
    extends OnMediaManagerListener {
        public void onResultYUVData(PlayerAttribute var1, int var2, int var3, byte[] var4);
    }

    public static interface OnSaveRealStreamDataListener
    extends OnMediaManagerListener {
        public void onStartSave();

        public void onSaveFileSize(int var1);
    }

    public static interface OnMediaOriginalDataListener
    extends OnMediaManagerListener {
        public void onOrignalData(PlayerAttribute var1, int var2, int var3, byte[] var4, int var5, String var6);
    }

    public static interface OnMediaManagerExListener
    extends OnMediaManagerListener {
        public void OnFunSDKResult(PlayerAttribute var1, Message var2, MsgContent var3);
    }

    public static interface OnMediaManagerListener {
        public void onMediaPlayState(PlayerAttribute var1, int var2);

        public void onFailed(PlayerAttribute var1, int var2, int var3);

        public void onShowRateAndTime(PlayerAttribute var1, boolean var2, String var3, long var4);

        public void onVideoBufferEnd(PlayerAttribute var1, MsgContent var2);

        public void onPlayStateClick(View var1);
    }

    class BufferWaitingCountdown
    implements Runnable {
        BufferWaitingCountdown() {
        }

        @Override
        public void run() {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (MediaManager.this.bufferWaitingCountdown == null) {
                        MediaManager.this.setPlayStateTipsShow(false);
                        MediaManager.this.setPlayWaitingShow(false);
                        MediaManager.this.setPlayStateViewShow(false);
                        return;
                    }
                    MediaManager.this.bufferWaitingProgress += 2;
                    if (MediaManager.this.bufferWaitingProgress <= 90) {
                        MediaManager.this.changePlayStateTips();
                    } else {
                        MediaManager.this.stopBufferWaiting();
                    }
                }
            });
        }
    }

    public static interface OnRecordClipTimingListener {
        public void onTiming(int var1);
    }

    class CutCountdown
    implements Runnable {
        CutCountdown() {
        }

        @Override
        public void run() {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (MediaManager.this.recordClipTimingListener != null) {
                        MediaManager.this.recordClipTimingListener.onTiming(++MediaManager.this.recordClipTimeCount);
                    }
                }
            });
        }
    }
}

