/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.lib.constant.DevType;
import com.lib.sdk.bean.StringUtils;
import java.util.concurrent.CopyOnWriteArrayList;

public class IdrDefine {
    public static final String SP_K_BUFFERED_END = "IDR_BUFFERED_END";
    public static final String SP_K_IDR_FISH_FRAME = "IDR_FISH_FRAME";
    public static final String SP_K_IDR_LAST_CALL_ID = "IDR_LAST_CALL_ID";
    public static final String SP_K_IDR_POWER = "IDR_SAVE_POWER";
    public static final String SP_K_IDR_CALL_SHOCK = "IDR_CALL_SHOCK";
    public static final String SP_K_IDR_CALL_RING = "IDR_CALL_RING";
    public static final String SP_K_OPEN_CALL_UI = "IDR_OPEN_CALL_VIEW";
    public static final String SP_K_LOW_BATTERY_PUSH = "LOW_BATTERY_PUSH";
    public static final String SP_K_USERNAME = "IDR_USERNAME_RECORD";
    public static final String SP_K_IDR_TALK_MODE = "IDR_TALK_MODE";
    private static final String SP_NAME = "IDR_SP_NAME";
    private static final CopyOnWriteArrayList<String> curPlayDevices = new CopyOnWriteArrayList();
    private static final String[] NotShowCallDevSN = new String[1];

    public static final void clearPlayDevices() {
        curPlayDevices.clear();
    }

    public static final void exitPlayDevices(String sn) {
        if (!TextUtils.isEmpty((CharSequence)sn)) {
            curPlayDevices.remove(sn);
        }
    }

    public static final void addToPlayDevices(String[] devSNs) {
        if (devSNs == null || devSNs.length == 0) {
            return;
        }
        curPlayDevices.clear();
        for (int i = 0; i < devSNs.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)devSNs[i])) continue;
            curPlayDevices.add(devSNs[i]);
        }
    }

    public static final void addToPlayDevices(String devSN) {
        if (!TextUtils.isEmpty((CharSequence)devSN)) {
            if (curPlayDevices.contains(devSN)) {
                return;
            }
            curPlayDevices.add(devSN);
        }
    }

    public static final boolean playDevicesContains(String devSN) {
        if (TextUtils.isEmpty((CharSequence)devSN)) {
            return false;
        }
        return curPlayDevices.contains(devSN);
    }

    public static final boolean isFirstLogin(Context context, String userName) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && !sp.contains(userName);
    }

    public static final boolean putName(Context context, String userName, String ext) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        if (ext == null) {
            ext = "";
        }
        return sp != null && sp.edit().putString(userName, ext).commit();
    }

    public static final SharedPreferences getIDRSharedPreferences(Context context) {
        if (context == null || context.getApplicationContext() == null) {
            return null;
        }
        return context.getApplicationContext().getSharedPreferences(SP_NAME, 0);
    }

    public static final boolean putPower(Context context, String sn, int electable, int level) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putInt(SP_K_IDR_POWER + sn, (electable << 8) + level).commit();
    }

    public static final int getPower(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null ? sp.getInt(SP_K_IDR_POWER + sn, -1) : -1;
    }

    public static final boolean putCallShock(Context context, String sn, boolean isShock) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp.edit().putBoolean(SP_K_IDR_CALL_SHOCK + sn, isShock).commit();
    }

    public static final boolean getCallShock(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.getBoolean(SP_K_IDR_CALL_SHOCK + sn, false);
    }

    public static final int getRing(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null ? sp.getInt(SP_K_IDR_CALL_RING + sn, -1) : -1;
    }

    public static final boolean putRing(Context context, String sn, int pos) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putInt(SP_K_IDR_CALL_RING + sn, pos).commit();
    }

    public static final Long getLastCallID(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null ? sp.getLong(SP_K_IDR_LAST_CALL_ID + sn, -1L) : -1L;
    }

    public static final boolean putLastCallID(Context context, String sn, long alarmID) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putLong(SP_K_IDR_LAST_CALL_ID + sn, alarmID).commit();
    }

    public static final String getFishFrame(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null ? sp.getString(SP_K_IDR_FISH_FRAME + sn, null) : null;
    }

    public static final boolean putFishFrame(Context context, String sn, String frame) {
        if (context == null) {
            return false;
        }
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putString(SP_K_IDR_FISH_FRAME + sn, frame).commit();
    }

    public static final void clearBufferEndState(Context context, String sn) {
        if (context == null) {
            return;
        }
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        if (sp != null) {
            sp.edit().remove(SP_K_BUFFERED_END + sn).commit();
        }
    }

    public static final int getBufferEndState(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        int state = sp != null ? sp.getInt(SP_K_BUFFERED_END + sn, -1) : -1;
        IdrDefine.clearBufferEndState(context, sn);
        return state;
    }

    public static final boolean putBufferEndState(Context context, String sn, int previewHandle) {
        if (context == null) {
            return false;
        }
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putInt(SP_K_BUFFERED_END + sn, previewHandle).commit();
    }

    public static boolean isNotShowCall(String sn) {
        if (NotShowCallDevSN[0] == null) {
            return false;
        }
        return NotShowCallDevSN[0].equals(sn);
    }

    public static void setNotShowCall(String sn) {
        if (!TextUtils.isEmpty((CharSequence)sn)) {
            IdrDefine.NotShowCallDevSN[0] = sn;
        }
    }

    public static void clearNotShowCall() {
        int length = NotShowCallDevSN.length;
        for (int i = 0; i < length; ++i) {
            IdrDefine.NotShowCallDevSN[i] = null;
        }
    }

    public static final boolean putTalkMode(Context context, String sn, boolean isFullDuple) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putBoolean(SP_K_IDR_TALK_MODE + sn, isFullDuple).commit();
    }

    public static final boolean getTalkMode(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.getBoolean(SP_K_IDR_TALK_MODE + sn, false);
    }

    public static final boolean getLowBatteryPush(Context context, String sn) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.getBoolean(SP_K_LOW_BATTERY_PUSH + sn, true);
    }

    public static final boolean putLowBatteryPush(Context context, String sn, boolean isPush) {
        SharedPreferences sp = IdrDefine.getIDRSharedPreferences(context);
        return sp != null && sp.edit().putBoolean(SP_K_LOW_BATTERY_PUSH + sn, isPush).commit();
    }

    public static boolean isIDR(int devType) {
        switch (devType) {
            case 21: 
            case 26: 
            case 285409282: 
            case 286326823: 
            case 0x11110031: 
            case 0x11110033: 
            case 0x11130001: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIDR(String pid) {
        return StringUtils.contrast(DevType.IDR.getPid(), pid) || StringUtils.contrast(DevType.PEEPHOLE.getPid(), pid) || StringUtils.contrast(DevType.DEV_CZ_IDR.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK_V2.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_LOW_POWER.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK_PEEPHOLE.getPid(), pid);
    }

    public static boolean isDoorbell(int devType) {
        switch (devType) {
            case 21: 
            case 26: 
            case 0x11130001: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDoor(int devType) {
        switch (devType) {
            case 286326823: 
            case 0x11110031: 
            case 0x11110033: {
                return true;
            }
        }
        return false;
    }

    public static boolean isShowCallUI(int devType) {
        if (IdrDefine.isIDR(devType)) {
            return true;
        }
        switch (devType) {
            case 286326823: {
                return true;
            }
        }
        return false;
    }
}

