/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.os.Message;
import android.text.TextUtils;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.sdk.bean.idr.BaseRequest;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.idr.IDRManagerCallBack;
import com.manager.device.idr.IDRStateResult;
import com.utils.LogUtils;
import org.greenrobot.eventbus.EventBus;

public class IDRWake
extends BaseRequest {
    public static final int GET_DEV_STATE_FROM_SERVER_ONLY = 1;
    public static final int IDR_AWAKEN = 10000;
    public static final int IDR_WEAK_SUCCESS = 10001;
    public static final int IDR_WEAK_FAILURE = 10002;
    public static final int IDR_NO_WEAK = 10003;
    public static final int IDR_SLEEP = 10004;
    public static final int IDR_LOCAL_UN_WEAK = 10005;
    private int mState = 10003;
    private int wakeHandle;

    public IDRWake(String sn) {
        super(sn);
    }

    public String getSN() {
        return this.mSN;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public boolean wakeUp(IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)this.mSN)) {
            return false;
        }
        if (this.isSending()) {
            return false;
        }
        this.mState = 10000;
        this.mIDRManagerCallBack = IDRManagerCallBack2;
        this.wakeHandle = FunSDK.DevWakeUp((int)this.mID, (String)this.mSN, (int)0);
        System.out.println("DevWakeUp");
        LogUtils.debugInfo("[APP_IDR]->", "send_" + this.mSN);
        return true;
    }

    public boolean wakeUpAndSendCtrl(String jsonData, boolean bDevLogin, IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)this.mSN)) {
            return false;
        }
        if (this.isSending()) {
            return false;
        }
        this.mState = 10000;
        this.mIDRManagerCallBack = IDRManagerCallBack2;
        this.wakeHandle = FunSDK.DevWakeUpExt((int)this.mID, (String)this.mSN, (String)jsonData, (boolean)bDevLogin, (int)0);
        System.out.println("DevWakeUpExt");
        LogUtils.debugInfo("[APP_IDR]->", "send_" + this.mSN);
        return true;
    }

    public void stopWakeUp() {
        if (this.wakeHandle != 0) {
            FunSDK.DestoryObj((int)this.wakeHandle, (int)1);
        }
    }

    public boolean wakeUpDevNeedCheckDevState(IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)this.mSN)) {
            return false;
        }
        FunSDK.SysGetDevState((int)this.mID, (String)this.mSN, (int)Integer.MAX_VALUE);
        return this.wakeUp(IDRManagerCallBack2);
    }

    public boolean getDevStateFromServer(IDRManagerCallBack IDRManagerCallBack2) {
        if (TextUtils.isEmpty((CharSequence)this.mSN)) {
            return false;
        }
        FunSDK.SysGetDevState((int)this.mID, (String)this.mSN, (int)1);
        this.mIDRManagerCallBack = IDRManagerCallBack2;
        return true;
    }

    public void cancelWakeUp() {
        this.mIDRManagerCallBack = null;
        this.mState = 10003;
        LogUtils.debugInfo("[APP_IDR]->", "cancel wake up" + this.mSN);
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.what == 5009) {
            int state = FunSDK.GetDevState((String)this.mSN, (int)8);
            LogUtils.debugInfo("[APP_IDR]->", "get dev state:" + this.mSN + " " + state);
            XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(this.mSN);
            if (xmDevInfo != null) {
                if (state == 1) {
                    xmDevInfo.setDevState(4);
                } else if (state == 2) {
                    xmDevInfo.setDevState(2);
                } else if (state == 3) {
                    xmDevInfo.setDevState(5);
                } else if (state == -1) {
                    xmDevInfo.setDevState(0);
                } else {
                    xmDevInfo.setDevState(1);
                }
            }
            if (ex.seq == 1) {
                this.mState = 10003;
                if (state == 3) {
                    if (null != this.mIDRManagerCallBack) {
                        this.mIDRManagerCallBack.onFail(state);
                    }
                    EventBus.getDefault().post((Object)new IDRStateResult(this.mSN, this.mState));
                } else if (null != this.mIDRManagerCallBack) {
                    this.mIDRManagerCallBack.onSuccess(state);
                }
                this.mIDRManagerCallBack = null;
                return 0;
            }
            if (state == 3) {
                this.mState = 10003;
                if (null != this.mIDRManagerCallBack) {
                    this.mIDRManagerCallBack.onFail(state);
                }
                EventBus.getDefault().post((Object)new IDRStateResult(this.mSN, this.mState));
                return 0;
            }
        } else if (msg.what == 5142) {
            this.mState = msg.arg1 < 0 ? (msg.arg1 == -11301 || msg.arg1 == -11318 ? 10001 : 10002) : 10001;
            if (this.mState == 10001) {
                XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(this.mSN);
                if (xmDevInfo != null) {
                    xmDevInfo.setDevState(1);
                }
                EventBus.getDefault().post((Object)new IDRStateResult(this.mSN, this.mState));
            }
            msg.obj = this;
            LogUtils.debugInfo("[APP_IDR]->", "wake up result:" + this.mSN + "_" + msg.arg1 + "_State_" + this.mState);
        }
        return super.OnFunSDKResult(msg, ex);
    }
}

