/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.text.TextUtils;
import com.manager.device.idr.Sleep;
import com.utils.LogUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.greenrobot.eventbus.EventBus;

public class IDRSleepModel {
    private static final int SLEEP_DELAY_TIME = 15;
    private Map<String, Sleep> mIDRModelMap = new ConcurrentHashMap<String, Sleep>();
    private ExecutorService mExecutor;
    private SleepRunnable mSleepRunnable;

    public static final void sleep(String sn) {
        Sleep sleep = new Sleep(sn);
        sleep.sleep(null);
    }

    public static final void sleep(String sn, int delayUpdateDevStateTimes) {
        Sleep sleep = new Sleep(sn);
        sleep.sleep(null, delayUpdateDevStateTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSleepIDR(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        Map<String, Sleep> map = this.mIDRModelMap;
        synchronized (map) {
            if (this.mIDRModelMap.containsKey(sn)) {
                Sleep sleep = this.mIDRModelMap.get(sn);
                sleep.setSleepCountDown(15);
                LogUtils.debugInfo("[APP_IDR]->", "exist_" + sn + "_" + sleep.getSleepCountDown());
            } else {
                LogUtils.debugInfo("[APP_IDR]->", "add_" + sn);
                Sleep sleep = new Sleep(sn);
                sleep.setSleepCountDown(15);
                this.mIDRModelMap.put(sn, sleep);
            }
            this.startSleepRunnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSleepIDR(String sn) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        Map<String, Sleep> map = this.mIDRModelMap;
        synchronized (map) {
            if (this.mIDRModelMap.containsKey(sn)) {
                this.mIDRModelMap.remove(sn);
                LogUtils.debugInfo("[APP_IDR]->", "remove_" + sn);
                if (this.mIDRModelMap.isEmpty()) {
                    EventBus.getDefault().post((Object)"IDRSleepService_QUEUE_EMPTY");
                }
            } else if (this.mIDRModelMap.isEmpty()) {
                EventBus.getDefault().post((Object)"IDRSleepService_QUEUE_EMPTY");
            }
        }
    }

    public void startSleepRunnable() {
        if (this.mExecutor == null) {
            this.mExecutor = Executors.newSingleThreadExecutor();
        }
        if (this.mSleepRunnable == null) {
            this.mSleepRunnable = new SleepRunnable();
        }
        LogUtils.debugInfo("[APP_IDR]->", "startSleepRunnable_" + this.mSleepRunnable.running);
        if (!this.mSleepRunnable.running) {
            this.mSleepRunnable.restart();
            this.mExecutor.execute(this.mSleepRunnable);
        }
    }

    public void stopSleepRunnable() {
        if (this.mSleepRunnable != null) {
            this.mSleepRunnable.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        this.stopSleepRunnable();
        Map<String, Sleep> map = this.mIDRModelMap;
        synchronized (map) {
            Iterator<Map.Entry<String, Sleep>> iter = this.mIDRModelMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Sleep> entry = iter.next();
                entry.getValue().onDestroy();
                iter.remove();
            }
        }
        if (this.mExecutor != null && !this.mExecutor.isShutdown()) {
            this.mExecutor.shutdownNow();
        }
    }

    public class SleepRunnable
    implements Runnable {
        public volatile boolean running;
        private volatile int mEmptyTime;

        public void restart() {
            this.running = true;
            this.mEmptyTime = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    Map map = IDRSleepModel.this.mIDRModelMap;
                    synchronized (map) {
                        if (IDRSleepModel.this.mIDRModelMap.isEmpty()) {
                            if (this.mEmptyTime >= 30) {
                                this.running = false;
                                EventBus.getDefault().post((Object)"IDRSleepService_QUEUE_EMPTY");
                                return;
                            }
                        } else {
                            this.mEmptyTime = 0;
                        }
                        Iterator iter = IDRSleepModel.this.mIDRModelMap.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            int sleepCount = ((Sleep)entry.getValue()).getSleepCountDown();
                            if (sleepCount <= 1) {
                                ((Sleep)entry.getValue()).sleep(null);
                                iter.remove();
                                continue;
                            }
                            ((Sleep)entry.getValue()).setSleepCountDown(sleepCount - 5);
                        }
                        if (IDRSleepModel.this.mIDRModelMap.isEmpty()) {
                            if (this.mEmptyTime >= 30) {
                                this.running = false;
                                EventBus.getDefault().post((Object)"IDRSleepService_QUEUE_EMPTY");
                                return;
                            }
                        } else {
                            this.mEmptyTime = 0;
                        }
                    }
                    this.mEmptyTime += 5;
                    LogUtils.debugInfo("[APP_IDR]->", "EmptyTime  " + this.mEmptyTime);
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.running = false;
            EventBus.getDefault().post((Object)"IDRSleepService_QUEUE_EMPTY");
        }
    }
}

