/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.fisheye;

import android.util.Log;
import android.view.View;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.sdk.struct.MultiLensParam;
import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.lib.sdk.struct.SDK_FishEyeFrameCM;
import com.lib.sdk.struct.SDK_FishEyeFrameHW;
import com.lib.sdk.struct.SDK_FishEyeFrameSW;
import com.lib.sdk.struct.SDK_TwoLensesInOne;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.device.DeviceManager;

public class FishEyeCorrectManager {
    private static final int FRAME_INFO_TYPE_CAR = 1;
    private static final int FRAME_INFO_TYPE_STORAGE_V4 = 2;
    private static final int FRAME_INFO_TYPE_FISH_HARD = 3;
    private static final int FRAME_INFO_TYPE_FISH_SOFT = 4;
    private static final int FRAME_INFO_TYPE_DEFORMATION = 5;
    private static final int FRAME_INFO_TYPE_VIRTUAL_I_FRAME = 6;
    private static final int FRAME_INFO_TYPE_SMART_ANALYSIS_RULE = 7;
    private static final int FRAME_INFO_TYPE_SMART_ANALYSIS_ALARM = 8;
    private static final int FRAME_INFO_TYPE_FACE_RECOGNITION = 9;
    private static final int FRAME_INFO_TYPE_MORE_SENSOR = 10;
    private static final int FRAME_INFO_TYPE_IOT_JSON_DATA = 11;
    private static final int FRAME_INFO_TYPE_DOUBLE_SENSOR = 12;
    private static final int FRAME_INFO_TYPE_MORE_SENSOR_RECORD = 13;
    private static final int FRAME_INFO_TYPE_PIP_TWO_IN_ONE = 14;
    public static final int V_MODE_NORMAL = 0;
    public static final int V_MODE_SW_180 = 1;
    public static final int V_MODE_SW_360 = 2;
    public static final int V_MODE_HW = 3;
    public static final int V_MODE_DISTORTION = 4;
    public static final int V_MODE_TWO_LENSES_IN_ONE = 5;
    private OnFishEyeCorrectListener fishEyeCorrectLs;
    private View playView;
    private static FishEyeCorrectManager manager;

    private FishEyeCorrectManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FishEyeCorrectManager getInstance(OnFishEyeCorrectListener ls) {
        if (manager == null) {
            Class<FishEyeCorrectManager> clazz = FishEyeCorrectManager.class;
            // MONITORENTER : com.manager.device.fisheye.FishEyeCorrectManager.class
            if (manager == null) {
                manager = new FishEyeCorrectManager();
            }
            // MONITOREXIT : clazz
        }
        if (manager == null) return manager;
        manager.setOnFishEyeCorrectListener(ls);
        return manager;
    }

    public void setOnFishEyeCorrectListener(OnFishEyeCorrectListener ls) {
        this.fishEyeCorrectLs = ls;
    }

    public void fishEyeCorrect(String devId, byte[] data, int msgId) {
        if (msgId != 3 && msgId != 4 && msgId != 5 && msgId != 10 && msgId != 14) {
            return;
        }
        Object fishFrame = null;
        int videoMode = 0;
        if (data != null && data.length > 8) {
            byte[] pFishParam;
            Object fp;
            if (msgId == 3) {
                this.dump(data);
                fp = new SDK_FishEyeFrameHW();
                pFishParam = new byte[data.length - 8];
                System.arraycopy(data, 8, pFishParam, 0, pFishParam.length);
                G.BytesToObj((Object)fp, (byte[])pFishParam);
                fishFrame = fp;
            } else if (msgId == 4) {
                this.dump(data);
                fp = new SDK_FishEyeFrameSW();
                pFishParam = new byte[data.length - 8];
                System.arraycopy(data, 8, pFishParam, 0, pFishParam.length);
                G.BytesToObj((Object)fp, (byte[])pFishParam);
                fishFrame = fp;
            } else if (msgId == 5) {
                this.dump(data);
                if (DeviceManager.getInstance().isDontDewarpDevice(devId)) {
                    fishFrame = null;
                } else {
                    fp = new SDK_FishEyeFrameCM();
                    pFishParam = new byte[data.length - 8];
                    System.arraycopy(data, 8, pFishParam, 0, pFishParam.length);
                    G.BytesToObj((Object)fp, (byte[])pFishParam);
                    fishFrame = fp;
                }
            } else if (msgId == 10) {
                fp = new MultiLensParam();
                pFishParam = new byte[data.length - 8];
                System.arraycopy(data, 8, pFishParam, 0, pFishParam.length);
                G.BytesToObj((Object)fp, (byte[])pFishParam);
                fishFrame = fp;
            } else if (msgId == 14) {
                this.dump(data);
                fp = new SDK_TwoLensesInOne();
                pFishParam = new byte[data.length - 8];
                System.arraycopy(data, 8, pFishParam, 0, pFishParam.length);
                G.BytesToObj((Object)fp, (byte[])pFishParam);
                fishFrame = fp;
            }
        }
        if (null != fishFrame) {
            XMDevInfo devInfo = DevDataCenter.getInstance().getDevInfo(devId);
            if (devInfo != null && devInfo.getDevType() == 0) {
                if (msgId == 4) {
                    devInfo.setDevType(17);
                    FunSDK.SysChangeDevInfo((int)0, (byte[])G.ObjToBytes((Object)devInfo), (String)"", (String)"", (int)0);
                } else if (msgId == 3) {
                    devInfo.setDevType(10);
                    FunSDK.SysChangeDevInfo((int)0, (byte[])G.ObjToBytes((Object)devInfo), (String)"", (String)"", (int)0);
                }
            }
            if (fishFrame instanceof SDK_FishEyeFrameSW) {
                boolean bFishSW180;
                boolean bFishSW360;
                boolean bl = bFishSW360 = ((SDK_FishEyeFrameSW)fishFrame).st_1_lensType == 1 || ((SDK_FishEyeFrameSW)fishFrame).st_1_lensType == 2;
                if (bFishSW360) {
                    videoMode = 2;
                }
                boolean bl2 = bFishSW180 = ((SDK_FishEyeFrameSW)fishFrame).st_1_lensType == 3 || ((SDK_FishEyeFrameSW)fishFrame).st_1_lensType == 6;
                if (bFishSW180) {
                    videoMode = 1;
                }
            } else if (fishFrame instanceof SDK_FishEyeFrameHW) {
                videoMode = 3;
            } else if (fishFrame instanceof SDK_FishEyeFrameCM) {
                videoMode = 4;
            } else if (fishFrame instanceof SDK_TwoLensesInOne) {
                videoMode = 5;
            }
            this.fishEyeCorrectLs.onFishFrame((SDK_FishEyeFrame)fishFrame, videoMode);
        }
    }

    private void dump(byte[] data) {
        String dmpStr = "";
        for (int i = 0; i < data.length; ++i) {
            dmpStr = dmpStr + String.format("%02x ", data[i] & 0xFF);
        }
        Log.d((String)"test", (String)("--> Frame : " + dmpStr));
    }

    public static interface OnFishEyeCorrectListener {
        public void onFishFrame(SDK_FishEyeFrame var1, int var2);
    }
}

