/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config;

import android.os.Message;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.AlarmInfoBean;
import com.lib.sdk.bean.CameraParamBean;
import com.lib.sdk.bean.DevVolumeBean;
import com.lib.sdk.bean.Encode264AbilityBean;
import com.lib.sdk.bean.GeneralInfoBean;
import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.NetWorkWiFiBean;
import com.lib.sdk.bean.NetworkPmsBean;
import com.lib.sdk.bean.RecordParamBean;
import com.lib.sdk.bean.ReserveWakeUp;
import com.lib.sdk.bean.SimplifyEncodeBean;
import com.lib.sdk.bean.SmartH264V2Bean;
import com.lib.sdk.bean.StorageInfoBean;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SystemManageShutDown;
import com.lib.sdk.bean.TimeZoneBean;
import com.lib.sdk.bean.WhiteLightBean;
import com.lib.sdk.bean.idr.NotifyLightBean;
import com.manager.base.BaseManager;
import com.manager.device.DeviceManager;
import com.manager.device.config.DevConfigInfo;
import com.manager.device.config.DevConfigManagerInterface;
import com.manager.device.config.SerialPortsInfo;
import com.utils.LogUtils;
import java.util.HashMap;

public class DevConfigManager
extends BaseManager
implements DevConfigManagerInterface,
IFunSDKResult {
    public static final int TIME_OUT = 5000;
    private int timeOut = 5000;
    private boolean logEnable = false;
    private int userId;
    private String devId;
    private HashMap<String, DevConfigInfo> devConfigInfos;
    private DeviceManager.OnDevManagerListener listener;

    private DevConfigManager(String devId) {
        this.devId = devId;
        this.init();
    }

    private DevConfigManager(String devId, DeviceManager.OnDevManagerListener listener) {
        this(devId);
        this.listener = listener;
    }

    public static DevConfigManager create(String devId) {
        return new DevConfigManager(devId);
    }

    public static DevConfigManager create(String devId, DeviceManager.OnDevManagerListener listener) {
        return new DevConfigManager(devId);
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        this.devConfigInfos = new HashMap();
        return true;
    }

    @Override
    public void unInit() {
        FunSDK.UnRegUser((int)this.userId);
    }

    @Override
    public void getDevConfig(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsKey(devConfigInfo2.getJsonName() + this.devId)) {
            this.devConfigInfos.put(devConfigInfo2.getJsonName() + this.devId, devConfigInfo2);
            if (devConfigInfo2.isNotLogin()) {
                FunSDK.DevConfigJsonNotLoginPtl((int)this.userId, (String)this.devId, (String)devConfigInfo2.getJsonName(), null, (int)1660, (int)devConfigInfo2.getChnId(), (int)0, (int)devConfigInfo2.getTimeOut(), (int)0, (int)0);
            } else {
                FunSDK.DevGetConfigByJson((int)this.userId, (String)this.devId, (String)devConfigInfo2.getJsonName(), (int)1024, (int)devConfigInfo2.getChnId(), (int)devConfigInfo2.getTimeOut(), (int)devConfigInfo2.getSeq());
            }
        } else {
            DevConfigInfo info = this.devConfigInfos.get(devConfigInfo2.getJsonName() + this.devId);
            if (info != null) {
                info.addListener(devConfigInfo2.getListener(), devConfigInfo2.getField());
            }
        }
    }

    @Override
    public void setDevConfig(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsKey(devConfigInfo2.getJsonName() + this.devId)) {
            this.devConfigInfos.put(devConfigInfo2.getJsonName() + this.devId, devConfigInfo2);
            if (devConfigInfo2.isNotLogin()) {
                FunSDK.DevConfigJsonNotLoginPtl((int)this.userId, (String)this.devId, (String)devConfigInfo2.getJsonName(), (String)devConfigInfo2.getJsonData(), (int)1660, (int)devConfigInfo2.getChnId(), (int)0, (int)devConfigInfo2.getTimeOut(), (int)0, (int)1);
            } else {
                FunSDK.DevSetConfigByJson((int)this.userId, (String)this.devId, (String)devConfigInfo2.getJsonName(), (String)devConfigInfo2.getJsonData(), (int)devConfigInfo2.getChnId(), (int)devConfigInfo2.getTimeOut(), (int)devConfigInfo2.getSeq());
            }
        }
    }

    @Override
    public void setDevCmd(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put(devConfigInfo2.getJsonName() + this.devId, devConfigInfo2);
            String jsonData = devConfigInfo2.getJsonData();
            FunSDK.DevCmdGeneral((int)this.userId, (String)this.devId, (int)devConfigInfo2.getCmdId(), (String)devConfigInfo2.getJsonName(), (int)-1, (int)devConfigInfo2.getTimeOut(), (byte[])(jsonData == null ? null : jsonData.getBytes()), (int)0, (int)devConfigInfo2.getSeq());
        }
    }

    @Override
    public void restartDevice(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("OPMachine" + this.devId, devConfigInfo2);
            JSONObject obj = new JSONObject();
            obj.put("Action", (Object)"Reboot");
            FunSDK.DevCmdGeneral((int)this.userId, (String)this.devId, (int)1450, (String)"OPMachine", (int)-1, (int)5000, (byte[])HandleConfigData.getSendData("OPMachine", "0x01", obj).getBytes(), (int)-1, (int)devConfigInfo2.getSeq());
        }
    }

    @Override
    public void openSerialPorts(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("OpenSerialPorts" + this.devId, devConfigInfo2);
            SerialPortsInfo serialPortsInfo = devConfigInfo2.getSerialPortsInfo();
            if (serialPortsInfo != null) {
                serialPortsInfo.setOperationType(5);
                int dataSize = serialPortsInfo.getSerialPortsData() == null ? 0 : serialPortsInfo.getSerialPortsData().length;
                FunSDK.DevOption((int)this.userId, (String)this.devId, (int)serialPortsInfo.getOperationType(), (byte[])serialPortsInfo.getSerialPortsData(), (int)dataSize, (int)serialPortsInfo.getSerialPortsType(), (int)this.userId, (int)0, (String)"", (int)devConfigInfo2.getSeq());
            }
        }
    }

    @Override
    public void closeSerialPorts(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("CloseSerialPorts" + this.devId, devConfigInfo2);
            SerialPortsInfo serialPortsInfo = devConfigInfo2.getSerialPortsInfo();
            if (serialPortsInfo != null) {
                serialPortsInfo.setOperationType(6);
                int dataSize = serialPortsInfo.getSerialPortsData() == null ? 0 : serialPortsInfo.getSerialPortsData().length;
                FunSDK.DevOption((int)this.userId, (String)this.devId, (int)serialPortsInfo.getOperationType(), (byte[])serialPortsInfo.getSerialPortsData(), (int)dataSize, (int)serialPortsInfo.getSerialPortsType(), (int)this.userId, (int)0, (String)"", (int)devConfigInfo2.getSeq());
            }
        }
    }

    @Override
    public void getSerialPortsData(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("ReadSerialPortsData" + this.devId, devConfigInfo2);
            SerialPortsInfo serialPortsInfo = devConfigInfo2.getSerialPortsInfo();
            if (serialPortsInfo != null) {
                serialPortsInfo.setOperationType(7);
                int dataSize = serialPortsInfo.getSerialPortsData() == null ? 0 : serialPortsInfo.getSerialPortsData().length;
                FunSDK.DevOption((int)this.userId, (String)this.devId, (int)serialPortsInfo.getOperationType(), (byte[])serialPortsInfo.getSerialPortsData(), (int)dataSize, (int)serialPortsInfo.getSerialPortsType(), (int)this.userId, (int)0, (String)"", (int)devConfigInfo2.getSeq());
            }
        }
    }

    @Override
    public void setSerialPortsData(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("WriteSerialPortsData" + this.devId, devConfigInfo2);
            SerialPortsInfo serialPortsInfo = devConfigInfo2.getSerialPortsInfo();
            if (serialPortsInfo != null) {
                serialPortsInfo.setOperationType(8);
                int dataSize = serialPortsInfo.getSerialPortsData() == null ? 0 : serialPortsInfo.getSerialPortsData().length;
                FunSDK.DevOption((int)this.userId, (String)this.devId, (int)serialPortsInfo.getOperationType(), (byte[])serialPortsInfo.getSerialPortsData(), (int)dataSize, (int)serialPortsInfo.getSerialPortsType(), (int)this.userId, (int)0, (String)"", (int)devConfigInfo2.getSeq());
            }
        }
    }

    @Override
    public void setSerialPortsDataReceiveListener(DevConfigInfo devConfigInfo2) {
        if (devConfigInfo2 == null) {
            return;
        }
        if (!this.devConfigInfos.containsValue(devConfigInfo2)) {
            this.devConfigInfos.put("ReceiveSerialPortsData" + this.devId, devConfigInfo2);
        }
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.arg1 < 0) {
            if (msg.what == 5122) {
                switch (ex.arg3) {
                    case 5: {
                        this.triggeredListener(this.devConfigInfos.get("OpenSerialPorts" + this.devId), msg, ex, ex.seq, false);
                        break;
                    }
                    case 6: {
                        this.triggeredListener(this.devConfigInfos.get("CloseSerialPorts" + this.devId), msg, ex, ex.seq, false);
                        break;
                    }
                    case 7: {
                        this.triggeredListener(this.devConfigInfos.get("ReadSerialPortsData" + this.devId), msg, ex, ex.seq, false);
                        break;
                    }
                    case 8: {
                        this.triggeredListener(this.devConfigInfos.get("WriteSerialPortsData" + this.devId), msg, ex, ex.pData, false);
                        break;
                    }
                }
            } else {
                DevConfigInfo devConfigInfo2 = this.devConfigInfos.get(ex.str + this.devId);
                if (msg.arg1 == -10005 && devConfigInfo2 != null && devConfigInfo2.isNeedTryAgain()) {
                    this.devConfigInfos.remove(ex.str + this.devId);
                    LogUtils.debugInfo("[APP_CONNECT_DEV]->", "\u8fde\u63a5\u8bbe\u5907-\u91cd\u8bd5");
                    if (msg.what == 5128) {
                        this.getDevConfig(devConfigInfo2);
                    } else if (msg.what == 5129) {
                        this.setDevConfig(devConfigInfo2);
                    } else if (msg.what == 5131) {
                        this.setDevCmd(devConfigInfo2);
                    } else {
                        this.triggeredListener(devConfigInfo2, msg, ex, null, false);
                    }
                } else {
                    this.triggeredListener(devConfigInfo2, msg, ex, null, false);
                }
            }
            return 0;
        }
        block6 : switch (msg.what) {
            case 5128: {
                HandleConfigData data;
                if (StringUtils.contrast(ex.str, "System.TimeZone")) {
                    HandleConfigData data2 = new HandleConfigData();
                    if (data2.getDataObj(G.ToString((byte[])ex.pData), TimeZoneBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data2.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "StorageInfo")) {
                    HandleConfigData data3 = new HandleConfigData();
                    if (data3.getDataObj(G.ToString((byte[])ex.pData), StorageInfoBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data3.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "General.General")) {
                    HandleConfigData data4 = new HandleConfigData();
                    if (data4.getDataObj(G.ToString((byte[])ex.pData), GeneralInfoBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data4.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Simplify.Encode")) {
                    HandleConfigData data5 = new HandleConfigData();
                    if (data5.getDataObj(G.ToString((byte[])ex.pData), SimplifyEncodeBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data5.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Alarm.PIR")) {
                    HandleConfigData data6 = new HandleConfigData();
                    if (data6.getDataObj(G.ToString((byte[])ex.pData), AlarmInfoBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data6.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "NetWork.PMS")) {
                    HandleConfigData data7 = new HandleConfigData();
                    if (data7.getDataObj(G.ToString((byte[])ex.pData), NetworkPmsBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data7.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Consumer.NotifyLight")) {
                    HandleConfigData data8 = new HandleConfigData();
                    if (data8.getDataObj(G.ToString((byte[])ex.pData), NotifyLightBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data8.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "System.ManageShutDown")) {
                    HandleConfigData data9 = new HandleConfigData();
                    if (data9.getDataObj(G.ToString((byte[])ex.pData), SystemManageShutDown.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data9.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "fVideo.Volume")) {
                    HandleConfigData data10 = new HandleConfigData();
                    if (data10.getDataObj(G.ToString((byte[])ex.pData), DevVolumeBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data10.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "General.Location.Language")) {
                    HandleConfigData data11 = new HandleConfigData();
                    if (data11.getDataObj(G.ToString((byte[])ex.pData), String.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data11.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Camera.Param")) {
                    HandleConfigData data12 = new HandleConfigData();
                    if (data12.getDataObj(G.ToString((byte[])ex.pData), CameraParamBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data12.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Record")) {
                    HandleConfigData data13 = new HandleConfigData();
                    if (data13.getDataObj(G.ToString((byte[])ex.pData), RecordParamBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data13.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "AVEnc.SmartH264V2")) {
                    HandleConfigData data14 = new HandleConfigData();
                    if (data14.getDataObj(G.ToString((byte[])ex.pData), SmartH264V2Bean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data14.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "NetWork.Wifi")) {
                    HandleConfigData data15 = new HandleConfigData();
                    if (data15.getDataObj(G.ToString((byte[])ex.pData), NetWorkWiFiBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data15.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Detect.MotionDetect")) {
                    HandleConfigData data16 = new HandleConfigData();
                    if (data16.getDataObj(G.ToString((byte[])ex.pData), AlarmInfoBean.class)) {
                        this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data16.getObj(), true);
                        break;
                    }
                } else if (StringUtils.contrast(ex.str, "Camera.WhiteLight") && (data = new HandleConfigData()).getDataObj(G.ToString((byte[])ex.pData), WhiteLightBean.class)) {
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data.getObj(), true);
                    break;
                }
                this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, G.ToString((byte[])ex.pData), true);
                break;
            }
            case 5129: {
                if (StringUtils.contrast(ex.str, "OPStorageManager")) {
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, ex.seq, true);
                    break;
                }
                this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, null, true);
                break;
            }
            case 5131: {
                if (StringUtils.contrast(ex.str, "OPTimeQuery")) {
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, G.ToString((byte[])ex.pData), true);
                    break;
                }
                if (StringUtils.contrast(ex.str, "OPMachine")) {
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, null, true);
                    break;
                }
                if (StringUtils.contrast(ex.str, "ChannelTitle")) {
                    HandleConfigData data = new HandleConfigData();
                    data.getDataObj(G.ToString((byte[])ex.pData), String.class);
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data.getObj(), true);
                    break;
                }
                if (StringUtils.contrast(ex.str, "MultiLanguage")) {
                    HandleConfigData data = new HandleConfigData();
                    data.getDataObj(G.ToString((byte[])ex.pData), String.class);
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data.getObj(), true);
                    break;
                }
                if (StringUtils.contrast(ex.str, "Encode264ability")) {
                    HandleConfigData data = new HandleConfigData();
                    data.getDataObj(G.ToString((byte[])ex.pData), Encode264AbilityBean.class);
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data.getObj(), true);
                    break;
                }
                if (StringUtils.contrast(ex.str, "GetAllReserveItem")) {
                    HandleConfigData data = new HandleConfigData();
                    data.getDataObj(G.ToString((byte[])ex.pData), ReserveWakeUp.Parameter.class);
                    this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, data.getObj(), true);
                    break;
                }
                this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, G.ToString((byte[])ex.pData), true);
                break;
            }
            case 5122: {
                switch (ex.arg3) {
                    case 5: {
                        this.triggeredListener(this.devConfigInfos.get("OpenSerialPorts" + this.devId), msg, ex, ex.seq, true);
                        break block6;
                    }
                    case 6: {
                        this.triggeredListener(this.devConfigInfos.get("CloseSerialPorts" + this.devId), msg, ex, ex.seq, true);
                        break block6;
                    }
                    case 7: {
                        this.triggeredListener(this.devConfigInfos.get("ReadSerialPortsData" + this.devId), msg, ex, ex.seq, true);
                        break block6;
                    }
                    case 8: {
                        this.triggeredListener(this.devConfigInfos.get("WriteSerialPortsData" + this.devId), msg, ex, ex.pData, true);
                        break block6;
                    }
                }
                break;
            }
            case 5130: {
                this.triggeredListener(this.devConfigInfos.get("ReceiveSerialPortsData" + this.devId), msg, ex, ex.pData, true);
                this.triggeredListener(this.devConfigInfos.get("WriteSerialPortsData" + this.devId), msg, ex, ex.pData, true);
                break;
            }
            case 5150: {
                this.triggeredListener(this.devConfigInfos.get(ex.str + this.devId), msg, ex, G.ToString((byte[])ex.pData), true);
                break;
            }
        }
        return 0;
    }

    public static String getCfgJsonFullName(String name, int chn) {
        if (chn == -1) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(".").append("[").append(chn).append("]");
        return sb.toString();
    }

    private void triggeredListener(DevConfigInfo info, Message msg, MsgContent ex, Object result, boolean bSuccess) {
        if (info != null && info.getListener() != null) {
            if (this.devConfigInfos.containsKey(info.getJsonName() + this.devId)) {
                this.devConfigInfos.remove(info.getJsonName() + this.devId);
            }
            if (bSuccess) {
                info.getListener().onSuccess(this.devId, msg.what, result);
            } else {
                info.getListener().onFailed(this.devId, msg.what, ex.str, msg.arg1);
            }
            if (info.getListener() instanceof OnDevConfigResultListener) {
                ((OnDevConfigResultListener)info.getListener()).onFunSDKResult(msg, ex);
            }
        } else if (this.listener != null) {
            if (bSuccess) {
                this.listener.onSuccess(this.devId, msg.what, result);
            } else {
                this.listener.onFailed(this.devId, msg.what, ex.str, msg.arg1);
            }
            if (this.listener instanceof OnDevConfigResultListener) {
                ((OnDevConfigResultListener)info.getListener()).onFunSDKResult(msg, ex);
            }
        }
    }

    public static interface OnDevConfigResultListener
    extends DeviceManager.OnDevManagerListener {
        public void onFunSDKResult(Message var1, MsgContent var2);
    }
}

