/*
 * Decompiled with CFR 0.152.
 */
package com.manager.base.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.lib.sdk.bean.StringUtils;
import com.manager.base.http.BaseResp;
import com.utils.LogUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ResponseCallback
implements Callback<ResponseBody> {
    private final ICallback callback;

    public ResponseCallback(ICallback callback) {
        this.callback = callback;
    }

    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
        this.printRequest(response.raw().request());
        ResponseBody responseBody = (ResponseBody)response.body();
        try {
            if (responseBody != null) {
                String jsonResult = URLDecoder.decode(responseBody.string(), "UTF-8");
                LogUtils.debugInfo("[APP_JVSS->]", "Http-responseLog:" + jsonResult);
                Gson gson = new Gson();
                BaseResp resp = (BaseResp)gson.fromJson(jsonResult, BaseResp.class);
                if (resp.code == 0 || resp.code == 200 || resp.code == 2000) {
                    this.callback.onSuccess(gson.toJson(resp.data));
                } else {
                    this.callback.onBusinessError(resp.getCode(), resp.getMsg());
                }
            } else {
                this.callback.onFailure(new Throwable("responseBody is null"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.callback.onFailure(e);
        }
    }

    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
        this.callback.onFailure(t);
    }

    private void printRequest(Request request) {
        String strBody = ResponseCallback.parseParams(request.body());
        String requestLog = request.url().toString();
        if (!StringUtils.isStringNULL(strBody)) {
            requestLog = requestLog + "\nAuthorization----->" + request.header("Authorization");
            requestLog = requestLog + "\nBody----->" + strBody;
        }
        LogUtils.debugInfo("[APP_JVSS->]", "Http-requestLog:" + requestLog);
    }

    public static String parseParams(RequestBody body) {
        try {
            if (body == null) {
                return "";
            }
            Buffer requestBuffer = new Buffer();
            body.writeTo((BufferedSink)requestBuffer);
            Charset charset = StandardCharsets.UTF_8;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            String text = requestBuffer.readString(charset);
            if (contentType != null && !"json".equals(contentType.subtype())) {
                text = URLDecoder.decode(text, ResponseCallback.convertCharset(charset));
            }
            return text;
        }
        catch (IOException e) {
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }

    public static interface ICallback {
        public void onSuccess(@Nullable String var1);

        default public void onBusinessError(int code, String message) {
        }

        default public void onFailure(@NonNull Throwable t) {
        }
    }
}

