/*
 * Decompiled with CFR 0.152.
 */
package com.manager.account;

import com.manager.account.AccountInterface;
import com.manager.account.BaseAccountManager;
import com.manager.account.LocalAccountManager;
import com.manager.account.XMAccountManager;
import com.manager.base.BaseManager;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import java.util.ArrayList;
import java.util.List;

public class AccountManager
extends BaseManager
implements AccountInterface {
    private static AccountManager accountManager;
    private LocalAccountManager localAccountManager;
    private XMAccountManager xmAccountManager;
    private BaseAccountManager curAccountManager;

    private AccountManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AccountManager getInstance() {
        if (null == accountManager) {
            Class<BaseAccountManager> clazz = BaseAccountManager.class;
            // MONITORENTER : com.manager.account.BaseAccountManager.class
            if (null == accountManager) {
                accountManager = new AccountManager();
            }
            // MONITOREXIT : clazz
        }
        if (null != AccountManager.accountManager.curAccountManager) return accountManager;
        if (DevDataCenter.getInstance().isLoginByAccount()) {
            XMAccountManager xmAccountManager = XMAccountManager.getInstance();
            if (!xmAccountManager.isInit()) return accountManager;
            AccountManager.accountManager.xmAccountManager = xmAccountManager;
            AccountManager.accountManager.curAccountManager = xmAccountManager;
            return accountManager;
        }
        LocalAccountManager localAccountManager = LocalAccountManager.getInstance();
        if (!localAccountManager.isInit()) return accountManager;
        AccountManager.accountManager.localAccountManager = localAccountManager;
        AccountManager.accountManager.curAccountManager = localAccountManager;
        return accountManager;
    }

    public LocalAccountManager localLogin(String dbPath, BaseAccountManager.OnAccountManagerListener ls) {
        this.init();
        if (null != this.xmAccountManager) {
            this.xmAccountManager.unInit();
        }
        this.localAccountManager = LocalAccountManager.getInstance();
        this.localAccountManager.login(dbPath, ls);
        this.curAccountManager = this.localAccountManager;
        return this.localAccountManager;
    }

    public XMAccountManager xmLogin(String userName, String password, int loginType, BaseAccountManager.OnAccountManagerListener ls) {
        this.init();
        if (null != this.localAccountManager) {
            this.localAccountManager.unInit();
        }
        this.xmAccountManager = XMAccountManager.getInstance();
        this.xmAccountManager.login(userName, password, loginType, ls);
        this.curAccountManager = this.xmAccountManager;
        return this.xmAccountManager;
    }

    public XMAccountManager xmLoginByCode(String emailOrPhoneNo, String code, int appType, BaseAccountManager.OnAccountManagerListener ls) {
        this.init();
        if (null != this.localAccountManager) {
            this.localAccountManager.unInit();
        }
        this.xmAccountManager = XMAccountManager.getInstance();
        this.xmAccountManager.loginByCode(emailOrPhoneNo, code, appType, ls);
        this.curAccountManager = this.xmAccountManager;
        return this.xmAccountManager;
    }

    public XMAccountManager xmLoginByUnionId(String unionId, String name, int loginType, BaseAccountManager.OnAccountManagerListener ls) {
        this.init();
        if (null != this.localAccountManager) {
            this.localAccountManager.unInit();
        }
        this.xmAccountManager = XMAccountManager.getInstance();
        this.xmAccountManager.loginByUnionId(unionId, name, loginType, ls);
        this.curAccountManager = this.xmAccountManager;
        return this.xmAccountManager;
    }

    public XMAccountManager getCodeForAccountLogin(String emailOrPhoneNo, BaseAccountManager.OnAccountManagerListener ls) {
        this.init();
        if (null != this.localAccountManager) {
            this.localAccountManager.unInit();
        }
        this.xmAccountManager = XMAccountManager.getInstance();
        this.xmAccountManager.sendCodeForAccountLogin(emailOrPhoneNo, ls);
        this.curAccountManager = this.xmAccountManager;
        return this.xmAccountManager;
    }

    @Override
    public boolean init() {
        this.isInit = true;
        return true;
    }

    @Override
    public void unInit() {
        if (null != this.xmAccountManager) {
            this.xmAccountManager.unInit();
        }
        if (null != this.localAccountManager) {
            this.localAccountManager.unInit();
        }
        this.isInit = false;
    }

    public BaseAccountManager getCurAccountManager() {
        return this.curAccountManager;
    }

    public int getLoginType() {
        return DevDataCenter.getInstance().getLoginType();
    }

    @Override
    public List<String> getDevList() {
        if (this.curAccountManager != null) {
            return this.curAccountManager.getDevList();
        }
        return new ArrayList<String>();
    }

    @Override
    public void sortDevList(List<String> localSortDevList) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.sortDevList(localSortDevList);
    }

    @Override
    public void setLocalSortDevList(List<String> localSortDevList) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.setLocalSortDevList(localSortDevList);
    }

    @Override
    public void setIsSortByLocalDevList(boolean isSort) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.setIsSortByLocalDevList(isSort);
    }

    @Override
    public void logout() {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.logout();
    }

    @Override
    public void addDev(XMDevInfo xmDevInfo, BaseAccountManager.OnAccountManagerListener ls) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.addDev(xmDevInfo, ls);
    }

    @Override
    public void addDev(XMDevInfo xmDevInfo, boolean isUnbindDevUnderOther, BaseAccountManager.OnAccountManagerListener ls) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.addDev(xmDevInfo, isUnbindDevUnderOther, ls);
    }

    @Override
    public void deleteDev(String devSN, BaseAccountManager.OnAccountManagerListener ls) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.deleteDev(devSN, ls);
    }

    @Override
    public void updateDevStateFromServer(BaseAccountManager.OnDevStateListener listener, String devId) {
        if (this.curAccountManager != null) {
            this.curAccountManager.updateDevStateFromServer(listener, devId);
        } else {
            this.curAccountManager = LocalAccountManager.getInstance();
            this.curAccountManager.init();
            this.curAccountManager.updateDevStateFromServer(listener, devId);
        }
    }

    @Override
    public void updateAllDevStateFromServer(List<String> devIdList, BaseAccountManager.OnDevStateListener listener) {
        if (this.curAccountManager != null) {
            this.curAccountManager.updateAllDevStateFromServer(devIdList, listener);
        } else {
            this.curAccountManager = LocalAccountManager.getInstance();
            this.curAccountManager.init();
            this.curAccountManager.updateAllDevStateFromServer(devIdList, listener);
        }
    }

    @Override
    public int getDevState(String devId) {
        if (this.curAccountManager != null) {
            return this.curAccountManager.getDevState(devId);
        }
        return 0;
    }

    @Override
    public XMDevInfo getDevInfo(String devId) {
        if (this.curAccountManager != null) {
            return this.curAccountManager.getDevInfo(devId);
        }
        return null;
    }

    @Override
    public void modifyDevName(String devId, String devName, BaseAccountManager.OnAccountManagerListener ls) {
        if (this.curAccountManager == null) {
            throw new RuntimeException("Please initialize XMAccountManager or LocalAccountManager");
        }
        this.curAccountManager.modifyDevName(devId, devName, ls);
    }

    @Override
    public int getOnlineDevCount() {
        if (this.curAccountManager != null) {
            this.curAccountManager.getOnlineDevCount();
        }
        return 0;
    }
}

