/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.idr;

import android.text.TextUtils;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;

public class WorkModeBean {
    public static final int WORK_MODE_LOW_POWER = 0;
    public static final int WORK_MODE_SMART = 1;
    @JSONField(name="ModeType")
    private int modeType;
    @JSONField(name="MaskTimeSection")
    private int maskTimeSection;
    @JSONField(name="NoSleepTimeSection")
    private ArrayList<NoSleepTimeSection> noSleepTimeSections;

    public int getModeType() {
        return this.modeType;
    }

    public void setModeType(int modeType) {
        this.modeType = modeType;
    }

    public int getMaskTimeSection() {
        return this.maskTimeSection;
    }

    public void setMaskTimeSection(int maskTimeSection) {
        this.maskTimeSection = maskTimeSection;
    }

    @JSONField(serialize=false)
    public boolean isSupportTimeSet(int modeType) {
        return this.maskTimeSection >> modeType == 1;
    }

    public ArrayList<NoSleepTimeSection> getNoSleepTimeSections() {
        return this.noSleepTimeSections;
    }

    public void setNoSleepTimeSections(ArrayList<NoSleepTimeSection> noSleepTimeSections) {
        this.noSleepTimeSections = noSleepTimeSections;
    }

    @JSONField(serialize=false)
    public NoSleepTimeSection getNoSleepTimeSection() {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return null;
        }
        return this.noSleepTimeSections.get(this.modeType);
    }

    @JSONField(serialize=false)
    public int[] getStartTimeBySelMode() {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return null;
        }
        NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
        if (noSleepTimeSection != null) {
            return this.timeStringToInt(noSleepTimeSection.getStartTime());
        }
        return null;
    }

    @JSONField(serialize=false)
    public void setStartTimeBySelMode(int[] startTime) {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size() || startTime == null) {
            return;
        }
        try {
            NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
            if (noSleepTimeSection != null) {
                noSleepTimeSection.setStartTime(String.format("%02d:%02d", startTime[0], startTime[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JSONField(serialize=false)
    public int[] getEndTimeBySelMode() {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return null;
        }
        NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
        if (noSleepTimeSection != null) {
            return this.timeStringToInt(noSleepTimeSection.getEndTime());
        }
        return null;
    }

    @JSONField(serialize=false)
    public void setEndTimeBySelMode(int[] endTime) {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size() || endTime == null) {
            return;
        }
        try {
            NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
            if (noSleepTimeSection != null) {
                noSleepTimeSection.setEndTime(String.format("%02d:%02d", endTime[0], endTime[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JSONField(serialize=false)
    public int getWeekMaskBySelMode() {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return 0;
        }
        NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
        if (noSleepTimeSection != null) {
            return noSleepTimeSection.getWeekMask();
        }
        return 0;
    }

    @JSONField(serialize=false)
    public void setWeekMaskBySelMode(int weekMask) {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return;
        }
        try {
            NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
            if (noSleepTimeSection != null) {
                noSleepTimeSection.setWeekMask(weekMask);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JSONField(serialize=false)
    public boolean isEnableBySelMode() {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return false;
        }
        NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
        if (noSleepTimeSection != null) {
            return noSleepTimeSection.isEnable();
        }
        return false;
    }

    @JSONField(serialize=false)
    public void setEnableBySelMode(boolean enable) {
        if (this.noSleepTimeSections == null || this.modeType < 0 || this.modeType >= this.noSleepTimeSections.size()) {
            return;
        }
        try {
            NoSleepTimeSection noSleepTimeSection = this.noSleepTimeSections.get(this.modeType);
            if (noSleepTimeSection != null) {
                noSleepTimeSection.setEnable(enable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @JSONField(serialize=false)
    private int[] timeStringToInt(String time) {
        String[] times;
        int[] iTimes = null;
        if (!TextUtils.isEmpty((CharSequence)time) && null != (times = time.split(":")) && times.length == 2) {
            iTimes = new int[]{Integer.parseInt(times[0]), Integer.parseInt(times[1])};
        }
        return iTimes;
    }

    public static class NoSleepTimeSection {
        @JSONField(name="Enable")
        private boolean enable;
        @JSONField(name="StartTime")
        private String startTime;
        @JSONField(name="EndTime")
        private String endTime;
        @JSONField(name="WeekMask")
        private int weekMask;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public int getWeekMask() {
            return this.weekMask;
        }

        public void setWeekMask(int weekMask) {
            this.weekMask = weekMask;
        }
    }
}

