/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean;

import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;

public class StringUtils {
    public static boolean contrast(String str1, String str2) {
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        if (str1 == null) {
            return true;
        }
        return str1.equals(str2);
    }

    public static boolean contrastIgnoreCase(String str1, String str2) {
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        if (str1 == null) {
            return true;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean containsIgnoreCase(String original, String str) {
        if (StringUtils.isStringNULL(original) || StringUtils.isStringNULL(str)) {
            return false;
        }
        return original.toLowerCase().contains(str.toLowerCase());
    }

    public static boolean isStringNULL(String str) {
        return str == null || str.equals("") || str.equals("null");
    }

    public static SpannableString getTintString(String originStr, int color2, String ... keywords) {
        if (originStr == null) {
            return null;
        }
        SpannableString ss = new SpannableString((CharSequence)originStr);
        for (String key : keywords) {
            int length = key.length();
            int start = originStr.indexOf(key);
            if (start <= -1) continue;
            ss.setSpan((Object)new ForegroundColorSpan(color2), start, start + length, 33);
        }
        return ss;
    }

    public static String getWholeText(String text, int byteCount) {
        try {
            if (text != null && text.getBytes("utf-8").length > byteCount) {
                char[] tempChars = text.toCharArray();
                int sumByte = 0;
                int charIndex = 0;
                int len = tempChars.length;
                for (int i = 0; i < len; ++i) {
                    char itemChar = tempChars[i];
                    sumByte = itemChar >= '\u0000' && itemChar <= '\u007f' ? ++sumByte : (itemChar >= '\u0080' && itemChar <= '\u07ff' ? (sumByte += 2) : (sumByte += 3));
                    if (sumByte <= byteCount) continue;
                    charIndex = i;
                    break;
                }
                return String.valueOf(tempChars, 0, charIndex);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return text;
    }

    public static boolean isJsonStr(String str) {
        try {
            JSON.parse((String)str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

