/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.utils.hook.utils;

import com.inuker.bluetooth.library.utils.StringUtils;
import com.inuker.bluetooth.library.utils.hook.utils.MemberUtils;
import com.inuker.bluetooth.library.utils.hook.utils.Validate;
import java.lang.reflect.Field;

public class FieldUtils {
    public static Field getDeclaredField(Class<?> cls, String fieldName, boolean forceAccess) {
        Validate.isTrue(cls != null, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        try {
            Field field = cls.getDeclaredField(fieldName);
            if (!MemberUtils.isAccessible(field)) {
                if (forceAccess) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }
}

