/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class FrameCryptorKeyManager {
    private long nativeKeyManager;

    @CalledByNative
    public FrameCryptorKeyManager(long nativeKeyManager) {
        this.nativeKeyManager = nativeKeyManager;
    }

    public long getNativeKeyManager() {
        return this.nativeKeyManager;
    }

    public boolean setKey(String participantId, int index, byte[] key) {
        return FrameCryptorKeyManager.nativeSetKey(this.nativeKeyManager, participantId, index, key);
    }

    public boolean setKeys(String participantId, ArrayList<byte[]> keys) {
        return FrameCryptorKeyManager.nativeSetKeys(this.nativeKeyManager, participantId, keys);
    }

    public ArrayList<byte[]> getKeys(String participantId) {
        return FrameCryptorKeyManager.nativeGetKeys(this.nativeKeyManager, participantId);
    }

    public void dispose() {
        this.checkKeyManagerExists();
        JniCommon.nativeReleaseRef(this.nativeKeyManager);
        this.nativeKeyManager = 0L;
    }

    private void checkKeyManagerExists() {
        if (this.nativeKeyManager == 0L) {
            throw new IllegalStateException("FrameCryptorKeyManager has been disposed.");
        }
    }

    private static native long createNativeKeyManager();

    private static native boolean nativeSetKey(long var0, String var2, int var3, byte[] var4);

    private static native boolean nativeSetKeys(long var0, String var2, ArrayList<byte[]> var3);

    private static native ArrayList<byte[]> nativeGetKeys(long var0, String var2);
}

