/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import com.flipkart.zjsonpatch.mapping.JsonTokenWrapper;
import java.util.EnumMap;
import java.util.Map;

enum NodeType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;
    private static final Map<JsonTokenWrapper, NodeType> TOKEN_MAP;

    private NodeType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NodeType getNodeType(JsonNodeWrapper node) {
        JsonTokenWrapper token = node.asToken();
        NodeType ret = TOKEN_MAP.get((Object)token);
        if (ret == null) {
            throw new NullPointerException("unhandled token type " + String.valueOf((Object)token));
        }
        return ret;
    }

    static {
        TOKEN_MAP = new EnumMap<JsonTokenWrapper, NodeType>(JsonTokenWrapper.class);
        TOKEN_MAP.put(JsonTokenWrapper.START_ARRAY, ARRAY);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_TRUE, BOOLEAN);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_FALSE, BOOLEAN);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_NUMBER_INT, INTEGER);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_NUMBER_FLOAT, NUMBER);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_NULL, NULL);
        TOKEN_MAP.put(JsonTokenWrapper.START_OBJECT, OBJECT);
        TOKEN_MAP.put(JsonTokenWrapper.VALUE_STRING, STRING);
    }
}

