/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch.mapping;

import com.flipkart.zjsonpatch.mapping.JacksonVersionException;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;

public final class JacksonVersionBridge {
    private static final ConcurrentHashMap<String, Class<?>> WRAPPER_CLASS_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static final String JACKSON2_NODE_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2NodeWrapper";
    private static final String JACKSON2_ARRAY_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ArrayNodeWrapper";
    private static final String JACKSON2_OBJECT_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ObjectNodeWrapper";
    private static final String JACKSON3_NODE_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3NodeWrapper";
    private static final String JACKSON3_ARRAY_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ArrayNodeWrapper";
    private static final String JACKSON3_OBJECT_WRAPPER = "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ObjectNodeWrapper";
    private static final String JACKSON2_JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    private static final String JACKSON2_ARRAY_NODE = "com.fasterxml.jackson.databind.node.ArrayNode";
    private static final String JACKSON2_OBJECT_NODE = "com.fasterxml.jackson.databind.node.ObjectNode";
    private static final String JACKSON3_JSON_NODE = "tools.jackson.databind.JsonNode";
    private static final String JACKSON3_ARRAY_NODE = "tools.jackson.databind.node.ArrayNode";
    private static final String JACKSON3_OBJECT_NODE = "tools.jackson.databind.node.ObjectNode";

    private JacksonVersionBridge() {
    }

    public static JsonNodeWrapper wrap(Object nativeNode) {
        if (nativeNode == null) {
            return null;
        }
        try {
            NodeTypeResolver resolver = JacksonVersionBridge.selectResolverFor(nativeNode);
            return resolver.wrapNode(nativeNode);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JacksonVersionException("Failed to wrap Jackson node: " + nativeNode.getClass().getName(), e);
        }
    }

    private static NodeTypeResolver selectResolverFor(Object nativeNode) {
        if (JacksonVersionBridge.isInstanceOf(nativeNode, JACKSON2_JSON_NODE)) {
            return NodeTypeResolver.JACKSON_2;
        }
        if (JacksonVersionBridge.isInstanceOf(nativeNode, JACKSON3_JSON_NODE)) {
            return NodeTypeResolver.JACKSON_3;
        }
        throw new IllegalArgumentException("Unknown Jackson node type: %s. Expected node extending com.fasterxml.jackson.databind.JsonNode (Jackson 2.x) or tools.jackson.databind.JsonNode (Jackson 3.x)".formatted(nativeNode.getClass().getName()));
    }

    private static JsonNodeWrapper createWrapper(String wrapperClassName, Object nativeNode) throws Exception {
        Constructor<?> constructor = JacksonVersionBridge.getConstructor(wrapperClassName);
        return (JsonNodeWrapper)constructor.newInstance(nativeNode);
    }

    private static Constructor<?> getConstructor(String wrapperClassName) {
        return CONSTRUCTOR_CACHE.computeIfAbsent(wrapperClassName, className -> {
            try {
                Class<?> wrapperClass = JacksonVersionBridge.getWrapperClass(className);
                Class<?> parameterType = JacksonVersionBridge.determineParameterType(className);
                return wrapperClass.getConstructor(parameterType);
            }
            catch (Exception e) {
                throw new JacksonVersionException("Failed to get constructor for wrapper class: %s".formatted(className), e);
            }
        });
    }

    private static Class<?> determineParameterType(String className) throws ClassNotFoundException {
        return switch (JacksonVersionBridge.getWrapperType(className)) {
            default -> throw new IncompatibleClassChangeError();
            case WrapperType.JACKSON2_ARRAY -> Class.forName(JACKSON2_ARRAY_NODE);
            case WrapperType.JACKSON2_OBJECT -> Class.forName(JACKSON2_OBJECT_NODE);
            case WrapperType.JACKSON2_NODE -> Class.forName(JACKSON2_JSON_NODE);
            case WrapperType.JACKSON3_ARRAY -> Class.forName(JACKSON3_ARRAY_NODE);
            case WrapperType.JACKSON3_OBJECT -> Class.forName(JACKSON3_OBJECT_NODE);
            case WrapperType.JACKSON3_NODE -> Class.forName(JACKSON3_JSON_NODE);
        };
    }

    private static WrapperType getWrapperType(String className) {
        boolean isJackson2 = className.contains("jackson2");
        boolean isJackson3 = className.contains("jackson3");
        boolean isArray = className.contains("ArrayNodeWrapper");
        boolean isObject = className.contains("ObjectNodeWrapper");
        if (isJackson2 && isArray) {
            return WrapperType.JACKSON2_ARRAY;
        }
        if (isJackson2 && isObject) {
            return WrapperType.JACKSON2_OBJECT;
        }
        if (isJackson2) {
            return WrapperType.JACKSON2_NODE;
        }
        if (isJackson3 && isArray) {
            return WrapperType.JACKSON3_ARRAY;
        }
        if (isJackson3 && isObject) {
            return WrapperType.JACKSON3_OBJECT;
        }
        if (isJackson3) {
            return WrapperType.JACKSON3_NODE;
        }
        throw new IllegalArgumentException("Unknown wrapper type: " + className);
    }

    private static Class<?> getWrapperClass(String wrapperClassName) {
        return WRAPPER_CLASS_CACHE.computeIfAbsent(wrapperClassName, className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JacksonVersionException("Wrapper class not found: %s. Ensure the corresponding Jackson version is available.".formatted(className), e);
            }
        });
    }

    private static boolean isInstanceOf(Object obj, String className) {
        Class clazz = CLASS_CACHE.computeIfAbsent(className, k -> {
            try {
                return Class.forName(k);
            }
            catch (ClassNotFoundException e) {
                return Void.TYPE;
            }
        });
        return clazz.isInstance(obj);
    }

    public static <T> T unwrap(JsonNodeWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        return (T)wrapper.getUnderlyingNode();
    }

    private static enum NodeTypeResolver {
        JACKSON_2(new NodeTypeMapping("com.fasterxml.jackson.databind.node.ArrayNode", "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ArrayNodeWrapper"), new NodeTypeMapping("com.fasterxml.jackson.databind.node.ObjectNode", "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2ObjectNodeWrapper"), new NodeTypeMapping("com.fasterxml.jackson.databind.JsonNode", "com.flipkart.zjsonpatch.mapping.jackson2.Jackson2NodeWrapper")),
        JACKSON_3(new NodeTypeMapping("tools.jackson.databind.node.ArrayNode", "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ArrayNodeWrapper"), new NodeTypeMapping("tools.jackson.databind.node.ObjectNode", "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3ObjectNodeWrapper"), new NodeTypeMapping("tools.jackson.databind.JsonNode", "com.flipkart.zjsonpatch.mapping.jackson3.Jackson3NodeWrapper"));

        private final NodeTypeMapping[] mappings;

        private NodeTypeResolver(NodeTypeMapping ... mappings) {
            this.mappings = mappings;
        }

        JsonNodeWrapper wrapNode(Object nativeNode) throws Exception {
            for (NodeTypeMapping mapping : this.mappings) {
                if (!JacksonVersionBridge.isInstanceOf(nativeNode, mapping.nodeType())) continue;
                return JacksonVersionBridge.createWrapper(mapping.wrapperClass(), nativeNode);
            }
            throw new IllegalArgumentException("Unsupported Jackson node type: %s".formatted(nativeNode.getClass()));
        }
    }

    private static enum WrapperType {
        JACKSON2_ARRAY,
        JACKSON2_OBJECT,
        JACKSON2_NODE,
        JACKSON3_ARRAY,
        JACKSON3_OBJECT,
        JACKSON3_NODE;

    }

    private record NodeTypeMapping(String nodeType, String wrapperClass) {
    }
}

