/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.flipkart.zjsonpatch.AbstractJsonPointer;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.mapping.JsonNodeWrapper;

class Diff {
    private final Operation operation;
    private final AbstractJsonPointer path;
    private final JsonNodeWrapper value;
    private AbstractJsonPointer toPath;
    private final JsonNodeWrapper srcValue;

    Diff(Operation operation, AbstractJsonPointer path, JsonNodeWrapper value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
        this.srcValue = null;
    }

    Diff(Operation operation, AbstractJsonPointer fromPath, AbstractJsonPointer toPath) {
        this.operation = operation;
        this.path = fromPath;
        this.toPath = toPath;
        this.value = null;
        this.srcValue = null;
    }

    Diff(Operation operation, AbstractJsonPointer path, JsonNodeWrapper srcValue, JsonNodeWrapper value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
        this.srcValue = srcValue;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AbstractJsonPointer getPath() {
        return this.path;
    }

    public JsonNodeWrapper getValue() {
        return this.value;
    }

    public static Diff generateDiff(Operation replace, AbstractJsonPointer path, JsonNodeWrapper target) {
        return new Diff(replace, path, target);
    }

    public static Diff generateDiff(Operation replace, AbstractJsonPointer path, JsonNodeWrapper source, JsonNodeWrapper target) {
        return new Diff(replace, path, source, target);
    }

    AbstractJsonPointer getToPath() {
        return this.toPath;
    }

    public JsonNodeWrapper getSrcValue() {
        return this.srcValue;
    }
}

