/*
 * Decompiled with CFR 0.152.
 */
package com.vicmikhailau.maskededittext;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.util.AttributeSet;
import android.widget.EditText;
import androidx.appcompat.widget.AppCompatEditText;
import com.vicmikhailau.maskededittext.IFormattedString;
import com.vicmikhailau.maskededittext.MaskedFormatter;
import com.vicmikhailau.maskededittext.MaskedWatcher;
import com.vicmikhailau.maskededittext.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/vicmikhailau/maskededittext/MaskedEditText;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mMaskedFormatter", "Lcom/vicmikhailau/maskededittext/MaskedFormatter;", "mMaskedWatcher", "Lcom/vicmikhailau/maskededittext/MaskedWatcher;", "maskString", "", "getMaskString", "()Ljava/lang/String;", "unMaskedText", "getUnMaskedText", "setMask", "", "mMaskStr", "MaskedEditText_release"})
public final class MaskedEditText
extends AppCompatEditText {
    @Nullable
    private MaskedFormatter mMaskedFormatter;
    @Nullable
    private MaskedWatcher mMaskedWatcher;

    public MaskedEditText(@NotNull Context context, @NotNull AttributeSet attrs) {
        String maskStr;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MaskedEditText);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttributes(attrs, R.styleable.MaskedEditText)");
        TypedArray typedArray2 = typedArray;
        if (typedArray2.hasValue(R.styleable.MaskedEditText_mask) && (maskStr = typedArray2.getString(R.styleable.MaskedEditText_mask)) != null) {
            CharSequence charSequence = maskStr;
            boolean bl = false;
            if (charSequence.length() > 0) {
                this.setMask(maskStr);
            }
        }
        typedArray2.recycle();
    }

    @Nullable
    public final String getMaskString() {
        MaskedFormatter maskedFormatter = this.mMaskedFormatter;
        return maskedFormatter == null ? null : maskedFormatter.getMaskString();
    }

    @Nullable
    public final String getUnMaskedText() {
        IFormattedString iFormattedString;
        Editable editable = this.getText();
        String currentText = editable == null ? null : editable.toString();
        String string = currentText;
        if (string == null) {
            iFormattedString = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            MaskedFormatter maskedFormatter = this.mMaskedFormatter;
            iFormattedString = maskedFormatter == null ? null : maskedFormatter.formatString(it);
        }
        IFormattedString formattedString = iFormattedString;
        string = formattedString;
        return string == null ? null : string.getUnMaskedString();
    }

    public final void setMask(@NotNull String mMaskStr) {
        MaskedFormatter maskedFormatter;
        Intrinsics.checkNotNullParameter((Object)mMaskStr, (String)"mMaskStr");
        this.mMaskedFormatter = new MaskedFormatter(mMaskStr);
        if (this.mMaskedWatcher != null) {
            this.removeTextChangedListener(this.mMaskedWatcher);
        }
        if ((maskedFormatter = this.mMaskedFormatter) != null) {
            MaskedFormatter maskedFormatter2 = maskedFormatter;
            boolean bl = false;
            boolean bl2 = false;
            MaskedFormatter it = maskedFormatter2;
            boolean bl3 = false;
            this.mMaskedWatcher = new MaskedWatcher(it, (EditText)this);
        }
        this.addTextChangedListener(this.mMaskedWatcher);
    }
}

