/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.utils;

import org.tron.trident.utils.Numeric;

public class TokenValidator {
    public static void validateCallValue(long callValue) {
        if (callValue < 0L) {
            throw new IllegalArgumentException("callValue must be >= 0");
        }
    }

    public static void validateTokenId(String tokenId) {
        if (tokenId == null || tokenId.isEmpty() || "_".equals(tokenId)) {
            return;
        }
        String trimmedTokenId = tokenId.trim();
        if (!Numeric.isNumericString(trimmedTokenId)) {
            throw new IllegalArgumentException("Token ID must be a valid number");
        }
        long tokenValue = Long.parseLong(trimmedTokenId);
        if (tokenValue < 1000000L) {
            throw new IllegalArgumentException("TRC10 token ID must ge 1000000");
        }
    }

    public static void validateTokenValue(long tokenValue) {
        if (tokenValue < 0L) {
            throw new IllegalArgumentException("tokenValue must be >= 0");
        }
    }
}

