/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.core.contract.abi;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import org.tron.trident.proto.Common;

public class AbiUtils {
    public static void loadAbiFromJson(String abiString, Common.SmartContract.ABI.Builder builder) {
        if (abiString == null || abiString.isEmpty()) {
            return;
        }
        Common.SmartContract.ABI abi = AbiUtils.jsonStr2ABI(abiString);
        builder.mergeFrom(abi);
    }

    public static Common.SmartContract.ABI jsonStr2ABI(String jsonStr) {
        if (jsonStr == null) {
            throw new IllegalArgumentException("ABI json string cannot be null");
        }
        JSONArray abiEntryArray = AbiUtils.getABIEntryArray(jsonStr);
        Common.SmartContract.ABI.Builder abiBuilder = Common.SmartContract.ABI.newBuilder();
        for (Object objectABIEntry : abiEntryArray) {
            Common.SmartContract.ABI.Entry entry = AbiUtils.parseAbiEntry((JSONObject)objectABIEntry);
            abiBuilder.addEntrys(entry);
        }
        return abiBuilder.build();
    }

    private static JSONArray getABIEntryArray(String jsonStr) {
        try {
            Object object = JSON.parse((String)jsonStr);
            if (object == null) {
                throw new IllegalArgumentException("Invalid JSON format: parsing result is null");
            }
            if (object instanceof JSONArray) {
                return (JSONArray)object;
            }
            if (object instanceof JSONObject) {
                JSONArray entries = ((JSONObject)object).getJSONArray("entrys");
                if (entries == null) {
                    throw new IllegalArgumentException("Missing entrys field in JSON object");
                }
                return entries;
            }
            throw new IllegalArgumentException("Invalid JSON format: expected JSONArray or JSONObject");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON: " + e.getMessage(), e);
        }
    }

    private static Common.SmartContract.ABI.Entry parseAbiEntry(JSONObject entryObj) {
        if (entryObj == null) {
            throw new IllegalArgumentException("entryObj can not be null");
        }
        String entryType = entryObj.getString("type");
        if (entryType == null) {
            throw new IllegalArgumentException("Missing type in ABI entry");
        }
        Common.SmartContract.ABI.Entry.Builder entryBuilder = AbiUtils.buildBaseEntry(entryObj, entryType);
        AbiUtils.processInputs(entryObj, entryBuilder, entryType);
        AbiUtils.processOutputs(entryObj, entryBuilder);
        return entryBuilder.build();
    }

    private static Common.SmartContract.ABI.Entry.Builder buildBaseEntry(JSONObject entryObj, String entryType) {
        Common.SmartContract.ABI.Entry.Builder builder = Common.SmartContract.ABI.Entry.newBuilder().setAnonymous(entryObj.getBooleanValue("anonymous", false)).setConstant(entryObj.getBooleanValue("constant", false));
        String name = entryObj.getString("name");
        if (name != null) {
            builder.setName(name);
        }
        builder.setType(AbiUtils.getEntryType(entryType));
        builder.setPayable(entryObj.getBooleanValue("payable", false));
        String stateMutability = entryObj.getString("stateMutability");
        if (stateMutability != null) {
            builder.setStateMutability(AbiUtils.getStateMutability(stateMutability));
        }
        return builder;
    }

    private static void processInputs(JSONObject abiObject, Common.SmartContract.ABI.Entry.Builder entryBuilder, String type) {
        JSONArray inputs = abiObject.getJSONArray("inputs");
        if (inputs == null) {
            if (!"fallback".equalsIgnoreCase(type) && !"receive".equalsIgnoreCase(type)) {
                throw new IllegalArgumentException("Missing inputs for not-fallback/receive function");
            }
            return;
        }
        for (Object input : inputs) {
            entryBuilder.addInputs(AbiUtils.parseParam((JSONObject)input));
        }
    }

    private static void processOutputs(JSONObject abiObject, Common.SmartContract.ABI.Entry.Builder entryBuilder) {
        JSONArray outputs = abiObject.getJSONArray("outputs");
        if (outputs != null) {
            for (Object output : outputs) {
                entryBuilder.addOutputs(AbiUtils.parseParam((JSONObject)output));
            }
        }
    }

    private static Common.SmartContract.ABI.Entry.Param parseParam(JSONObject paramObject) {
        String type = paramObject.getString("type");
        String name = paramObject.getString("name");
        if (type == null || name == null) {
            throw new IllegalArgumentException("Missing type or name in parameter");
        }
        return Common.SmartContract.ABI.Entry.Param.newBuilder().setIndexed(paramObject.getBooleanValue("indexed", false)).setName(name).setType(type).build();
    }

    private static Common.SmartContract.ABI.Entry.EntryType getEntryType(String type) {
        switch (type.toLowerCase()) {
            case "constructor": {
                return Common.SmartContract.ABI.Entry.EntryType.Constructor;
            }
            case "function": {
                return Common.SmartContract.ABI.Entry.EntryType.Function;
            }
            case "event": {
                return Common.SmartContract.ABI.Entry.EntryType.Event;
            }
            case "fallback": {
                return Common.SmartContract.ABI.Entry.EntryType.Fallback;
            }
            case "receive": {
                return Common.SmartContract.ABI.Entry.EntryType.Receive;
            }
            case "error": {
                return Common.SmartContract.ABI.Entry.EntryType.Error;
            }
        }
        return Common.SmartContract.ABI.Entry.EntryType.UnknownEntryType;
    }

    private static Common.SmartContract.ABI.Entry.StateMutabilityType getStateMutability(String stateMutability) {
        switch (stateMutability.toLowerCase()) {
            case "pure": {
                return Common.SmartContract.ABI.Entry.StateMutabilityType.Pure;
            }
            case "view": {
                return Common.SmartContract.ABI.Entry.StateMutabilityType.View;
            }
            case "nonpayable": {
                return Common.SmartContract.ABI.Entry.StateMutabilityType.Nonpayable;
            }
            case "payable": {
                return Common.SmartContract.ABI.Entry.StateMutabilityType.Payable;
            }
        }
        return Common.SmartContract.ABI.Entry.StateMutabilityType.UnknownMutabilityType;
    }
}

