/*
 * Copyright 2019 Web3 Labs Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package org.tron.trident.utils;

import java.util.List;

/**
 * String utility functions.
 */
public class Strings {

  private Strings() {
  }

  public static String toCsv(List<String> src) {
    // return src == null ? null : String.join(", ", src.toArray(new String[0]));
    return join(src, ", ");
  }

  public static String join(List<String> src, String delimiter) {
    return src == null ? null : String.join(delimiter, src.toArray(new String[0]));
  }

  public static String capitaliseFirstLetter(String string) {
    if (string == null || string.length() == 0) {
      return string;
    } else {
      return string.substring(0, 1).toUpperCase() + string.substring(1);
    }
  }

  public static String lowercaseFirstLetter(String string) {
    if (string == null || string.length() == 0) {
      return string;
    } else {
      return string.substring(0, 1).toLowerCase() + string.substring(1);
    }
  }

  public static String zeros(int n) {
    return repeat('0', n);
  }

  public static String repeat(char value, int n) {
    return new String(new char[n]).replace("\0", String.valueOf(value));
  }

  public static boolean isEmpty(String s) {
    return s == null || s.length() == 0;
  }
}
