/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.GetClassByNameFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.util.CleanableSupplier;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

public interface GetLoadedClassesRetrieverFunction
extends Function<ClassLoader, CleanableSupplier<Collection<Class<?>>>> {

    public static interface Native
    extends GetLoadedClassesRetrieverFunction {

        public static class ForJava7
        implements Native {
            protected Field classesField;

            public ForJava7(Map<Object, Object> context) throws InitializeException {
                this.checkNativeEngine();
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.classesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes");
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
                if (classLoader == null) {
                    throw new NullPointerException("Input classLoader parameter can't be null");
                }
                return new CleanableSupplier<Collection<Class<?>>>(){
                    Collection<Class<?>> classes;

                    @Override
                    public Collection<Class<?>> get() {
                        if (this.classes != null) {
                            return this.classes;
                        }
                        this.classes = (Collection)Narcissus.getField((Object)classLoader, (Field)ForJava7.this.classesField);
                        return this.classes;
                    }

                    @Override
                    public void clear() {
                        this.get();
                        if (this.classes != null) {
                            this.classes.clear();
                        }
                    }
                };
            }

            public static class ForSemeru
            extends io.github.toolfactory.jvm.function.catalog.GetLoadedClassesRetrieverFunction$ForJava7$ForSemeru {
                public ForSemeru(Map<Object, Object> context) {
                    super(context);
                }

                @Override
                protected ForJava7.ForSemeru.ClassNameBasedLockSupplier buildClassNameBasedLockSupplier(final Map<Object, Object> context) {
                    return new ForJava7.ForSemeru.ClassNameBasedLockSupplier(){
                        protected ThrowExceptionFunction throwExceptionFunction;
                        {
                            this.throwExceptionFunction = ObjectProvider.get(context).getOrBuildObject(ThrowExceptionFunction.class, context);
                        }

                        @Override
                        public Hashtable<String, Object> get(ClassLoader classLoader) {
                            return (Hashtable)Narcissus.getField((Object)classLoader, (Field)ForSemeru.this.classNameBasedLockField);
                        }

                        @Override
                        protected ClassLoader getClassLoader(Class<?> cls) {
                            return (ClassLoader)Narcissus.getField(cls, (Field)ForSemeru.this.classLoaderField);
                        }
                    };
                }
            }
        }
    }

    public static class ForJava7
    implements GetLoadedClassesRetrieverFunction {
        protected Unsafe unsafe;
        protected Long loadedClassesVectorMemoryOffset;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            this.loadedClassesVectorMemoryOffset = this.unsafe.objectFieldOffset((Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes"));
        }

        @Override
        public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
            if (classLoader == null) {
                throw new NullPointerException("Input classLoader parameter can't be null");
            }
            return new CleanableSupplier<Collection<Class<?>>>(){
                Collection<Class<?>> classes;

                @Override
                public Collection<Class<?>> get() {
                    if (this.classes != null) {
                        return this.classes;
                    }
                    this.classes = (Collection)ForJava7.this.unsafe.getObject(classLoader, ForJava7.this.loadedClassesVectorMemoryOffset);
                    return this.classes;
                }

                @Override
                public void clear() {
                    this.get();
                    if (this.classes != null) {
                        this.classes.clear();
                    }
                }
            };
        }

        public static class ForSemeru
        implements GetLoadedClassesRetrieverFunction {
            protected ClassNameBasedLockSupplier classNameBasedLockSupplier;
            protected Field classNameBasedLockField;
            protected Field classLoaderField;
            protected GetClassByNameFunction getClassByNameFunction;

            public ForSemeru(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.getClassByNameFunction = functionProvider.getOrBuildObject(GetClassByNameFunction.class, context);
                this.classNameBasedLockField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classNameBasedLock");
                this.classLoaderField = (Field)getDeclaredFieldFunction.apply(Class.class, "classLoader");
                this.classNameBasedLockSupplier = this.buildClassNameBasedLockSupplier(context);
            }

            protected ClassNameBasedLockSupplier buildClassNameBasedLockSupplier(final Map<Object, Object> context) {
                return new ClassNameBasedLockSupplier(){
                    protected Unsafe unsafe;
                    protected Long classNameBasedLockHashTableOffset;
                    protected Long classLoaderFieldOffset;
                    {
                        this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
                        this.classNameBasedLockHashTableOffset = this.unsafe.objectFieldOffset(ForSemeru.this.classNameBasedLockField);
                        this.classLoaderFieldOffset = this.unsafe.objectFieldOffset(ForSemeru.this.classLoaderField);
                    }

                    @Override
                    public Hashtable<String, Object> get(ClassLoader classLoader) {
                        return (Hashtable)this.unsafe.getObject(classLoader, this.classNameBasedLockHashTableOffset);
                    }

                    @Override
                    protected ClassLoader getClassLoader(Class<?> cls) {
                        return (ClassLoader)this.unsafe.getObject(cls, this.classLoaderFieldOffset);
                    }
                };
            }

            @Override
            public CleanableSupplier<Collection<Class<?>>> apply(final ClassLoader classLoader) {
                return new CleanableSupplier<Collection<Class<?>>>(){
                    Hashtable<String, Object> classNameBasedLock;
                    Collection<Class<?>> loadedClasses = ConcurrentHashMap.newKeySet();

                    @Override
                    public Collection<Class<?>> get() {
                        Hashtable<Object, Object> loadedClassesHS = null;
                        Hashtable<String, Object> loadedClassesHSTemp = this.getClassNameBasedLock();
                        while (loadedClassesHS == null) {
                            try {
                                if (loadedClassesHSTemp != null) {
                                    loadedClassesHS = new Hashtable<String, Object>(loadedClassesHSTemp);
                                    continue;
                                }
                                loadedClassesHS = new Hashtable();
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {}
                        }
                        for (Map.Entry entry : loadedClassesHS.entrySet()) {
                            try {
                                Class cls = (Class)ForSemeru.this.getClassByNameFunction.apply(entry.getKey(), false, classLoader, CleanableSupplier.class);
                                if (ForSemeru.this.classNameBasedLockSupplier.getClassLoader(cls) != classLoader) continue;
                                this.loadedClasses.add(cls);
                            }
                            catch (Throwable throwable) {}
                        }
                        return this.loadedClasses;
                    }

                    @Override
                    public void clear() {
                        if (this.classNameBasedLock != null) {
                            this.classNameBasedLock.clear();
                        }
                        this.loadedClasses.clear();
                    }

                    private Hashtable<String, Object> getClassNameBasedLock() {
                        if (this.classNameBasedLock != null) {
                            return this.classNameBasedLock;
                        }
                        this.classNameBasedLock = ForSemeru.this.classNameBasedLockSupplier.get(classLoader);
                        return this.classNameBasedLock;
                    }
                };
            }

            protected static abstract class ClassNameBasedLockSupplier {
                protected ClassNameBasedLockSupplier() {
                }

                protected abstract Hashtable<String, Object> get(ClassLoader var1);

                protected abstract ClassLoader getClassLoader(Class<?> var1);
            }
        }
    }
}

