/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.PrivateLookupInMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.util.JavaClass;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.Unsafe;

public interface DefineHookClassFunction
extends BiFunction<Class<?>, byte[], Class<?>> {

    public static class ForJava17
    extends Abst {
        protected MethodHandle privateLookupInMethodHandle;
        protected MethodHandles.Lookup consulter;

        public ForJava17(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException {
            super(context);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.consulter = (MethodHandles.Lookup)functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get();
            this.defineHookClassMethodHandle = this.consulter.findSpecial(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class), MethodHandles.Lookup.class);
            this.privateLookupInMethodHandle = (MethodHandle)functionProvider.getOrBuildObject(PrivateLookupInMethodHandleSupplier.class, context).get();
        }

        @Override
        public Class<?> apply(Class<?> clientClass, byte[] byteCode) {
            try {
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)this.privateLookupInMethodHandle.invokeWithArguments(clientClass, this.consulter);
                try {
                    return (Class)this.defineHookClassMethodHandle.invokeWithArguments(lookup, byteCode);
                }
                catch (LinkageError exc) {
                    try {
                        return Class.forName(JavaClass.create(ByteBuffer.wrap(byteCode)).getName());
                    }
                    catch (Throwable inExc) {
                        return (Class)this.throwExceptionFunction.apply(inExc, new Object[0]);
                    }
                }
            }
            catch (Throwable exc) {
                return (Class)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
        }
    }

    public static class ForJava9
    extends ForJava7 {
        public ForJava9(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException, Throwable {
            super(context);
        }

        @Override
        public MethodHandles.Lookup retrieveConsulter(MethodHandles.Lookup consulter, MethodHandle lookupMethod) throws Throwable {
            return (MethodHandles.Lookup)lookupMethod.invokeWithArguments(this.unsafe.getClass(), consulter);
        }
    }

    public static class ForJava7
    extends Abst {
        protected Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) throws NoSuchMethodException, IllegalAccessException, Throwable {
            super(context);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            this.defineHookClassMethodHandle = this.retrieveConsulter((MethodHandles.Lookup)functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get(), (MethodHandle)functionProvider.getOrBuildObject(PrivateLookupInMethodHandleSupplier.class, context).get()).findSpecial(this.unsafe.getClass(), "defineAnonymousClass", MethodType.methodType(Class.class, Class.class, byte[].class, Object[].class), this.unsafe.getClass());
        }

        public MethodHandles.Lookup retrieveConsulter(MethodHandles.Lookup consulter, MethodHandle privateLookupInMethodHandle) throws Throwable {
            return (MethodHandles.Lookup)privateLookupInMethodHandle.invokeWithArguments(consulter, this.unsafe.getClass());
        }

        @Override
        public Class<?> apply(Class<?> clientClass, byte[] byteCode) {
            try {
                return (Class)this.defineHookClassMethodHandle.invokeWithArguments(this.unsafe, clientClass, byteCode, null);
            }
            catch (Throwable exc) {
                return (Class)this.throwExceptionFunction.apply(exc, new Object[0]);
            }
        }
    }

    public static abstract class Abst
    implements DefineHookClassFunction {
        protected MethodHandle defineHookClassMethodHandle;
        protected ThrowExceptionFunction throwExceptionFunction;

        public Abst(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
        }
    }
}

