/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.opus;

import io.github.thibaultbee.streampack.internal.utils.av.audio.opus.IdentificationHeader;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/OpusCsdParser;", "", "()V", "Companion", "core_release"})
public final class OpusCsdParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MARKER_PREFIX = "AOPUS";
    private static final int MARKER_SIZE = 8;
    @NotNull
    private static final String HEADER_MARKER = "AOPUSHDR";
    @NotNull
    private static final String CODEC_DELAY_MARKER = "AOPUSDLY";
    @NotNull
    private static final String SEEK_PREROLL_MARKER = "AOPUSPRL";
    private static final int LENGTH_SIZE = 8;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00102\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/OpusCsdParser$Companion;", "", "()V", "CODEC_DELAY_MARKER", "", "HEADER_MARKER", "LENGTH_SIZE", "", "MARKER_PREFIX", "MARKER_SIZE", "SEEK_PREROLL_MARKER", "isCsdSyntax", "", "buffer", "Ljava/nio/ByteBuffer;", "parse", "Lkotlin/Triple;", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/opus/IdentificationHeader;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCsdSyntax(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return ByteBufferExtensionsKt.startWith(buffer, OpusCsdParser.MARKER_PREFIX);
        }

        @NotNull
        public final Triple<IdentificationHeader, ByteBuffer, ByteBuffer> parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (IdentificationHeader.Companion.isIdentificationHeader(buffer)) {
                return new Triple((Object)IdentificationHeader.Companion.parse(buffer), null, null);
            }
            IdentificationHeader identificationHeader = null;
            while (buffer.remaining() >= 16) {
                String marker = ByteBufferExtensionsKt.getString(buffer, 8);
                long length = ByteBufferExtensionsKt.getLong(buffer, true);
                int position = buffer.position();
                switch (marker) {
                    case "AOPUSHDR": {
                        identificationHeader = IdentificationHeader.Companion.parse(buffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Opus marker: " + marker);
                    }
                    case "AOPUSDLY": 
                    case "AOPUSPRL": 
                }
                buffer.position(position + (int)length);
            }
            if (identificationHeader == null) {
                throw new IllegalArgumentException("Opus identification header not found");
            }
            return new Triple(identificationHeader, null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

