/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio;

import android.media.MediaFormat;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.utils.av.audio.AudioObjectType;
import io.github.thibaultbee.streampack.internal.utils.av.audio.ChannelConfiguration;
import io.github.thibaultbee.streampack.internal.utils.av.audio.SamplingFrequencyIndex;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.config.ELDSpecificConfig;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.config.GASpecificConfig;
import io.github.thibaultbee.streampack.internal.utils.av.audio.aac.config.SpecificConfig;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBuffer;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.BitBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 22\u00020\u0001:\u000212BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016JP\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u00d6\u0003J\t\u0010)\u001a\u00020\u0005H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u000200H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBufferWriter;", "audioObjectType", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "sampleRate", "", "channelConfiguration", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;", "extension", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;", "specificConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/config/SpecificConfig;", "epConfig", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;ILio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/config/SpecificConfig;Ljava/lang/Integer;)V", "getAudioObjectType", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "bitSize", "getBitSize", "()I", "getChannelConfiguration", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;", "getEpConfig", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getExtension", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;", "getSampleRate", "getSpecificConfig", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/config/SpecificConfig;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;ILio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/config/SpecificConfig;Ljava/lang/Integer;)Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig;", "equals", "", "other", "", "hashCode", "toString", "", "write", "", "output", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "Ljava/nio/ByteBuffer;", "AudioSpecificConfigExtension", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nAudioSpecificConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSpecificConfig.kt\nio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1#2:352\n*E\n"})
public final class AudioSpecificConfig
extends BitBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioObjectType audioObjectType;
    private final int sampleRate;
    @NotNull
    private final ChannelConfiguration channelConfiguration;
    @Nullable
    private final AudioSpecificConfigExtension extension;
    @Nullable
    private final SpecificConfig specificConfig;
    @Nullable
    private final Integer epConfig;
    private final int bitSize;

    public AudioSpecificConfig(@NotNull AudioObjectType audioObjectType, int sampleRate, @NotNull ChannelConfiguration channelConfiguration, @Nullable AudioSpecificConfigExtension extension, @Nullable SpecificConfig specificConfig, @Nullable Integer epConfig) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
        Intrinsics.checkNotNullParameter((Object)((Object)channelConfiguration), (String)"channelConfiguration");
        this.audioObjectType = audioObjectType;
        this.sampleRate = sampleRate;
        this.channelConfiguration = channelConfiguration;
        this.extension = extension;
        this.specificConfig = specificConfig;
        this.epConfig = epConfig;
        AudioSpecificConfig audioSpecificConfig = this;
        AudioSpecificConfigExtension audioSpecificConfigExtension = this.extension;
        SpecificConfig specificConfig2 = this.specificConfig;
        int n2 = AudioSpecificConfig.Companion.getAudioObjectTypeSize(this.audioObjectType) + AudioSpecificConfig.Companion.getSamplingFrequencySize(this.sampleRate) + 4 + (audioSpecificConfigExtension != null ? audioSpecificConfigExtension.getBitSize() : 0) + (specificConfig2 != null ? specificConfig2.getBitSize() : 0);
        Integer n3 = this.epConfig;
        if (n3 != null) {
            int n4 = ((Number)n3).intValue();
            int n5 = n2;
            AudioSpecificConfig audioSpecificConfig2 = audioSpecificConfig;
            boolean bl = false;
            int n6 = 2;
            audioSpecificConfig = audioSpecificConfig2;
            n2 = n5;
            n = n6;
        } else {
            n = 0;
        }
        audioSpecificConfig.bitSize = n2 + n;
        if ((this.audioObjectType == AudioObjectType.PS || this.audioObjectType == AudioObjectType.SBR) && this.extension == null) {
            boolean $i$a$-requireNotNull-AudioSpecificConfig$42 = false;
            String $i$a$-requireNotNull-AudioSpecificConfig$42 = "Extension is required for PS or SBR";
            throw new IllegalArgumentException($i$a$-requireNotNull-AudioSpecificConfig$42.toString());
        }
        if (AudioSpecificConfig.Companion.hasSpecificConfig(this.audioObjectType) && this.specificConfig == null) {
            boolean $i$a$-requireNotNull-AudioSpecificConfig$52 = false;
            String $i$a$-requireNotNull-AudioSpecificConfig$52 = "Specific config is required for " + this.audioObjectType.name();
            throw new IllegalArgumentException($i$a$-requireNotNull-AudioSpecificConfig$52.toString());
        }
        if (AudioSpecificConfig.Companion.hasErrorProtectionSpecificConfig(this.audioObjectType)) {
            if (this.epConfig == null) {
                boolean bl = false;
                String string2 = "Error protection config is required for " + this.audioObjectType.name();
                throw new IllegalArgumentException(string2.toString());
            }
        }
    }

    public /* synthetic */ AudioSpecificConfig(AudioObjectType audioObjectType, int n, ChannelConfiguration channelConfiguration, AudioSpecificConfigExtension audioSpecificConfigExtension, SpecificConfig specificConfig, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            audioSpecificConfigExtension = null;
        }
        if ((n3 & 0x10) != 0) {
            specificConfig = null;
        }
        if ((n3 & 0x20) != 0) {
            n2 = null;
        }
        this(audioObjectType, n, channelConfiguration, audioSpecificConfigExtension, specificConfig, n2);
    }

    @NotNull
    public final AudioObjectType getAudioObjectType() {
        return this.audioObjectType;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    @NotNull
    public final ChannelConfiguration getChannelConfiguration() {
        return this.channelConfiguration;
    }

    @Nullable
    public final AudioSpecificConfigExtension getExtension() {
        return this.extension;
    }

    @Nullable
    public final SpecificConfig getSpecificConfig() {
        return this.specificConfig;
    }

    @Nullable
    public final Integer getEpConfig() {
        return this.epConfig;
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        SamplingFrequencyIndex frequencyIndex = SamplingFrequencyIndex.Companion.fromSampleRate(this.sampleRate);
        if (this.audioObjectType.getValue() > 31) {
            throw new NotImplementedError("Codec not supported");
        }
        ByteBufferExtensionsKt.put(output, this.audioObjectType.getValue() << 3 | frequencyIndex.getValue() >> 1);
        if (frequencyIndex == SamplingFrequencyIndex.EXPLICIT) {
            throw new NotImplementedError("Explicit frequency is not supported");
        }
        ByteBufferExtensionsKt.put(output, (frequencyIndex.getValue() & 1) << 7 | this.channelConfiguration.getValue() << 3);
    }

    @Override
    public void write(@NotNull BitBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @NotNull
    public final AudioObjectType component1() {
        return this.audioObjectType;
    }

    public final int component2() {
        return this.sampleRate;
    }

    @NotNull
    public final ChannelConfiguration component3() {
        return this.channelConfiguration;
    }

    @Nullable
    public final AudioSpecificConfigExtension component4() {
        return this.extension;
    }

    @Nullable
    public final SpecificConfig component5() {
        return this.specificConfig;
    }

    @Nullable
    public final Integer component6() {
        return this.epConfig;
    }

    @NotNull
    public final AudioSpecificConfig copy(@NotNull AudioObjectType audioObjectType, int sampleRate, @NotNull ChannelConfiguration channelConfiguration, @Nullable AudioSpecificConfigExtension extension, @Nullable SpecificConfig specificConfig, @Nullable Integer epConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
        Intrinsics.checkNotNullParameter((Object)((Object)channelConfiguration), (String)"channelConfiguration");
        return new AudioSpecificConfig(audioObjectType, sampleRate, channelConfiguration, extension, specificConfig, epConfig);
    }

    public static /* synthetic */ AudioSpecificConfig copy$default(AudioSpecificConfig audioSpecificConfig, AudioObjectType audioObjectType, int n, ChannelConfiguration channelConfiguration, AudioSpecificConfigExtension audioSpecificConfigExtension, SpecificConfig specificConfig, Integer n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            audioObjectType = audioSpecificConfig.audioObjectType;
        }
        if ((n3 & 2) != 0) {
            n = audioSpecificConfig.sampleRate;
        }
        if ((n3 & 4) != 0) {
            channelConfiguration = audioSpecificConfig.channelConfiguration;
        }
        if ((n3 & 8) != 0) {
            audioSpecificConfigExtension = audioSpecificConfig.extension;
        }
        if ((n3 & 0x10) != 0) {
            specificConfig = audioSpecificConfig.specificConfig;
        }
        if ((n3 & 0x20) != 0) {
            n2 = audioSpecificConfig.epConfig;
        }
        return audioSpecificConfig.copy(audioObjectType, n, channelConfiguration, audioSpecificConfigExtension, specificConfig, n2);
    }

    @NotNull
    public String toString() {
        return "AudioSpecificConfig(audioObjectType=" + (Object)((Object)this.audioObjectType) + ", sampleRate=" + this.sampleRate + ", channelConfiguration=" + (Object)((Object)this.channelConfiguration) + ", extension=" + this.extension + ", specificConfig=" + this.specificConfig + ", epConfig=" + this.epConfig + ')';
    }

    public int hashCode() {
        int result = this.audioObjectType.hashCode();
        result = result * 31 + Integer.hashCode(this.sampleRate);
        result = result * 31 + this.channelConfiguration.hashCode();
        result = result * 31 + (this.extension == null ? 0 : this.extension.hashCode());
        result = result * 31 + (this.specificConfig == null ? 0 : this.specificConfig.hashCode());
        result = result * 31 + (this.epConfig == null ? 0 : ((Object)this.epConfig).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioSpecificConfig)) {
            return false;
        }
        AudioSpecificConfig audioSpecificConfig = (AudioSpecificConfig)other;
        if (this.audioObjectType != audioSpecificConfig.audioObjectType) {
            return false;
        }
        if (this.sampleRate != audioSpecificConfig.sampleRate) {
            return false;
        }
        if (this.channelConfiguration != audioSpecificConfig.channelConfiguration) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.extension, (Object)audioSpecificConfig.extension)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.specificConfig, (Object)audioSpecificConfig.specificConfig)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.epConfig, (Object)audioSpecificConfig.epConfig);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006$"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBufferWriter;", "audioObjectType", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "sampleRate", "", "channelConfiguration", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;", "extensionAudioObjectType", "(Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;ILio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;)V", "getAudioObjectType", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "bitSize", "getBitSize", "()I", "getChannelConfiguration", "()Lio/github/thibaultbee/streampack/internal/utils/av/audio/ChannelConfiguration;", "getExtensionAudioObjectType", "getSampleRate", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write", "", "output", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "Companion", "core_release"})
    @SourceDebugExtension(value={"SMAP\nAudioSpecificConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioSpecificConfig.kt\nio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n1#2:352\n*E\n"})
    public static final class AudioSpecificConfigExtension
    extends BitBufferWriter {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final AudioObjectType audioObjectType;
        private final int sampleRate;
        @Nullable
        private final ChannelConfiguration channelConfiguration;
        @NotNull
        private final AudioObjectType extensionAudioObjectType;
        private final int bitSize;

        public AudioSpecificConfigExtension(@NotNull AudioObjectType audioObjectType, int sampleRate, @Nullable ChannelConfiguration channelConfiguration, @NotNull AudioObjectType extensionAudioObjectType) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
            Intrinsics.checkNotNullParameter((Object)((Object)extensionAudioObjectType), (String)"extensionAudioObjectType");
            this.audioObjectType = audioObjectType;
            this.sampleRate = sampleRate;
            this.channelConfiguration = channelConfiguration;
            this.extensionAudioObjectType = extensionAudioObjectType;
            AudioSpecificConfigExtension audioSpecificConfigExtension = this;
            int n2 = Companion.getSamplingFrequencySize(this.sampleRate) + Companion.getAudioObjectTypeSize(this.audioObjectType);
            ChannelConfiguration channelConfiguration2 = this.channelConfiguration;
            if (channelConfiguration2 != null) {
                ChannelConfiguration channelConfiguration3 = channelConfiguration2;
                int n3 = n2;
                AudioSpecificConfigExtension audioSpecificConfigExtension2 = audioSpecificConfigExtension;
                boolean bl = false;
                int n4 = 4;
                audioSpecificConfigExtension = audioSpecificConfigExtension2;
                n2 = n3;
                n = n4;
            } else {
                n = 0;
            }
            audioSpecificConfigExtension.bitSize = n2 + n;
            if (this.audioObjectType == AudioObjectType.ER_BSAC) {
                if (this.channelConfiguration == null) {
                    boolean bl = false;
                    String string2 = "Channel configuration is required for ER_BSAC";
                    throw new IllegalArgumentException(string2.toString());
                }
            }
        }

        public /* synthetic */ AudioSpecificConfigExtension(AudioObjectType audioObjectType, int n, ChannelConfiguration channelConfiguration, AudioObjectType audioObjectType2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                audioObjectType2 = AudioObjectType.SBR;
            }
            this(audioObjectType, n, channelConfiguration, audioObjectType2);
        }

        @NotNull
        public final AudioObjectType getAudioObjectType() {
            return this.audioObjectType;
        }

        public final int getSampleRate() {
            return this.sampleRate;
        }

        @Nullable
        public final ChannelConfiguration getChannelConfiguration() {
            return this.channelConfiguration;
        }

        @NotNull
        public final AudioObjectType getExtensionAudioObjectType() {
            return this.extensionAudioObjectType;
        }

        @Override
        public int getBitSize() {
            return this.bitSize;
        }

        @Override
        public void write(@NotNull BitBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            String string2 = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @NotNull
        public final AudioObjectType component1() {
            return this.audioObjectType;
        }

        public final int component2() {
            return this.sampleRate;
        }

        @Nullable
        public final ChannelConfiguration component3() {
            return this.channelConfiguration;
        }

        @NotNull
        public final AudioObjectType component4() {
            return this.extensionAudioObjectType;
        }

        @NotNull
        public final AudioSpecificConfigExtension copy(@NotNull AudioObjectType audioObjectType, int sampleRate, @Nullable ChannelConfiguration channelConfiguration, @NotNull AudioObjectType extensionAudioObjectType) {
            Intrinsics.checkNotNullParameter((Object)((Object)audioObjectType), (String)"audioObjectType");
            Intrinsics.checkNotNullParameter((Object)((Object)extensionAudioObjectType), (String)"extensionAudioObjectType");
            return new AudioSpecificConfigExtension(audioObjectType, sampleRate, channelConfiguration, extensionAudioObjectType);
        }

        public static /* synthetic */ AudioSpecificConfigExtension copy$default(AudioSpecificConfigExtension audioSpecificConfigExtension, AudioObjectType audioObjectType, int n, ChannelConfiguration channelConfiguration, AudioObjectType audioObjectType2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                audioObjectType = audioSpecificConfigExtension.audioObjectType;
            }
            if ((n2 & 2) != 0) {
                n = audioSpecificConfigExtension.sampleRate;
            }
            if ((n2 & 4) != 0) {
                channelConfiguration = audioSpecificConfigExtension.channelConfiguration;
            }
            if ((n2 & 8) != 0) {
                audioObjectType2 = audioSpecificConfigExtension.extensionAudioObjectType;
            }
            return audioSpecificConfigExtension.copy(audioObjectType, n, channelConfiguration, audioObjectType2);
        }

        @NotNull
        public String toString() {
            return "AudioSpecificConfigExtension(audioObjectType=" + (Object)((Object)this.audioObjectType) + ", sampleRate=" + this.sampleRate + ", channelConfiguration=" + (Object)((Object)this.channelConfiguration) + ", extensionAudioObjectType=" + (Object)((Object)this.extensionAudioObjectType) + ')';
        }

        public int hashCode() {
            int result = this.audioObjectType.hashCode();
            result = result * 31 + Integer.hashCode(this.sampleRate);
            result = result * 31 + (this.channelConfiguration == null ? 0 : this.channelConfiguration.hashCode());
            result = result * 31 + this.extensionAudioObjectType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AudioSpecificConfigExtension)) {
                return false;
            }
            AudioSpecificConfigExtension audioSpecificConfigExtension = (AudioSpecificConfigExtension)other;
            if (this.audioObjectType != audioSpecificConfigExtension.audioObjectType) {
                return false;
            }
            if (this.sampleRate != audioSpecificConfigExtension.sampleRate) {
                return false;
            }
            if (this.channelConfiguration != audioSpecificConfigExtension.channelConfiguration) {
                return false;
            }
            return this.extensionAudioObjectType == audioSpecificConfigExtension.extensionAudioObjectType;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension$Companion;", "", "()V", "parse", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$AudioSpecificConfigExtension;", "reader", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AudioSpecificConfigExtension parse(@NotNull BitBuffer reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                int samplingFrequency = AudioSpecificConfig.Companion.getSamplingFrequency(reader);
                AudioObjectType audioObjectType = AudioSpecificConfig.Companion.getAudioObjectType(reader);
                ChannelConfiguration channelConfiguration = audioObjectType == AudioObjectType.ER_BSAC ? ChannelConfiguration.Companion.fromValue(reader.getShort(4)) : null;
                return new AudioSpecificConfigExtension(audioObjectType, samplingFrequency, channelConfiguration, null, 8, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0006\u00a8\u0006!"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig$Companion;", "", "()V", "fromAudioConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioSpecificConfig;", "config", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "fromMediaFormat", "format", "Landroid/media/MediaFormat;", "getAudioObjectType", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/AudioObjectType;", "reader", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/BitBuffer;", "getAudioObjectTypeSize", "", "audioObjectType", "getSamplingFrequency", "getSamplingFrequencySize", "samplingFrequency", "hasELDSpecificConfig", "", "hasErrorProtectionSpecificConfig", "hasGASpecificConfig", "hasSpecificConfig", "parse", "bitBuffer", "buffer", "Ljava/nio/ByteBuffer;", "writeFromByteBuffer", "", "decoderSpecificInfo", "audioConfig", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getAudioObjectTypeSize(AudioObjectType audioObjectType) {
            return audioObjectType.getValue() < 32 ? 5 : 11;
        }

        private final AudioObjectType getAudioObjectType(BitBuffer reader) {
            int audioObjectType = reader.getInt(5);
            if (audioObjectType == 31) {
                audioObjectType = 32 + reader.getInt(6);
            }
            return AudioObjectType.Companion.fromValue(audioObjectType);
        }

        private final int getSamplingFrequencySize(int samplingFrequency) {
            SamplingFrequencyIndex samplingFrequencyIndex = SamplingFrequencyIndex.Companion.fromSampleRate(samplingFrequency);
            return samplingFrequencyIndex == SamplingFrequencyIndex.EXPLICIT ? 28 : 4;
        }

        private final int getSamplingFrequency(BitBuffer reader) {
            int samplingFrequencyIndex = reader.getInt(4);
            return samplingFrequencyIndex == 15 ? reader.getInt(24) : SamplingFrequencyIndex.Companion.fromValue(samplingFrequencyIndex).toSampleRate();
        }

        private final boolean hasGASpecificConfig(AudioObjectType audioObjectType) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[audioObjectType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean hasELDSpecificConfig(AudioObjectType audioObjectType) {
            return audioObjectType == AudioObjectType.ER_AAC_ELD;
        }

        private final boolean hasSpecificConfig(AudioObjectType audioObjectType) {
            switch (WhenMappings.$EnumSwitchMapping$0[audioObjectType.ordinal()]) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    return true;
                }
            }
            return this.hasGASpecificConfig(audioObjectType) || this.hasELDSpecificConfig(audioObjectType);
        }

        private final boolean hasErrorProtectionSpecificConfig(AudioObjectType audioObjectType) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[audioObjectType.ordinal()]) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 33: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final AudioSpecificConfig parse(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            BitBuffer bitBuffer = new BitBuffer(buffer, 0, 0, 6, null);
            return this.parse(bitBuffer);
        }

        @NotNull
        public final AudioSpecificConfig parse(@NotNull BitBuffer bitBuffer) {
            int syncExtensionType;
            Integer epConfig;
            SpecificConfig specificConfig;
            AudioSpecificConfigExtension extension;
            ChannelConfiguration channelConfiguration;
            int samplingFrequency;
            AudioObjectType audioObjectType;
            block18: {
                block17: {
                    SpecificConfig specificConfig2;
                    Intrinsics.checkNotNullParameter((Object)bitBuffer, (String)"bitBuffer");
                    audioObjectType = this.getAudioObjectType(bitBuffer);
                    samplingFrequency = this.getSamplingFrequency(bitBuffer);
                    channelConfiguration = ChannelConfiguration.Companion.fromValue(bitBuffer.getShort(4));
                    extension = null;
                    if (audioObjectType == AudioObjectType.SBR || audioObjectType == AudioObjectType.PS) {
                        extension = AudioSpecificConfigExtension.Companion.parse(bitBuffer);
                        audioObjectType = extension.getAudioObjectType();
                    }
                    if (this.hasGASpecificConfig(audioObjectType)) {
                        specificConfig2 = GASpecificConfig.Companion.parse(bitBuffer, channelConfiguration, audioObjectType);
                    } else if (this.hasELDSpecificConfig(audioObjectType)) {
                        specificConfig2 = ELDSpecificConfig.Companion.parse(bitBuffer, channelConfiguration);
                    } else {
                        if (this.hasSpecificConfig(audioObjectType)) {
                            String string2 = "Specific config not yet implemented for " + audioObjectType.name();
                            throw new NotImplementedError("An operation is not implemented: " + string2);
                        }
                        specificConfig2 = null;
                    }
                    specificConfig = specificConfig2;
                    Integer n = epConfig = this.hasErrorProtectionSpecificConfig(audioObjectType) ? Integer.valueOf(bitBuffer.getInt(2)) : null;
                    int n2 = 2;
                    if (n != null && n == n2) break block17;
                    Integer n3 = epConfig;
                    n2 = 3;
                    if (n3 == null || n3 != n2) break block18;
                }
                String string3 = "Error protection config not yet implemented for " + audioObjectType.name();
                throw new NotImplementedError("An operation is not implemented: " + string3);
            }
            if (extension != null && extension.getAudioObjectType() != AudioObjectType.SBR && bitBuffer.getBitRemaining() >= 16 && (syncExtensionType = bitBuffer.getInt(11)) == 695) {
                AudioObjectType extensionAudioObjectType = this.getAudioObjectType(bitBuffer);
                if (extensionAudioObjectType == AudioObjectType.SBR) {
                    boolean sbrPresentFlag = bitBuffer.getBoolean();
                    if (sbrPresentFlag) {
                        int syncExtensionType2;
                        this.getSamplingFrequency(bitBuffer);
                        if (bitBuffer.getBitRemaining() >= 12 && (syncExtensionType2 = bitBuffer.getInt(11)) == 1352) {
                            bitBuffer.getBoolean();
                        }
                    }
                } else if (extensionAudioObjectType == AudioObjectType.ER_BSAC) {
                    boolean sbrPresentFlag = bitBuffer.getBoolean();
                    if (sbrPresentFlag) {
                        this.getSamplingFrequency(bitBuffer);
                    }
                    bitBuffer.getLong(4);
                }
            }
            return new AudioSpecificConfig(audioObjectType, samplingFrequency, channelConfiguration, extension, specificConfig, epConfig);
        }

        @NotNull
        public final AudioSpecificConfig fromMediaFormat(@NotNull MediaFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            String string2 = format.getString("mime");
            Intrinsics.checkNotNull((Object)string2);
            AudioObjectType audioObjectType = AudioObjectType.Companion.fromProfile(string2, format.getInteger("aac-profile"));
            ChannelConfiguration channelConfig = ChannelConfiguration.Companion.fromChannelCount(format.getInteger("channel-count"));
            GASpecificConfig specificConfig = new GASpecificConfig(audioObjectType, channelConfig, false, false, false, null, null, null, null, null, null, null, null, null, 16352, null);
            return new AudioSpecificConfig(audioObjectType, format.getInteger("sample-rate"), channelConfig, null, specificConfig, null, 40, null);
        }

        @NotNull
        public final AudioSpecificConfig fromAudioConfig(@NotNull AudioConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            AudioObjectType audioObjectType = AudioObjectType.Companion.fromProfile(config.getMimeType(), config.getProfile());
            ChannelConfiguration channelConfig = ChannelConfiguration.Companion.fromChannelConfig(config.getChannelConfig());
            GASpecificConfig specificConfig = new GASpecificConfig(audioObjectType, channelConfig, false, false, false, null, null, null, null, null, null, null, null, null, 16352, null);
            return new AudioSpecificConfig(audioObjectType, config.getSampleRate(), channelConfig, null, specificConfig, null, 40, null);
        }

        public final void writeFromByteBuffer(@NotNull ByteBuffer buffer, @NotNull ByteBuffer decoderSpecificInfo, @NotNull AudioConfig audioConfig) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)decoderSpecificInfo, (String)"decoderSpecificInfo");
            Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
            if (!Intrinsics.areEqual((Object)audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
                throw new NotImplementedError("No support for " + audioConfig.getMimeType());
            }
            buffer.put(decoderSpecificInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AudioObjectType.values().length];
                try {
                    nArray[AudioObjectType.AAC_MAIN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.AAC_LC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.AAC_SSR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.AAC_LTP.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.AAC_SCALABLE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.TWIN_VQ.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_AAC_LC.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_AAC_LTP.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_AAC_SCALABLE.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_TWIN_VQ.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_BSAC.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_AAC_LD.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.CELP.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.HVXC.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.TTSI.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.MAIN_SYNTHESIS.ordinal()] = 16;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.WAVETABLE_SYNTHESIS.ordinal()] = 17;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.GENERAL_MIDI.ordinal()] = 18;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ALGORITHMIC_SYNTHESIS.ordinal()] = 19;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_CELP.ordinal()] = 20;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_HVXC.ordinal()] = 21;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_HILN.ordinal()] = 22;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_PARAMETRIC.ordinal()] = 23;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.SSC.ordinal()] = 24;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.MPEG_SURROUND.ordinal()] = 25;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.LAYER_1.ordinal()] = 26;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.LAYER_2.ordinal()] = 27;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.LAYER_3.ordinal()] = 28;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.DST.ordinal()] = 29;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ALS.ordinal()] = 30;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.SLS.ordinal()] = 31;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.SLS_NON_CORE.ordinal()] = 32;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.ER_AAC_ELD.ordinal()] = 33;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.SMR_SIMPLE.ordinal()] = 34;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AudioObjectType.SMR_MAIN.ordinal()] = 35;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

