/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.utils.TimeUtils;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/MovieHeaderBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "version", "", "creationTime", "", "modificationTime", "timescale", "", "duration", "rate", "", "volume", "transformationMatrix", "", "nextTrackId", "(BJJIJFF[II)V", "size", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
@SourceDebugExtension(value={"SMAP\nMovieHeaderBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovieHeaderBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/MovieHeaderBox\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class MovieHeaderBox
extends FullBox {
    private final long creationTime;
    private final long modificationTime;
    private final int timescale;
    private final long duration;
    private final float rate;
    private final float volume;
    @NotNull
    private final int[] transformationMatrix;
    private final int nextTrackId;
    private final int size;

    public MovieHeaderBox(byte version, long creationTime, long modificationTime, int timescale, long duration, float rate, float volume, @NotNull int[] transformationMatrix, int nextTrackId) {
        Intrinsics.checkNotNullParameter((Object)transformationMatrix, (String)"transformationMatrix");
        super("mvhd", version, 0, false, 8, null);
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.timescale = timescale;
        this.duration = duration;
        this.rate = rate;
        this.volume = volume;
        this.transformationMatrix = transformationMatrix;
        this.nextTrackId = nextTrackId;
        if (!(this.nextTrackId > 0)) {
            boolean bl = false;
            String string2 = "nextTrackId must be greater than 0";
            throw new IllegalArgumentException(string2.toString());
        }
        this.size = super.getSize() + (version == 1 ? 28 : 16) + 80;
    }

    public /* synthetic */ MovieHeaderBox(byte by, long l, long l2, int n, long l3, float f, float f2, int[] nArray, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            l = TimeUtils.INSTANCE.getUtcNowIsom();
        }
        if ((n3 & 4) != 0) {
            l2 = TimeUtils.INSTANCE.getUtcNowIsom();
        }
        if ((n3 & 0x20) != 0) {
            f = 1.0f;
        }
        if ((n3 & 0x40) != 0) {
            f2 = 1.0f;
        }
        if ((n3 & 0x80) != 0) {
            int[] nArray2 = new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 0x40000000};
            nArray = nArray2;
        }
        this(by, l, l2, n, l3, f, f2, nArray, n2);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        byte by = this.getVersion();
        if (by == 1) {
            output.putLong(this.creationTime);
            output.putLong(this.modificationTime);
            output.putInt(this.timescale);
            output.putLong(this.duration);
        } else if (by == 0) {
            ByteBufferExtensionsKt.putInt(output, this.creationTime);
            ByteBufferExtensionsKt.putInt(output, this.modificationTime);
            output.putInt(this.timescale);
            ByteBufferExtensionsKt.putInt(output, this.duration);
        } else {
            throw new IllegalArgumentException("version must be 0 or 1");
        }
        ByteBufferExtensionsKt.putFixed1616(output, this.rate);
        ByteBufferExtensionsKt.putFixed88(output, this.volume);
        output.put(new byte[10]);
        ByteBufferExtensionsKt.put3x3Matrix(output, this.transformationMatrix);
        output.put(new byte[24]);
        output.putInt(this.nextTrackId);
    }
}

