/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags;

import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.Metadata;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.CodecID;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.ExtendedVideoTag;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.av.FourCCs;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0011"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/VideoMetadata;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/Metadata;", "codecID", "", "dataRate", "width", "height", "frameRate", "(Ljava/lang/Integer;IIII)V", "getCodecID", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getFrameRate", "()I", "getHeight", "getWidth", "Companion", "core_release"})
public final class VideoMetadata
extends Metadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer codecID;
    private final int width;
    private final int height;
    private final int frameRate;
    @NotNull
    private static final String TAG = "VideoMetadata";

    public VideoMetadata(@Nullable Integer codecID, int dataRate, int width, int height, int frameRate) {
        super(dataRate);
        this.codecID = codecID;
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
    }

    @Nullable
    public final Integer getCodecID() {
        return this.codecID;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    @kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/VideoMetadata$Companion;", "", "()V", "TAG", "", "fromVideoConfig", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/VideoMetadata;", "config", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VideoMetadata fromVideoConfig(@NotNull VideoConfig config, @Nullable ISourceOrientationProvider sourceOrientationProvider) {
            ISourceOrientationProvider iSourceOrientationProvider;
            Integer videoCodecID;
            Integer n;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (ExtendedVideoTag.Companion.isSupportedCodec(config.getMimeType())) {
                n = FourCCs.Companion.fromMimeType(config.getMimeType()).getValue().getCode();
            } else {
                Integer n2;
                try {
                    n2 = CodecID.Companion.fromMimeType(config.getMimeType()).getValue();
                }
                catch (Exception e) {
                    ILogger.DefaultImpls.e$default(Logger.INSTANCE, VideoMetadata.TAG, "Failed to get videocodecid for: " + config.getMimeType(), null, 4, null);
                    n2 = null;
                }
                n = videoCodecID = n2;
            }
            if ((iSourceOrientationProvider = sourceOrientationProvider) == null || (iSourceOrientationProvider = iSourceOrientationProvider.getOrientedSize(config.getResolution())) == null) {
                iSourceOrientationProvider = config.getResolution();
            }
            ISourceOrientationProvider resolution = iSourceOrientationProvider;
            return new VideoMetadata(videoCodecID, config.getStartBitrate(), resolution.getWidth(), resolution.getHeight(), config.getFps());
        }

        public static /* synthetic */ VideoMetadata fromVideoConfig$default(Companion companion, VideoConfig videoConfig, ISourceOrientationProvider iSourceOrientationProvider, int n, Object object) {
            if ((n & 2) != 0) {
                iSourceOrientationProvider = null;
            }
            return companion.fromVideoConfig(videoConfig, iSourceOrientationProvider);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

