/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AACPacketType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.AudioTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.PacketType;
import io.github.thibaultbee.streampack.internal.muxers.flv.tags.video.VideoTagFactory;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.AVCCBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.PassthroughBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.video.avc.AVCDecoderConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.av.video.hevc.HEVCDecoderConfigurationRecord;
import io.github.thibaultbee.streampack.internal.utils.av.video.vpx.VPCodecConfigurationRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0013H\u0002J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/AVTagsFactory;", "", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "config", "Lio/github/thibaultbee/streampack/data/Config;", "sendHeader", "", "(Lio/github/thibaultbee/streampack/internal/data/Frame;Lio/github/thibaultbee/streampack/data/Config;Z)V", "build", "", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "createAudioTags", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "createVideoBufferWriter", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "buffer", "Ljava/nio/ByteBuffer;", "createVideoSequenceStartBufferWriter", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "createVideoTags", "core_release"})
public final class AVTagsFactory {
    @NotNull
    private final Frame frame;
    @NotNull
    private final Config config;
    private final boolean sendHeader;

    public AVTagsFactory(@NotNull Frame frame, @NotNull Config config, boolean sendHeader) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.frame = frame;
        this.config = config;
        this.sendHeader = sendHeader;
    }

    @NotNull
    public final List<FlvTag> build() {
        List<FlvTag> list;
        if (this.frame.isVideo()) {
            Config config = this.config;
            Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.VideoConfig");
            list = this.createVideoTags(this.frame, (VideoConfig)config, this.sendHeader);
        } else if (this.frame.isAudio()) {
            Config config = this.config;
            Intrinsics.checkNotNull((Object)config, (String)"null cannot be cast to non-null type io.github.thibaultbee.streampack.data.AudioConfig");
            list = this.createAudioTags(this.frame, (AudioConfig)config, this.sendHeader);
        } else {
            throw new IOException("Frame is neither video nor audio: " + this.frame.getMimeType());
        }
        return list;
    }

    private final List<FlvTag> createAudioTags(Frame frame, AudioConfig config, boolean sendHeader) {
        List audioTag = new ArrayList();
        if (sendHeader) {
            long l = frame.getPts();
            List<ByteBuffer> list = frame.getExtra();
            Intrinsics.checkNotNull(list);
            audioTag.add(new AudioTag(l, list.get(0), Intrinsics.areEqual((Object)config.getMimeType(), (Object)"audio/mp4a-latm") ? AACPacketType.SEQUENCE_HEADER : null, config));
        }
        audioTag.add(new AudioTag(frame.getPts(), frame.getBuffer(), Intrinsics.areEqual((Object)config.getMimeType(), (Object)"audio/mp4a-latm") ? AACPacketType.RAW : null, config));
        return audioTag;
    }

    private final List<FlvTag> createVideoTags(Frame frame, VideoConfig config, boolean sendHeader) {
        List videoTags = new ArrayList();
        if (frame.isKeyFrame() && sendHeader) {
            videoTags.add(new VideoTagFactory(frame.getPts(), this.createVideoSequenceStartBufferWriter(frame, config), true, PacketType.SEQUENCE_START, config.getMimeType()).build());
        }
        videoTags.add(new VideoTagFactory(frame.getPts(), this.createVideoBufferWriter(frame.getBuffer()), frame.isKeyFrame(), PacketType.CODED_FRAMES_X, config.getMimeType()).build());
        return videoTags;
    }

    private final ByteBufferWriter createVideoSequenceStartBufferWriter(Frame frame, VideoConfig config) {
        ByteBufferWriter byteBufferWriter;
        switch (config.getMimeType()) {
            case "video/avc": {
                List<ByteBuffer> list = frame.getExtra();
                Intrinsics.checkNotNull(list);
                byteBufferWriter = AVCDecoderConfigurationRecord.Companion.fromParameterSets(list.get(0), frame.getExtra().get(1));
                break;
            }
            case "video/hevc": {
                List<ByteBuffer> list = frame.getExtra();
                Intrinsics.checkNotNull(list);
                byteBufferWriter = HEVCDecoderConfigurationRecord.Companion.fromParameterSets(list);
                break;
            }
            case "video/x-vnd.on2.vp9": {
                byteBufferWriter = VPCodecConfigurationRecord.Companion.fromMediaFormat(frame.getFormat());
                break;
            }
            case "video/av01": {
                if (frame.getExtra() == null) {
                    throw new IOException("AV1 sequence header without CSD buffer is not supported");
                }
                byteBufferWriter = new PassthroughBufferWriter(frame.getExtra().get(0));
                break;
            }
            default: {
                throw new IOException("Unsupported video codec: " + config.getMimeType());
            }
        }
        return byteBufferWriter;
    }

    private final ByteBufferWriter createVideoBufferWriter(ByteBuffer buffer) {
        String string2 = this.config.getMimeType();
        return (Intrinsics.areEqual((Object)string2, (Object)"video/avc") ? true : Intrinsics.areEqual((Object)string2, (Object)"video/hevc")) ? (ByteBufferWriter)new AVCCBufferWriter(buffer) : (ByteBufferWriter)new PassthroughBufferWriter(buffer);
    }
}

