/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.gl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.view.Surface;
import io.github.thibaultbee.streampack.internal.gl.GlUtils;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0005R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/EglWindowSurface;", "", "surface", "Landroid/view/Surface;", "useHighBitDepth", "", "(Landroid/view/Surface;Z)V", "configs", "", "Landroid/opengl/EGLConfig;", "[Landroid/opengl/EGLConfig;", "eglContext", "Landroid/opengl/EGLContext;", "eglDisplay", "Landroid/opengl/EGLDisplay;", "eglSurface", "Landroid/opengl/EGLSurface;", "createEGLSurface", "", "eglSetup", "getHeight", "", "getWidth", "makeCurrent", "makeUnCurrent", "release", "setPresentationTime", "nSecs", "", "swapBuffers", "Companion", "core_release"})
public final class EglWindowSurface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Surface surface;
    @NotNull
    private EGLDisplay eglDisplay;
    @NotNull
    private EGLContext eglContext;
    @NotNull
    private EGLSurface eglSurface;
    @NotNull
    private final EGLConfig[] configs;
    private static final int EGL_RECORDABLE_ANDROID = 12610;

    public EglWindowSurface(@NotNull Surface surface, boolean useHighBitDepth) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.surface = surface;
        EGLDisplay eGLDisplay = EGL14.EGL_NO_DISPLAY;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_DISPLAY");
        this.eglDisplay = eGLDisplay;
        EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
        this.eglContext = eGLContext;
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
        this.eglSurface = eGLSurface;
        this.configs = new EGLConfig[1];
        this.eglSetup(useHighBitDepth);
    }

    public /* synthetic */ EglWindowSurface(Surface surface, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(surface, bl);
    }

    private final void eglSetup(boolean useHighBitDepth) {
        int[] numConfigs;
        int recordable;
        int eglAlphaSize;
        EGLDisplay eGLDisplay = EGL14.eglGetDisplay((int)0);
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"eglGetDisplay(...)");
        this.eglDisplay = eGLDisplay;
        if (Objects.equals(this.eglDisplay, EGL14.EGL_NO_DISPLAY)) {
            throw new RuntimeException("unable to get EGL14 display");
        }
        int[] version = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.eglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
            throw new RuntimeException("unable to initialize EGL14");
        }
        int eglColorSize = useHighBitDepth ? 10 : 8;
        int[] nArray = new int[]{12324, eglColorSize, 12323, eglColorSize, 12322, eglColorSize, 12321, eglAlphaSize = useHighBitDepth ? 2 : 0, 12352, 4, 12610, recordable = useHighBitDepth ? 0 : 1, 12344};
        int[] attribList = nArray;
        if (!EGL14.eglChooseConfig((EGLDisplay)this.eglDisplay, (int[])attribList, (int)0, (EGLConfig[])this.configs, (int)0, (int)this.configs.length, (int[])(numConfigs = new int[1]), (int)0)) {
            throw new RuntimeException("unable to find RGB888+recordable ES2 EGL config");
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        attribList = nArray2;
        EGLContext eGLContext = EGL14.eglCreateContext((EGLDisplay)this.eglDisplay, (EGLConfig)this.configs[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])attribList, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"eglCreateContext(...)");
        this.eglContext = eGLContext;
        GlUtils.INSTANCE.checkEglError("eglCreateContext");
        this.createEGLSurface();
    }

    private final void createEGLSurface() {
        int[] nArray = new int[]{12344};
        int[] surfaceAttribs = nArray;
        EGLSurface eGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.eglDisplay, (EGLConfig)this.configs[0], (Object)this.surface, (int[])surfaceAttribs, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"eglCreateWindowSurface(...)");
        this.eglSurface = eGLSurface;
        GlUtils.INSTANCE.checkEglError("eglCreateWindowSurface");
    }

    public final void release() {
        if (!Objects.equals(this.eglDisplay, EGL14.EGL_NO_DISPLAY)) {
            EGL14.eglDestroySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
            EGL14.eglDestroyContext((EGLDisplay)this.eglDisplay, (EGLContext)this.eglContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.eglDisplay);
        }
        this.surface.release();
        EGLDisplay eGLDisplay = EGL14.EGL_NO_DISPLAY;
        Intrinsics.checkNotNullExpressionValue((Object)eGLDisplay, (String)"EGL_NO_DISPLAY");
        this.eglDisplay = eGLDisplay;
        EGLContext eGLContext = EGL14.EGL_NO_CONTEXT;
        Intrinsics.checkNotNullExpressionValue((Object)eGLContext, (String)"EGL_NO_CONTEXT");
        this.eglContext = eGLContext;
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
        this.eglSurface = eGLSurface;
    }

    public final void makeCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (EGLSurface)this.eglSurface, (EGLContext)this.eglContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public final void makeUnCurrent() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.eglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    public final boolean swapBuffers() {
        return EGL14.eglSwapBuffers((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface);
    }

    public final int getWidth() {
        int[] value = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12375, (int[])value, (int)0);
        return value[0];
    }

    public final int getHeight() {
        int[] value = new int[1];
        EGL14.eglQuerySurface((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (int)12374, (int[])value, (int)0);
        return value[0];
    }

    public final void setPresentationTime(long nSecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.eglDisplay, (EGLSurface)this.eglSurface, (long)nSecs);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/EglWindowSurface$Companion;", "", "()V", "EGL_RECORDABLE_ANDROID", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

