/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.camera;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.internal.sources.camera.ICameraThreadManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u000e\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\u0016H\u0017J \u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u001fH\u0017J\b\u0010 \u001a\u00020\u0011H\u0016J \u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/camera/CameraHandlerManager;", "Lio/github/thibaultbee/streampack/internal/sources/camera/ICameraThreadManager;", "()V", "cameraHandler", "Landroid/os/Handler;", "cameraThread", "Landroid/os/HandlerThread;", "captureBurstRequests", "", "captureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "captureRequests", "", "Landroid/hardware/camera2/CaptureRequest;", "callback", "Landroid/hardware/camera2/CameraCaptureSession$CaptureCallback;", "createCaptureSession", "", "camera", "Landroid/hardware/camera2/CameraDevice;", "targets", "Landroid/view/Surface;", "Landroid/hardware/camera2/CameraCaptureSession$StateCallback;", "createCaptureSessionByOutputConfiguration", "outputConfigurations", "Landroid/hardware/camera2/params/OutputConfiguration;", "openCamera", "manager", "Landroid/hardware/camera2/CameraManager;", "cameraId", "", "Landroid/hardware/camera2/CameraDevice$StateCallback;", "release", "setRepeatingSingleRequest", "captureRequest", "core_release"})
@SourceDebugExtension(value={"SMAP\nCameraHandlerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraHandlerManager.kt\nio/github/thibaultbee/streampack/internal/sources/camera/CameraHandlerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class CameraHandlerManager
implements ICameraThreadManager {
    @NotNull
    private HandlerThread cameraThread;
    @NotNull
    private Handler cameraHandler;

    /*
     * WARNING - void declaration
     */
    public CameraHandlerManager() {
        void $this$cameraThread_u24lambda_u240;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("CameraThread");
        CameraHandlerManager cameraHandlerManager = this;
        boolean bl = false;
        $this$cameraThread_u24lambda_u240.start();
        cameraHandlerManager.cameraThread = handlerThread;
        this.cameraHandler = new Handler(this.cameraThread.getLooper());
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(@NotNull CameraManager manager, @NotNull String cameraId2, @NotNull CameraDevice.StateCallback callback) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        manager.openCamera(cameraId2, callback, this.cameraHandler);
    }

    @Override
    public void createCaptureSession(@NotNull CameraDevice camera, @NotNull List<? extends Surface> targets, @NotNull CameraCaptureSession.StateCallback callback) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        camera.createCaptureSession(targets, callback, this.cameraHandler);
    }

    @Override
    @RequiresApi(value=24)
    public void createCaptureSessionByOutputConfiguration(@NotNull CameraDevice camera, @NotNull List<OutputConfiguration> outputConfigurations, @NotNull CameraCaptureSession.StateCallback callback) {
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter(outputConfigurations, (String)"outputConfigurations");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        camera.createCaptureSessionByOutputConfigurations(outputConfigurations, callback, this.cameraHandler);
    }

    @Override
    public int setRepeatingSingleRequest(@NotNull CameraCaptureSession captureSession, @NotNull CaptureRequest captureRequest, @NotNull CameraCaptureSession.CaptureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)captureSession, (String)"captureSession");
        Intrinsics.checkNotNullParameter((Object)captureRequest, (String)"captureRequest");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return captureSession.setRepeatingRequest(captureRequest, callback, this.cameraHandler);
    }

    @Override
    public int captureBurstRequests(@NotNull CameraCaptureSession captureSession, @NotNull List<CaptureRequest> captureRequests, @NotNull CameraCaptureSession.CaptureCallback callback) {
        Intrinsics.checkNotNullParameter((Object)captureSession, (String)"captureSession");
        Intrinsics.checkNotNullParameter(captureRequests, (String)"captureRequests");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return captureSession.captureBurst(captureRequests, callback, this.cameraHandler);
    }

    @Override
    public void release() {
        this.cameraThread.quitSafely();
        try {
            this.cameraThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

