/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import android.util.Size;
import android.view.Surface;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.gl.EglWindowSurface;
import io.github.thibaultbee.streampack.internal.gl.FullFrameRect;
import io.github.thibaultbee.streampack.internal.gl.Texture2DProgram;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationListener;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.av.video.DynamicRangeProfile;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020%H\u0016R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r8V@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "encoderListener", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "onInternalErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "useSurfaceMode", "", "orientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "(Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;Lio/github/thibaultbee/streampack/listeners/OnErrorListener;ZLio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "_bitrate", "", "Ljava/lang/Integer;", "value", "bitrate", "getBitrate", "()I", "setBitrate", "(I)V", "codecSurface", "Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "getCodecSurface", "()Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "inputSurface", "Landroid/view/Surface;", "getInputSurface", "()Landroid/view/Surface;", "getOnInternalErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "createMediaFormat", "Landroid/media/MediaFormat;", "config", "Lio/github/thibaultbee/streampack/data/Config;", "withProfileLevel", "extendMediaFormat", "", "format", "onNewMediaCodec", "mediaCodec", "Landroid/media/MediaCodec;", "startStream", "stopStream", "CodecSurface", "core_release"})
public final class VideoMediaCodecEncoder
extends MediaCodecEncoder<VideoConfig> {
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    private final boolean useSurfaceMode;
    @Nullable
    private final ISourceOrientationProvider orientationProvider;
    @Nullable
    private final CodecSurface codecSurface;
    @Nullable
    private Integer _bitrate;
    private int bitrate;

    public VideoMediaCodecEncoder(@NotNull IEncoderListener encoderListener, @NotNull OnErrorListener onInternalErrorListener2, boolean useSurfaceMode, @Nullable ISourceOrientationProvider orientationProvider) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        Intrinsics.checkNotNullParameter((Object)onInternalErrorListener2, (String)"onInternalErrorListener");
        super(encoderListener);
        this.onInternalErrorListener = onInternalErrorListener2;
        this.useSurfaceMode = useSurfaceMode;
        this.orientationProvider = orientationProvider;
        this.codecSurface = this.useSurfaceMode ? new CodecSurface(this.orientationProvider) : null;
    }

    @Override
    @NotNull
    protected OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    @Nullable
    public final CodecSurface getCodecSurface() {
        return this.codecSurface;
    }

    @Override
    public int getBitrate() {
        Integer n = this._bitrate;
        return n != null ? n.intValue() : super.getBitrate();
    }

    public void setBitrate(int value) {
        Bundle bundle = new Bundle();
        bundle.putInt("video-bitrate", value);
        MediaCodec mediaCodec = this.getMediaCodec();
        if (mediaCodec != null) {
            mediaCodec.setParameters(bundle);
        }
        this.bitrate = value;
        this._bitrate = value;
    }

    @Override
    public void onNewMediaCodec(@NotNull MediaCodec mediaCodec) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)mediaCodec, (String)"mediaCodec");
            try {
                String string2 = mediaCodec.getOutputFormat().getString("mime");
                Intrinsics.checkNotNull((Object)string2);
                String mimeType = string2;
                int profile = mediaCodec.getOutputFormat().getInteger("profile");
                CodecSurface codecSurface = this.codecSurface;
                if (codecSurface != null) {
                    codecSurface.setUseHighBitDepth(DynamicRangeProfile.Companion.fromProfile(mimeType, profile).isHdr());
                }
            }
            catch (Exception _) {
                CodecSurface codecSurface = this.codecSurface;
                if (codecSurface == null) break block4;
                codecSurface.setUseHighBitDepth(false);
            }
        }
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.setOutputSurface(mediaCodec.createInputSurface());
        }
    }

    @Override
    @NotNull
    public MediaFormat createMediaFormat(@NotNull Config config, boolean withProfileLevel) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        MediaFormat videoFormat = super.createMediaFormat(config, withProfileLevel);
        if (this.useSurfaceMode) {
            videoFormat.setInteger("color-format", 2130708361);
        } else {
            int colorFormat = ((VideoConfig)config).getDynamicRangeProfile().isHdr() ? 54 : 2135033992;
            videoFormat.setInteger("color-format", colorFormat);
        }
        return videoFormat;
    }

    @Override
    public void extendMediaFormat(@NotNull Config config, @NotNull MediaFormat format) {
        block0: {
            Size size2;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            VideoConfig videoConfig = (VideoConfig)config;
            ISourceOrientationProvider iSourceOrientationProvider = this.orientationProvider;
            if (iSourceOrientationProvider == null) break block0;
            ISourceOrientationProvider it = iSourceOrientationProvider;
            boolean bl = false;
            Size $this$extendMediaFormat_u24lambda_u241_u24lambda_u240 = size2 = it.getOrientedSize(videoConfig.getResolution());
            boolean bl2 = false;
            format.setInteger("width", $this$extendMediaFormat_u24lambda_u241_u24lambda_u240.getWidth());
            format.setInteger("height", $this$extendMediaFormat_u24lambda_u241_u24lambda_u240.getHeight());
        }
    }

    @Override
    public void startStream() {
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.startStream();
        }
        super.startStream();
    }

    @Override
    public void stopStream() {
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.stopStream();
        }
        super.stopStream();
    }

    @Nullable
    public final Surface getInputSurface() {
        CodecSurface codecSurface = this.codecSurface;
        return codecSurface != null ? codecSurface.getInputSurface() : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010$\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0003J\b\u0010%\u001a\u00020&H\u0002J(\u0010'\u001a\u0004\u0018\u00010\t2\b\u0010(\u001a\u0004\u0018\u00010\t2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020&0*H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020&H\u0016J\u0006\u0010.\u001a\u00020&J\u0006\u0010/\u001a\u00020&J\u0006\u00100\u001a\u00020&R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00061"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationListener;", "orientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "(Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "_inputSurface", "Landroid/view/Surface;", "eglSurface", "Lio/github/thibaultbee/streampack/internal/gl/EglWindowSurface;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "fullFrameRect", "Lio/github/thibaultbee/streampack/internal/gl/FullFrameRect;", "inputSurface", "getInputSurface", "()Landroid/view/Surface;", "isRunning", "", "value", "outputSurface", "getOutputSurface", "setOutputSurface", "(Landroid/view/Surface;)V", "stMatrix", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "textureId", "", "useHighBitDepth", "getUseHighBitDepth", "()Z", "setUseHighBitDepth", "(Z)V", "attachOrBuildSurfaceTexture", "detachSurfaceTexture", "", "ensureGlContext", "surface", "action", "Lkotlin/Function1;", "initOrUpdateSurfaceTexture", "onFrameAvailable", "onOrientationChanged", "release", "startStream", "stopStream", "core_release"})
    public static final class CodecSurface
    implements SurfaceTexture.OnFrameAvailableListener,
    ISourceOrientationListener {
        @Nullable
        private final ISourceOrientationProvider orientationProvider;
        @Nullable
        private EglWindowSurface eglSurface;
        @Nullable
        private FullFrameRect fullFrameRect;
        private int textureId;
        private final ExecutorService executor;
        private boolean isRunning;
        @Nullable
        private SurfaceTexture surfaceTexture;
        @NotNull
        private final float[] stMatrix;
        @Nullable
        private Surface _inputSurface;
        private boolean useHighBitDepth;
        @Nullable
        private Surface outputSurface;

        public CodecSurface(@Nullable ISourceOrientationProvider orientationProvider) {
            block0: {
                this.orientationProvider = orientationProvider;
                this.textureId = -1;
                this.executor = Executors.newSingleThreadExecutor();
                this.stMatrix = new float[16];
                ISourceOrientationProvider iSourceOrientationProvider = this.orientationProvider;
                if (iSourceOrientationProvider == null) break block0;
                iSourceOrientationProvider.addListener(this);
            }
        }

        @Nullable
        public final Surface getInputSurface() {
            return this._inputSurface;
        }

        public final boolean getUseHighBitDepth() {
            return this.useHighBitDepth;
        }

        public final void setUseHighBitDepth(boolean bl) {
            this.useHighBitDepth = bl;
        }

        @Nullable
        public final Surface getOutputSurface() {
            return this.outputSurface;
        }

        public final void setOutputSurface(@Nullable Surface value) {
            this.executor.submit(() -> CodecSurface._set_outputSurface_$lambda$2(this, value)).get();
            this.outputSurface = value;
        }

        private final void initOrUpdateSurfaceTexture(Surface surface) {
            this.eglSurface = this.ensureGlContext(new EglWindowSurface(surface, this.useHighBitDepth), (Function1<? super EglWindowSurface, Unit>)((Function1)new Function1<EglWindowSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull EglWindowSurface it) {
                    void $this$invoke_u24lambda_u241;
                    void $this$invoke_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int width = it.getWidth();
                    int height = it.getHeight();
                    ISourceOrientationProvider iSourceOrientationProvider = CodecSurface.access$getOrientationProvider$p(this.this$0);
                    if (iSourceOrientationProvider == null || (iSourceOrientationProvider = iSourceOrientationProvider.getOrientedSize(new Size(width, height))) == null) {
                        iSourceOrientationProvider = new Size(width, height);
                    }
                    ISourceOrientationProvider size2 = iSourceOrientationProvider;
                    ISourceOrientationProvider iSourceOrientationProvider2 = CodecSurface.access$getOrientationProvider$p(this.this$0);
                    int orientation = iSourceOrientationProvider2 != null ? iSourceOrientationProvider2.getOrientation() : 0;
                    FullFrameRect fullFrameRect = new FullFrameRect(new Texture2DProgram());
                    CodecSurface codecSurface = this.this$0;
                    Object object = fullFrameRect;
                    CodecSurface codecSurface2 = this.this$0;
                    boolean $i$a$-apply-VideoMediaCodecEncoder$CodecSurface$initOrUpdateSurfaceTexture$1$32 = false;
                    CodecSurface.access$setTextureId$p(codecSurface, $this$invoke_u24lambda_u240.createTextureObject());
                    ISourceOrientationProvider iSourceOrientationProvider3 = CodecSurface.access$getOrientationProvider$p(codecSurface);
                    $this$invoke_u24lambda_u240.setMVPMatrixAndViewPort(orientation, (Size)size2, iSourceOrientationProvider3 != null ? iSourceOrientationProvider3.getMirroredVertically() : false);
                    CodecSurface.access$setFullFrameRect$p(codecSurface2, fullFrameRect);
                    ISourceOrientationProvider iSourceOrientationProvider4 = CodecSurface.access$getOrientationProvider$p(this.this$0);
                    if (iSourceOrientationProvider4 == null || (iSourceOrientationProvider4 = iSourceOrientationProvider4.getDefaultBufferSize((Size)size2)) == null) {
                        iSourceOrientationProvider4 = new Size(width, height);
                    }
                    ISourceOrientationProvider defaultBufferSize = iSourceOrientationProvider4;
                    codecSurface = CodecSurface.access$attachOrBuildSurfaceTexture(this.this$0, CodecSurface.access$getSurfaceTexture$p(this.this$0));
                    object = this.this$0;
                    CodecSurface $i$a$-apply-VideoMediaCodecEncoder$CodecSurface$initOrUpdateSurfaceTexture$1$32 = codecSurface;
                    codecSurface2 = this.this$0;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.setDefaultBufferSize(defaultBufferSize.getWidth(), defaultBufferSize.getHeight());
                    $this$invoke_u24lambda_u241.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)object);
                    CodecSurface.access$setSurfaceTexture$p(codecSurface2, (SurfaceTexture)codecSurface);
                }
            }));
        }

        @SuppressLint(value={"Recycle"})
        private final SurfaceTexture attachOrBuildSurfaceTexture(SurfaceTexture surfaceTexture) {
            SurfaceTexture surfaceTexture2;
            if (surfaceTexture == null) {
                SurfaceTexture surfaceTexture3;
                SurfaceTexture $this$attachOrBuildSurfaceTexture_u24lambda_u243 = surfaceTexture3 = new SurfaceTexture(this.textureId);
                boolean bl = false;
                this._inputSurface = new Surface($this$attachOrBuildSurfaceTexture_u24lambda_u243);
                surfaceTexture2 = surfaceTexture3;
            } else {
                surfaceTexture.attachToGLContext(this.textureId);
                surfaceTexture2 = surfaceTexture;
            }
            return surfaceTexture2;
        }

        private final EglWindowSurface ensureGlContext(EglWindowSurface surface, Function1<? super EglWindowSurface, Unit> action) {
            block0: {
                EglWindowSurface eglWindowSurface = surface;
                if (eglWindowSurface == null) break block0;
                EglWindowSurface it = eglWindowSurface;
                boolean bl = false;
                it.makeCurrent();
                action.invoke((Object)it);
                it.makeUnCurrent();
            }
            return surface;
        }

        @Override
        public void onOrientationChanged() {
            this.executor.execute(() -> CodecSurface.onOrientationChanged$lambda$6(this));
        }

        public void onFrameAvailable(@NotNull SurfaceTexture surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            if (!this.isRunning) {
                return;
            }
            this.executor.execute(() -> CodecSurface.onFrameAvailable$lambda$9(this, surfaceTexture));
        }

        public final void startStream() {
            this.ensureGlContext(this.eglSurface, (Function1<? super EglWindowSurface, Unit>)((Function1)new Function1<EglWindowSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EglWindowSurface it) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SurfaceTexture surfaceTexture = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                        if (surfaceTexture == null) break block0;
                        surfaceTexture.updateTexImage();
                    }
                }
            }));
            this.isRunning = true;
        }

        private final void detachSurfaceTexture() {
            this.ensureGlContext(this.eglSurface, (Function1<? super EglWindowSurface, Unit>)((Function1)new Function1<EglWindowSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EglWindowSurface it) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        SurfaceTexture surfaceTexture = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                        if (surfaceTexture != null) {
                            surfaceTexture.detachFromGLContext();
                        }
                        FullFrameRect fullFrameRect = CodecSurface.access$getFullFrameRect$p(this.this$0);
                        if (fullFrameRect == null) break block1;
                        fullFrameRect.release(true);
                    }
                }
            }));
            EglWindowSurface eglWindowSurface = this.eglSurface;
            if (eglWindowSurface != null) {
                eglWindowSurface.release();
            }
            this.eglSurface = null;
            this.fullFrameRect = null;
        }

        public final void stopStream() {
            this.executor.submit(() -> CodecSurface.stopStream$lambda$11(this)).get();
        }

        public final void release() {
            ISourceOrientationProvider iSourceOrientationProvider = this.orientationProvider;
            if (iSourceOrientationProvider != null) {
                iSourceOrientationProvider.removeListener(this);
            }
            this.stopStream();
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                surfaceTexture.setOnFrameAvailableListener(null);
            }
            SurfaceTexture surfaceTexture2 = this.surfaceTexture;
            if (surfaceTexture2 != null) {
                surfaceTexture2.release();
            }
            this.surfaceTexture = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void _set_outputSurface_$lambda$2(CodecSurface this$0, Surface $value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.eglSurface != null) {
                this$0.detachSurfaceTexture();
            }
            CodecSurface codecSurface = this$0;
            synchronized (codecSurface) {
                boolean bl = false;
                Surface surface = $value;
                if (surface != null) {
                    Surface it = surface;
                    boolean bl2 = false;
                    this$0.initOrUpdateSurfaceTexture(it);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void onOrientationChanged$lambda$6(CodecSurface this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            CodecSurface codecSurface = this$0;
            synchronized (codecSurface) {
                boolean bl = false;
                this$0.ensureGlContext(this$0.eglSurface, (Function1<? super EglWindowSurface, Unit>)((Function1)new Function1<EglWindowSurface, Unit>(this$0){
                    final /* synthetic */ CodecSurface this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull EglWindowSurface it) {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            int width = it.getWidth();
                            int height = it.getHeight();
                            FullFrameRect fullFrameRect = CodecSurface.access$getFullFrameRect$p(this.this$0);
                            if (fullFrameRect != null) {
                                ISourceOrientationProvider iSourceOrientationProvider = CodecSurface.access$getOrientationProvider$p(this.this$0);
                                float f = iSourceOrientationProvider != null ? iSourceOrientationProvider.getOrientation() : 0;
                                ISourceOrientationProvider iSourceOrientationProvider2 = CodecSurface.access$getOrientationProvider$p(this.this$0);
                                if (iSourceOrientationProvider2 == null || (iSourceOrientationProvider2 = iSourceOrientationProvider2.getOrientedSize(new Size(width, height))) == null) {
                                    iSourceOrientationProvider2 = new Size(width, height);
                                }
                                ISourceOrientationProvider iSourceOrientationProvider3 = CodecSurface.access$getOrientationProvider$p(this.this$0);
                                fullFrameRect.setMVPMatrixAndViewPort(f, (Size)iSourceOrientationProvider2, iSourceOrientationProvider3 != null ? iSourceOrientationProvider3.getMirroredVertically() : false);
                            }
                            SurfaceTexture surfaceTexture = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                            if (surfaceTexture != null) {
                                surfaceTexture.updateTexImage();
                            }
                            SurfaceTexture surfaceTexture2 = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                            if (surfaceTexture2 == null) break block3;
                            surfaceTexture2.releaseTexImage();
                        }
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void onFrameAvailable$lambda$9(CodecSurface this$0, SurfaceTexture $surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$surfaceTexture, (String)"$surfaceTexture");
            CodecSurface codecSurface = this$0;
            synchronized (codecSurface) {
                boolean bl = false;
                EglWindowSurface eglWindowSurface = this$0.eglSurface;
                if (eglWindowSurface != null) {
                    EglWindowSurface it = eglWindowSurface;
                    boolean bl2 = false;
                    it.makeCurrent();
                    $surfaceTexture.updateTexImage();
                    $surfaceTexture.getTransformMatrix(this$0.stMatrix);
                    FullFrameRect fullFrameRect = this$0.fullFrameRect;
                    if (fullFrameRect != null) {
                        fullFrameRect.drawFrame(this$0.textureId, this$0.stMatrix);
                    }
                    it.setPresentationTime($surfaceTexture.getTimestamp());
                    it.swapBuffers();
                    $surfaceTexture.releaseTexImage();
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void stopStream$lambda$11(CodecSurface this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            CodecSurface codecSurface = this$0;
            synchronized (codecSurface) {
                boolean bl = false;
                this$0.isRunning = false;
                this$0.detachSurfaceTexture();
                Unit unit = Unit.INSTANCE;
            }
        }

        public static final /* synthetic */ ISourceOrientationProvider access$getOrientationProvider$p(CodecSurface $this) {
            return $this.orientationProvider;
        }

        public static final /* synthetic */ void access$setFullFrameRect$p(CodecSurface $this, FullFrameRect fullFrameRect) {
            $this.fullFrameRect = fullFrameRect;
        }

        public static final /* synthetic */ void access$setSurfaceTexture$p(CodecSurface $this, SurfaceTexture surfaceTexture) {
            $this.surfaceTexture = surfaceTexture;
        }

        public static final /* synthetic */ SurfaceTexture access$attachOrBuildSurfaceTexture(CodecSurface $this, SurfaceTexture surfaceTexture) {
            return $this.attachOrBuildSurfaceTexture(surfaceTexture);
        }

        public static final /* synthetic */ SurfaceTexture access$getSurfaceTexture$p(CodecSurface $this) {
            return $this.surfaceTexture;
        }

        public static final /* synthetic */ void access$setTextureId$p(CodecSurface $this, int n) {
            $this.textureId = n;
        }

        public static final /* synthetic */ FullFrameRect access$getFullFrameRect$p(CodecSurface $this) {
            return $this.fullFrameRect;
        }
    }
}

