/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.sources.screen;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.activity.result.ActivityResult;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.sources.IVideoCapture;
import io.github.thibaultbee.streampack.internal.sources.screen.ScreenCapture;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0002\u0018+\u0018\u0000 ;2\u00020\u0001:\u0001;B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020'H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u000202H\u0016J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u000202H\u0016R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture;", "Lio/github/thibaultbee/streampack/internal/sources/IVideoCapture;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activityResult", "Landroidx/activity/result/ActivityResult;", "getActivityResult", "()Landroidx/activity/result/ActivityResult;", "setActivityResult", "(Landroidx/activity/result/ActivityResult;)V", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "hasSurface", "", "getHasSurface", "()Z", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "io/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$mediaProjectionCallback$1", "Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$mediaProjectionCallback$1;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "onErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "getOnErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "timestampOffset", "", "getTimestampOffset", "()J", "videoConfig", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "virtualDisplayCallback", "io/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$virtualDisplayCallback$1", "Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$virtualDisplayCallback$1;", "virtualDisplayHandler", "Landroid/os/Handler;", "virtualDisplayThread", "Landroid/os/HandlerThread;", "configure", "", "config", "getFrame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "release", "startStream", "stopStream", "Companion", "core_release"})
public final class ScreenCapture
implements IVideoCapture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Surface encoderSurface;
    private final long timestampOffset;
    private final boolean hasSurface;
    @Nullable
    private MediaProjection mediaProjection;
    @Nullable
    private ActivityResult activityResult;
    @Nullable
    private OnErrorListener onErrorListener;
    @NotNull
    private final MediaProjectionManager mediaProjectionManager;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private VideoConfig videoConfig;
    @NotNull
    private final HandlerThread virtualDisplayThread;
    @NotNull
    private final Handler virtualDisplayHandler;
    @NotNull
    private final virtualDisplayCallback.1 virtualDisplayCallback;
    @NotNull
    private final mediaProjectionCallback.1 mediaProjectionCallback;
    @NotNull
    private static final String VIRTUAL_DISPLAY_NAME = "StreamPackScreenCapture";

    /*
     * WARNING - void declaration
     */
    public ScreenCapture(@NotNull Context context) {
        void $this$virtualDisplayThread_u24lambda_u2d0;
        HandlerThread handlerThread;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.hasSurface = true;
        Object object = context.getSystemService("media_projection");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        }
        this.mediaProjectionManager = (MediaProjectionManager)object;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("VirtualDisplayThread");
        ScreenCapture screenCapture = this;
        boolean bl = false;
        $this$virtualDisplayThread_u24lambda_u2d0.start();
        screenCapture.virtualDisplayThread = handlerThread;
        this.virtualDisplayHandler = new Handler(this.virtualDisplayThread.getLooper());
        this.virtualDisplayCallback = new VirtualDisplay.Callback(this){
            final /* synthetic */ ScreenCapture this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPaused() {
                super.onPaused();
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this.this$0), "onPaused", null, 4, null);
            }

            public void onStopped() {
                super.onStopped();
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this.this$0), "onStopped", null, 4, null);
                OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                if (onErrorListener != null) {
                    onErrorListener.onError(new StreamPackError("Screen capture has been stopped"));
                }
            }
        };
        this.mediaProjectionCallback = new MediaProjection.Callback(this){
            final /* synthetic */ ScreenCapture this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStop() {
                super.onStop();
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this.this$0), "onStop", null, 4, null);
                OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                if (onErrorListener != null) {
                    onErrorListener.onError(new StreamPackError("Screen capture has been stopped"));
                }
            }
        };
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    @Override
    public boolean getHasSurface() {
        return this.hasSurface;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        throw new UnsupportedOperationException("Screen source expects to run in Surface mode");
    }

    @Nullable
    public final ActivityResult getActivityResult() {
        return this.activityResult;
    }

    public final void setActivityResult(@Nullable ActivityResult activityResult) {
        this.activityResult = activityResult;
    }

    @Nullable
    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.videoConfig = config;
    }

    @Override
    public void startStream() {
        VideoConfig it;
        MediaProjection mediaProjection;
        if (!(this.videoConfig != null)) {
            boolean $i$a$-require-ScreenCapture$startStream$32 = false;
            String $i$a$-require-ScreenCapture$startStream$32 = "Video has not been configured!";
            throw new IllegalArgumentException($i$a$-require-ScreenCapture$startStream$32.toString());
        }
        if (!(this.activityResult != null)) {
            boolean bl = false;
            String string = "Activity result must be set!";
            throw new IllegalArgumentException(string.toString());
        }
        ScreenCapture screenCapture = this;
        ActivityResult activityResult = this.activityResult;
        if (activityResult == null) {
            mediaProjection = null;
        } else {
            ActivityResult activityResult2 = activityResult;
            ScreenCapture screenCapture2 = screenCapture;
            boolean bl = false;
            int n = it.getResultCode();
            Intent intent = it.getData();
            Intrinsics.checkNotNull((Object)intent);
            mediaProjection = this.mediaProjectionManager.getMediaProjection(n, intent);
            screenCapture = screenCapture2;
        }
        screenCapture.mediaProjection = mediaProjection;
        VideoConfig videoConfig = this.videoConfig;
        if (videoConfig != null) {
            it = videoConfig;
            boolean bl = false;
            MediaProjection mediaProjection2 = this.mediaProjection;
            this.virtualDisplay = mediaProjection2 == null ? null : mediaProjection2.createVirtualDisplay(VIRTUAL_DISPLAY_NAME, it.getResolution().getWidth(), it.getResolution().getHeight(), 320, 16, this.getEncoderSurface(), (VirtualDisplay.Callback)this.virtualDisplayCallback, this.virtualDisplayHandler);
            MediaProjection mediaProjection3 = this.mediaProjection;
            if (mediaProjection3 != null) {
                mediaProjection3.registerCallback((MediaProjection.Callback)this.mediaProjectionCallback, this.virtualDisplayHandler);
            }
        }
    }

    @Override
    public void stopStream() {
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.virtualDisplay = null;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
        }
        this.mediaProjection = null;
    }

    @Override
    public void release() {
        this.virtualDisplayThread.quitSafely();
        try {
            this.virtualDisplayThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$Companion;", "", "()V", "VIRTUAL_DISPLAY_NAME", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

