/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.audio.aac;

import android.media.MediaFormat;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.utils.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.av.audio.ChannelConfiguration;
import io.github.thibaultbee.streampack.internal.utils.av.audio.SamplingFrequencyIndex;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTS;", "", "protectionAbsent", "", "sampleRate", "", "channelCount", "payloadLength", "(ZIII)V", "getChannelCount", "()I", "getPayloadLength", "getProtectionAbsent", "()Z", "getSampleRate", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toByteBuffer", "Ljava/nio/ByteBuffer;", "toString", "", "write", "", "buffer", "Companion", "core_release"})
public final class ADTS {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean protectionAbsent;
    private final int sampleRate;
    private final int channelCount;
    private final int payloadLength;

    public ADTS(boolean protectionAbsent, int sampleRate, int channelCount, int payloadLength) {
        this.protectionAbsent = protectionAbsent;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.payloadLength = payloadLength;
    }

    public final boolean getProtectionAbsent() {
        return this.protectionAbsent;
    }

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final int getChannelCount() {
        return this.channelCount;
    }

    public final int getPayloadLength() {
        return this.payloadLength;
    }

    public final void write(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ByteBufferExtensionsKt.putShort(buffer, 0xFFF0 | BitOperationExtensionsKt.toInt(this.protectionAbsent));
        int samplingFrequencyIndex = SamplingFrequencyIndex.Companion.fromSampleRate(this.sampleRate).getValue();
        int channelConfiguration = ChannelConfiguration.Companion.fromChannelCount(this.channelCount).getValue();
        int frameLength = this.payloadLength + (this.protectionAbsent ? 7 : 9);
        buffer.putInt(0x40000000 | samplingFrequencyIndex << 26 | channelConfiguration << 22 | frameLength << 5 | 0x1F);
        ByteBufferExtensionsKt.put(buffer, 252);
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.protectionAbsent ? 7 : 9);
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.write(buffer);
        buffer.rewind();
        return buffer;
    }

    public final boolean component1() {
        return this.protectionAbsent;
    }

    public final int component2() {
        return this.sampleRate;
    }

    public final int component3() {
        return this.channelCount;
    }

    public final int component4() {
        return this.payloadLength;
    }

    @NotNull
    public final ADTS copy(boolean protectionAbsent, int sampleRate, int channelCount, int payloadLength) {
        return new ADTS(protectionAbsent, sampleRate, channelCount, payloadLength);
    }

    public static /* synthetic */ ADTS copy$default(ADTS aDTS, boolean bl, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            bl = aDTS.protectionAbsent;
        }
        if ((n4 & 2) != 0) {
            n = aDTS.sampleRate;
        }
        if ((n4 & 4) != 0) {
            n2 = aDTS.channelCount;
        }
        if ((n4 & 8) != 0) {
            n3 = aDTS.payloadLength;
        }
        return aDTS.copy(bl, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "ADTS(protectionAbsent=" + this.protectionAbsent + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", payloadLength=" + this.payloadLength + ')';
    }

    public int hashCode() {
        int n = this.protectionAbsent ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result = n;
        result = result * 31 + Integer.hashCode(this.sampleRate);
        result = result * 31 + Integer.hashCode(this.channelCount);
        result = result * 31 + Integer.hashCode(this.payloadLength);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ADTS)) {
            return false;
        }
        ADTS aDTS = (ADTS)other;
        if (this.protectionAbsent != aDTS.protectionAbsent) {
            return false;
        }
        if (this.sampleRate != aDTS.sampleRate) {
            return false;
        }
        if (this.channelCount != aDTS.channelCount) {
            return false;
        }
        return this.payloadLength == aDTS.payloadLength;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTS$Companion;", "", "()V", "fromAudioConfig", "Lio/github/thibaultbee/streampack/internal/utils/av/audio/aac/ADTS;", "config", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "payloadLength", "", "fromMediaFormat", "format", "Landroid/media/MediaFormat;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ADTS fromMediaFormat(@NotNull MediaFormat format, int payloadLength) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            return new ADTS(true, format.getInteger("sample-rate"), format.getInteger("channel-count"), payloadLength);
        }

        @NotNull
        public final ADTS fromAudioConfig(@NotNull AudioConfig config, int payloadLength) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new ADTS(true, config.getSampleRate(), AudioConfig.Companion.getNumberOfChannels(config.getChannelConfig()), payloadLength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

