/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.ts.packets;

import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.Service;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.Stream;
import io.github.thibaultbee.streampack.internal.muxers.ts.packets.Psi;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0003$%&B9\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020 H\u0016J\u0006\u0010#\u001a\u00020\u001eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Psi;", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "listener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "service", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Service;", "streams", "", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "pid", "", "versionNumber", "", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Lio/github/thibaultbee/streampack/internal/muxers/ts/data/Service;Ljava/util/List;SB)V", "bitSize", "", "getBitSize", "()I", "programInfoLength", "getProgramInfoLength", "size", "getSize", "getStreams", "()Ljava/util/List;", "setStreams", "(Ljava/util/List;)V", "mimeType", "", "putRegistrationDescriptor", "", "buffer", "Ljava/nio/ByteBuffer;", "tag", "toByteBuffer", "write", "Companion", "Descriptor", "StreamType", "core_release"})
public final class Pmt
extends Psi
implements ITSElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Service service;
    @NotNull
    private List<Stream> streams;
    public static final byte TID = 2;

    public Pmt(@Nullable IMuxerListener listener, @NotNull Service service, @NotNull List<Stream> streams, short pid, byte versionNumber) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        super(listener, pid, (byte)2, true, false, service.getInfo().getId(), versionNumber, (byte)0, (byte)0, 384, null);
        this.service = service;
        this.streams = streams;
    }

    public /* synthetic */ Pmt(IMuxerListener iMuxerListener, Service service, List list, short s, byte by, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n & 0x10) != 0) {
            by = 0;
        }
        this(iMuxerListener, service, list, s, by);
    }

    @NotNull
    public final List<Stream> getStreams() {
        return this.streams;
    }

    public final void setStreams(@NotNull List<Stream> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.streams = list;
    }

    @Override
    public int getBitSize() {
        return 32 + 40 * this.streams.size() + 8 * this.getProgramInfoLength();
    }

    @Override
    public int getSize() {
        return this.getBitSize() / 8;
    }

    private final int getProgramInfoLength() {
        Stream it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.streams;
        int n = this.getProgramInfoLength("audio/opus");
        boolean $i$f$filter = false;
        void var3_4 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getConfig().getMimeType(), (Object)"audio/opus")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$filter$iv = this.streams;
        int n2 = this.getProgramInfoLength("video/hevc");
        n *= list.size();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getConfig().getMimeType(), (Object)"video/hevc")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return n + n2 * list2.size();
    }

    public final void write() {
        if (this.service.getPcrPid() != null) {
            this.write(this.toByteBuffer());
        }
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        Short s = this.service.getPcrPid();
        Intrinsics.checkNotNull((Object)s);
        ByteBufferExtensionsKt.putShort(buffer, 0xE000 | s);
        ByteBufferExtensionsKt.putShort(buffer, 61440);
        Iterable $this$forEach$iv = this.streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stream it = (Stream)element$iv;
            boolean bl = false;
            buffer.put(StreamType.Companion.fromMimeType(it.getConfig().getMimeType()).getValue());
            ByteBufferExtensionsKt.putShort(buffer, 0xE000 | it.getPid());
            ByteBufferExtensionsKt.putShort(buffer, 0xF000 | this.getProgramInfoLength(it.getConfig().getMimeType()));
            if (Intrinsics.areEqual((Object)it.getConfig().getMimeType(), (Object)"audio/opus")) {
                this.putRegistrationDescriptor(buffer, "Opus");
                buffer.put((byte)127);
                buffer.put((byte)2);
                buffer.put((byte)-128);
                ByteBufferExtensionsKt.put(buffer, AudioConfig.Companion.getNumberOfChannels(((AudioConfig)it.getConfig()).getChannelConfig()));
                continue;
            }
            if (!Intrinsics.areEqual((Object)it.getConfig().getMimeType(), (Object)"video/hevc")) continue;
            this.putRegistrationDescriptor(buffer, "HEVC");
        }
        buffer.rewind();
        return buffer;
    }

    private final int getProgramInfoLength(String mimeType) {
        String string = mimeType;
        return Intrinsics.areEqual((Object)string, (Object)"audio/opus") ? 10 : (Intrinsics.areEqual((Object)string, (Object)"video/hevc") ? 6 : 0);
    }

    private final void putRegistrationDescriptor(ByteBuffer buffer, String tag) {
        if (!(tag.length() == 4)) {
            boolean $i$a$-require-Pmt$putRegistrationDescriptor$22 = false;
            String $i$a$-require-Pmt$putRegistrationDescriptor$22 = "Tag must be 4 characters long";
            throw new IllegalArgumentException($i$a$-require-Pmt$putRegistrationDescriptor$22.toString());
        }
        buffer.put(Descriptor.REGISTRATION.getValue());
        buffer.put((byte)4);
        CharSequence $this$forEach$iv = tag;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            ByteBufferExtensionsKt.put(buffer, it);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$Companion;", "", "()V", "TID", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "VIDEO_MPEG1", "VIDEO_MPEG2", "AUDIO_MPEG1", "AUDIO_MPEG2", "PRIVATE_SECTION", "PRIVATE_DATA", "AUDIO_AAC", "AUDIO_AAC_LATM", "VIDEO_MPEG4", "METADATA", "VIDEO_H264", "VIDEO_HEVC", "VIDEO_CAVS", "VIDEO_VC1", "VIDEO_DIRAC", "AUDIO_AC3", "AUDIO_DTS", "AUDIO_TRUEHD", "AUDIO_EAC3", "Companion", "core_release"})
    public static final class StreamType
    extends Enum<StreamType> {
        @NotNull
        public static final Companion Companion;
        private final byte value;
        public static final /* enum */ StreamType VIDEO_MPEG1;
        public static final /* enum */ StreamType VIDEO_MPEG2;
        public static final /* enum */ StreamType AUDIO_MPEG1;
        public static final /* enum */ StreamType AUDIO_MPEG2;
        public static final /* enum */ StreamType PRIVATE_SECTION;
        public static final /* enum */ StreamType PRIVATE_DATA;
        public static final /* enum */ StreamType AUDIO_AAC;
        public static final /* enum */ StreamType AUDIO_AAC_LATM;
        public static final /* enum */ StreamType VIDEO_MPEG4;
        public static final /* enum */ StreamType METADATA;
        public static final /* enum */ StreamType VIDEO_H264;
        public static final /* enum */ StreamType VIDEO_HEVC;
        public static final /* enum */ StreamType VIDEO_CAVS;
        public static final /* enum */ StreamType VIDEO_VC1;
        public static final /* enum */ StreamType VIDEO_DIRAC;
        public static final /* enum */ StreamType AUDIO_AC3;
        public static final /* enum */ StreamType AUDIO_DTS;
        public static final /* enum */ StreamType AUDIO_TRUEHD;
        public static final /* enum */ StreamType AUDIO_EAC3;
        private static final /* synthetic */ StreamType[] $VALUES;

        private StreamType(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static StreamType[] values() {
            return (StreamType[])$VALUES.clone();
        }

        public static StreamType valueOf(String value) {
            return Enum.valueOf(StreamType.class, value);
        }

        static {
            VIDEO_MPEG1 = new StreamType(1);
            VIDEO_MPEG2 = new StreamType(2);
            AUDIO_MPEG1 = new StreamType(3);
            AUDIO_MPEG2 = new StreamType(4);
            PRIVATE_SECTION = new StreamType(5);
            PRIVATE_DATA = new StreamType(6);
            AUDIO_AAC = new StreamType(15);
            AUDIO_AAC_LATM = new StreamType(17);
            VIDEO_MPEG4 = new StreamType(16);
            METADATA = new StreamType(21);
            VIDEO_H264 = new StreamType(27);
            VIDEO_HEVC = new StreamType(36);
            VIDEO_CAVS = new StreamType(66);
            VIDEO_VC1 = new StreamType(-22);
            VIDEO_DIRAC = new StreamType(-47);
            AUDIO_AC3 = new StreamType(-127);
            AUDIO_DTS = new StreamType(-126);
            AUDIO_TRUEHD = new StreamType(-125);
            AUDIO_EAC3 = new StreamType(-121);
            $VALUES = streamTypeArray = new StreamType[]{StreamType.VIDEO_MPEG1, StreamType.VIDEO_MPEG2, StreamType.AUDIO_MPEG1, StreamType.AUDIO_MPEG2, StreamType.PRIVATE_SECTION, StreamType.PRIVATE_DATA, StreamType.AUDIO_AAC, StreamType.AUDIO_AAC_LATM, StreamType.VIDEO_MPEG4, StreamType.METADATA, StreamType.VIDEO_H264, StreamType.VIDEO_HEVC, StreamType.VIDEO_CAVS, StreamType.VIDEO_VC1, StreamType.VIDEO_DIRAC, StreamType.AUDIO_AC3, StreamType.AUDIO_DTS, StreamType.AUDIO_TRUEHD, StreamType.AUDIO_EAC3};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType$Companion;", "", "()V", "fromMimeType", "Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType;", "mimeType", "", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StreamType fromMimeType(@NotNull String mimeType) {
                StreamType streamType;
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                switch (mimeType) {
                    case "video/mpeg2": {
                        streamType = VIDEO_MPEG2;
                        break;
                    }
                    case "audio/mpeg": {
                        streamType = AUDIO_MPEG1;
                        break;
                    }
                    case "audio/mp4a-latm": {
                        streamType = AUDIO_AAC;
                        break;
                    }
                    case "video/mp4v-es": {
                        streamType = VIDEO_MPEG4;
                        break;
                    }
                    case "video/avc": {
                        streamType = VIDEO_H264;
                        break;
                    }
                    case "video/hevc": {
                        streamType = VIDEO_HEVC;
                        break;
                    }
                    case "audio/ac3": {
                        streamType = AUDIO_AC3;
                        break;
                    }
                    case "audio/eac3": {
                        streamType = AUDIO_EAC3;
                        break;
                    }
                    case "audio/opus": {
                        streamType = PRIVATE_DATA;
                        break;
                    }
                    default: {
                        streamType = PRIVATE_DATA;
                    }
                }
                return streamType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$Descriptor;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "VIDEO_STREAM", "REGISTRATION", "ISO_639_LANGUAGE", "IOD", "SL", "FMC", "METADATA", "METADATA_STD", "core_release"})
    public static final class Descriptor
    extends Enum<Descriptor> {
        private final byte value;
        public static final /* enum */ Descriptor VIDEO_STREAM = new Descriptor(2);
        public static final /* enum */ Descriptor REGISTRATION = new Descriptor(5);
        public static final /* enum */ Descriptor ISO_639_LANGUAGE = new Descriptor(10);
        public static final /* enum */ Descriptor IOD = new Descriptor(29);
        public static final /* enum */ Descriptor SL = new Descriptor(30);
        public static final /* enum */ Descriptor FMC = new Descriptor(31);
        public static final /* enum */ Descriptor METADATA = new Descriptor(38);
        public static final /* enum */ Descriptor METADATA_STD = new Descriptor(39);
        private static final /* synthetic */ Descriptor[] $VALUES;

        private Descriptor(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static Descriptor[] values() {
            return (Descriptor[])$VALUES.clone();
        }

        public static Descriptor valueOf(String value) {
            return Enum.valueOf(Descriptor.class, value);
        }

        static {
            $VALUES = descriptorArray = new Descriptor[]{Descriptor.VIDEO_STREAM, Descriptor.REGISTRATION, Descriptor.ISO_639_LANGUAGE, Descriptor.IOD, Descriptor.SL, Descriptor.FMC, Descriptor.METADATA, Descriptor.METADATA_STD};
        }
    }
}

