/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.util.Range;
import android.util.Rational;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.internal.utils.ExtensionsKt;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/utils/Exposure;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableCompensationRange", "Landroid/util/Range;", "", "getAvailableCompensationRange", "()Landroid/util/Range;", "availableCompensationStep", "Landroid/util/Rational;", "getAvailableCompensationStep", "()Landroid/util/Rational;", "value", "compensation", "getCompensation", "()I", "setCompensation", "(I)V", "core_release"})
public final class Exposure {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;

    public Exposure(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    public final Range<Integer> getAvailableCompensationRange() {
        Range range;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            range = null;
        } else {
            String it = string2;
            boolean bl = false;
            range = CameraExtensionsKt.getExposureRange(this.context, it);
        }
        Range range2 = range;
        if (range == null) {
            range2 = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return range2;
    }

    @NotNull
    public final Rational getAvailableCompensationStep() {
        Rational rational;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            rational = null;
        } else {
            String it = string2;
            boolean bl = false;
            rational = CameraExtensionsKt.getExposureStep(this.context, it);
        }
        Rational rational2 = rational;
        if (rational == null) {
            rational2 = new Rational(1, 1);
        }
        return rational2;
    }

    public final int getCompensation() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
        return n == null ? 0 : n;
    }

    public final void setCompensation(int value) {
        CaptureRequest.Key key = CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AE_EXPOSURE_COMPENSATION");
        this.cameraController.setSetting(key, ExtensionsKt.clamp(value, this.getAvailableCompensationRange()));
    }
}

