/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.views;

import android.graphics.Point;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import android.view.Display;
import io.github.thibaultbee.streampack.views.SmartSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a;\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"SIZE_1080P", "Lio/github/thibaultbee/streampack/views/SmartSize;", "getSIZE_1080P", "()Lio/github/thibaultbee/streampack/views/SmartSize;", "getDisplaySmartSize", "display", "Landroid/view/Display;", "getPreviewOutputSize", "Landroid/util/Size;", "T", "characteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "targetClass", "Ljava/lang/Class;", "format", "", "(Landroid/view/Display;Landroid/hardware/camera2/CameraCharacteristics;Ljava/lang/Class;Ljava/lang/Integer;)Landroid/util/Size;", "core_release"})
public final class CameraSizesKt {
    @NotNull
    private static final SmartSize SIZE_1080P = new SmartSize(1920, 1080);

    @NotNull
    public static final SmartSize getSIZE_1080P() {
        return SIZE_1080P;
    }

    @NotNull
    public static final SmartSize getDisplaySmartSize(@NotNull Display display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Point outPoint = new Point();
        display.getRealSize(outPoint);
        return new SmartSize(outPoint.x, outPoint.y);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Size getPreviewOutputSize(@NotNull Display display, @NotNull CameraCharacteristics characteristics, @NotNull Class<T> targetClass, @Nullable Integer format) {
        Object element$iv2;
        block6: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)display, (String)"display");
            Intrinsics.checkNotNullParameter((Object)characteristics, (String)"characteristics");
            Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
            SmartSize screenSize = CameraSizesKt.getDisplaySmartSize(display);
            boolean hdScreen = screenSize.getLong() >= SIZE_1080P.getLong() || screenSize.getShort() >= SIZE_1080P.getShort();
            SmartSize maxSize = hdScreen ? SIZE_1080P : screenSize;
            Object object = characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"characteristics.get(\n   \u2026CONFIGURATION_MAP\n    )!!");
            StreamConfigurationMap config = (StreamConfigurationMap)object2;
            if (format == null) {
                bl = StreamConfigurationMap.isOutputSupportedFor(targetClass);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
            } else {
                bl = config.isOutputSupportedFor(format.intValue());
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
            }
            Integer n = format;
            Object[] allSizes = n == null ? config.getOutputSizes(targetClass) : config.getOutputSizes(n.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)allSizes, (String)"allSizes");
            Iterable iterable = ArraysKt.sortedWith((Object[])allSizes, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Size it = (Size)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getHeight() * it.getWidth());
                    it = (Size)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getHeight() * it.getWidth()));
                }
            });
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Size size = (Size)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new SmartSize(it.getWidth(), it.getHeight()));
            }
            List validSizes = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
            Iterable $this$first$iv = validSizes;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                SmartSize it = (SmartSize)element$iv2;
                boolean bl3 = false;
                if (!(it.getLong() <= maxSize.getLong() && it.getShort() <= maxSize.getShort())) continue;
                break block6;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((SmartSize)element$iv2).getSize();
    }

    public static /* synthetic */ Size getPreviewOutputSize$default(Display display, CameraCharacteristics cameraCharacteristics, Class clazz, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return CameraSizesKt.getPreviewOutputSize(display, cameraCharacteristics, clazz, n);
    }
}

