/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.packet;

import android.content.Context;
import android.util.Size;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.containers.AmfContainer;
import io.github.thibaultbee.streampack.internal.muxers.flv.amf.containers.AmfEcmaArray;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.CodecID;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.FlvTag;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.SoundFormat;
import io.github.thibaultbee.streampack.internal.muxers.flv.packet.TagType;
import io.github.thibaultbee.streampack.internal.utils.ExtensionsKt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/OnMetadata;", "Lio/github/thibaultbee/streampack/internal/muxers/flv/packet/FlvTag;", "context", "Landroid/content/Context;", "manageVideoOrientation", "", "streams", "", "Lio/github/thibaultbee/streampack/data/Config;", "(Landroid/content/Context;ZLjava/util/List;)V", "amfContainer", "Lio/github/thibaultbee/streampack/internal/muxers/flv/amf/containers/AmfContainer;", "payloadSize", "", "getPayloadSize", "()I", "tagHeaderSize", "getTagHeaderSize", "writePayload", "", "buffer", "Ljava/nio/ByteBuffer;", "writeTagHeader", "core_release"})
public final class OnMetadata
extends FlvTag {
    @NotNull
    private final AmfContainer amfContainer;

    public OnMetadata(@NotNull Context context, boolean manageVideoOrientation, @NotNull List<? extends Config> streams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        super(0L, TagType.SCRIPT, false, 4, null);
        this.amfContainer = new AmfContainer();
        this.amfContainer.add("onMetaData");
        AmfEcmaArray ecmaArray = new AmfEcmaArray();
        ecmaArray.add("duration", 0.0);
        Iterable $this$forEach$iv = streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Config it = (Config)element$iv;
            boolean bl = false;
            Config config = it;
            if (config instanceof AudioConfig) {
                ecmaArray.add("audiocodecid", SoundFormat.Companion.fromMimeType(it.getMimeType()).getValue());
                ecmaArray.add("audiodatarate", (double)it.getStartBitrate() / (double)1000);
                ecmaArray.add("audiosamplerate", ((AudioConfig)it).getSampleRate());
                ecmaArray.add("audiosamplesize", ExtensionsKt.numOfBits(((AudioConfig)it).getByteFormat()));
                ecmaArray.add("stereo", AudioConfig.Companion.getNumberOfChannels(((AudioConfig)it).getChannelConfig()) == 2);
                continue;
            }
            if (config instanceof VideoConfig) {
                Size resolution = manageVideoOrientation ? ((VideoConfig)it).getOrientedResolution(context) : ((VideoConfig)it).getResolution();
                ecmaArray.add("videocodecid", CodecID.Companion.fromMimeType(it.getMimeType()).getValue());
                ecmaArray.add("videodatarate", (double)it.getStartBitrate() / (double)1000);
                ecmaArray.add("width", resolution.getWidth());
                ecmaArray.add("height", resolution.getHeight());
                ecmaArray.add("framerate", ((VideoConfig)it).getFps());
                continue;
            }
            throw new IOException(Intrinsics.stringPlus((String)"Not supported mime type: ", (Object)it.getMimeType()));
        }
        this.amfContainer.add(ecmaArray);
    }

    @Override
    protected void writeTagHeader(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    @Override
    protected int getTagHeaderSize() {
        return 0;
    }

    @Override
    protected void writePayload(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.amfContainer.encode(buffer);
    }

    @Override
    protected int getPayloadSize() {
        return this.amfContainer.getSize();
    }
}

