/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.os.Build;
import android.util.Range;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/github/thibaultbee/streampack/utils/Zoom;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableRatioRange", "Landroid/util/Range;", "", "getAvailableRatioRange", "()Landroid/util/Range;", "value", "zoomRatio", "getZoomRatio", "()F", "setZoomRatio", "(F)V", "core_release"})
public final class Zoom {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;

    public Zoom(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    public final Range<Float> getAvailableRatioRange() {
        Range range;
        String string = this.cameraController.getCameraId();
        if (string == null) {
            range = null;
        } else {
            String it = string;
            boolean bl = false;
            range = CameraExtensionsKt.getZoomRatioRange(this.context, it);
        }
        Range range2 = range;
        if (range == null) {
            range2 = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
        }
        return range2;
    }

    public final float getZoomRatio() {
        float f;
        if (Build.VERSION.SDK_INT >= 30) {
            Float f2 = (Float)this.cameraController.getSetting(CaptureRequest.CONTROL_ZOOM_RATIO);
            f = f2 == null ? 1.0f : f2.floatValue();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public final void setZoomRatio(float value) {
        if (Build.VERSION.SDK_INT >= 30) {
            CaptureRequest.Key key = CaptureRequest.CONTROL_ZOOM_RATIO;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_ZOOM_RATIO");
            this.cameraController.setSetting(key, Float.valueOf(value));
        }
    }
}

